<%@ page language="java" pageEncoding="UTF-8" contentType="text/html;charset=utf-8" %>
<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<head>
    <title><fmt:message key="login.title"/></title>
    <link rel="shortcut icon" href="<c:url value="/favicon.ico"/>" type="image/x-icon"/>
    <style type="text/css">
        body {

        }

        form {
            width: 620px;
            height: 374px;
            margin: 0 auto;
            margin-top: 10em;
        }

        table {
            margin-top: 180px;
            margin-left: 40px;
            width: 100%;
        }

        label {
            display: block;
            text-align: right;
        }

    </style>
</head>
<body>
<form method="post" id="loginForm" action="<c:url value='j_spring_security_check'/>">
    <table>
        <c:if test="${param.error != null}">
            <tr class="error">
                <td colspan="2">
                    <fmt:message key="errors.verify.mismatch"/>
                    <c:out value="${requestScope.SPRING_SECURITY_LAST_EXCEPTION.message}"/>
                </td>
            </tr>
        </c:if>
        <tr>
            <td>
                <label for="j_stationNumber">
                    <fmt:message key="label.facility"/>
                </label>
            </td>
            <td>
                <select id="j_stationNumber" name="j_stationNumber" tabindex="3">
                    <c:forEach items="${vistaAccounts}" var="account">
                        <option value="<c:out value="${account.primaryStation}"/>"><c:out value="${account.name}"/>
                            (<c:out value="${account.primaryStation}"/>)
                        </option>
                    </c:forEach>
                </select>
            </td>
        </tr>
        <tr>
            <td>
                <label for="j_access">
                    <fmt:message key="label.access"/>
                </label>
            </td>
            <td>
                <input type="password" name="j_access" id="j_access" tabindex="1"/>
            </td>
        </tr>

        <tr>
            <td>
                <label for="j_verify">
                    <fmt:message key="label.verify"/>
                </label>
            </td>
            <td>
                <input type="password" name="j_verify" id="j_verify" tabindex="2"/>
            </td>
        </tr>

        <tr>
            <td/>
            <td>
                <input type="submit" name="login" value="<fmt:message key='button.login'/>"
                       tabindex="4"/>
            </td>
        </tr>
    </table>
</form>
</body>
</html>
