package gov.va.med.edp.web.controller;

import gov.va.med.edp.vistalink.locator.VistaLinkConnectorConfig;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Set;

public class LoginController extends AbstractController implements InitializingBean {

    public static final String DEFAULT_VIEW_NAME = "login";

    private String viewName = DEFAULT_VIEW_NAME;

    private Set/*<VistaLinkConnectorConfig>*/ vistaAccounts;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(viewName, "viewName must not be null");
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new ModelAndView(getViewName(), "vistaAccounts", vistaAccounts);
    }

    public String getViewName() {
        return viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public Set/*<VistaLinkConnectorConfig>*/ getVistaAccounts() {
        return vistaAccounts;
    }

    public void setVistaAccounts(Set/*<VistaLinkConnectorConfig>*/ vistaAccounts) {
        this.vistaAccounts = vistaAccounts;
    }
}