package gov.va.med.edp.dao.rpc;

import gov.va.med.edp.vistalink.VistaLinkDaoSupport;
import org.springframework.dao.DataAccessException;

import java.util.List;
import java.util.Map;
import java.util.ArrayList;

import gov.va.med.edp.dao.TrackingDao;

public class VistaLinkTrackingDao extends VistaLinkDaoSupport implements TrackingDao {
    static final String EDPF_TRACKING_SYSTEM_CONTEXT = "EDPF TRACKING SYSTEM";
    static final String EDP_CONTROLLER_RPC = "EDPCTRL RPC";

    public String executeCommand(String stationNumber, String duz, Map params) throws DataAccessException {
        return getRpcTemplate().rpcAsUser(stationNumber, duz, EDPF_TRACKING_SYSTEM_CONTEXT, EDP_CONTROLLER_RPC, buildRpcParameterList(params));
    }

    private List buildRpcParameterList(Map params) {
        ArrayList paramList = new ArrayList();
        paramList.add(params);
        return paramList;
    }
}
