package gov.va.med.edp;

import gov.va.med.edp.vistalink.VistaLinkTemplate;
import gov.va.med.edp.vistalink.locator.VistaLinkConnectorConfig;
import gov.va.med.edp.vistalink.locator.VistaLinkConnectorConfigConnectionFactoryLocator;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

import java.io.Console;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

import static java.util.Arrays.asList;

public class VistaLinkTester {
    public static void main(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        OptionSpec<String> hostOption = parser.acceptsAll(asList("S", "server", "host")).withRequiredArg().ofType(String.class);
        OptionSpec<Integer> portOption = parser.acceptsAll(asList("P", "port")).withRequiredArg().ofType(Integer.class);
        OptionSpec<String> divisionOption = parser.acceptsAll(asList("D", "division", "station-num")).withRequiredArg().ofType(String.class);
        OptionSpec<String> rpcContextOption = parser.acceptsAll(asList("C", "context", "rpc-context")).withRequiredArg().ofType(String.class);
        OptionSpec<String> rpcNameOption = parser.acceptsAll(asList("N", "name", "rpc-name")).withRequiredArg().ofType(String.class);

        try {
            OptionSet options = parser.parse(args);

            Console console = System.console();

            String host = options.has(hostOption) ? hostOption.value(options) : console.readLine("Host: ");
            int port = options.has(portOption) ? portOption.value(options) : Integer.parseInt(console.readLine("Port: "));
            String division = options.has(divisionOption) ? divisionOption.value(options) : console.readLine("Division: ");

            char[] accessCode = console.readPassword("Access: ");
            char[] verifyCode = console.readPassword("Verify: ");

            String rpcContext = options.has(rpcContextOption) ? rpcContextOption.value(options) : console.readLine("RPC Context: ");
            String rpcName = options.has(rpcNameOption) ? rpcNameOption.value(options) : console.readLine("RPC Name: ");
            ;

            if (rpcContext == null) rpcContext = "";

            VistaLinkTester tester = new VistaLinkTester(host, port, division, accessCode.toString(), verifyCode.toString());

            System.out.println("Enter RPC Parameters (^ when finished)");

            List<String> params = new ArrayList<String>();
            int i = 1;
            boolean done = false;
            while (!done) {
                String param = console.readLine("RPC Param " + i + ": ");
                if (param.equalsIgnoreCase("^")) {
                    done = true;
                } else {
                    params.add(param);
                    i++;
                }
            }

            System.out.println("Executing vlink://" + division + "@" + host + ":" + port + "/" + rpcContext + "/" + rpcName);

            System.out.println(tester.execute(rpcContext, rpcName, params));
        } catch (OptionException e) {
            System.out.println(e.getLocalizedMessage());
            System.out.println("Usage:");
            parser.printHelpOn(System.out);
            System.exit(1);
        } catch (Throwable t) {
            t.printStackTrace();
        }
//        HashSet connectors = new HashSet();
//        connectors.add(new VistaLinkConnectorConfig("500", "WORLDVISTA DEMO CLINIC", "66.206.177.84", 9310, "EDISUSER1", "VISTAIS#1"));
    }

    private String division;

    private VistaLinkTemplate t;

    public VistaLinkTester(String host, int port, String division, String accessCode, String verifyCode) {
        this.division = division;

        HashSet connectors = new HashSet();
        connectors.add(new VistaLinkConnectorConfig(division, "VISTALINK TESTER", host, port, accessCode, verifyCode));

        VistaLinkConnectorConfigConnectionFactoryLocator l = new VistaLinkConnectorConfigConnectionFactoryLocator();
        l.setConnectors(connectors);

        t = new VistaLinkTemplate(l);
    }

    public String execute(String rpcContext, String rpcName, List params) {
        if (params.size() > 0)
            return t.rpcAsApplication(this.division, "VISTALINK TESTER", rpcContext, rpcName, params);
        else
            return t.rpcAsApplication(this.division, "VISTALINK TESTER", rpcContext, rpcName);
    }
}
