package gov.va.med.edp;

import gov.va.med.edp.vistalink.VistaLinkTemplate;
import gov.va.med.edp.vistalink.locator.VistaLinkConnectorConfig;
import gov.va.med.edp.vistalink.locator.VistaLinkConnectorConfigConnectionFactoryLocator;
import gov.va.med.vistalink.adapter.cci.VistaLinkResourceException;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.springframework.dao.DataAccessResourceFailureException;

import java.io.Console;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

import static java.util.Arrays.asList;

public class VistaLinkTester {
    public static void main(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        parser.acceptsAll(asList("?", "help"), "Print usage information");
        OptionSpec<String> hostOption = parser.acceptsAll(asList("S", "server", "host"), "Hostname or IP where VistALink is listening").withRequiredArg().ofType(String.class);
        OptionSpec<Integer> portOption = parser.acceptsAll(asList("P", "port"), "Port where VistALink is listening").withRequiredArg().ofType(Integer.class);
        OptionSpec<String> divisionOption = parser.acceptsAll(asList("D", "division", "station-num"), "Station Number").withRequiredArg().ofType(String.class);
        OptionSpec<String> duzOption = parser.acceptsAll(asList("U", "DUZ")).withRequiredArg().ofType(String.class);
        OptionSpec<String> rpcContextOption = parser.acceptsAll(asList("C", "context", "rpc-context"), "RPC Context").withRequiredArg().ofType(String.class);
        OptionSpec<String> rpcNameOption = parser.acceptsAll(asList("N", "name", "rpc-name"), "RPC Name").withRequiredArg().ofType(String.class);

        try {
            OptionSet options = parser.parse(args);

            if (options.has("?") || options.has("help")) {
                System.out.println("Usage:");
                parser.printHelpOn(System.out);
                System.exit(0);
            }

            Console console = System.console();

            String host = options.has(hostOption) ? hostOption.value(options) : console.readLine("Host: ");
            int port = options.has(portOption) ? portOption.value(options) : Integer.parseInt(console.readLine("Port: "));
            String division = options.has(divisionOption) ? divisionOption.value(options) : console.readLine("Station Number: ");

            char[] accessCodeChars = console.readPassword("Access: ");
            char[] verifyCodeChars = console.readPassword("Verify: ");

            String accessCode = new String(accessCodeChars);
            String verifyCode = new String(verifyCodeChars);

            String duz = options.has(duzOption) ? duzOption.value(options) : console.readLine("DUZ: ");
            String rpcContext = options.has(rpcContextOption) ? rpcContextOption.value(options) : console.readLine("RPC Context: ");
            String rpcName = options.has(rpcNameOption) ? rpcNameOption.value(options) : console.readLine("RPC Name: ");

            if (rpcContext == null) rpcContext = "";

            VistaLinkTester tester = new VistaLinkTester(host, port, division, accessCode, verifyCode);

            System.out.println("Enter RPC Parameters (^ when finished)");

            List<String> params = new ArrayList<String>();
            int i = 1;
            boolean done = false;
            while (!done) {
                String param = console.readLine("RPC Param " + i + ": ");
                if (param.equalsIgnoreCase("^")) {
                    done = true;
                } else {
                    params.add(param);
                    i++;
                }
            }

            System.out.println("Executing vlink://" + division + "@" + host + ":" + port + "/" + rpcContext + "/" + rpcName + formatRpcParams(params));

            System.out.println(tester.execute(duz, rpcContext, rpcName, params));
        } catch (OptionException e) {
            System.out.println(e.getLocalizedMessage());
            System.out.println("Usage:");
            parser.printHelpOn(System.out);
            System.exit(1);
        } catch (gov.va.med.edp.vistalink.VistaLinkDataRetrievalFailureException e) {
            System.out.println(e.getMessage());
        } catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static String formatRpcParams(List params) {
        StringBuilder b = new StringBuilder();
        if (!params.isEmpty()) b.append("?");
        for (int i = 0; i < params.size(); i++) {
            b.append("[");
            b.append(i + 1);
            b.append("]=");
            b.append(params.get(i).toString());
            if (i < params.size() - 1) {
                b.append("&");
            }
        }
        return b.toString();
    }

    private String division;

    private VistaLinkTemplate t;

    public VistaLinkTester(String host, int port, String division, String accessCode, String verifyCode) {
        this.division = division;

        HashSet connectors = new HashSet();
        connectors.add(new VistaLinkConnectorConfig(division, "VISTALINK TESTER", host, port, accessCode, verifyCode));

        VistaLinkConnectorConfigConnectionFactoryLocator l = new VistaLinkConnectorConfigConnectionFactoryLocator();
        l.setConnectors(connectors);

        t = new VistaLinkTemplate(l);
    }

    public String execute(String duz, String rpcContext, String rpcName, List params) {
        if (params.size() > 0)
            return t.rpcAsUser(this.division, duz, rpcContext, rpcName, params);
        else
            return t.rpcAsUser(this.division, duz, rpcContext, rpcName);
    }
}
