GPLMEDS ; CCDCCR/CJE - CCR/CCD PROCESSING FOR MEDICATIONS ;07/23/08  14:33
   ;;0.1;CCDCCR;;JUL 16,2008;
   ;Copyright 2008 WorldVistA.  Licensed under the terms of the GNU
   ;General Public License See attached copy of the License.
   ;
   ;This program is free software; you can redistribute it and/or modify
   ;it under the terms of the GNU General Public License as published by
   ;the Free Software Foundation; either version 2 of the License, or
   ;(at your option) any later version.
   ;
   ;This program is distributed in the hope that it will be useful,
   ;but WITHOUT ANY WARRANTY; without even the implied warranty of
   ;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   ;GNU General Public License for more details.
   ;
   ;You should have received a copy of the GNU General Public License along
   ;with this program; if not, write to the Free Software Foundation, Inc.,
   ;51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
   ;
   W "NO ENTRY FROM TOP",!
   Q
   ;
EXTRACT(MEDXML,DFN,MEDOUTXML) ; EXTRACT MEDICATIONS INTO PROVIDED XML TEMPLATE
   ;
   ; MEDXML AND OUTXML ARE PASSED BY NAME SO GLOBALS CAN BE USED
   ; IMEDXML WILL CONTAIN ONLY THE MEDICATIONS SECTION OF THE OVERALL TEMPLATE
   ;
   N MEDRSLT,I,J,K,MEDPTMP,X,MEDVMAP,TBUF
   D ACTIVE^ORWPS(.MEDRSLT,DFN)
   I '$D(MEDRSLT(1)) D  ; NO MEDS FOR THIS PATIENT, EXIT
   . W "ERROR RUNNINIG MEDICATIONS RPC",!
   . S @MEDOUTXML@(0)=0
   . Q
   ; I DEBUG ZWR MEDRSLT
   M GPLMEDS=MEDRSLT
   S MEDTVMAP=$NA(^TMP("GPLCCR",$J,"MEDICATIONS"))
   S MEDTARYTMP=$NA(^TMP("GPLCCR",$J,"MEDARYTMP"))
   K @MEDTVMAP,@MEDTARYTMP
   ; FIRST GO THROUGH MEDRSLT ARRAY AND COUNT MEDS AND LINES IN MEDS
   ; ZA(0) IS TOTAL NUMBER OF MEDS ZA(ZI) IS LINES IN MED ZI
   N ZA,ZI,ZJ,ZK,ZN S (ZI,ZJ,ZK,ZN)=0 ; ZI IS MED NUMBER, ZJ IS LINE IN MED
   ; ZK IS THE NUMBER OF LINES IN A MED AND ZN IS COUNTER THROUGH LINES
   S ZA(0)=0 ; ZA IS ARRAY OF MED LINE COUNTS
   F ZJ=1:1 Q:'$D(MEDRSLT(ZJ))  D  ; COUNT THE MEDS AND LINES
   . I MEDRSLT(ZJ)?1"~".E D  ; FOUND NEW MED
   . . S ZI=ZI+1 ; INCREMENT MED COUNT
   . . S ZA(0)=ZI ; NEW TOTAL FOR MEDS
   . . S ZA(ZI)=ZJ_U_1 ; EACH ZA(X) IS Y^Z WHERE Y IS START LINE AND Z IS COUNT
   . E  D  ; FOR EVERY LINE NOT A FIRST LINE IN MED
   . . S ZK=$P(ZA(ZI),U,2)+1 ; INCREMENT LINE COUNT FOR CURRENT MED
   . . S $P(ZA(ZI),U,2)=ZK ; AND STORE IT IN ARRAY
   ;ZWR ZA
   F ZI=1:1:ZA(0) D  ; FOR EACH MED
   . I DEBUG W "ZI IS ",ZI,!
   . S MEDVMAP=$NA(@MEDTVMAP@(ZI))
   . K @MEDVMAP
   . I DEBUG W "VMAP= ",MEDVMAP,!
   . S ZJ=$P(ZA(ZI),U,1) ; INDEX OF FIRST LINE OF MED IN MEDRSLT
   . S MEDPTMP=MEDRSLT(ZJ) ; PULL OUT FIRST LINE OF MED
   . S @MEDVMAP@("MEDOBJECTID")="MED"_ZI ; UNIQUE OBJID FOR MEDS
   . S @MEDVMAP@("MEDISSUEDATETXT")=$$FMDTOUTC^CCRUTIL($P(MEDPTMP,"^",11),"DT") ; GETS LAST FILL DATE
   . S @MEDVMAP@("MEDDATETIMEAGE")=""
   . S @MEDVMAP@("MEDDATETIMEAGEUNITS")=""
   . S @MEDVMAP@("MEDTYPETEXT")="Medication"
   . S @MEDVMAP@("MEDSTATUSTEXT")=$P(MEDPTMP,"^",10) ; STATUS FROM RPC
   . S @MEDVMAP@("MEDSOURCEACTORID")="ACTORSYSTEM_1"
   . S @MEDVMAP@("MEDPRODUCTNAMETEXT")=$P(MEDPTMP,"^",3)
   . S @MEDVMAP@("MEDPRODUCTNAMECODEVALUE")=""
   . S @MEDVMAP@("MEDPRODUCTNAMECODINGINGSYSTEM")=""
   . S @MEDVMAP@("MEDPRODUCTNAMECODEVERSION")=""
   . S @MEDVMAP@("MEDBRANDNAMETEXT")=""
   . S @MEDVMAP@("MEDBRANDNAMECODEVALUE")=""
   . S @MEDVMAP@("MEDBRANDNAMECODINGSYSTEM")=""
   . S @MEDVMAP@("MEDBRANDNAMECODEVERSION")=""
   . S @MEDVMAP@("MEDSTRENGTHVALUE")=""
   . S @MEDVMAP@("MEDSTRENGTHUNIT")=""
   . S @MEDVMAP@("MEDFORMTEXT")=""
   . S @MEDVMAP@("MEDQUANTITYVALUE")=""
   . S @MEDVMAP@("MEDQUANTITYUNIT")=""
   . S @MEDVMAP@("MEDRFNO")=""
   . S ZK=$P(ZA(ZI),U,2) ; NUMBER OF LINES IN MED
   . I ZK>1 D  ; MORE THAN ONE LINE IN MED
   . . S @MEDVMAP@("MEDDESCRIPTIONTEXT")=$P(MEDRSLT(ZJ+1)," *",2)
   . I ZK>2 D  ; THIRD THROUGH 2+N LINES OF MED ARE INSTRUCTIONS
   . . N TMPTXT S TMPTXT="" ; BUILD UP INSTRUCTION LINE
   . . S ZN=0 ; DON'T KNOW WHY
   . . F ZN=2:1:ZK-1 D  ; REMAINING LINES IN EACH MED
   . . . I MEDRSLT(ZJ+ZN)]"\ Sig: " D  ; REMOVE THIS MARKUP
   . . . . S TMPTXT=TMPTXT_$P(MEDRSLT(ZJ+ZN),"\ Sig: ",2)_" " ; APPEND 2 TMPTXT
   . . . E  S TMPTXT=TMPTXT_MEDRSLT(ZJ+ZN)_" " ; SEPARATE LINES WITH SPACE
   . . S @MEDVMAP@("MEDDIRECTIONDESCRIPTIONTEXT")=TMPTXT ; CP TO MAP VAR
   . S @MEDVMAP@("MEDDOSEVALUE")=""
   . S @MEDVMAP@("MEDDOSEUNIT")=""
   . S @MEDVMAP@("MEDFREQUENCYVALUE")=""
   . S @MEDVMAP@("MEDDURATIONVALUE")=""
   . S @MEDVMAP@("MEDDURATIONUNIT")=""
   . S @MEDVMAP@("MEDDIRECTIONROUTETEXT")=""
   . S @MEDVMAP@("MEDDIRECTIONFREQUENCYVALUE")=""
   . S MEDARYTMP=$NA(@MEDTARYTMP@(ZI))
   . K @MEDARYTMP
   . D MAP^GPLXPATH(MEDXML,MEDVMAP,MEDARYTMP)
   . I ZI=1 D  ; FIRST ONE IS JUST A COPY
   . . ; W "FIRST ONE",!
   . . D CP^GPLXPATH(MEDARYTMP,MEDOUTXML)
   . I ZI>1 D  ; AFTER THE FIRST, INSERT INNER XML
   . . D INSINNER^GPLXPATH(MEDOUTXML,MEDARYTMP)
   N MEDTMP,MEDI
   D MISSING^GPLXPATH(MEDOUTXML,"MEDTMP") ; SEARCH XML FOR MISSING VARS
   I MEDTMP(0)>0 D  ; IF THERE ARE MISSING VARS - MARKED AS @@X@@
   . W "MEDICATION MISSING ",!
   . F MEDI=1:1:MEDTMP(0) W MEDTMP(MEDI),!
   Q
   ;
