ewdu ; JJIH/SMH - Utilities for EWD to VISTA interaction ; 11/18/11 5:39pm
 ;
r(sessid) ; Restore Symbol Table
 d mergeArrayFromSession^%zewdAPI(.DUZ,"DUZ",sessid)
 d mergeArrayFromSession^%zewdAPI(.IO,"IO",sessid)
 s U=$$getSessionValue^%zewdAPI("U",sessid)
 quit
 ;
s(sessid) ; Save to Symbol Table
 d mergeArrayToSession^%zewdAPI(.DUZ,"DUZ",sessid)
 d mergeArrayToSession^%zewdAPI(.IO,"IO",sessid)
 d setSessionValue^%zewdAPI("U","^",sessid)
 quit
 ;
NULL ; Open Null Device
 s %ZIS="0H",IOP="NULL" d ^%ZIS
 i POP s $ec=",U1,"  ; this crashes everything... intended...
 q
 ;
SETUP(sessid) ; Set-up and SSO
 ; TODO: Set IO("CLNM")
 i '$data(IO) d NULL                  ; Open Null Device
 s IO("IP")=$$getServerValue^%zewdAPI("REMOTE_ADDR",sessid)
 n return
 d SETUP^XUSRB(.return)               ; Set-up and Try SSO
 i $g(return(5)),DUZ>0 q $$s(sessid)  ; Single Sign-On Successful!
 e  d  q ""                           ; Otherwise, get INTRO text
 . N RET
 . D INTRO^XUSRB(.RET)
 . d mergeArrayToSession^%zewdAPI(.RET,"introtxt",sessid)
 ; ---
so(sessid) ; SO from EWD; routes to $$SO
 ; TODO: Set IO("CLNM")
 d NULL                             ; IO set-up
 s IO("IP")=$$getServerValue^%zewdAPI("REMOTE_ADDR",sessid)
 d SETUP^XUSRB();                   ; This time, just need partition set-up
 n ac s ac=$$getSessionValue^%zewdAPI("ac",sessid)
 n vc s vc=$$getSessionValue^%zewdAPI("vc",sessid)
 n result s result=$$SO(ac,vc)
 ;
 ; Change Verify Code Logic Ahead... Damn Complex!
 i $l(result),result="CVC" d  q ""  ; User must change Verify Code
 . S DUZ=$$STATE^XWBSEC("XUS DUZ")  ; VISTA kills off DUZ if vc needs changing.
 .                                  ; That's fine when it can get it back. But we are not a stateful process.
 .                                  ; By the time the second request is made, XUS DUZ is gone gone gone.
 . d s(sessid)                      ; Save symbol table for next page (including DUZ)
 . d setRedirect^%zewdAPI("cvc",sessid) ; Next page is cvc.
 . d setSessionValue^%zewdAPI("cvcForced",1,sessid) ; Need to know that the user is toast!
 ;
 i $l(result) q result  ; General Error Message - User can't log-in
 ;
 e  d  q ""  ; Everything Okay
 . d s(sessid)
 . i $$isCheckboxOn^%zewdAPI("cvc","cvc",sessid) d setRedirect^%zewdAPI("cvc",sessid)
 ;
SO(ac,vc) ; Sign-on to VISTA, AV way
 ; TODO: Handle the rest of the return values
 N return
 D VALIDAV^XUSRB(.return,$$ENCRYP^XUSRB1(ac_";"_vc))
 i return(0)>0,'return(2) q "" ; Sign on successful!
 i return(0)=0,return(2) q "CVC"  ; Verify Code must be changed NOW!
 i $l(return(3)) q return(3)  ; Error Message returned whole
 ; Note: division selection not implemented here
 quit ""
 ; ---
sss(id) ; Test
 d setRedirect^%zewdAPI("index",id,"bb")
 q ""
whoami(sessid) ; Who Am I? PrePage Script
 d r(sessid)
 n Name s Name=$$GET1^DIQ(200,DUZ,.01) ; User Name
 d setSessionValue^%zewdAPI("Name",Name,sessid)
 q ""
cvc(sessid) ; Change Verify Code
 ; get stored session values for DUZ, IO, and U
 d r(sessid) ; Restore the Symbol Table
 n VC1,VC2,VC3
 s VC1=$$getPasswordValue^%zewdAPI("vc1",sessid)
 s VC2=$$getPasswordValue^%zewdAPI("vc2",sessid)
 s VC3=$$getPasswordValue^%zewdAPI("vc3",sessid)
 ; Uppercase them -- otherwise CVC will fail.
 s VC1=$$UP^XLFSTR(VC1)
 s VC2=$$UP^XLFSTR(VC2)
 s VC3=$$UP^XLFSTR(VC3)
 ; Roman Cipher them vista-wise
 n eVC1,eVC2,eVC3
 s eVC1=$$ENCRYP^XUSRB1(VC1)
 s eVC2=$$ENCRYP^XUSRB1(VC2)
 s eVC3=$$ENCRYP^XUSRB1(VC3)
 ; Set-up Call
 n vcString s vcString=eVC1_U_eVC2_U_eVC3
 n ret
 d CVC^XUSRB(.ret,vcString)
 i ret(0)=0 q ""  ; Success
 i ret(0)>0 q ret(1)  ; Failure
 ;;
 ;;return(0)=0
 ;;return(1)=0
 ;;return(2)=1
 ;;return(3)="VERIFY CODE must be changed before continued use."
 ;;return(4)=0
 ;;return(5)=0
 ;;return(6)=""
 ;;return(7)="Good evening DOCTOR,TEN"
 ;;return(8)="     You last signed on today at 22:19"
listEWDApps(sessid)  ; Lists all available EWD Applicaitons, not including ewdMgr. Intended to be an imitation of a menu.
 n apps  ; Will hold our applications
 do
 . n ewdpath s ewdpath=^zewd("config","applicationRootPath")
 . o "lsApps":(shell="/bin/bash":command="ls -1 "_ewdpath:READONLY)::"PIPE"
 . u "lsApps"
 . n line
 . n counter s counter=1
 . for  read line quit:$zeof  do
 . . i line="ewdMgr" quit  ; Don't include ewdMgr
 . . s apps(counter)=line
 . . s counter=counter+1
 . c "lsApps"
 . zwrite:$g(debug) apps
 . d mergeArrayToSession^%zewdAPI(.apps,"installedapps",sessid)
 ;
 ; Old code: uses JSON
 ; n appsjson s appsjson=$$arrayToJSON^%zewdJSON("apps")
 ; zwrite:$g(debug) appsjson
 ; d setSessionValue^%zewdAPI("appsjson",appsjson,sessid)
 ; 
 q ""
redir(sessid)
 n redirapp s redirapp=$$getRequestValue^%zewdAPI("nextapp",sessid)
 d setRedirect^%zewdAPI("index",sessid,redirapp)
 q ""
 ;

FILES(sessid)  ; Get File of Files
 d clearList^%zewdAPI("file",sessid)                        ; Clean
 N FILE S FILE=""                                           ; Looper that is also the File Name
 FOR  S FILE=$O(^DIC("B",FILE)) QUIT:FILE=""  DO            ; ditto
 . N IEN S IEN=$O(^(FILE,""))                               ; IEN from 2nd subscript in B index
 . d appendToList^%zewdAPI("file",FILE,IEN,sessid)          ; Add to session
 Q ""
ENTRY(sessid)  ; Get Entries in a specific file
 d clearList^%zewdAPI("entry",sessid)                       ; Clean
 n file s file=$$getSessionValue^%zewdAPI("file",sessid)    ; Get select file from combo box
 n glo s glo=^DIC(file,0,"GL")                              ; Get File Global
 s glo=$$CREF^DILF(glo)                                     ; Get the closed root reference
 N ENTRY S ENTRY=""                                         ; Looper that is also the Entry
 FOR  S ENTRY=$O(@glo@("B",ENTRY)) QUIT:ENTRY=""  DO        ; ditto
 . N IEN S IEN=$O(^(ENTRY,""))                              ; IEN
 . d appendToList^%zewdAPI("entry",ENTRY,IEN,sessid)        ; Add to session
 Q ""
CAPOPTS(sessid) ; Nothing much
 K ^SAMOPTS
 ZSHOW "V":^SAMOPTS
 Q ""
INQ(sessid) ; DIINQUIRE Application Pre-Page Script
 ;
 ; First, get the options
 n outopt   ; Output Options checkbox values
 d getCheckboxValues^%zewdAPI("outopt",.outopt,sessid)
 n capopts s capopts=""  ; Caption Options to get from checkbox values
 n i s i=""
 for  set i=$order(outopt(i)) q:i=""  s capopts=capopts_i
 ;
 ; Get File and Entry
 n file s file=$$getSessionValue^%zewdAPI("file",sessid)
 n entry s entry=$$getRequestValue^%zewdAPI("entry",sessid)
 ;
 ; dbug dbug
 k ^ZZSAM
 ZSHOW "V":^ZZSAM
 ;
 ; Now actual VISTA work--write out the output to a file
 S IOP="HFS" D ^%ZIS    ; Open HFS Device
 U IO                   ; USE HFS Device
 ; D CAPTION^DIQ(file,entry,capopts)      ; Write Out Report
 D CAPTION^DIQ(file,1,"ARC")      ; Temp until Russian Doll is fixed :-(
 D ^%ZISC               ; Close Device
 ; done
 ;
 ; This code doesn't work, and my debugger couldn't go through it.
 ; something is wrong--and I have an old version of GT.M--why is this happening?
 ; N PATH S PATH=$$PATH^MXMLPRSE(IO("CLOSE"))
 ; N FILE S FILE=$P(IO("CLOSE"),PATH,2)
 ; N RESULT S RESULT=$$FTG^%ZISH(PATH,FILE,$NAME(^TMP("EWDU",$J)),3) ; Doesn't work!!!
 ;
 ; ------------------> Read the File Back
 OPEN IO("CLOSE"):(READONLY:rewind)       ; Open Again for reading
 USE IO("CLOSE")        ; Use
 N CNT S CNT=1          ; Counter
 KILL ^TMP("EWDU",$J)   ; Kill TMP Global
 FOR  DO  Q:$ZEOF       ; Read the file
 . N % R %
 . S ^TMP("EWDU",$J,CNT)=%
 . S CNT=CNT+1
 C IO("CLOSE"):(delete) ; Close and delete
 ; <------------------ Close the File
 ;
 ; Move to EWD Session
 d clearSessionArray^%zewdAPI("DIINQUIRE",sessid)
 d mergeGlobalToSession^%zewdAPI($NAME(^TMP("EWDU",$J)),"DIINQUIRE",sessid)
 QUIT ""
