C0CRNF	  ; CCDCCR/GPL - Reference Name Format (RNF) utilities; 12/6/08
	;;1.0;C0C;;May 19, 2009;Build 1
	;Copyright 2009 George Lilly.  Licensed under the terms of the GNU
	;General Public License See attached copy of the License.
	;
	;This program is free software; you can redistribute it and/or modify
	;it under the terms of the GNU General Public License as published by
	;the Free Software Foundation; either version 2 of the License, or
	;(at your option) any later version.
	;
	;This program is distributed in the hope that it will be useful,
	;but WITHOUT ANY WARRANTY; without even the implied warranty of
	;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	;GNU General Public License for more details.
	;
	;You should have received a copy of the GNU General Public License along
	;with this program; if not, write to the Free Software Foundation, Inc.,
	;51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
	;
	W "This is the Reference Name Format (RNF) Utility Library ",!
	W !
	Q
	;
FIELDS(C0CFRTN,C0CF)	; RETURNS AN ARRAY OF THE FIELDS IN FILE C0CF,
	; C0CFRTN IS PASSED BY NAME, C0CF IS PASSED BY VALUE
	;
	N C0CFI,C0CFJ ;INNER LOOP, OUTER LOOP
	N C0CFN ; FIELD NAME
	S C0CFI=0 S C0CFJ=C0CF
	K @C0CFRTN ; CLEAR THE RETURN ARRAY
	F  Q:C0CFJ'[C0CF  D ; FOR THE C0CF FILE AND ALL SUBFILES INCLUSIVE
	. ;W "1: "_C0CFJ," ",C0CFI,!
	. F  S C0CFI=$O(^DD(C0CFJ,C0CFI)) Q:+C0CFI=0  D  ; EVERY FIELD
	. . ;W "2: "_C0CFJ," ",C0CFI,!
	. . S C0CFN=$P($G(^DD(C0CFJ,C0CFI,0)),"^",1) ;PULL FIELD NAME FROM ^DD
	. . ;W "N: ",C0CFN,!
	. . ;I C0CFN="STR" W C0CFN," ",C0CFJ,!
	. . I $D(@C0CFRTN@(C0CFN)) D  ; IS THIS A DUPLICATE?
	. . . I $G(DEBUG) D  ;
	. . . . W "DUPLICATE FOUND! ",C0CFJ," ",C0CFI," ",C0CFN,!,@C0CFRTN@(C0CFN),!
	. . . S @C0CFRTN@(C0CFN_"_"_C0CFJ)=C0CFJ_"^"_C0CFI
	. . E  S @C0CFRTN@(C0CFN)=C0CFJ_"^"_C0CFI
	. S C0CFJ=$O(^DD(C0CFJ)) ; NEXT SUBFILE
	Q
	;
TESTRNF	; TEST THE RNF1TO2 ROUTINE
	S G1("ONE")=1
	S G1("TWO")=2
	S G1("THREE")=3
	D RNF1TO2("GPL","G1")
	S G1("ONE")="NOT1"
	S G1("TWO")="STILL2"
	S G1("THREE")=3
	D RNF1TO2("GPL","G1")
	ZWR GPL
	Q
	;
RNF1TO2(ZOUT,ZIN)	; ADDS AN RNF1 ARRAY (ZIN) TO THE END OF AN RNF2 ARRAY 
	; (ZOUT) BOTH ARE PASSED BY NAME
	; RNF1 IS OF THE FORM:
	; @ZIN@("VAR1")=VAL1 
	; @ZIN@("VAR2")=VAL2 
	; RNF2 IS OF THE FORM:
	; @ZOUT@("F","VAR1")=""
	; @ZOUT@("F","VAR2")=""
	; @ZOUT@("V",n,"VAR1")=VAL1
	; @ZOUT@("V",n,"VAR2")=VAL2
	; WHERE n IS THE "ROW" OF THE ARRAY
	N ZI S ZI=""
	N ZN
	I '$D(@ZOUT@("V",1)) S ZN=1
	E  S ZN=$O(@ZOUT@("V",""),-1)+1
	F  S ZI=$O(@ZIN@(ZI)) Q:ZI=""  D  ;
	. S @ZOUT@("F",ZI)=""
	. S @ZOUT@("V",ZN,ZI)=@ZIN@(ZI)
	Q
	;
RNF1TO2B(ZOUT,ZIN)	; ADDS AN RNF1 ARRAY (ZIN) TO THE END OF AN RNF2 ARRAY 
	; THE "B" ROUTINE SUPPORTS WP FIELDS IN THE ARRAY
	; EVERY "V" VARIABLE IS FOLLOWED BY A "1"
	; FOR EXAMPLE @G@("V",n,"VAR1",1)="VALUE1"
	; USE THIS ROUTINE IF YOU WANT TO CONVERT THE RESULT TO A CSV 
	; WITH RNF2CSV 
	; (ZOUT) BOTH ARE PASSED BY NAME
	; RNF1 IS OF THE FORM:
	; @ZIN@("VAR1")=VAL1 
	; @ZIN@("VAR2")=VAL2 
	; RNF2 IS OF THE FORM:
	; @ZOUT@("F","VAR1")=""
	; @ZOUT@("F","VAR2")=""
	; @ZOUT@("V",n,"VAR1",1)=VAL1
	; @ZOUT@("V",n,"VAR2",1)=VAL2
	; WHERE n IS THE "ROW" OF THE ARRAY
	N ZI S ZI=""
	N ZN
	I '$D(@ZOUT@("V",1)) S ZN=1
	E  S ZN=$O(@ZOUT@("V",""),-1)+1
	F  S ZI=$O(@ZIN@(ZI)) Q:ZI=""  D  ;
	. S @ZOUT@("F",ZI)=""
	. S @ZOUT@("V",ZN,ZI,1)=@ZIN@(ZI)
	Q
	;
GETNOLD(GRTN,GFILE,GIEN,GNN)	; GET FIELDS FOR ACCESS BY NAME
	; GRTN IS PASSED BY NAME
	;
	N C0CTMP,C0CI,C0CJ,C0CREF,C0CNAME
	I $D(GNN) I GNN="ALL" S C0CNN=0 ; NOT NON-NULL (ALL FIELDS TO BE RETURNED)
	E  S C0CNN=1 ; NON-NULL IS TRUE (ONLY POPULATED FIELDS RETURNED)
	S C0CREF=GIEN_"," ; OPEN ROOT REFERENCE INTO FILE
	D CLEAN^DILF ; MAKE SURE WE ARE CLEANED UP
	D GETS^DIQ(GFILE,C0CREF,"**","I","C0CTMP")
	D FIELDS(GRTN,GFILE) ;GET ALL THE FIELD NAMES FOR THE FILE
	S @GRTN@(0)=GFILE_"^RNF1^"_GIEN_"^"_DT_"^"_$J ; STRUCTURE SIGNATURE
	S (C0CI,C0CJ)=""
	F  S C0CJ=$O(C0CTMP(C0CJ)) Q:C0CJ=""  D  ; FOR ALL SUBFILES
	. S C0CREF=$O(C0CTMP(C0CJ,"")) ; RECORD REFERENCE
	. F  S C0CI=$O(C0CTMP(C0CJ,C0CREF,C0CI)) Q:C0CI=""  D  ; ARRAY OF FIELDS
	. . ;W C0CJ," ",C0CI,!
	. . S C0CNAME=$P(^DD(C0CJ,C0CI,0),"^",1) ;PULL THE FIELD NAME
	. . S C0CVALUE=C0CTMP(C0CJ,C0CREF,C0CI) ;
	. . I C0CVALUE["C0CTMP" S C0CVALUE=C0CTMP(C0CJ,C0CREF,C0CI,1) ;1ST LINE OF WP
	. . S $P(@GRTN@(C0CNAME),"^",3)=C0CVALUE ;RETURN VALUE IN P3
	I C0CNN D  ; IF ONLY NON-NULL VALUES ARE TO BE RETURNED
	. S C0CI=""
	. F  S C0CI=$O(@GRTN@(C0CI)) Q:C0CI=""  D  ; GO THROUGH THE WHOLE ARRAY
	. . I $P(@GRTN@(C0CI),"^",3)="" K @GRTN@(C0CI) ; KILL THE NULL ENTRIES
	Q
	;
GETN(GRTN,GFILE,GREF,GNDX,GNN)	; GET BY NAME ; RETURN A FIELD VALUE MAP
	; THE FOLLOWING COMMENTS ARE WRONG.. THIS ROUTINE STILL RETURNS AN RNF1
	; FORMAT ARRAY @GRTN@("FIELD NAME")="FILE^FIELD#^VALUE" ;GPL
	; GETN IS AN EXTRINSIC WHICH RETURNS THE NEXT IEN AFTER THE CURRENT GIEN
	; GRTN, PASSED BY NAME, RETURNS A FIELD MAP AND A VALUE MAP
	; .. FIELD MAP @GRTN@("F","FIELDNAME^FILE^FIELD#")=""
	; ... ANY FIELD USED BY ANY RECORD PROCESSED IS IN THE FIELD MAP
	; .. VALUE MAP @GRTN@("V","IEN","FIELDNAME")=VALUE
	; .. GRTN IS NOT INITIALIZED, SO MULTIPLE CALLS ARE CUMULATIVE
	; .. IF GNN="ALL" THEN ALL FIELDS FOR THE FILE ARE IN THE FIELD MAP
	; .. EVEN IF GNN="ALL" ONLY POPULATED FIELDS ARE RETURNED IN THE VALUE MAP
	; .. NUL FIELDS CAN BE DETERMINED BY CHECKING FIELD MAP - THIS SAVES SPACE
	; IF GREF IS "" THE FIRST RECORD IS OBTAINED
	; IF GNDX IS NULL, GREF IS AN IEN FOR THE FILE
	; GNDX IS THE INDEX TO USE TO OBTAIN THE IEN
	; GREF IS THE VALUE FOR THE INDEX
	; GANN= NOT NULL - IF GANN IS "ALL" THEN EVEN NULL FIELDS WILL BE RETURNED
	; OTHERWISE, ONLY POPULATED FIELDS ARE RETURNED IN GRTN
	;
	;
	N GIEN,GF
	S GF=$$FILEREF(GFILE) ;CLOSED FILE REFERENCE FOR FILE NUMBER GFILE
	I ('$D(GNDX))!($G(GNDX)="") S GIEN=GREF ; IF NO INDEX USED, GREF IS THE IEN
	E  D  ; WE ARE USING AN INDEX
	. ;N ZG
	. S ZG=$Q(@GF@(GNDX,GREF)) ;ACCESS INDEX
	. I ZG'="" D  ;
	. . I $QS(ZG,3)=GREF D  ; IS GREF IN INDEX?
	. . . S GIEN=$QS(ZG,4) ; PULL OUT THE IEN
	. . E  S GIEN="" ; NOT FOUND IN INDEX
	. E  S GIEN="" ;
	;W "IEN: ",GIEN,!
	;N C0CTMP,C0CI,C0CJ,C0CREF,C0CNAME
	I $D(GNN) I GNN="ALL" S C0CNN=0 ; NOT NON-NULL (ALL FIELDS TO BE RETURNED)
	E  S C0CNN=1 ; NON-NULL IS TRUE (ONLY POPULATED FIELDS RETURNED)
	S C0CREF=GIEN_"," ; OPEN ROOT REFERENCE INTO FILE
	D CLEAN^DILF ; MAKE SURE WE ARE CLEANED UP
	K C0CTMP
	D GETS^DIQ(GFILE,C0CREF,"**","IE","C0CTMP")
	D FIELDS(GRTN,GFILE) ;GET ALL THE FIELD NAMES FOR THE FILE
	S @GRTN@(0)=GFILE_"^RNF1^"_GIEN_"^"_DT_"^"_$J_"^"_DUZ ; STRUCTURE SIGNATURE
	S (C0CI,C0CJ)=""
	F  S C0CJ=$O(C0CTMP(C0CJ)) Q:C0CJ=""  D  ; FOR ALL SUBFILES
	. S C0CREF=$O(C0CTMP(C0CJ,"")) ; RECORD REFERENCE
	. F  S C0CI=$O(C0CTMP(C0CJ,C0CREF,C0CI)) Q:C0CI=""  D  ; ARRAY OF FIELDS
	. . ;W C0CJ," ",C0CI,!
	. . S C0CNAME=$P(^DD(C0CJ,C0CI,0),"^",1) ;PULL THE FIELD NAME
	. . S C0CVALUE=C0CTMP(C0CJ,C0CREF,C0CI,"E") ;
	. . I C0CVALUE["C0CTMP" D  ; WP FIELD
	. . . N ZT,ZWP S ZWP=0 ;ITERATOR
	. . . S ZWP=$O(C0CTMP(C0CJ,C0CREF,C0CI,ZWP)) ; INIT TO FIRST LINE
	. . . S C0CVALUE=C0CTMP(C0CJ,C0CREF,C0CI,ZWP) ; INIT TO FIRST LINE
	. . . F  S ZWP=$O(C0CTMP(C0CJ,C0CREF,C0CI,ZWP)) Q:'ZWP  D  ;
	. . . . S ZT=" "_C0CTMP(C0CJ,C0CREF,C0CI,ZWP) ;LINE OF WP
	. . . . S ZT=$TR(ZT,"^""","|'") ;HACK TO GET RID OF ^ AND " IN TEXT "
	. . . . S C0CVALUE=C0CVALUE_ZT ;
	. . S $P(@GRTN@(C0CNAME),"^",3)=C0CVALUE ;RETURN VALUE IN P3
	. . S $P(@GRTN@(C0CNAME,"I"),"^",3)=$G(C0CTMP(C0CJ,C0CREF,C0CI,"I"))
	I C0CNN D  ; IF ONLY NON-NULL VALUES ARE TO BE RETURNED
	. S C0CI=""
	. F  S C0CI=$O(@GRTN@(C0CI)) Q:C0CI=""  D  ; GO THROUGH THE WHOLE ARRAY
	. . I $P(@GRTN@(C0CI),"^",3)="" K @GRTN@(C0CI) ; KILL THE NULL ENTRIES
	Q
	;
GETN1(GRTN,GFILE,GREF,GNDX,GNN)	; NEW GET ;GPL ; RETURN A FIELD VALUE MAP
	; THE FOLLOWING COMMENTS ARE WRONG.. THIS ROUTINE STILL RETURNS AN RNF1
	; FORMAT ARRAY @GRTN@("FIELD NAME")="FILE^FIELD#^VALUE" ;GPL
	; GETN IS AN EXTRINSIC WHICH RETURNS THE NEXT IEN AFTER THE CURRENT GIEN
	; GRTN, PASSED BY NAME, RETURNS A FIELD MAP AND A VALUE MAP
	; .. FIELD MAP @GRTN@("F","FIELDNAME^FILE^FIELD#")=""
	; ... ANY FIELD USED BY ANY RECORD PROCESSED IS IN THE FIELD MAP
	; .. VALUE MAP @GRTN@("V","IEN","FIELDNAME")=VALUE
	; .. GRTN IS NOT INITIALIZED, SO MULTIPLE CALLS ARE CUMULATIVE
	; .. IF GNN="ALL" THEN ALL FIELDS FOR THE FILE ARE IN THE FIELD MAP
	; .. EVEN IF GNN="ALL" ONLY POPULATED FIELDS ARE RETURNED IN THE VALUE MAP
	; .. NUL FIELDS CAN BE DETERMINED BY CHECKING FIELD MAP - THIS SAVES SPACE
	; IF GREF IS "" THE FIRST RECORD IS OBTAINED
	; IF GNDX IS NULL, GREF IS AN IEN FOR THE FILE
	; GNDX IS THE INDEX TO USE TO OBTAIN THE IEN
	; GREF IS THE VALUE FOR THE INDEX
	; GANN= NOT NULL - IF GANN IS "ALL" THEN EVEN NULL FIELDS WILL BE RETURNED
	; OTHERWISE, ONLY POPULATED FIELDS ARE RETURNED IN GRTN
	;
	;
	N GIEN,GF
	S GF=$$FILEREF(GFILE) ;CLOSED FILE REFERENCE FOR FILE NUMBER GFILE
	I ('$D(GNDX))!(GNDX="") S GIEN=GREF ; IF NO INDEX USED, GREF IS THE IEN
	E  D  ; WE ARE USING AN INDEX
	. ;N ZG
	. S ZG=$Q(@GF@(GNDX,GREF)) ;ACCESS INDEX
	. I ZG'="" D  ;
	. . I $QS(ZG,3)=GREF D  ; IS GREF IN INDEX?
	. . . S GIEN=$QS(ZG,4) ; PULL OUT THE IEN
	. . E  S GIEN="" ; NOT FOUND IN INDEX
	. E  S GIEN="" ;
	;W "IEN: ",GIEN,!
	;N C0CTMP,C0CI,C0CJ,C0CREF,C0CNAME
	I $D(GNN) I GNN="ALL" S C0CNN=0 ; NOT NON-NULL (ALL FIELDS TO BE RETURNED)
	E  S C0CNN=1 ; NON-NULL IS TRUE (ONLY POPULATED FIELDS RETURNED)
	S C0CREF=GIEN_"," ; OPEN ROOT REFERENCE INTO FILE
	D CLEAN^DILF ; MAKE SURE WE ARE CLEANED UP
	K C0CTMP
	D GETS^DIQ(GFILE,C0CREF,"**","IE","C0CTMP")
	D FIELDS(GRTN,GFILE) ;GET ALL THE FIELD NAMES FOR THE FILE
	S @GRTN@(0)=GFILE_"^RNF1^"_GIEN_"^"_DT_"^"_$J_"^"_DUZ ; STRUCTURE SIGNATURE
	S (C0CI,C0CJ)=""
	F  S C0CJ=$O(C0CTMP(C0CJ)) Q:C0CJ=""  D  ; FOR ALL SUBFILES
	. S C0CREF=$O(C0CTMP(C0CJ,"")) ; RECORD REFERENCE
	. F  S C0CI=$O(C0CTMP(C0CJ,C0CREF,C0CI)) Q:C0CI=""  D  ; ARRAY OF FIELDS
	. . ;W C0CJ," ",C0CI,!
	. . S C0CNAME=$P(^DD(C0CJ,C0CI,0),"^",1) ;PULL THE FIELD NAME
	. . S C0CVALUE=C0CTMP(C0CJ,C0CREF,C0CI,"E") ;
	. . I C0CVALUE["C0CTMP" D  ; WP FIELD
	. . . N ZT,ZWP S ZWP=0 ;ITERATOR
	. . . S ZWP=$O(C0CTMP(C0CJ,C0CREF,C0CI,ZWP)) ; INIT TO FIRST LINE
	. . . S C0CVALUE=C0CTMP(C0CJ,C0CREF,C0CI,ZWP) ; INIT TO FIRST LINE
	. . . F  S ZWP=$O(C0CTMP(C0CJ,C0CREF,C0CI,ZWP)) Q:'ZWP  D  ;
	. . . . S ZT=" "_C0CTMP(C0CJ,C0CREF,C0CI,ZWP) ;LINE OF WP
	. . . . S ZT=$TR(ZT,"^""","|'") ;HACK TO GET RID OF ^ AND " IN TEXT "
	. . . . S C0CVALUE=C0CVALUE_ZT ;
	. . S $P(@GRTN@(C0CNAME),"^",3)=C0CVALUE ;RETURN VALUE IN P3
	. . S $P(@GRTN@(C0CNAME,"I"),"^",3)=$G(C0CTMP(C0CJ,C0CREF,C0CI,"I"))
	I C0CNN D  ; IF ONLY NON-NULL VALUES ARE TO BE RETURNED
	. S C0CI=""
	. F  S C0CI=$O(@GRTN@(C0CI)) Q:C0CI=""  D  ; GO THROUGH THE WHOLE ARRAY
	. . I $P(@GRTN@(C0CI),"^",3)="" K @GRTN@(C0CI) ; KILL THE NULL ENTRIES
	Q
	;
GETN2(GARTN,GAFILE,GAIDX,GACNT,GASTRT,GANN)	; RETURN FIELD MAP AND VALUES
	; GARTN, PASSED BY NAME, RETURNS A FIELD MAP AND A VALUE MAP
	; .. FIELD MAP @GARTN@("F","FIELDNAME")="FILE;FIELD#"
	; ... ANY FIELD USED BY ANY RECORD PROCESSED IS IN THE FIELD MAP
	; .. VALUE MAP @GARTN@("V","IEN","FIELDNAME","N")=VALUE
	; .. WHERE N IS THE INDEX FOR MULTIPLES.. 1 FOR SINGLE VALUES
	; .. GARTN IS NOT INITIALIZED, SO MULTIPLE CALLS ARE CUMULATIVE
	; .. IF GANN="ALL" THEN ALL FIELDS FOR THE FILE ARE IN THE FIELD MAP
	; .. EVEN IF GANN="ALL" ONLY POPULATED FIELDS ARE RETURNED IN THE VALUE MAP
	; .. NUL FIELDS CAN BE DETERMINED BY CHECKING FIELD MAP - THIS SAVES SPACE
	; GAFILE IS THE FILE NUMBER TO BE PROCESSED. IT IS PASSED BY VALUE
	; GAIDX IS THE OPTIONAL INDEX TO USE IN THE FILE. IF GAIDX IS "" THE IEN
	; .. OF THE FILE WILL BE USED
	; GACNT IS THE NUMBER OF RECORDS TO PROCESS. IT IS PASSED BY VALUE
	; .. IF GARCNT IS NULL, ALL RECORDS ARE PROCESSED
	; GASTRT IS THE IEN OF THE FIRST RECORD TO PROCESS. IT IS PASSED BY VALUE
	; .. IF GARSTART IS NULL, PROCESSING STARTS AT THE FIRST RECORD
	; GANN= NOT NULL - IF GANN IS "ALL" THEN EVEN NULL FIELDS WILL BE RETURNED
	; OTHERWISE, ONLY POPULATED FIELDS ARE RETURNED IN GARFLD AND GARVAL
	;N GATMP,GAI,GAF
	S GAF=$$FILEREF(GAFILE) ; GET CLOSED ROOT FOR THE FILE NUMBER GAFILE
	I '$D(GAIDX) S GAIDX="" ;DEFAULT
	I '$D(GANN) S GANN="" ;DEFAULT ONLY POPULATED FIELDS RETURNED
	I GAIDX'="" S GAF=$NA(@GAF@(GAIDX)) ; IF WE ARE USING AN INDEX
	W GAF,!
	W $O(@GAF@(0)) ;
	S GAI=0 ;ITERATOR
	F  S GAI=$O(@GAF@(GAI)) Q:GAI=""  D  ;
	. D GETN1("GATMP",GAFILE,GAI,GAIDX,GANN) ;GET ONE RECORD
	. N GAX S GAX=0
	. F  S GAX=$O(GATMP(GAX)) Q:GAX=""  D  ;PULL OUT THE FIELDS
	. . D ADDNV(GARTN,GAI,GAX,GATMP(GAX)) ;INSERT THE NAME/VALUE INTO GARTN
	Q
	;
ADDNV(GNV,GNVN,GNVF,GNVV)	; CREATE AN ELEMENT OF THE MATRIX
	;
	S @GNV@("F",GNVF)=$P(GNVV,"^",1)_"^"_$P(GNVV,"^",2) ;NAME=FILE^FIELD#
	S @GNV@("V",GNVN,GNVF,1)=$P(GNVV,"^",3) ;SET THE VALUE
	Q
	;
RNF2CSV(RNRTN,RNIN,RNSTY)	;CONVERTS AN RFN2 GLOBAL TO A CSV FORMAT
	; READY TO WRITE FOR USE WITH EXCEL @RNRTN@(0) IS NUMBER OF LINES
	; RNSTY IS STYLE OF THE OUTPUT -
	; .. "NV"= ROWS ARE NAMES, COLUMNS ARE VALUES
	; .. "VN"= ROWS ARE VALUES, COLUMNS ARE NAMES
	; .. DEFAULT IS "NV" BECAUSE MANY MATRICES HAVE MORE FIELDS THAN VALUES
	N RNR,RNC ;ROW ROOT,COL ROOT
	N RNI,RNJ,RNX
	I '$D(RNSTY) S RNSTY="NV" ;DEFAULT
	I RNSTY="NV" D NV(RNRTN,RNIN)  ; INTERNAL SUBROUTINES DEPENDING ON ORIENTATION
	E  D VN(RNRTN,RNIN) ;
	Q
	;
NV(RNRTN,RNIN)	;
	S RNR=$NA(@RNIN@("F"))
	S RNC=$NA(@RNIN@("V"))
	;S RNY=$P(@RNIN@(0),"^",1) ; FILE NUMBER
	S RNX="""FILE"""_"," ; FIRST COLUMN NAME IS "FIELD"
	S RNI=""
	F  S RNI=$O(@RNC@(RNI)) Q:RNI=""  D  ; FOR EACH COLUMN
	. S RNX=RNX_RNI_"," ;ADD THE COLUMM ELEMENT AND A COMMA
	S RNX=$E(RNX,1,$L(RNX)-1) ; STRIP OFF THE LAST COMMA
	D PUSH^C0CXPATH(RNRTN,RNX) ; FIRST LINE CONTAINS COLUMN HEADINGS
	S RNI=""
	F  S RNI=$O(@RNR@(RNI)) Q:RNI=""  D  ; FOR EACH ROW
	. S RNX=""""_RNI_""""_"," ; FIRST ELEMENT ON ROW IS THE FIELD
	. S RNJ=""
	. F  S RNJ=$O(@RNC@(RNJ)) Q:RNJ=""  D  ; FOR EACH COL
	. . I $D(@RNC@(RNJ,RNI,1)) D  ; THIS ROW HAS THIS COLUMN
	. . . S RNX=RNX_""""_@RNC@(RNJ,RNI,1)_""""_"," ; ADD THE ELEMENT PLUS A COMMA
	. . E  S RNX=RNX_"," ; NUL COLUMN
	. S RNX=$E(RNX,1,$L(RNX)-1) ; STRIP OFF THE LAST COMMA
	. D PUSH^C0CXPATH(RNRTN,RNX)
	Q
	;
VN(RNRTN,RNIN)	;
	S RNR=$NA(@RNIN@("V"))
	S RNC=$NA(@RNIN@("F"))
	;S RNY=$P(@RNIN@(0),"^",1) ; FILE NUMBER
	S RNX="""ROW"""_"," ; FIRST COLUMN NAME IS "ROW"
	S RNI=""
	F  S RNI=$O(@RNC@(RNI)) Q:RNI=""  D  ; FOR EACH COLUMN
	. S RNX=RNX_RNI_"," ;ADD THE COLUMM ELEMENT AND A COMMA
	S RNX=$E(RNX,1,$L(RNX)-1) ; STRIP OFF THE LAST COMMA
	D PUSH^C0CXPATH(RNRTN,RNX) ; FIRST LINE CONTAINS COLUMN HEADINGS
	S RNI=""
	F  S RNI=$O(@RNR@(RNI)) Q:RNI=""  D  ; FOR EACH ROW
	. S RNX=""""_RNI_""""_"," ; FIRST ELEMENT ON ROW IS THE FIELD
	. S RNJ=""
	. F  S RNJ=$O(@RNC@(RNJ)) Q:RNJ=""  D  ; FOR EACH COL
	. . I $D(@RNR@(RNI,RNJ,1)) D  ; THIS ROW HAS THIS COLUMN
	. . . S RNV=$TR(@RNR@(RNI,RNJ,1),"""","")
	. . . S RNV=$TR(RNV,",","")
	. . . S RNX=RNX_""""_RNV_""""_"," ; ADD THE ELEMENT PLUS A COMMA
	. . E  S RNX=RNX_"," ; NUL COLUMN
	. S RNX=$E(RNX,1,$L(RNX)-1) ; STRIP OFF THE LAST COMMA
	. D PUSH^C0CXPATH(RNRTN,RNX)
	Q
	;
READCSV(PATH,NAME,GLB)	; READ A CSV FILE IN FROM UNIX TO GLB, PASSED BY NAME
	;
	Q $$FTG^%ZISH(PATH,NAME,GLB,1)
	;
FILE2CSV(FNUM,FVN)	; WRITES OUT A FILEMAN FILE TO CSV
	;
	;N G1,G2
	I '$D(FVN) S FVN="NV" ; DEFAULT ORIENTATION OF CVS FILE
	S G1=$NA(^TMP($J,"C0CCSV",1))
	S G2=$NA(^TMP($J,"C0CCSV",2))
	D GETN2(G1,FNUM) ; GET THE MATRIX
	D RNF2CSV(G2,G1,FVN) ; PREPARE THE CVS FILE
	K @G1
	D FILEOUT(G2,"FILE_"_FNUM_".csv")
	K @G2
	Q
	;
FILEOUT(FOARY,FONAM)	; WRITE OUT A FILE
	;
	W $$OUTPUT^C0CXPATH($NA(@FOARY@(1)),FONAM,^TMP("C0CCCR","ODIR"))
	Q
	;
FILEREF(FNUM)	; EXTRINSIC THAT RETURNS A CLOSED ROOT FOR FILE NUMBER FNUM
	;
	N C0CF
	S C0CF=^DIC(FNUM,0,"GL") ;OPEN ROOT TO FILE
	S C0CF=$P(C0CF,",",1)_")" ; CLOSE THE ROOT
	I C0CF["()" S C0CF=$P(C0CF,"()",1)
	Q C0CF
	;
SKIP	;
	N TXT,DIERR
	S TXT=$$GET1^DIQ(8925,TIUIEN,"2","","TXT")
	I $D(DIERR) D CLEAN^DILF Q
	W "  report_text:",!  ;Progress Note Text
	N LN S LN=0
	F  S LN=$O(TXT(LN)) Q:'LN  D
	. W "    text"_LN_": "_TXT(LN),!
	. Q
	Q
	;
RNF2HNV(ZOUT,ZIN)	;RETURN AN HTML TABLE IN ZOUT, PASSED BY NAME
	; OF ZIN, WHICH IS PASSED BY NAME AND IS IN RNF2 FORMAT
	; ZOUT IS NOT INITIALIZED, SO THE TABLE WILL GO AT THE END
	; THE TABLE WILL BE IN NV FORMAT, ROWS ARE NAMES COLUMNS ARE VALUES 
	D PUSH^C0CXPATH(ZOUT,"<table border=""1"">")
	N ZI,ZJ,ZV,ZN S ZI="" S ZJ=0
	D PUSH^C0CXPATH(ZOUT,"<tr><td></td>") ;begin row and leave a blank col
	F  S ZJ=$O(@ZIN@("V",ZJ)) Q:+ZJ=0  D  ; FOR EACH OCCURANCE
	. S ZV="<td>"_ZJ_"</td>" ; OCCURANCE AS COLUMNS HEADER
	. D PUSH^C0CXPATH(ZOUT,ZV)
	D PUSH^C0CXPATH(ZOUT,"</tr>") ;end of first row
	S ZI=""
	F  S ZI=$O(@ZIN@("F",ZI)) Q:ZI=""  D  ; FOR EACH VARIABLE
	. S ZN="<tr><td>"_ZI_"</td>" ; VARIABLE NAME IN FIRST COLUMN
	. D PUSH^C0CXPATH(ZOUT,ZN)
	. S ZJ=0 ;RESET TO DO IT AGAIN
	. F  S ZJ=$O(@ZIN@("V",ZJ)) Q:+ZJ=0  D  ; FOR EACH OCCURANCE
	. . S ZV="<td>"_$G(@ZIN@("V",ZJ,ZI,1))_"</td>"
	. . D PUSH^C0CXPATH(ZOUT,ZV)
	. D PUSH^C0CXPATH(ZOUT,"</tr>") ;END OF ROW
	D PUSH^C0CXPATH(ZOUT,"</table>") ; end of table
	Q
	;
RNF2HVN(ZOUT,ZIN)	;RETURN AN HTML TABLE IN ZOUT, PASSED BY NAME
	; OF ZIN, WHICH IS PASSED BY NAME AND IS IN RNF2 FORMAT
	; ZOUT IS NOT INITIALIZED, SO THE TABLE WILL GO AT THE END
	; THE TABLE WILL BE IN VN FORMAT, ROWS ARE VALUES COLUMNS ARE NAMES 
	D PUSH^C0CXPATH(ZOUT,"<table border=""1"">")
	N ZI,ZJ S ZI="" S ZJ=0
	D PUSH^C0CXPATH(ZOUT,"<tr>") ;new row for column headers
	F  S ZI=$O(@ZIN@("F",ZI)) Q:ZI=""  D  ; FOR EACH VARIABLE
	. S ZV="<td>"_ZI_"</td>"
	. D PUSH^C0CXPATH(ZOUT,ZV) ; name
	D PUSH^C0CXPATH(ZOUT,"</tr>") ; end header row
	S ZI="" ;RESET TO DO AGAIN
	F  S ZJ=$O(@ZIN@("V",ZJ)) Q:+ZJ=0  D  ; FOR EACH ROW OF VARIABLES
	. D PUSH^C0CXPATH(ZOUT,"<tr>") ;begin row
	. F  S ZI=$O(@ZIN@("F",ZI)) Q:ZI=""  D  ; FOR EACH VARIABLE
	. . S ZV="<td>"_$G(@ZIN@("V",ZJ,ZI,1))_"</td>" ; value
	. . D PUSH^C0CXPATH(ZOUT,ZV) ; value
	. D PUSH^C0CXPATH(ZOUT,"</tr>") ; end header
	D PUSH^C0CXPATH(ZOUT,"</table>") ;end of table
	Q
	;
ZFILE(ZFN,ZTAB)	; EXTRINSIC TO RETURN FILE NUMBER FOR FIELD NAME PASSED
	; BY VALUE IN ZFN. FILE NUMBER IS PIECE 1 OF @ZTAB@(ZFN)
	; IF ZTAB IS NULL, IT DEFAULTS TO C0CA
	I '$D(ZTAB) S ZTAB="C0CA"
	Q $P(@ZTAB@(ZFN),"^",1)
ZFIELD(ZFN,ZTAB)	;EXTRINSIC TO RETURN FIELD NUMBER FOR FIELD NAME PASSED
	; BY VALUE IN ZFN. FILE NUMBER IS PIECE 2 OF @ZTAB@(ZFN)
	; IF ZTAB IS NULL, IT DEFAULTS TO C0CA
	I '$D(ZTAB) S ZTAB="C0CA"
	Q $P(@ZTAB@(ZFN),"^",2)
ZVALUE(ZFN,ZTAB)	;EXTRINSIC TO RETURN VALUE FOR FIELD NAME PASSED
	; BY VALUE IN ZFN. FILE NUMBER IS PIECE 3 OF @ZTAB@(ZFN)
	; IF ZTAB IS NULL, IT DEFAULTS TO C0CA
	I '$D(ZTAB) S ZTAB="C0CA"
	Q $P($G(@ZTAB@(ZFN)),"^",3)
	;
ZVALUEI(ZFN,ZTAB)	;EXTRINSIC TO RETURN INTERNAL VALUE FOR FIELD NAME PASSED
	; BY VALUE IN ZFN. FILE NUMBER IS PIECE 3 OF @ZTAB@(ZFN)
	; IF ZTAB IS NULL, IT DEFAULTS TO C0CA
	I '$D(ZTAB) S ZTAB="C0CA"
	Q $P($G(@ZTAB@(ZFN,"I")),"^",3)
	;
