C0CENC  ; CCDCCR/GPL - CCR/CCD PROCESSING FOR ENCOUNTERS ; 05/21/10
 ;;1.0;C0C;;May 21, 2010;Build 1
 ;Copyright 2010 George Lilly, University of Minnesota and others.
 ;Licensed under the terms of the GNU General Public License.
 ;See attached copy of the License.
 ;
 ;This program is free software; you can redistribute it and/or modify
 ;it under the terms of the GNU General Public License as published by
 ;the Free Software Foundation; either version 2 of the License, or
 ;(at your option) any later version.
 ;
 ;This program is distributed in the hope that it will be useful,
 ;but WITHOUT ANY WARRANTY; without even the implied warranty of
 ;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ;GNU General Public License for more details.
 ;
 ;You should have received a copy of the GNU General Public License along
 ;with this program; if not, write to the Free Software Foundation, Inc.,
 ;51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 ;
 W "NO ENTRY FROM TOP",!
 Q
 ;
EXTRACT(ENCXML,DFN,ENCOUT) ; EXTRACT ENCOUNTERS INTO  XML TEMPLATE
 ; ENCXML AND ENCOUT ARE PASSED BY NAME SO GLOBALS CAN BE USED
 ;
 D SETVARS^C0CPROC ; SET UP VARIABLES FOR PROCEDUCRES, ENCOUNTERS, AND NOTES
 ;I '$D(@C0CENC) D TIUGET(DFN,C0CENC,C0CPRC,C0CNTE) ; GET VARS IF NOT THERE
 K @C0CENC
 D TIUGET(DFN,C0CENC,C0CPRC,C0CNTE) ; GET ENCOUNTERS
 D MAP(ENCXML,C0CENC,ENCOUT) ;MAP RESULTS FOR ENCOUNTERS
 Q
 ;
TIUGET(DFN,C0CENC,C0CPRC,C0CNTE) ; CALLS ENTRY^C0CCPT TO GET PROCEDURES, 
 ; ENCOUNTERS AND NOTES. RETURNS THEM IN RNF2 ARRAYS PASSED BY NAME
 ; C0CENC: ENCOUNTERS, C0CPRC: PROCEDURES, C0CNTE: NOTES
 ; READY TO BE MAPPED TO XML BY MAP^C0CENC, MAP^C0CPROC, AND MAP^C0CCMT
 ; THESE RETURN ARRAYS ARE NOT INITIALIZED, BUT ARE ADDED TO IF THEY 
 ; EXIST. THIS IS SO THAT ADDITIONAL PROCEDURES CAN BE OBTAINED FROM
 ; THE SURGERY PACKGE AND ADDITIONAL COMMENTS FROM OTHER CCR SECTIONS
 ;
 ;K VISIT,LST,NOTE
 I '$D(C0CPRC) D SETVARS^C0CPROC ; INITIALIZE WORK AREAS IF NOT ALREADY THERE
 I '$D(VISIT) D ENTRY^C0CCPT(DFN,,,1) ; RETURNS VISIT LOCAL VARIABLE
 ; NEED TO ADD START AND END DATES FROM PARAMETERS
 N ZI S ZI=""
 N PREVCPT,PREVDT S (PREVCPT,PREVDT)=""
 F  S ZI=$O(VISIT(ZI),-1) Q:ZI=""  D  ; REVERSE TIME ORDER - MOST RECENT FIRST
 . N ZDATE
 . S ZDATE=$$DATE(VISIT(ZI,"DATE",0))
 . S ZPRVARY=$NA(VISIT(ZI,"PRV"))
 . N ZPRV
 . S ZPRV=$$PRV(ZPRVARY) ; THE PRIMARY PROVIDER OBJECT IN THE FORM
 . ; ACTORPROVIDER_IEN WHERE IEN IS THE PROVIDER IEN IN NEW PERSON 
 . ; ENCOBJECTID - ENCOUNTER OBJECT ID
 . ; ENCDATETIME - ENCOUNTER DATE TIME
 . ; ENCTYPETXT - ENCOUNTER TYPE (PLANNING TO USE ADMINISTRATIVE CPT IF AVAIL)
 . ; ENCTYPECODE - CODE OF TYPE - PLANNING CPT CODE
 . ; ENCTYPECODESYS - CODING SYSTEM OF TYPE - CPT-4
 . ; ENCDESCTXT - ENCOUNTER DESCRIPTION TEXT
 . ; ENCDESCCODE - ENCOUNTER DESCRIPTION CODE
 . ; ENCDESCCODESYS - ENCOUNTER DESCRIPTION CODE SYSTEM
 . ; ENCLOCACTORID - ENCOUNTER LOCATION ACTOR ID
 . ; ENCPRVACTORID - ENCOUNTER PRACTIONER ACTOR ID
 . ; ENCINDTXT - ENCOUNTER INDICATION TEXT
 . ; ENCINDCODE - ENCOUNTER INDICATION CODE
 . ; ENCINDCODESYS - ENCOUNTER INDICATION CODE SYSTEM
 . ; ENCACTORID - ENCOUNTER SOURCE ACTOR ID
 . ; ENCCOMMENTID - ENCOUNTER COMMENT ID - POINTER TO NOTE IN COMMENT SECTION
 . S ZRNF("ENCOBJECTID")="ENCOUNTER_"_ZI
 . S ZRNF("ENCDATETIME")=ZDATE ; ENCOUNTER DATE TIME
 . S ZRNF("ENCTYPETXT")=""
 . S ZRNF("ENCTYPECODE")=""
 . S ZRNF("ENCTYPECODESYS")=""
 . S ZRNF("ENCDESCTXT")=""
 . S ZRNF("ENCDESCCODE")=""
 . S ZRNF("ENCDESCCODESYS")=""
 . N TYPTXT,TYPCDE,TYPSYS  ; WILL BE UPDATED BY GETTYPE CALL
 . I $$GETTYPE("VISIT(ZI)",.TYPTXT,.TYPCDE,.TYPSYS) D  ; RETURNS FALSE IF NO TYPE
 . . S ZRNF("ENCTYPETXT")=TYPTXT
 . . S ZRNF("ENCTYPECODE")=TYPCDE
 . . S ZRNF("ENCTYPECODESYS")=TYPSYS
 . . S ZRNF("ENCDESCTXT")=TYPTXT ; FOR NOW, DESCRIPTION IS SAME AS TYPE
 . . S ZRNF("ENCDESCCODE")=TYPCDE ; DESCRIPTION IS REQUIRED (TYPE IS NOT)
 . . S ZRNF("ENCDESCCODESYS")=TYPSYS ; NEED TO CLARIFY FOR VISTA
 . S ZRNF("ENCLOCACTORID")="ACTORORGANIZATION_1"
 . S ZRNF("ENCPRVACTORID")=ZPRV ; PRIMARY PROVIDER LISTED FOR THE ENCOUNTER
 . S ZRNF("ENCINDTXT")="" ; WE WILL PUT POINTERS TO PROBLEMS HERE
 . S ZRNF("ENCINDCODE")=""
 . S ZRNF("ENCINDCODESYS")=""
 . S ZRNF("ENCACTORID")=ZPRV ; SOURCE WILL BE PRIMARY PROVIDER
 . S ZRNF("ENCCOMMENTID")=""
 . I $G(VISIT(ZI,"TEXT",1))'="" D  ; THERE IS A NOTE
 . . M @C0CNTE@(ZI,"TEXT")=VISIT(ZI,"TEXT") ; COPY THE TEXT OF THE NOTE
 . . S @C0CNTE@(ZI,"COMMENTOBJECTID")="NOTE_"_ZI
 . . S @C0CNTE@(ZI,"CMTDATETIME")=ZDATE ; DATE OF THE NOTE
 . . S @C0CNTE@(ZI,"ACTORSOURCEID")=ZPRV ; SOURCE OF THE NOTE
 . . S ZRNF("ENCCOMMENTID")="NOTE_"_ZI ; POINT TO THE NOTE FROM THE ENCOUNTER
 . D RNF1TO2^C0CRNF(C0CENC,"ZRNF") ; ADD THIS ROW TO THE ARRAY
 . ;S PREVCPT=ZCPT
 . ;S PREVDT=ZDATE
 N ZRIM S ZRIM=$NA(^TMP("C0CRIM","VARS",DFN,"ENCOUNTERS"))
 M @ZRIM=@C0CENC@("V")
 K VISIT,LST,NOTE
 Q
 ;
GETTYPE(ZARY,ZTXT,ZCDE,ZSYS) ; EXTRINSIC WHICH RETURNS FALSE IF NO ENCOUNTER TYPE
 ; UPDATES ZTXT WITH ENCOUNTER TYPE TEXT, ZCDE WITH ENCOUNTER TYPE CODE
 ; AND ZSYS WITH ENCOUNTER TYPE CODING SYSTEM
 ; THIS ROUTINE SHOULD BE UPDATED TO SEARCH FOR AN ADMINISTRATIVE CPT CODE
 ; INSTEAD OF JUST THE FIRST ONE IN THE LIST - GPL 1/23/10
 N ZS,ZC
 S ZC="" S ZS=""
 S (ZTXT,ZCDE,ZSYS)=""
 F  S ZC=$O(@ZARY@("CPT",ZC)) Q:ZC=""  D  ; TRY AND FIND A "99" CPT CODE
 . N ZT
 . S ZT=$$CPT^C0CPROC(@ZARY@("CPT",ZC)) ; VALUES IN A CPT MULTIPLE
 . I $E($P(ZT,U,1),1,2)="99" S ZS=ZT ; IS IT AN ADMIN CPT CODE?
 I ZS'="" D  ; CODED ENCOUNTER TYPE FOUND
 . S ZTXT=$P(ZS,U,2)_" "_$P(ZS,U,3) ; USE BOTH PIECES FOR THE TYPE
 . S ZCDE=$P($$CPT^C0CPROC(ZS),U,1) ; CPT CODE FOR ENCOUTER
 . S ZSYS=""
 . I ZCDE'="" S ZSYS="CPT-4" ; ONLY HAVE A CODING SYSTEM IF THERE IS A CODE
 I ZS="" S ZTXT=$$ANYTXT(ZARY) ; TRY AND GET FREE FORM TEXT FROM CPT MULTIPLES
 I ZTXT="" Q 0 ; FAILED
 W !,ZTXT
 Q 1 ; SUCCESS
 ;
ANYTXT(ZVST) ; EXTRINSIC WHICH RETURNS TEXT FROM THE CPT MULTIPLE
 ; OF A VISIT ARRAY WITHOUT CHECKING THE CPT CODE (THAT HAVING FAILED)
 ; ZVST IS THE VISIT ARRAY AND IS PASSED BY NAME
 ; RETURNS TEXT TO USE AS ENCOUNTER TYPE IF ANY
 N ZK,ZL
 S ZK="" S ZL=""
 F  S ZK=$O(@ZVST@("CPT",ZK)) Q:ZK=""  D  ; LOOK FOR SOME TEXT TO USE
 . N ZT
 . S ZT=$G(@ZVST@("CPT",ZK)) ; LOOK AT THIS CPT MULTIPLE
 . I $P(ZT,U,2)_" "_$P(ZT,U,3)'=" " S ZL=$P(ZT,U,2)_" "_$P(ZT,U,3)
 . ; CONCATENATE PIECE 2 AND 3 OF THE CPT MULTIPLE FOR A TYPE
 I ZL="" S ZL=$G(@ZVST@("CLASS")) ; USE THE NOTE DOCUMENT CLASS FOR ENCOUTNER TYPE
 Q ZL
 ;
PRV(IARY) ; RETURNS THE PRIMARY PROVIDER FROM THE "PRV" ARRAY PASSED BY NAME
 N ZI,ZR,ZRTN S ZI="" S ZR="" S ZRTN=""
 F  S ZI=$O(@IARY@(ZI)) Q:ZI=""  D  ; FOR EACH PRV SEG
 . I ZR'="" Q  ;ONLY WANT THE FIRST PRIMARY PROVIDER
 . I $P(@IARY@(ZI),U,5)=1 S ZR=$P(@IARY@(ZI),U,1)
 I ZR'="" S ZRTN="ACTORPROVIDER_"_ZR
 Q ZRTN
 ;
DATE(ISTR) ; EXTRINSIC TO RETURN THE DATE IN CCR FORMAT
 Q $$FMDTOUTC^C0CUTIL(ISTR,"DT")
 ;
CPT(ISTR) ; EXTRINSIC THAT SEARCHES FOR CPT CODES AND RETURNS
 ; CPT^CATEGORY^TEXT
 N Z1,Z2,Z3,ZRTN
 S Z1=$P(ISTR,U,1) 
 I Z1="" D  ;
 . I ISTR["(CPT-4 " S Z1=$P($P(ISTR,"(CPT-4 ",2),")",1)
 I Z1'="" D  ; IF THERE IS A CPT CODE IN THERE
 . ;S Z1=$P(ISTR,U,1)
 . S Z2=$P(ISTR,U,2)
 . S Z3=$P(ISTR,U,3)
 . S ZRTN=Z1_U_Z2_U_Z3
 E  S ZRTN=""
 Q ZRTN
 ;
MAP(ENCXML,C0CENC,ENCOUT) ; MAP PROCEDURES XML 
 ;
 N ZTEMP S ZTEMP=$NA(^TMP("C0CCCR",$J,DFN,"ENCTEMP")) ;WORK AREA FOR TEMPLATE
 K @ZTEMP
 N ZBLD
 S ZBLD=$NA(^TMP("C0CCCR",$J,DFN,"ENCBLD")) ; BUILD LIST AREA
 D QUEUE^C0CXPATH(ZBLD,ENCXML,1,1) ; FIRST LINE
 N ZINNER
 D QUERY^C0CXPATH(ENCXML,"//Encounters/Encounter","ZINNER") ;ONE ENCOUNTER
 N ZTMP,ZVAR,ZI
 S ZI=""
 F  S ZI=$O(@C0CENC@("V",ZI)) Q:ZI=""  D  ;FOR EACH ENCOUNTER
 . S ZTMP=$NA(@ZTEMP@(ZI)) ;THIS ENCOUNTER XML
 . S ZVAR=$NA(@C0CENC@("V",ZI)) ;THIS ENCOUNTER VARIABLES
 . D MAP^C0CXPATH("ZINNER",ZVAR,ZTMP) ; MAP THE PROCEDURE
 . D QUEUE^C0CXPATH(ZBLD,ZTMP,1,@ZTMP@(0)) ;QUE FOR BUILD
 D QUEUE^C0CXPATH(ZBLD,ENCXML,@ENCXML@(0),@ENCXML@(0))
 N ZZTMP
 D BUILD^C0CXPATH(ZBLD,ENCOUT) ;BUILD FINAL XML
 K @ZTEMP,@ZBLD,@C0CENC
 Q
 ;  
