VWPSSXPD ; VW/SMH - Update the Drug File and friends... ; Wed Apr 12 2012
 ;;WorldVista Modifications;1.0
 ; (C) Sam Habiel
 ; Licensed under AGPL
 ;
 ; This routine contains utilities to remove a drug file and install a new drug file in VISTA.
 ; Workflow:
 ; 1. Call KILLDRUG to remove all Drug Data
 ; 2. Restore a global containing a Drug File (^PSDRUG) and Pharmacy Orderable Item file (^PS(50.6)). Can use a KIDS global transport.
 ; 3. Call RESTOCK to sync CPRS files back with drug files.
 ;
 ; PEPs: KILLDRUG to remove all Drugs
 ;       RESTOCK to add the drugs back to CPRS
 ; 
 ; 
KILLDRUG ; Remove all Drug Data. Public Entry Point. Use this to call the routine.
 D DT^DICRW ; Min FM Vars
 D EN^DDIOL("Killing Drug File (50)") D DRUG
 D EN^DDIOL("Killing Pharmacy Orderable Items (50.7)") D PO
 D EN^DDIOL("Removing Pharmacy Orderable Items from the Orderable Item file (101.43)") D O
 D EN^DDIOL("Syncing the Order Quick View file (101.44)") D CPRS
 QUIT
 ;
RESTOCK ; Restock CPRS Orderable Items from new Drug & Pharmacy Orderable Item File. Public Entry Point. Call this after repopulating the drug file (50) and the pharmacy orderable item file (50.7)
 N PSOIEN ; Looper variable
 D DT^DICRW ; Establish FM Basic Variables
 ; 
 ; Loop through Orderable Item file and call the protocol file updater to CPRS Files
 S PSOIEN=0 F  S PSOIEN=$O(^PS(50.7,PSOIEN)) Q:'PSOIEN  D 
 . D EN^DDIOL("Updating Pharamcy Orderable Item "_PSOIEN)
 . D EN^PSSPOIDT(PSOIEN),EN2^PSSHL1(PSOIEN,"MUP")
 D CPRS ; Update Orderable Item View files 
 QUIT
 ;
DRUG ; Kill Drug File; Private
 N %1 S %1=^PSDRUG(0)
 K ^PSDRUG
 S ^PSDRUG(0)=%1
 S $P(^PSDRUG(0),"^",3,4)=""
 QUIT
 ;
PO ; Kill Pharmacy Orderable Items; Private
 N %1 S %1=^PS(50.7,0)
 K ^PS(50.7)
 S ^PS(50.7,0)=%1
 S $P(^PS(50.7,0),"^",3,4)=""
 QUIT
 ;
O ; Kill off Pharamcy Order Items (Only!) in the Orderable Item file; Private
 N DA ; Used in For loop below
 N DIK S DIK="^ORD(101.43,"
 N I S I=0
 FOR  S I=$O(^ORD(101.43,"ID",I)) QUIT:I=""  DO
 . I I["PSP" S DA=$O(^ORD(101.43,"ID",I,"")) D ^DIK
 QUIT
 ;
CPRS ; Now, update the CPRS lists (sync with Orderable Item file) - Uses a CPRS API to do this; Private
 ; Next 3 variables are required as inputs
 N ATTEMPT S ATTEMPT=0 ; Attempt to Update
 N UPDTIME S UPDTIME=$HOROLOG ; Update Time
 N DGNM ; Dialog Name
 ; IVA RX -> Additives; IVB RX -> Solutions
 ; IVM RX -> Inpatient Meds for Outpatients
 ; NV RX -> Non-VA Meds ; O RX -> Outpatient
 ; UD RX -> Unit Dose
 FOR DGNM="IVA RX","IVB RX","IVM RX","NV RX","O RX","UD RX" DO
 . D EN^DDIOL("Rebuilding "_DGNM)
 . D FVBLD^ORWUL
 QUIT
 ;
