C0CRARPT	       ; C0C/ELN - CCR/CCD PROCESSING FOR RAD REPORT ; 19/10/2010
	       ;;1.2;C0C;;May 11, 2012;Build 46
MAP(MIXML,DFN,MOXML)	   ;TO MAKE THIS COMPATIBLE WITH OLD CALLING FOR EXTRACT
	       ; ASSUMES THAT EXTRACT HAS BEEN RUN AND THE VARIABLES STORED IN MIVAR
	       ; MIXML,MIVAR, AND MOXML ARE PASSED BY NAME
	       ; MIXML IS THE TEMPLATE TO USE
	       ; MOXML IS THE OUTPUT XML ARRAY
	       ; DFN IS THE PATIENT RECORD NUMBER
	       N C0COXML,C0CO,C0CV,C0CIXML
	       I '$D(MIVAR) S C0CV="" ;DEFAULT
	       E  S C0CV=MIVAR ;PASSED VARIABLE ARRAY
	       I '$D(MIXML) S C0CIXML="" ;DEFAULT
	       E  S C0CIXML=MIXML ;PASSED INPUT XML
	       D RPCMAP(.C0COXML,DFN,C0CV,C0CIXML) ; CALL RPC TO DO THE WORK
	       I '$D(MOXML) D  Q
	       . S C0CO=$NA(^TMP("C0CCCR",$J,DFN,"RESULTS")) ;DEFAULT FOR OUTPUT
	       . M @C0CO=C0COXML ; COPY RESULTS TO OUTPUT
	       E  D
	       . N C0COOXML
	       . S CCRGLO=$NA(^TMP("C0CCCR",$J,DFN,"CCR"))
	       . D QUERY^C0CXPATH(CCRGLO,"//ContinuityOfCareRecord/Body/Results","C0CRSXML")
	       . S C0COCNT=$O(C0CRSXML(""),-1)
	       . S C0CRES=0
	       . F  S C0CRES=$O(C0COXML(C0CRES)) Q:C0CRES=""  D
	       . . Q:$G(C0COXML(C0CRES))="<Results>"!($G(C0COXML(C0CRES))="</Results>")
	       . . S C0CRSXML(C0COCNT)=$G(C0COXML(C0CRES))
	       . . S C0COCNT=C0COCNT+1
	       . S C0CRSXML(C0COCNT)="</Results>"
	       . S C0CRSXML(0)=C0COCNT
	       . D REPLACE^C0CXPATH(CCRGLO,"","//ContinuityOfCareRecord/Body")
	       . D INSERT^C0CXPATH(CCRGLO,"C0CRSXML","//ContinuityOfCareRecord/Body")
	       S C0CO=MOXML,@C0CO@(0)=0
	       K C0CRSXML,C0COCNT,C0COXML,C0CRES
	       Q
RPCMAP(RTN,DFN,RMIVAR,RMIXML)	  ; RPC ENTRY POINT FOR MAPPING RESULTS
	       ; RTN IS PASSED BY REFERENCE
	       N C0CT0,C0CT,C0CV ; CCR TEMPLATE, RESULTS SUBTEMPLATE, VARIABLES
	       N C0CRT,C0CTT ; TEST REQUEST TEMPLATE, TEST RESULT TEMPLATE
	       I '$D(DEBUG) S DEBUG=0 ; DEFAULT NO DEBUGGING
	       I RMIXML="" D  ; INPUT XML NOT PASSED
	       . D LOAD^C0CCCR0("C0CT0") ; LOAD ENTIRE CCR TEMPLATE
	       . D QUERY^C0CXPATH("C0CT0","//ContinuityOfCareRecord/Body/Results","C0CT0R")
	       . S C0CT="C0CT0R" ; NAME OF EXTRACTED RESULTS TEMPLATE
	       E  S C0CT=RMIXML ; WE ARE PASSED THE RESULTS PART OF THE TEMPLATE
	       I RMIVAR="" D  ; LOCATION OF VARIABLES NOT PASSED
	       . S C0CV=$NA(^TMP("C0CCCR",$J,"RESULTS")) ;DEFAULT VARIABLE LOCATION
	       E  S C0CV=RMIVAR ; PASSED LOCATIONS OF VARS
	       D CP^C0CXPATH(C0CT,"C0CRT") ; START MAKING TEST REQUEST TEMPLATE
	       D REPLACE^C0CXPATH("C0CRT","","//Results/Result/Test") ; DELETE TEST FROM REQ
	       D QUERY^C0CXPATH(C0CT,"//Results/Result/Test","C0CTT") ; MAKE TEST TEMPLATE
	       D EXTRACT("C0CT",DFN,) ; FIRST CALL EXTRACT
	       I '$D(@C0CV@(0)) D  Q  ; NO VARS THERE
	       . S RTN(0)=0 ; PASS BACK NO RESULTS INDICATOR
	       ; NO RESULTS
	       I @C0CV@(0)=0 S RTN(0)=0 Q
	       S RIMVARS=$NA(^TMP("C0CRIM","VARS",DFN,"RESULTS"))
	       K @RIMVARS
	       M @RIMVARS=@C0CV ; UPDATE RIMVARS SO THEY STAY IN SYNCH
	       N C0CI,C0CIN,C0CJ,C0CJE,C0CJS,C0CJN,C0CMAP,C0CTMAP,C0CTMP
	       S C0CIN=@C0CV@(0) ; COUNT OF RESULTS (OBR)
	       N C0CRTMP ; AREA TO BUILD ONE RESULT REQUEST AND ALL TESTS FOR IT
	       N C0CRBASE S C0CRBASE=$NA(^TMP($J,"TESTTMP")) ;WORK AREA
	       N C0CRBLD ; BUILD LIST FOR XML - THE BUILD IS DELAYED UNTIL THE END
	       ; TO IMPROVE PERFORMANCE
	       D QUEUE^C0CXPATH("C0CRBLD","C0CRT",1,1) ;<Results>
	       F C0CI=1:1:C0CIN D  ; LOOP THROUGH VARIABLES
	       . K C0CMAP,C0CTMP ;EMPTY OUT LAST BATCH OF VARIABLES
	       . S C0CRTMP=$NA(@C0CRBASE@(C0CI)) ;PARTITION OF WORK AREA FOR EACH TEST
	       . S C0CMAP=$NA(@C0CV@(C0CI)) ;
	       . D MAP^C0CXPATH("C0CRT",C0CMAP,C0CRTMP) ; MAP OBR DATA
	       . D QUEUE^C0CXPATH("C0CRBLD",C0CRTMP,2,@C0CRTMP@(0)-4) ;UP TO <Test>
	       . I $D(@C0CMAP@("M","TEST",0)) D  ; TESTS EXIST
	       . . S C0CJN=@C0CMAP@("M","TEST",0) ; NUMBER OF TESTS
	       . . K C0CTO ; CLEAR OUTPUT VARIABLE
	       . . F C0CJ=1:1:C0CJN D   ;FOR EACH TEST RESULT
	       . . . K C0CTMAP ; EMPTY MAPS FOR TEST RESULTS
	       . . . S C0CTMP=$NA(@C0CRBASE@(C0CI,C0CJ)) ;WORK AREA FOR TEST RESULTS
	       . . . S C0CTMAP=$NA(@C0CMAP@("M","TEST",C0CJ)) ;
	       . . . D MAP^C0CXPATH("C0CTT",C0CTMAP,C0CTMP) ; MAP TO TMP
	       . . . I C0CJ=1 S C0CJS=2 E  S C0CJS=1 ;FIRST TIME,SKIP THE <Test>
	       . . . I C0CJ=C0CJN S C0CJE=@C0CTMP@(0)-1 E  S C0CJE=@C0CTMP@(0) ;</Test>
	       . . . S C0CJS=1 S C0CJE=@C0CTMP@(0) ; INSERT ALL OF THE TEXT XML
	       . . . D QUEUE^C0CXPATH("C0CRBLD",C0CTMP,C0CJS,C0CJE) ; ADD TO BUILD LIST
	       . D QUEUE^C0CXPATH("C0CRBLD","C0CRT",C0CRT(0)-1,C0CRT(0)-1) ;</Result>
	       D QUEUE^C0CXPATH("C0CRBLD","C0CRT",C0CRT(0),C0CRT(0)) ;</Results>
	       D BUILD^C0CXPATH("C0CRBLD","RTN") ;RENDER THE XML
	       K @C0CRBASE ; CLEAR OUT TEMPORARY STURCTURE
	       Q
EXTRACT(ILXML,DFN,OLXML)	       ; EXTRACT RADIOLOGY REPORTS INTO THE C0CLVAR GLOBAL
	       S C0CLB=$NA(^TMP("C0CCCR",$J,"RESULTS")) ; BASE GLB FOR RADS VARS
	       S RADFN=DFN
	       D GHL7^C0CRAHL7 ; GET HL7 MESSAGE FOR THIS PATIENT
	       ;ELN K @C0CLB ; CLEAR OUT OLD VARS IF ANY
	       N QTSAV S QTSAV=$G(C0CQT) ;SAVE QUIET FLAG
	       S C0CQT=1 ; SURPRESS LISTING
	       D LIST ; EXTRACT THE VARIABLES
	       ;S C0CQT=QTSAV ; RESET SILENT FLAG
	       K ^TMP("HLS",$J),^TMP("C0CCCR","RATBL") ; KILL HL7 MESSAGE OUTPUT
	       K C0CLB,C0CLB2,C0CLI,C0CLOBX,RADFN
	       I $D(OLXML) S @OLXML@(0)=0 ; EXTRACT DOES NOT PRODUCE XML... SEE MAP^C0CLABS
	       Q
LIST	   ; LIST THE HL7 MESSAGE; ALSO, EXTRACT THE RESULT VARIABLES TO C0CLB
	       N C0CI,C0CJ,C0COBT,C0CHB,C0CVAR,C0CTAB,C0CTYP
	       I '$D(C0CLB) S C0CLB=$NA(^TMP("C0CCCR",$J,"RESULTS")) ; BASE GLB FOR LABS VARS
	       I '$D(C0CQT) S C0CQT=0
	       I '$D(DFN) S DFN=1 ; DEFAULT TEST PATIENT
	       I '$D(^TMP("C0CCCR","RATBL",0))!($G(^TMP("C0CCCR","RATBL",0))'="V3") D
	       . D SETTBL^C0CLABS ;INITIALIZE LAB TABLE
	       . K ^TMP("C0CCCR","RATBL")
	       . M ^TMP("C0CCCR","RATBL")=^TMP("C0CCCR","LABTBL")
	       I '$D(^TMP("HLS",$J,1)) D GHL7^C0CRAHL7 ; GET HL7 MGS IF NOT ALREADY DONE
	       S C0CTAB=$NA(^TMP("C0CCCR","RATBL")) ; BASE OF OBX TABLE
	       S C0CHB=$NA(^TMP("HLS",$J))
	       S C0CI=""
	       S @C0CLB@(0)=$O(^TMP("C0CCCR",$J,"RESULTS",""),-1) ; INITALIZE RESULTS VARS COUNT
	       F  S C0CI=$O(@C0CHB@(C0CI)) Q:C0CI=""  D  ; FOR ALL RECORDS IN HL7 MSG
	       . K C0CVAR,XV ; CLEAR OUT VARIABLE VALUES
	       . S C0CTYP=$P(@C0CHB@(C0CI),"|",1)
	       . D LTYP^C0CLABS(@C0CHB@(C0CI),C0CTYP,.C0CVAR,C0CQT)
	       . M XV=C0CVAR ;
	       . I C0CTYP="OBR" D  ; BEGINNING OF NEW SECTION
	       . . S @C0CLB@(0)=@C0CLB@(0)+1 ; INCREMENT COUNT
	       . . S C0CLI=@C0CLB@(0) ; INDEX FOR THIS RESULT
	       . . ;M @C0CLB@(C0CLI)=C0CVAR ; PERSIST THE OBR VARS
	       . . S XV("RESULTOBJECTID")="RESULT_"_C0CLI
	       . . S C0CX1=XV("RESULTSOURCEACTORID") ; SOURCE FROM OBR
	       . . S XV("RESULTSOURCEACTORID")="ACTORPROVIDER_"_$P($P(C0CX1,"^",1),"-",1)
	       . . S C0CX1=XV("RESULTASSESSMENTDATETIME") ;DATE TIME IN HL7 FORMAT
	       . . S C0CX2=$$HL7TFM^XLFDT(C0CX1,"L") ;FM DT LOCAL
	       . . S XV("RESULTASSESSMENTDATETIME")=$$FMDTOUTC^C0CUTIL(C0CX2,"DT") ;UTC TIME
	       . . M @C0CLB@(C0CLI)=XV ; PERSIST THE OBR VARS
	       . . S C0CLOBX=0 ; MARK THE BEGINNING OF A NEW SECTION
	       . I C0CTYP="OBX" D  ; SPECIAL CASE FOR OBX3
	       . . ; RESULTTESTCODEVALUE
	       . . ; RESULTTESTDESCRIPTIONTEXT
	       . . I C0CVAR("C3")="C4" D  ; PRIMARY CODE "CPT"
	       . . . S XV("RESULTTESTCODEVALUE")=C0CVAR("C1") ; THE CPT CODE VALUE
	       . . . S XV("RESULTTESTCODINGSYSTEM")="CPT" ; DISPLAY NAME FOR CPT
	       . . . S XV("RESULTTESTDESCRIPTIONTEXT")=C0CVAR("C2") ; DESCRIPTION TEXT
	       . . E  I C0CVAR("C6")'="" D  ; NO CPT CODES, USE SECONDARY IF PRESENT
	       . . . S XV("RESULTTESTCODEVALUE")=C0CVAR("C4") ; SECONDARY CODE VALUE
	       . . . S XV("RESULTTESTCODINGSYSTEM")=C0CVAR("C6") ; SECONDARY CODE NAME
	       . . . S XV("RESULTTESTDESCRIPTIONTEXT")=C0CVAR("C5") ; SECONDARY TEXT
	       . . E  D  ; NO SECONDARY, USE PRIMARY
	       . . . S XV("RESULTTESTCODEVALUE")=C0CVAR("C1") ; PRIMARY CODE VALUE
	       . . . S XV("RESULTTESTCODINGSYSTEM")=C0CVAR("C3") ; PRIMARY DISPLAY NAME
	       . . . S XV("RESULTTESTDESCRIPTIONTEXT")=C0CVAR("C2") ; USE PRIMARY TEXT
	       . . N C0CZG S C0CZG=XV("RESULTTESTNORMALDESCTEXT") ;
	       . . S XV("RESULTTESTNORMALDESCTEXT")=C0CZG
	       . . S C0CZG=XV("RESULTTESTVALUE")
	       . . S XV("RESULTTESTVALUE")=C0CZG
	       . . I C0CLOBX=0 D  ; FIRST TEST RESULT FOR THIS SECTION
	       . . . S C0CLB2=$NA(@C0CLB@(C0CLI,"M","TEST")) ; INDENT FOR TEST RESULTS
	       . . S C0CLOBX=C0CLOBX+1 ; INCREMENT TEST COUNT
	       . . S @C0CLB2@(0)=C0CLOBX ; STORE THE TEST COUNT
	       . . S XV("RESULTTESTOBJECTID")="RESULTTEST_"_C0CLI_"_"_C0CLOBX
	       . . S C0CX1=XV("RESULTTESTSOURCEACTORID") ; TEST SOURCE
	       . . S C0CX2=$P($P(C0CX1,"^",1),"-",1) ; PULL OUT STATION NUMBER
	       . . S XV("RESULTTESTSOURCEACTORID")="ACTORORGANIZATION_"_C0CX2
	       . . S XV("RESULTTESTNORMALSOURCEACTORID")=XV("RESULTTESTSOURCEACTORID")
	       . . S C0CX1=XV("RESULTTESTDATETIME") ;DATE TIME IN HL7 FORMAT
	       . . S C0CX2=$$HL7TFM^XLFDT(C0CX1,"L") ;FM DT LOCAL
	       . . S XV("RESULTTESTDATETIME")=$$FMDTOUTC^C0CUTIL(C0CX2,"DT") ;UTC TIME
	       . . M @C0CLB2@(C0CLOBX)=XV ; PERSIST THE TEST RESULT VARIABLES
	       K XV,C0CZG,C0CX1,C0CX2,C0CVAR
	       Q
