C0QKIDS	; VEN/SMH - Kids Utilities for transporting C0Q data ; 5/24/12 3:53pm
	;;1.0;C0Q;;May 21, 2012;Build 43
	; Licensed under package license. See Documentation.
	;
	; PEPs: TRAN, POST
	;
TRAN	; Unified Transport; PEP
	; D TRAN301  ; looks like I won't send that file over
	D TRAN201
	QUIT
POST	; Unified Post; PEP
	; D POST301  ; looks like I won't send that file over
	D POST101
	D POST201
	QUIT
	;
	; << >>
	;
TRAN301	; Grab FDA for entire file C0Q PATIENT LIST and store in Transport Global; Private EP
	N C0QIEN S C0QIEN=0 ; IEN walker
	N C0QREF1 S C0QREF1=$NAME(^TMP("C0QOLD",$J)) ; Temporary Global Reference
	N C0QREF2 S C0QREF2=$NAME(^TMP("C0QNEW",$J)) ; Temporary Global Reference
	K @C0QREF1,@C0QREF2   ; Kill that
	F  S C0QIEN=$O(^C0Q(301,C0QIEN)) Q:'+C0QIEN  D
	. D GETS^DIQ(1130580001.301,C0QIEN_",","*","",C0QREF1) ; Load FDA's in there
	. M @C0QREF2@(1130580001.301,"?+"_C0QIEN_",")=@C0QREF1@(1130580001.301,C0QIEN_",") ; Change IENs to ?+ IENs
	M @XPDGREF@("C0Q","1130580001.301")=@C0QREF2  ; Put in Transport Global
	K @C0QREF1,@C0QREF2  ; Remove
	QUIT
	;
TRAN201	; Grab FDA for 201 C0Q MEASUREMENTS selected fields; Private EP
	N C0QIEN S C0QIEN=0 ; IEN walker
	N C0QREF1 S C0QREF1=$NAME(^TMP("C0QOLD",$J)) ; Temporary Global Reference
	N C0QREF2 S C0QREF2=$NAME(^TMP("C0QNEW",$J)) ; Temporary Global Reference
	K @C0QREF1,@C0QREF2   ; Kill that
	;
	; We need C0QCOUNT so that it wouldn't reuse the numbers, b/c updater wants numbers for every different item
	N C0QCOUNT S C0QCOUNT=$O(^C0Q(201," "),-1) ; Counter for SubIENs for destination array; init at highest IEN to prevent dups
	F  S C0QIEN=$O(^C0Q(201,C0QIEN)) Q:'+C0QIEN  D  ; Walk IENs
	. W "Exporting "_C0QIEN,!
	. ; Fields SET NAME, BEGIN DATE, END DATE, LOCKED, USE ALL MEASURES, MU YEAR KEY
	. D GETS^DIQ(1130580001.201,C0QIEN_",",".01;.02;.03;.05;.2;.3","",C0QREF1)
	. M @C0QREF2@(1130580001.201,"?+"_C0QIEN_",")=@C0QREF1@(1130580001.201,C0QIEN_",") ; Change IENs to ?+ IENs
	. N C0QIEN2 S C0QIEN2=0 ; Subfile walker
	. F  S C0QIEN2=$O(^C0Q(201,C0QIEN,5,C0QIEN2)) Q:'+C0QIEN2  D  ; MEASURE subfile
	. . W "Exporting IENS "_C0QIEN2_","_C0QIEN_",",!
	. . D GETS^DIQ(1130580001.2011,C0QIEN2_","_C0QIEN_",",".01","",C0QREF1) ; MEASURE (#.01)
	. . S C0QCOUNT=C0QCOUNT+1 ; Increment the counter for SubIEN (can't reuse)
	. . M @C0QREF2@(1130580001.2011,"?+"_C0QCOUNT_","_"?+"_C0QIEN_",")=@C0QREF1@(1130580001.2011,C0QIEN2_","_C0QIEN_",") ; as above
	;
	M @XPDGREF@("C0Q","1130580001.201")=@C0QREF2 ; Put in transport global
	K @C0QREF1,@C0QREF2  ; Remove temp
	QUIT
	;
POST201	; File FDA for 201; Private EP
	IF $O(^C0Q(201,0)) DO  QUIT  ; Quit if data is already there.
	. D MES^XPDUTL("Data exists in file C0Q MEASUREMENTS... Not adding new data")
	;
	D MES^XPDUTL("Adding data to C0Q MEASUREMENTS")
	N C0QFDA S C0QFDA=$NAME(@XPDGREF@("C0Q","1130580001.201")) ; Grab FDA from Transport Global
	N C0QERR ; Error array for filer
	D UPDATE^DIE("E",C0QFDA,"","C0QERR") ; File all
	I $D(C0QERR) D  ; if there's an error, print it out
	. D MES^XPDUTL("Couldn't add data into C0Q MEASUREMENTS")
	. S C0QERR=$Q(C0QERR)
	. F  S C0QERR=$Q(@C0QERR) Q:C0QERR=""  D MES^XPDUTL(C0QERR_": "_@C0QERR)
	QUIT
	;
POST301	; Get FDA from Transport Global and install in destination system for C0Q PATIENT LIST; Private EP
	N C0QFDA S C0QFDA=$NAME(@XPDGREF@("C0Q","1130580001.301")) ; FDA array name is the global reference
	N C0QERR ; Error 
	D UPDATE^DIE("E",C0QFDA,"","C0QERR") ; File all
	I $D(C0QERR) D  ; if there's an error, print it out
	. D MES^XPDUTL("Couldn't add data into C0Q PATIENT LIST file")
	. S C0QERR=$Q(C0QERR)
	. F  S C0QERR=$Q(@C0QERR) Q:C0QERR=""  D MES^XPDUTL(C0QERR_": "_@C0QERR)
	QUIT
	;
POST101	; Clean transported data from broken pointers in C0Q QUALITY MEASURE in destination systems; Private EP
	D MES^XPDUTL("Cleaning C0Q QUALITY MEASURE data")
	N C0QIEN S C0QIEN=0 ; Ien looper
	N C0QFDA ; Fileman Data Array
	F  S C0QIEN=$O(^C0Q(101,C0QIEN)) Q:'+C0QIEN  DO  ; For each record, delete these fields
	. S C0QFDA(1130580001.101,C0QIEN_",",1)="@" ; NUMERATOR PATIENT LIST
	. S C0QFDA(1130580001.101,C0QIEN_",",1.5)="@" ; NEGATIVE NUMERATOR LIST
	. S C0QFDA(1130580001.101,C0QIEN_",",2)="@" ; DENOMINATOR PATIENT LIST
	. ; ---
	. ; I wasn't planning on emptying these out, but the IENs in desintation systems may be different
	. ; so it is best to remove them for now. It's a pointer field, so IENs are important.
	. ; Desination file is populated automatically, but only at the site, and only after config.
	. ; So we can't really ship the pointers as part of the install.
	. ; ---
	. S C0QFDA(1130580001.101,C0QIEN_",",1.1)="@" ; ALTERNATIVE NUMERATOR LIST
	. S C0QFDA(1130580001.101,C0QIEN_",",1.51)="@" ; ALTERNATE NEGATIVE NUM LIST
	. S C0QFDA(1130580001.101,C0QIEN_",",2.1)="@" ; ALTERNATIVE DENOMINATOR LIST
	N C0QERR ; Errors
	D FILE^DIE("","C0QFDA","C0QERR") ; Do it!
	I $D(C0QERR) D  ; if there's an error, print it out
	. D MES^XPDUTL("Couldn't fix data into C0Q QUALITY MEASURE file")
	. S C0QERR=$Q(C0QERR)
	. F  S C0QERR=$Q(@C0QERR) Q:C0QERR=""  D MES^XPDUTL(C0QERR_": "_@C0QERR)
	QUIT
