CCRUTIL ;CCRCCD/SMH - Various Utilites for generating the CCR/CCD;06/15/08
 ;;0.1;CCRCCD;;Jun 15, 2008;
 ;Copyright 2008 WorldVistA.  Licensed under the terms of the GNU
 ;General Public License See attached copy of the License.
 ;
 ;This program is free software; you can redistribute it and/or modify
 ;it under the terms of the GNU General Public License as published by
 ;the Free Software Foundation; either version 2 of the License, or
 ;(at your option) any later version.
 ;
 ;This program is distributed in the hope that it will be useful,
 ;but WITHOUT ANY WARRANTY; without even the implied warranty of
 ;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ;GNU General Public License for more details.
 ;
 ;You should have received a copy of the GNU General Public License along
 ;with this program; if not, write to the Free Software Foundation, Inc.,
 ;51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 ;
 W "No Entry at Top!"
 Q
 ;
FMDTOUTC(DATE,FORMAT) ; Convert Fileman Date to UTC Date Format; PUBLIC; Extrinsic
 ; FORMAT is Format of Date. Can be either D (Day) or DT (Date and Time)
 ; If not passed, or passed incorrectly, it's assumed that it is D.
 ; FM Date format is "YYYMMDD.HHMMSS" HHMMSS may not be supplied.
 ; UTC date is formatted as follows: YYYY-MM-DDThh:mm:ss_offsetfromUTC
 ; UTC, Year, Month, Day, Hours, Minutes, Seconds, Time offset (obtained from Mailman Site Parameters)
 N UTC,Y,M,D,H,MM,S,OFF
 S Y=1700+$E(DATE,1,3)
 S M=$E(DATE,4,5)
 S D=$E(DATE,6,7)
 S H=$E(DATE,9,10)
 I $L(H)=1 S H="0"_H
 S MM=$E(DATE,11,12)
 I $L(MM)=1 S MM="0"_MM
 S S=$E(DATE,13,14)
 I $L(S)=1 S S="0"_S
 S OFF=$$TZ^XLFDT ; See Kernel Manual for documentation.
 ; If H, MM and S are empty, it means that the FM date didn't supply the time.
 ; In this case, set H, MM and S to "00"
 ; S:('$L(H)&'$L(MM)&'$L(S)) (H,MM,S)="00" ; IF ONLY SOME ARE MISSING?
 S:'$L(H) H="00"
 S:'$L(MM) MM="00"
 S:'$L(S) S="00"
 S UTC=Y_"-"_M_"-"_D_"T"_H_":"_MM_$S(S="":":00",1:":"_S)_OFF ; Skip's code to fix hanging colon if no seconds
 I $L($G(FORMAT)),FORMAT="DT" Q UTC ; Date with time.
 E  Q $P(UTC,"T")
 ;
SORTDT(V1,V2,ORDR) ; DATE SORT ARRAY AND RETURN INDEX IN V1 AND COUNT
 ; AS EXTRINSIC ORDR IS 1 OR -1 FOR FORWARD OR REVERSE
 ; DATE AND TIME ORDER. DEFAULT IS FORWARD
 ; V2 IS AN ARRAY OF DATES IN FILEMAN FORMAT
 ; V1 IS RETURNS INDIRECT INDEXES OF V2 IN REVERSE DATE ORDER
 ; SO V2(V1(X)) WILL RETURN THE DATES IN DATE/TIME ORDER
 ; THE COUNT OF THE DATES IS RETURNED AS AN EXTRINSIC
 ; BOTH V1 AND V2 ARE PASSED BY REFERENCE
 N VSRT ; TEMP FOR HASHING DATES
 N ZI,ZJ,ZTMP,ZCNT,ZP1,ZP2
 S ZCNT=0 ; COUNTING NUMBER OF DATES
 S ZTMP="" ;
 F ZI=0:0 D  Q:$O(V2(ZTMP))=""  ; FOR EACH DATE IN THE ARRAY
 . S ZCNT=ZCNT+1 ; INCREMENT THE COUNT
 . S ZTMP=$O(V2(ZTMP)) ; NEXT DATE
 . I $D(V2(ZTMP)) D  ; IF THE DATE EXISTS
 . . S ZP1=$P(V2(ZTMP),".",1) ; THE DATE PIECE
 . . S ZP2=$P(V2(ZTMP),".",2) ; THE TIME PIECE
 . . S VSRT(ZP1,ZP2_"00000"_ZCNT)=ZCNT ; HASH ON DATE AND TIME
 . . ; S VSRT($P(V2(ZTMP),U,4)_"000000"_ZCNT)=ZCNT ; PULL DATE
 . I DEBUG W "ZTMP=",ZTMP," "
 S V1(0)=ZCNT ; ARRAYS ARE THE SAME SIZE
 ; I DEBUG ZWR V2
 ; I DEBUG ZWR VSRT
 N ZD,ZT ; DATA AND TIME ITERATORS
 N ZDONE ; DONE FLAG
 S (ZD,ZT)=""
 S ZDONE=0
 N UORDR ; ORDER TO USE 1=FORWARD -1=REVERSE
 S UORDR=ORDR ; DIRECTION TO SORT
 I ORDR="" S UORDR=1
 N ZZCNT S ZZCNT=0 ; ANOTHER COUNTER
 F ZI=0:0 D  Q:ZDONE  ; VISIT THE ARRAY IN DATE ORDER
 . S ZD=$O(VSRT(ZD),UORDR) ; NEXT DATE
 . I ZD="" S ZDONE=1
 . I 'ZDONE D  ; MORE DATES
 . . S ZT="" ; WANT FIRST TIME FOR THIS DATE
 . . F ZJ=0:0 D  Q:$O(VSRT(ZD,ZT),UORDR)=""  ; LOOP THROUGH ALL TIMES
 . . . S ZT=$O(VSRT(ZD,ZT),UORDR) ; NEXT TIME
 . . . S ZZCNT=ZZCNT+1 ; INCREMENT COUNTER
 . . . S V1(ZZCNT)=VSRT(ZD,ZT) ; PULL OUT THE INDEX
 Q ZCNT
 ;
SORTDT2(V1,V2,ORDR) ; REWRITE TO USE 3 INSTEAD OF 2 LVLS OF INDEX
 ; AND $Q INSTEAD OF $O
 ; DATE SORT ARRAY AND RETURN INDEX IN V1 AND COUNT
 ; AS EXTRINSIC ORDR IS 1 OR -1 FOR FORWARD OR REVERSE
 ; DATE AND TIME ORDER. DEFAULT IS FORWARD
 ; V2 IS AN ARRAY OF DATES IN FILEMAN FORMAT
 ; V1 IS RETURNS INDIRECT INDEXES OF V2 IN REVERSE DATE ORDER
 ; SO V2(V1(X)) WILL RETURN THE DATES IN DATE/TIME ORDER
 ; THE COUNT OF THE DATES IS RETURNED AS AN EXTRINSIC
 ; BOTH V1 AND V2 ARE PASSED BY REFERENCE
 N VSRT ; TEMP FOR HASHING DATES
 N ZI,ZJ,ZTMP,ZCNT,ZP1,ZP2
 S ZCNT=0 ; COUNTING NUMBER OF DATES
 S ZTMP="" ;
 F ZI=0:0 D  Q:$O(V2(ZTMP))=""  ; FOR EACH DATE IN THE ARRAY
 . S ZCNT=ZCNT+1 ; INCREMENT THE COUNT
 . S ZTMP=$O(V2(ZTMP)) ; NEXT DATE
 . I $D(V2(ZTMP)) D  ; IF THE DATE EXISTS
 . . S ZP1=$P(V2(ZTMP),".",1) ; THE DATE PIECE
 . . S ZP2=$P(V2(ZTMP),".",2) ; THE TIME PIECE
 . . S VSRT(ZP1,ZP2,ZCNT)=ZCNT ; HASH ON DATE AND TIME
 . I DEBUG W "ZTMP=",ZTMP," "
 S V1(0)=ZCNT ; ARRAYS ARE THE SAME SIZE
 ; I DEBUG ZWR V2
 ; I DEBUG ZWR VSRT
 N ZD,ZT ; DATA AND TIME ITERATORS
 N ZDONE ; DONE FLAG
 S (ZD,ZT)=""
 S ZDONE=0
 N UORDR ; ORDER TO USE 1=FORWARD -1=REVERSE
 S UORDR=ORDR ; DIRECTION TO SORT
 I ORDR="" S UORDR=1
 N ZZCNT S ZZCNT=0 ; ANOTHER COUNTER
 F ZI=0:0 D  Q:ZDONE  ; VISIT THE ARRAY IN DATE ORDER
 . S ZD=$O(VSRT(ZD),UORDR) ; NEXT DATE fix this
 . I ZD="" S ZDONE=1
 . I 'ZDONE D  ; MORE DATES
 . . S ZT="" ; WANT FIRST TIME FOR THIS DATE
 . . F ZJ=0:0 D  Q:$O(VSRT(ZD,ZT),UORDR)=""  ; LOOP THROUGH ALL TIMES
 . . . S ZT=$O(VSRT(ZD,ZT),UORDR) ; NEXT TIME
 . . . S ZZCNT=ZZCNT+1 ; INCREMENT COUNTER
 . . . S V1(ZZCNT)=VSRT(ZD,ZT) ; PULL OUT THE INDEX
 Q ZCNT
 ;