C0QQRDA ; GPL - Quality Reporting QRDA Processing ; 8/1/12 4:24pm
	;;1.0;QUALITY MEASURES;**4**;May 21, 2012;Build 28
	;Copyright 2012 George Lilly.  Licensed under the terms of the GNU
	;General Public License See attached copy of the License.
	;
	;This program is free software; you can redistribute it and/or modify
	;it under the terms of the GNU General Public License as published by
	;the Free Software Foundation; either version 2 of the License, or
	;(at your option) any later version.
	;
	;This program is distributed in the hope that it will be useful,
	;but WITHOUT ANY WARRANTY; without even the implied warranty of
	;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	;GNU General Public License for more details.
	;
	;You should have received a copy of the GNU General Public License along
	;with this program; if not, write to the Free Software Foundation, Inc.,
	;51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
	;
EN
	N REF S REF=$NAME(^TMP("C0QQRDA",$J))
	K @REF
	D WORK(REF)
	D PRINTXML(REF)
	QUIT
	;
	; Get measure set iens from Measure Set file
	; TODO: Populate from a config file.
WORK(C0QREF)
	N C0Q1 S C0Q1=$O(^C0Q(201,"B","ED CMS REPORTING MEASURES",""))
	N C0Q2 S C0Q2=$O(^C0Q(201,"B","STK CMS REPORTING MEASURES",""))
	N C0Q3 S C0Q3=$O(^C0Q(201,"B","VTE CMS REPORTING MEASURES",""))
	;
	; For each measure, write it, count totals and move patients over
	N C0QX F C0QX="C0Q1","C0Q2","C0Q3" D
	. Q:'@C0QX
	. D EN^DDIOL(@C0QX_": "_^C0Q(201,@C0QX,0))
	. D EN^DDIOL("")
	. D UPDATE^C0QUPDT(.A,@C0QX)
	. ;
	. ; Get QRDA code for Measure Set.
	. N C0QMSQRDA S C0QMSQRDA=$$GET1^DIQ($$C0QMFN^C0QUPDT(),@C0QX_",","QRDA TEMPLATE ROOT")
	. N C0QI S C0QI=0 ; Fileman IEN looper
	. F  S C0QI=$O(^C0Q(201,@C0QX,5,C0QI)) Q:'C0QI  D  ; For each measure
	. . N C0QMEASUREQRDA S C0QMEASUREQRDA=$$GET1^DIQ($$C0QMMFN^C0QUPDT(),C0QI_","_@C0QX_",",".01:QRDA TEMPLATE ROOT")
	. . N C0QP S C0QP=0
	. . F  S C0QP=$O(^C0Q(201,@C0QX,5,C0QI,3,C0QP)) Q:'C0QP  D  ; For each patient in denominator
	. . . N C0QDFN S C0QDFN=+^(C0QP,0)
	. . . S @C0QREF@(C0QDFN,C0QMSQRDA,C0QMEASUREQRDA)=""
	QUIT
	;
PRINTXML(C0QREF) ; Print the XML; Private EP
	N C0QDFN,C0QMS,C0QM S (C0QDFN,C0QMS,C0QM)="" ; DFN, Measure Set, Measure loopers
	F  S C0QDFN=$O(@C0QREF@(C0QDFN)) Q:C0QDFN=""  D  ; For each patient
	. W !!,$C(27),"[1;37;42m","Prosessing DFN ",C0QDFN,$C(27),"[0m",!  ; Print in Green.
	. ;
	. ;
	. ; CCR Generatation is next; protected against crashes.
	. ; ET set to new value then restored.
	. N C0QCCRXML ; CCR XML
	. N OLDTRAP S OLDTRAP=$ET
	. ; ET: Rollback to this level, write the error in red , clear it, then quit
	. N $ES,$ET
	. S $ET="Q:($ES)  W $C(27),""[1;37;41m"",$ZS,$C(27),""[0m"",! S $EC="""""
	. D CCRRPC^C0CCCR(.C0QCCRXML,C0QDFN) ; Run CCR RPC.
	. S $ET=OLDTRAP
	. ;
	. ;
	. ; Quality XML Section generated by hand next...
	. N C0QXML ; Generated Quality XML
	. D XMLSTORE(.C0QXML,$$OT("QUALITY")) ; Open Tag
	. F  S C0QMS=$O(@C0QREF@(C0QDFN,C0QMS)) Q:C0QMS=""  D  ; For each measure set
	. . D XMLSTORE(.C0QXML,$$OT("MEASURE_SET")) ; Open tag
	. . D XMLSTORE(.C0QXML,$$TAG("ID",C0QMS)) ; Write out set QRDA code
	. . D XMLSTORE(.C0QXML,$$OT("MEASURES")) ; Open tag
	. . F  S C0QM=$O(@C0QREF@(C0QDFN,C0QMS,C0QM)) Q:C0QM=""  D  ; for each measure
	. . . D XMLSTORE(.C0QXML,$$TAG("MEASURE",C0QM)) ; Write <measure> and qrda code
	. . D XMLSTORE(.C0QXML,$$CT("MEASURES")) ; Close tag
	. . D XMLSTORE(.C0QXML,$$CT("MEASURE_SET")) ; Close tag
	. D XMLSTORE(.C0QXML,$$CT("QUALITY")) ; Close tag
	. ;
	. ;
	. ; Insert XML under the root of the document XPATH
	. D INSERT^C0CXPATH($NA(C0QCCRXML),$NA(C0QXML),"//ContinuityOfCareRecord")
	. ;
	. ; 
	. ; Get Kernel Default Directory
	. N DEFDIR S DEFDIR=$$DEFDIR^%ZISH()
	. ;
	. ; 
	. ; Write out to a file.
	. N FN S FN="QRDA_CCR_DFN"_$$RJ^XLFSTR(C0QDFN,10,"0")_".XML" ; File Name
	. K C0QCCRXML(0) ; remove zero node
	. D EN^DDIOL($$OUTPUT^C0CXPATH($NA(C0QCCRXML(1)),FN,DEFDIR))
	QUIT
	;
	; Quick XML stuff ; All Private
OT(STR) Q "<"_STR_">"  ; $$ Open Tag
CT(STR) Q "</"_STR_">"  ; $$ Close Tag
TAG(NM,CONTENT) Q "<"_NM_">"_CONTENT_"</"_NM_">"  ; $$ Whole tag
	;
XMLSTORE(REF,STR) ; Priv Proc - Store XML
	; REF -> Save Array. Pass by Reference.
	; STR -> What to store. Pass by Value.
	; Use like this: D XMLSTORE(.STORE,"<tag>")
	; Output: STORE(1)="<tag>"
	N L ; Number Subscript to use
	S L=$O(REF(" "),-1) S L=L+1 ; Get last number and increment
	S REF(L)=STR,REF(0)=L ; Store string in numbered sub, store last number in 0 node (not used here)
	QUIT
 ;
 ; Following is for formatting printed XML. L passed in Symbol Table and starts at 0.
L1 D WS S L=L+1 Q  ; Write space and increment
L2 S L=L-1 D WS Q  ; Decrement and Write space
WS X "F I=1:1:L W "" """ Q  ; Write Space
