C0CVIT2	; CCDCCR/CJE/GPL - CCR/CCD PROCESSING FOR VITALS ; 07/16/08
	;;1.2;CCD/CCR GENERATION UTILITIES;;Oct 30, 2012;Build 50
	;Copyright 2008,2009 George Lilly, University of Minnesota and others.
	;
	; This program is free software: you can redistribute it and/or modify
	; it under the terms of the GNU Affero General Public License as
	; published by the Free Software Foundation, either version 3 of the
	; License, or (at your option) any later version.
	;
	; This program is distributed in the hope that it will be useful,
	; but WITHOUT ANY WARRANTY; without even the implied warranty of
	; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	; GNU Affero General Public License for more details.
	;
	; You should have received a copy of the GNU Affero General Public License
	; along with this program.  If not, see <http://www.gnu.org/licenses/>.
	;
	W "NO ENTRY FROM TOP",!
	Q
	;
EXTRACT(VITXML,DFN,VITOUT)	; EXTRACT VITAL SIGNS INTO XML TEMPLATE
	; VITXML AND VITOUT ARE PASSED BY NAME SO GLOBALS CAN BE USED
	;
	; USE THE FOLLOWING TEMPLATE FOR THE RNF2 ARRAYS
	; THAT GET PASSED TO *GET ROUTINES
	;C0C[NAME]=$NA(^TMP("C0CCCR",$J,DFN,"C0C(NAME))
	N C0CVIT
	S C0CVIT=$NA(^TMP("C0CCCR",$J,DFN,"C0CVIT"))
	; USE THE FOLLOWING TEMPLATE FOR GETTING/GENERATING THE RNF2 ARRAYS
	; THAT GET INSERTED INTO THE XML TEMPLATE
	; D GET[VISTA/RPMS](DFN,C0CIMM) ; GET VARS
	I $$RPMS^C0CUTIL() D GETRPMS(DFN,C0CVIT) ; GET VARS
	I ($$VISTA^C0CUTIL())!($$WV^C0CUTIL())!($$OV^C0CUTIL()) D GETVISTA(DFN,C0CVIT)
	; USE THE FOLLOWING TEMPATE FOR MAPPING RNF2 ARRAYS TO XML TEMPLATE
	; D MAP([NAME]XML,C0C[NAME],[NAME]OUT) ;MAP RESULTS FOR PROCEDURES
	D MAP(VITXML,C0CVIT,VITOUT) ;MAP RESULTS FOR PROCEDURES
	Q
	;
GETVISTA(DFN,C0CVIT)	; CALLS VITALS^ORQQVI TO GET VITAL SIGNS. 
	; ERETURNS THEM IN RNF2 ARRAYS PASSED BY NAME
	; C0CVIT: VITAL SIGNS
	; READY TO BE MAPPED TO XML BY MAP^C0CVIT2
	; THESE RETURN ARRAYS ARE NOT INITIALIZED, BUT ARE ADDED TO IF THEY 
	; EXIST.
	;
	; KILL OF ARRAYS IS TAKEN CARE OF IN ^C0CCCR (K ^TMP("C0CCCR",$J))
	;
	; SETUP RPC/API CALL HERE
	; USE START AND END DATES FROM PARAMETERS IF REQUIRED
	;
	N VIT,DATA,START,END
	; RPC REQUIRES FM DATES NOT T-* DATES
	D DT^DILF(,$$GET^C0CPARMS("VITLIMIT"),.END) ; GET THE LIMIT PARM
	D DT^DILF(,$$GET^C0CPARMS("VITSTART"),.START) ; GET START PARM
	; RPC CALL (ORY,DFN,ORSDT,OREDT):
	;ORY: return variable
	;DFN: patient identifier from Patient File [#2]
	;ORSDT: start date/time in Fileman format
	;OREDT: end date/time in Fileman format
	; OUTPUT FORMAT:
	;vital measurement ien^vital type^rate^date/time taken
	D VITALS^ORQQVI(.VIT,DFN,START,END) ; RUN QUERY VITALS CALL
	I '$D(VIT) S @VITOUT@(0)=0 K VIT Q  ; RETURN NOT FOUND, KILL ARRAY AND QUIT
	I $P(VIT(1),U,2)="No vitals found." D  Q  ; signal no vitals and quit
	. I $D(VITOUT) S @VITOUT@(0)=0
	. K VIT
	;
	; PREFORM SORT HERE IF NEEDED
	;
	; SORT IS REQUIRED FOR VITAL SIGNS - LATEST VITALS NEED TO BE LISTED FIRST
	; COPIED SORT LOGIC:
	N VSORT,VDATES,VCNT ; ARRAY FOR DATE SORTED VITALS INDEX
	D VITSORT(.VDATES) ; PULL OUT THE DATES INTO AN ARRAY
	S VCNT=$$SORTDT^C0CUTIL(.VSORT,.VDATES,-1) ; PUT VITALS IN REVERSE
	; VSORT IS VITALS IN REVERSE ORDER
	;
	; MAP EACH ROW OF RPC/API TO RNF1 ARRAY
	; RNF1 ARRAY FORMAT:
	; VAR("NAME_OF_RIM_VARIABLE")=VALUE
	;
	; VITAL SIGNS ARE DONE DIFFERENTLY DUE TO THE DIFFERENT TYPES OF VITAL SIGNS
	; THIS LOOP WILL GET EACH ROW, DETERMINE THE TYPE, AND CALL THE RESPECTIVE PROCESSING METHOD
	; THAT WILL DO THE MAPPING TO RNF1 STYLE ARRAYS
	N C0CVI,C0CC,ZRNF
	;S C0CVI="" ; INITIALIZE FOR $O
	F C0CC=1:1:VSORT(0) S C0CVI=VSORT(C0CC) D  ; FOR EACH VITAL SIGN IN THE LIST
	. I DEBUG W VIT(C0CVI),!
	. ; FIGURE OUT WHICH TYPE OF VITAL SIGN IT IS (HEIGHT, WEIGHT, BLOOD PRESSURE, TEMPERATURE, RESPIRATION, PULSE, PAIN, OTHER)
	. D:$P(VIT(C0CVI),U,3)="HT" HEIGHT1($$FMDTOUTC^C0CUTIL($P(VIT(C0CVI),U,4),"DT"),$P(^GMR(120.5,$P(VIT(C0CVI),U,1),0),U,6),$P(VIT(C0CVI),U,3),"in")
	. D:$P(VIT(C0CVI),U,3)="WT" WEIGHT1($$FMDTOUTC^C0CUTIL($P(VIT(C0CVI),U,4),"DT"),$P(^GMR(120.5,$P(VIT(C0CVI),U,1),0),U,6),$P(VIT(C0CVI),U,3),"lbs")
	. D:$P(VIT(C0CVI),U,3)="BP" BP1($$FMDTOUTC^C0CUTIL($P(VIT(C0CVI),U,4),"DT"),$P(^GMR(120.5,$P(VIT(C0CVI),U,1),0),U,6),$P(VIT(C0CVI),U,3),"")
	. D:$P(VIT(C0CVI),U,3)="T" TMP1($$FMDTOUTC^C0CUTIL($P(VIT(C0CVI),U,4),"DT"),$P(^GMR(120.5,$P(VIT(C0CVI),U,1),0),U,6),$P(VIT(C0CVI),U,3),"F")
	. D:$P(VIT(C0CVI),U,3)="R" RESP1($$FMDTOUTC^C0CUTIL($P(VIT(C0CVI),U,4),"DT"),$P(^GMR(120.5,$P(VIT(C0CVI),U,1),0),U,6),$P(VIT(C0CVI),U,3),"")
	. D:$P(VIT(C0CVI),U,3)="P" PULSE1($$FMDTOUTC^C0CUTIL($P(VIT(C0CVI),U,4),"DT"),$P(^GMR(120.5,$P(VIT(C0CVI),U,1),0),U,6),$P(VIT(C0CVI),U,3),"")
	. D:$P(VIT(C0CVI),U,3)="PN" PAIN1($$FMDTOUTC^C0CUTIL($P(VIT(C0CVI),U,4),"DT"),$P(^GMR(120.5,$P(VIT(C0CVI),U,1),0),U,6),$P(VIT(C0CVI),U,3),"")
	. D:'$D(ZRNF) OTHER1($$FMDTOUTC^C0CUTIL($P(C0CVI,U,4),"DT"),"OTHER VITAL",$P(^GMR(120.5,$P(VIT(C0CVI),U,1),0),U,6),$P(VIT(C0CVI),U,3),"UNKNOWN") ;IF THE VITAL ISN'T DEFINED IT IS OTHER
	. D RNF1TO2^C0CRNF(C0CVIT,"ZRNF") ;ADD THIS ROW TO THE ARRAY
	. K ZRNF
	; SAVE RIM VARIABLES SEE C0CRIMA
	N ZRIM S ZRIM=$NA(^TMP("C0CRIM","VARS",DFN,"VITALS"))
	M @ZRIM=@C0CVIT@("V")
	Q
	;
GETRPMS(DFN,C0CVIT)	; CALLS QUERY^BEHOVM TO GET VITAL SIGNS. 
	; ERETURNS THEM IN RNF2 ARRAYS PASSED BY NAME
	; C0CVIT: VITAL SIGNS
	; READY TO BE MAPPED TO XML BY MAP^C0CVIT2
	; THESE RETURN ARRAYS ARE NOT INITIALIZED, BUT ARE ADDED TO IF THEY 
	; EXIST.
	;
	; KILL OF ARRAYS IS TAKEN CARE OF IN ^C0CCCR (K ^TMP("C0CCCR",$J))
	;
	; SETUP RPC/API CALL HERE
	; USE START AND END DATES FROM PARAMETERS IF REQUIRED
	;
	; RPMS VITAL RPC ONLY RETURNS LATEST VITAL IN SPECIFIED DATE RANGE NOT ALL VITALS IN DATE RANGE
	; WE NEED TO SETUP THE VARIABLES THE INTERNAL CALL NEEDS TO BYPASS A HARD CODE OF ONE VITAL FOR DATE RANGE
	N C0CEDT,C0CSDT,VIT,DATA,START,END
	; RPC REQUIRES FM DATES NOT T-* DATES
	D DT^DILF(,$$GET^C0CPARMS("VITLIMIT"),.END) ; GET THE LIMIT PARM
	D DT^DILF(,$$GET^C0CPARMS("VITSTART"),.START) ; GET START PARM
	; RPC OUTPUT FORMAT:
	; vfile ien^vital name^vital abbr^date/time taken(FM FORMAT)^value+units (US & metric)
	D QUERY^BEHOVM("LISTX") ; RUN QUERY VITALS CALL
	I '$D(^TMP("CIAVMRPC",$J)) S @VITOUT@(0)=0 K ^TMP("CIAVMRPC",$J) Q  ; RETURN NOT FOUND, KILL ARRAY AND QUIT
	; MOVE THE ARRAY TO LOCAL VARIABLE
	M VIT=^TMP("CIAVMRPC",$J,0)
	; RPC CLEANUP
	K ^TMP("CIAVMRPC",$J),VITS,RMAX,START,END,DATA,METRIC,VSTR,VUNT
	;
	; PREFORM SORT HERE IF NEEDED
	;
	; SORT IS REQUIRED FOR VITAL SIGNS - LATEST VITALS NEED TO BE LISTED FIRST
	; COPIED SORT LOGIC:
	N VSORT,VDATES,VCNT ; ARRAY FOR DATE SORTED VITALS INDEX
	D VITSORT(.VDATES) ; PULL OUT THE DATES INTO AN ARRAY
	S VCNT=$$SORTDT^C0CUTIL(.VSORT,.VDATES,-1) ; PUT VITALS IN REVERSE
	; VSORT IS VITALS IN REVERSE ORDER
	;
	; MAP EACH ROW OF RPC/API TO RNF1 ARRAY
	; RNF1 ARRAY FORMAT:
	; VAR("NAME_OF_RIM_VARIABLE")=VALUE
	;
	; VITAL SIGNS ARE DONE DIFFERENTLY DUE TO THE DIFFERENT TYPES OF VITAL SIGNS
	; THIS LOOP WILL GET EACH ROW, DETERMINE THE TYPE, AND CALL THE RESPECTIVE PROCESSING METHOD
	; THAT WILL DO THE MAPPING TO RNF1 STYLE ARRAYS
	N C0CVI,C0CC,ZRNF
	;S C0CVI="" ; INITIALIZE FOR $O
	F C0CC=1:1:VSORT(0) S C0CVI=VSORT(C0CC) D  ; FOR EACH VITAL SIGN IN THE LIST
	. I DEBUG W VIT(C0CVI),!
	. ; FIGURE OUT WHICH TYPE OF VITAL SIGN IT IS (HEIGHT, WEIGHT, BLOOD PRESSURE, TEMPERATURE, RESPIRATION, PULSE, PAIN, OTHER)
	. D:$P(VIT(C0CVI),U,3)="HT" HEIGHT
	. D:$P(VIT(C0CVI),U,3)="WT" WEIGHT
	. D:$P(VIT(C0CVI),U,3)="BP" BP
	. D:$P(VIT(C0CVI),U,3)="TMP" TMP
	. D:$P(VIT(C0CVI),U,3)="RS" RESP
	. D:$P(VIT(C0CVI),U,3)="PU" PULSE
	. D:$P(VIT(C0CVI),U,3)="PA" PAIN
	. D:'$D(ZRNF) OTHER ;IF THE VITAL ISN'T DEFINED IT IS OTHER
	. D RNF1TO2^C0CRNF(C0CVIT,"ZRNF") ;ADD THIS ROW TO THE ARRAY
	. K ZRNF
	; SAVE RIM VARIABLES SEE C0CRIMA
	N ZRIM S ZRIM=$NA(^TMP("C0CRIM","VARS",DFN,"VITALS"))
	M @ZRIM=@C0CVIT@("V")
	Q
	;
HEIGHT	;
	I DEBUG W "IN VITAL:  HEIGHT",!
	S ZRNF("VITALSIGNSDATAOBJECTID")="VITAL"_C0CC ; UNIQUE OBJID
	S ZRNF("VITALSIGNSDATETIMETYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSEXACTDATETIME")=$$FMDTOUTC^C0CUTIL($P(VIT(C0CVI),U,4),"DT")
	S ZRNF("VITALSIGNSDESCRIPTIONTEXT")="HEIGHT"
	S ZRNF("VITALSIGNSSOURCEACTORID")="ACTORSYSTEM_1"
	S ZRNF("VITALSIGNSTESTOBJECTID")="VITALTEST"_C0CC
	S ZRNF("VITALSIGNSTESTTYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSDESCCODEVALUE")="248327008"
	S ZRNF("VITALSIGNSDESCCODINGSYSTEM")="SNOMED"
	S ZRNF("VITALSIGNSCODEVERSION")=""
	S ZRNF("VITALSIGNSTESTSOURCEACTORID")="ACTORPROVIDER_"_$P($G(^AUPNVMSR($P(VIT(C0CVI),U,1),12)),U,4)
	S ZRNF("VITALSIGNSTESTRESULTVALUE")=$P($P(VIT(C0CVI),U,5)," ",1)
	S ZRNF("VITALSIGNSTESTRESULTUNIT")=$P($P(VIT(C0CVI),U,5)," ",2)
	Q
	;
WEIGHT	;
	I DEBUG W "IN VITAL:  WEIGHT",!
	S ZRNF("VITALSIGNSDATAOBJECTID")="VITAL"_C0CC
	S ZRNF("VITALSIGNSDATETIMETYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSEXACTDATETIME")=$$FMDTOUTC^C0CUTIL($P(VIT(C0CVI),U,4),"DT")
	S ZRNF("VITALSIGNSDESCRIPTIONTEXT")="WEIGHT"
	S ZRNF("VITALSIGNSSOURCEACTORID")="ACTORSYSTEM_1"
	S ZRNF("VITALSIGNSTESTOBJECTID")="VITALTEST"_C0CC
	S ZRNF("VITALSIGNSTESTTYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSDESCCODEVALUE")="107647005"
	S ZRNF("VITALSIGNSDESCCODINGSYSTEM")="SNOMED"
	S ZRNF("VITALSIGNSCODEVERSION")=""
	S ZRNF("VITALSIGNSTESTSOURCEACTORID")="ACTORPROVIDER_"_$P($G(^AUPNVMSR($P(VIT(C0CVI),U,1),12)),U,4)
	S ZRNF("VITALSIGNSTESTRESULTVALUE")=$P($P(VIT(C0CVI),U,5)," ",1)
	S ZRNF("VITALSIGNSTESTRESULTUNIT")=$P($P(VIT(C0CVI),U,5)," ",2)
	Q
	;
BP	;
	I DEBUG W "IN VITAL:  BLOOD PRESSURE",!
	S ZRNF("VITALSIGNSDATAOBJECTID")="VITAL"_C0CC
	S ZRNF("VITALSIGNSDATETIMETYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSEXACTDATETIME")=$$FMDTOUTC^C0CUTIL($P(VIT(C0CVI),U,4),"DT")
	S ZRNF("VITALSIGNSDESCRIPTIONTEXT")="BLOOD PRESSURE"
	S ZRNF("VITALSIGNSSOURCEACTORID")="ACTORSYSTEM_1"
	S ZRNF("VITALSIGNSTESTOBJECTID")="VITALTEST"_C0CC
	S ZRNF("VITALSIGNSTESTTYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSDESCCODEVALUE")="392570002"
	S ZRNF("VITALSIGNSDESCCODINGSYSTEM")="SNOMED"
	S ZRNF("VITALSIGNSCODEVERSION")=""
	S ZRNF("VITALSIGNSTESTSOURCEACTORID")="ACTORPROVIDER_"_$P($G(^AUPNVMSR($P(VIT(C0CVI),U,1),12)),U,4)
	S ZRNF("VITALSIGNSTESTRESULTVALUE")=$P($P(VIT(C0CVI),U,5)," ",1)
	S ZRNF("VITALSIGNSTESTRESULTUNIT")=$P($P(VIT(C0CVI),U,5)," ",2)
	Q
	;
TMP	;
	I DEBUG W "IN VITAL:  TEMPERATURE",!
	S ZRNF("VITALSIGNSDATAOBJECTID")="VITAL"_C0CC
	S ZRNF("VITALSIGNSDATETIMETYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSEXACTDATETIME")=$$FMDTOUTC^C0CUTIL($P(VIT(C0CVI),U,4),"DT")
	S ZRNF("VITALSIGNSDESCRIPTIONTEXT")="TEMPERATURE"
	S ZRNF("VITALSIGNSSOURCEACTORID")="ACTORSYSTEM_1"
	S ZRNF("VITALSIGNSTESTOBJECTID")="VITALTEST"_C0CC
	S ZRNF("VITALSIGNSTESTTYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSDESCCODEVALUE")="309646008"
	S ZRNF("VITALSIGNSDESCCODINGSYSTEM")="SNOMED"
	S ZRNF("VITALSIGNSCODEVERSION")=""
	S ZRNF("VITALSIGNSTESTSOURCEACTORID")="ACTORPROVIDER_"_$P($G(^AUPNVMSR($P(VIT(C0CVI),U,1),12)),U,4)
	S ZRNF("VITALSIGNSTESTRESULTVALUE")=$P($P(VIT(C0CVI),U,5)," ",1)
	S ZRNF("VITALSIGNSTESTRESULTUNIT")=$P($P(VIT(C0CVI),U,5)," ",2)
	Q
	;
RESP	;
	I DEBUG W "IN VITAL:  RESPIRATION",!
	S ZRNF("VITALSIGNSDATAOBJECTID")="VITAL"_C0CC
	S ZRNF("VITALSIGNSDATETIMETYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSEXACTDATETIME")=$$FMDTOUTC^C0CUTIL($P(VIT(C0CVI),U,4),"DT")
	S ZRNF("VITALSIGNSDESCRIPTIONTEXT")="RESPIRATION"
	S ZRNF("VITALSIGNSSOURCEACTORID")="ACTORSYSTEM_1"
	S ZRNF("VITALSIGNSTESTOBJECTID")="VITALTEST"_C0CC
	S ZRNF("VITALSIGNSTESTTYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSDESCCODEVALUE")="366147009"
	S ZRNF("VITALSIGNSDESCCODINGSYSTEM")="SNOMED"
	S ZRNF("VITALSIGNSCODEVERSION")=""
	S ZRNF("VITALSIGNSTESTSOURCEACTORID")="ACTORPROVIDER_"_$P($G(^AUPNVMSR($P(VIT(C0CVI),U,1),12)),U,4)
	S ZRNF("VITALSIGNSTESTRESULTVALUE")=$P($P(VIT(C0CVI),U,5)," ",1)
	S ZRNF("VITALSIGNSTESTRESULTUNIT")=$P($P(VIT(C0CVI),U,5)," ",2)
	Q
	;
PULSE	;
	I DEBUG W "IN VITAL:  PULSE",!
	S ZRNF("VITALSIGNSDATAOBJECTID")="VITAL"_C0CC
	S ZRNF("VITALSIGNSDATETIMETYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSEXACTDATETIME")=$$FMDTOUTC^C0CUTIL($P(VIT(C0CVI),U,4),"DT")
	S ZRNF("VITALSIGNSDESCRIPTIONTEXT")="PULSE"
	S ZRNF("VITALSIGNSSOURCEACTORID")="ACTORSYSTEM_1"
	S ZRNF("VITALSIGNSTESTOBJECTID")="VITALTEST"_C0CC
	S ZRNF("VITALSIGNSTESTTYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSDESCCODEVALUE")="366199006"
	S ZRNF("VITALSIGNSDESCCODINGSYSTEM")="SNOMED"
	S ZRNF("VITALSIGNSCODEVERSION")=""
	S ZRNF("VITALSIGNSTESTSOURCEACTORID")="ACTORPROVIDER_"_$P($G(^AUPNVMSR($P(VIT(C0CVI),U,1),12)),U,4)
	S ZRNF("VITALSIGNSTESTRESULTVALUE")=$P($P(VIT(C0CVI),U,5)," ",1)
	S ZRNF("VITALSIGNSTESTRESULTUNIT")=$P($P(VIT(C0CVI),U,5)," ",2)
	Q
	;
PAIN	;
	I DEBUG W "IN VITAL:  PAIN",!
	S ZRNF("VITALSIGNSDATAOBJECTID")="VITAL"_C0CC
	S ZRNF("VITALSIGNSDATETIMETYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSEXACTDATETIME")=$$FMDTOUTC^C0CUTIL($P(VIT(C0CVI),U,4),"DT")
	S ZRNF("VITALSIGNSDESCRIPTIONTEXT")="PAIN"
	S ZRNF("VITALSIGNSSOURCEACTORID")="ACTORSYSTEM_1"
	S ZRNF("VITALSIGNSTESTOBJECTID")="VITALTEST"_C0CC
	S ZRNF("VITALSIGNSTESTTYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSDESCCODEVALUE")="22253000"
	S ZRNF("VITALSIGNSDESCCODINGSYSTEM")="SNOMED"
	S ZRNF("VITALSIGNSCODEVERSION")=""
	S ZRNF("VITALSIGNSTESTSOURCEACTORID")="ACTORPROVIDER_"_$P($G(^AUPNVMSR($P(VIT(C0CVI),U,1),12)),U,4)
	S ZRNF("VITALSIGNSTESTRESULTVALUE")=$P($P(VIT(C0CVI),U,5)," ",1)
	S ZRNF("VITALSIGNSTESTRESULTUNIT")=$P($P(VIT(C0CVI),U,5)," ",2)
	Q
	;
OTHER	;
	I DEBUG W "IN VITAL:  OTHER",!
	S ZRNF("VITALSIGNSDATAOBJECTID")="VITAL"_C0CC
	S ZRNF("VITALSIGNSDATETIMETYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSEXACTDATETIME")=$$FMDTOUTC^C0CUTIL($P(VIT(C0CVI),U,4),"DT")
	S ZRNF("VITALSIGNSDESCRIPTIONTEXT")=$P(VIT(C0CVI),U,2)
	S ZRNF("VITALSIGNSSOURCEACTORID")="ACTORSYSTEM_1"
	S ZRNF("VITALSIGNSTESTOBJECTID")="VITALTEST"_C0CC
	S ZRNF("VITALSIGNSTESTTYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSDESCCODEVALUE")=""
	S ZRNF("VITALSIGNSDESCCODINGSYSTEM")=""
	S ZRNF("VITALSIGNSCODEVERSION")=""
	S ZRNF("VITALSIGNSTESTSOURCEACTORID")="ACTORPROVIDER_"_$P($G(^AUPNVMSR($P(VIT(C0CVI),U,1),12)),U,4)
	S ZRNF("VITALSIGNSTESTRESULTVALUE")=$P($P(VIT(C0CVI),U,5)," ",1)
	S ZRNF("VITALSIGNSTESTRESULTUNIT")=$P($P(VIT(C0CVI),U,5)," ",2)
	Q
	;
	;TEMPORARY, THINKING ON HOW TO REFACTOR (CJE)
HEIGHT1(DT,ACTOR,VALUE,UNIT)	;
	I DEBUG W "IN VITAL:  HEIGHT",!
	S ZRNF("VITALSIGNSDATAOBJECTID")="VITAL"_C0CC ; UNIQUE OBJID
	S ZRNF("VITALSIGNSDATETIMETYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSEXACTDATETIME")=DT
	S ZRNF("VITALSIGNSDESCRIPTIONTEXT")="HEIGHT"
	S ZRNF("VITALSIGNSSOURCEACTORID")="ACTORSYSTEM_1"
	S ZRNF("VITALSIGNSTESTOBJECTID")="VITALTEST"_C0CC
	S ZRNF("VITALSIGNSTESTTYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSDESCCODEVALUE")="248327008"
	S ZRNF("VITALSIGNSDESCCODINGSYSTEM")="SNOMED"
	S ZRNF("VITALSIGNSCODEVERSION")=""
	S ZRNF("VITALSIGNSTESTSOURCEACTORID")="ACTORPROVIDER_"_ACTOR
	S ZRNF("VITALSIGNSTESTRESULTVALUE")=VALUE
	S ZRNF("VITALSIGNSTESTRESULTUNIT")=UNIT
	Q
	;
WEIGHT1(DT,ACTOR,VALUE,UNIT)	;
	I DEBUG W "IN VITAL:  WEIGHT",!
	S ZRNF("VITALSIGNSDATAOBJECTID")="VITAL"_C0CC
	S ZRNF("VITALSIGNSDATETIMETYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSEXACTDATETIME")=DT
	S ZRNF("VITALSIGNSDESCRIPTIONTEXT")="WEIGHT"
	S ZRNF("VITALSIGNSSOURCEACTORID")="ACTORSYSTEM_1"
	S ZRNF("VITALSIGNSTESTOBJECTID")="VITALTEST"_C0CC
	S ZRNF("VITALSIGNSTESTTYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSDESCCODEVALUE")="107647005"
	S ZRNF("VITALSIGNSDESCCODINGSYSTEM")="SNOMED"
	S ZRNF("VITALSIGNSCODEVERSION")=""
	S ZRNF("VITALSIGNSTESTSOURCEACTORID")="ACTORPROVIDER_"_ACTOR
	S ZRNF("VITALSIGNSTESTRESULTVALUE")=VALUE
	S ZRNF("VITALSIGNSTESTRESULTUNIT")=UNIT
	Q
	;
BP1(DT,ACTOR,VALUE,UNIT)	;
	I DEBUG W "IN VITAL:  BLOOD PRESSURE",!
	S ZRNF("VITALSIGNSDATAOBJECTID")="VITAL"_C0CC
	S ZRNF("VITALSIGNSDATETIMETYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSEXACTDATETIME")=DT
	S ZRNF("VITALSIGNSDESCRIPTIONTEXT")="BLOOD PRESSURE"
	S ZRNF("VITALSIGNSSOURCEACTORID")="ACTORSYSTEM_1"
	S ZRNF("VITALSIGNSTESTOBJECTID")="VITALTEST"_C0CC
	S ZRNF("VITALSIGNSTESTTYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSDESCCODEVALUE")="392570002"
	S ZRNF("VITALSIGNSDESCCODINGSYSTEM")="SNOMED"
	S ZRNF("VITALSIGNSCODEVERSION")=""
	S ZRNF("VITALSIGNSTESTSOURCEACTORID")="ACTORPROVIDER_"_ACTOR
	S ZRNF("VITALSIGNSTESTRESULTVALUE")=VALUE
	S ZRNF("VITALSIGNSTESTRESULTUNIT")=UNIT
	Q
	;
TMP1(DT,ACTOR,VALUE,UNIT)	;
	I DEBUG W "IN VITAL:  TEMPERATURE",!
	S ZRNF("VITALSIGNSDATAOBJECTID")="VITAL"_C0CC
	S ZRNF("VITALSIGNSDATETIMETYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSEXACTDATETIME")=DT
	S ZRNF("VITALSIGNSDESCRIPTIONTEXT")="TEMPERATURE"
	S ZRNF("VITALSIGNSSOURCEACTORID")="ACTORSYSTEM_1"
	S ZRNF("VITALSIGNSTESTOBJECTID")="VITALTEST"_C0CC
	S ZRNF("VITALSIGNSTESTTYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSDESCCODEVALUE")="309646008"
	S ZRNF("VITALSIGNSDESCCODINGSYSTEM")="SNOMED"
	S ZRNF("VITALSIGNSCODEVERSION")=""
	S ZRNF("VITALSIGNSTESTSOURCEACTORID")="ACTORPROVIDER_"_ACTOR
	S ZRNF("VITALSIGNSTESTRESULTVALUE")=VALUE
	S ZRNF("VITALSIGNSTESTRESULTUNIT")=UNIT
	Q
	;
RESP1(DT,ACTOR,VALUE,UNIT)	;
	I DEBUG W "IN VITAL:  RESPIRATION",!
	S ZRNF("VITALSIGNSDATAOBJECTID")="VITAL"_C0CC
	S ZRNF("VITALSIGNSDATETIMETYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSEXACTDATETIME")=DT
	S ZRNF("VITALSIGNSDESCRIPTIONTEXT")="RESPIRATION"
	S ZRNF("VITALSIGNSSOURCEACTORID")="ACTORSYSTEM_1"
	S ZRNF("VITALSIGNSTESTOBJECTID")="VITALTEST"_C0CC
	S ZRNF("VITALSIGNSTESTTYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSDESCCODEVALUE")="366147009"
	S ZRNF("VITALSIGNSDESCCODINGSYSTEM")="SNOMED"
	S ZRNF("VITALSIGNSCODEVERSION")=""
	S ZRNF("VITALSIGNSTESTSOURCEACTORID")="ACTORPROVIDER_"_ACTOR
	S ZRNF("VITALSIGNSTESTRESULTVALUE")=VALUE
	S ZRNF("VITALSIGNSTESTRESULTUNIT")=UNIT
	Q
	;
PULSE1(DT,ACTOR,VALUE,UNIT)	;
	I DEBUG W "IN VITAL:  PULSE",!
	S ZRNF("VITALSIGNSDATAOBJECTID")="VITAL"_C0CC
	S ZRNF("VITALSIGNSDATETIMETYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSEXACTDATETIME")=DT
	S ZRNF("VITALSIGNSDESCRIPTIONTEXT")="PULSE"
	S ZRNF("VITALSIGNSSOURCEACTORID")="ACTORSYSTEM_1"
	S ZRNF("VITALSIGNSTESTOBJECTID")="VITALTEST"_C0CC
	S ZRNF("VITALSIGNSTESTTYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSDESCCODEVALUE")="366199006"
	S ZRNF("VITALSIGNSDESCCODINGSYSTEM")="SNOMED"
	S ZRNF("VITALSIGNSCODEVERSION")=""
	S ZRNF("VITALSIGNSTESTSOURCEACTORID")="ACTORPROVIDER_"_ACTOR
	S ZRNF("VITALSIGNSTESTRESULTVALUE")=VALUE
	S ZRNF("VITALSIGNSTESTRESULTUNIT")=UNIT
	Q
	;
PAIN1(DT,ACTOR,VALUE,UNIT)	;
	I DEBUG W "IN VITAL:  PAIN",!
	S ZRNF("VITALSIGNSDATAOBJECTID")="VITAL"_C0CC
	S ZRNF("VITALSIGNSDATETIMETYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSEXACTDATETIME")=DT
	S ZRNF("VITALSIGNSDESCRIPTIONTEXT")="PAIN"
	S ZRNF("VITALSIGNSSOURCEACTORID")="ACTORSYSTEM_1"
	S ZRNF("VITALSIGNSTESTOBJECTID")="VITALTEST"_C0CC
	S ZRNF("VITALSIGNSTESTTYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSDESCCODEVALUE")="22253000"
	S ZRNF("VITALSIGNSDESCCODINGSYSTEM")="SNOMED"
	S ZRNF("VITALSIGNSCODEVERSION")=""
	S ZRNF("VITALSIGNSTESTSOURCEACTORID")="ACTORPROVIDER_"_ACTOR
	S ZRNF("VITALSIGNSTESTRESULTVALUE")=VALUE
	S ZRNF("VITALSIGNSTESTRESULTUNIT")=UNIT
	Q
	;
OTHER1(DT,TEXT,ACTOR,VALUE,UNIT)	;
	I DEBUG W "IN VITAL:  OTHER",!
	S ZRNF("VITALSIGNSDATAOBJECTID")="VITAL"_C0CC
	S ZRNF("VITALSIGNSDATETIMETYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSEXACTDATETIME")=DT
	S ZRNF("VITALSIGNSDESCRIPTIONTEXT")=TEXT
	S ZRNF("VITALSIGNSSOURCEACTORID")="ACTORSYSTEM_1"
	S ZRNF("VITALSIGNSTESTOBJECTID")="VITALTEST"_C0CC
	S ZRNF("VITALSIGNSTESTTYPETEXT")="OBSERVED"
	S ZRNF("VITALSIGNSDESCCODEVALUE")=""
	S ZRNF("VITALSIGNSDESCCODINGSYSTEM")=""
	S ZRNF("VITALSIGNSCODEVERSION")=""
	S ZRNF("VITALSIGNSTESTSOURCEACTORID")="ACTORPROVIDER_"_ACTOR
	S ZRNF("VITALSIGNSTESTRESULTVALUE")=VALUE
	S ZRNF("VITALSIGNSTESTRESULTUNIT")=UNIT
	Q
	;
VITSORT(VDT)	; RUN DATE SORTING ALGORITHM
	; VDT IS PASSED BY REFERENCE AND WILL CONTAIN THE ARRAY
	; OF DATES IN THE VITALS RESULTS
	N VDTI,VDTJ,VTDCNT
	S VTDCNT=0 ; COUNT TO BUILD ARRAY
	S VDTJ="" ; USED TO VISIT THE RESULTS
	F VDTI=0:0 D  Q:$O(VIT(VDTJ))=""  ; VISIT ALL RESULTS
	. S VDTJ=$O(VIT(VDTJ)) ; NEXT RESULT
	. S VTDCNT=VTDCNT+1 ; INCREMENT COUNTER
	. S VDT(VTDCNT)=$P(VIT(VDTJ),U,4) ; PULL OUT THE DATE
	S VDT(0)=VTDCNT
	Q
	;
MAP(VITXML,C0CVIT,VITOUT)	; MAP VITAL SIGNS XML 
	;
	N ZTEMP S ZTEMP=$NA(^TMP("C0CCCR",$J,DFN,"VITTEMP")) ;WORK AREA FOR TEMPLATE
	K @ZTEMP
	N ZBLD
	S ZBLD=$NA(^TMP("C0CCCR",$J,DFN,"VITBLD")) ; BUILD LIST AREA
	D QUEUE^C0CXPATH(ZBLD,VITXML,1,1) ; FIRST LINE
	N ZINNER
	; XPATH NEEDS TO MATCH YOUR SECTION
	D QUERY^C0CXPATH(VITXML,"//VitalSigns/Result","ZINNER") ;ONE VITAL SIGN
	N ZTMP,ZVAR,ZI
	S ZI=""
	F  S ZI=$O(@C0CVIT@("V",ZI)) Q:ZI=""  D  ;FOR EACH VITAL SIGN
	. S ZTMP=$NA(@ZTEMP@(ZI)) ;THIS VITAL SIGN XML
	. S ZVAR=$NA(@C0CVIT@("V",ZI)) ;THIS VITAL SIGN VARIABLES
	. D MAP^C0CXPATH("ZINNER",ZVAR,ZTMP) ; MAP THE VITAL SIGN
	. D QUEUE^C0CXPATH(ZBLD,ZTMP,1,@ZTMP@(0)) ;QUEUE FOR BUILD
	D QUEUE^C0CXPATH(ZBLD,VITXML,@VITXML@(0),@VITXML@(0))
	N ZZTMP ; IS THIS NEEDED?
	D BUILD^C0CXPATH(ZBLD,VITOUT) ;BUILD FINAL XML
	K @ZTEMP,@ZBLD
	Q
	;  
