unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Forms, Dialogs, StdCtrls, Controls, ShlObj,
  ExtCtrls;

type
  TMainForm = class(TForm)
    CheckBox1: TCheckBox;
    Memo1: TMemo;
    Label1: TLabel;
    Button1: TButton;
    Button2: TButton;
    Label2: TLabel;
    Button3: TButton;
    Image1: TImage;
    Image2: TImage;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    procedure WMDropFiles(var Message: TMessage); message WM_DROPFILES;
    procedure ResolveLink(FileName: String);
    function PIDLToString(IDList: PItemIDList): String;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses
  ShellLinker, ShellApi, ActiveX, CommCtrl;


procedure TMainForm.FormCreate(Sender: TObject);
begin
  DragAcceptFiles(Handle, True);
end;


procedure TMainForm.WMDropFiles(var Message: TMessage);
var
  FileName: array[Byte] of Char;
begin
  SetForegroundWindow(Handle);
  DragQueryFile(Message.wParam, 0, @FileName, SizeOf(FileName));
  if LowerCase(ExtractFileExt(FileName)) <> '.lnk' then
    MessageDlg('Only *.lnk files can be dragged into this window.', mtWarning, [mbOk], 0)
  else
  begin
    ResolveLink(FileName);
    if CheckBox1.Checked then
      if not ExecuteLink(FileName, Application.Handle, nil) then
        MessageDlg('Could not execute link.', mtWarning, [mbOk], 0);
  end;
end;


procedure TMainForm.Button1Click(Sender: TObject);
// Demonstrates the CreateLink method
var
  Folder: String;
begin
  Folder := GetSpecialFolderPath(CSIDL_DESKTOPDIRECTORY);
  if CreateLink(Application.Title, Folder, Application.ExeName, '',
                   'Demonstrates using shell links') then
    MessageDlg('You should now have a link to this demo on your desktop.',
               mtInformation, [mbOk], 0)
  else
    MessageDlg('Could not create link.', mtWarning, [mbOk], 0);
end;


procedure TMainForm.Button2Click(Sender: TObject);
// Demonstrates the CreateLinkEx method
var
  pidl: PItemIDList;
  Folder: String;
  li: TLinkInfo;
begin
  if SHGetSpecialFolderLocation(Application.Handle, CSIDL_BITBUCKET, pidl) = NOERROR then
  begin
    Folder := GetSpecialFolderPath(CSIDL_DESKTOPDIRECTORY);
    FillChar(li, SizeOf(li), 0);
    li.ClsID := pidl;
    li.Description := 'A link to the Recycle Bin';
    li.HotKey := LinkHotKeyToWord(HOTKEYF_CONTROL + HOTKEYF_ALT + HOTKEYF_SHIFT, Ord('R'));
    li.ShowState := ssMaximized;
    if CreateLinkEx('Recycle Bin demo link', Folder, li) then
      MessageDlg('You should now have a link to the Recycle Bin on your desktop.',
                 mtInformation, [mbOk], 0)
    else
      MessageDlg('Could not create link.', mtWarning, [mbOk], 0);
  end;
end;


procedure TMainForm.Button3Click(Sender: TObject);
begin
  Close;
end;


procedure TMainForm.ResolveLink(FileName: String);
// Demonstrates the GetLinkInfo and other methods
var
  li: TLinkInfo;
  Title: String;
begin
  if GetLinkInfo(FileName, li) then
  begin
    Memo1.Clear;
    Title := ExtractFileName(FileName);
    Delete(Title, Length(Title)-3, 255);
    Memo1.Lines.Add('Link title: '#9#9 + Title);
    Memo1.Lines.Add('Link file name: '#9 + FileName);
    Memo1.Lines.Add('--------------------');
    if li.Target <> '' then
    begin
      // Target is part of file system (file or folder)
      Memo1.Lines.Add('Target path: '#9 + li.Target);
      Memo1.Lines.Add('Working dir.: '#9 + li.WorkDir);
      Memo1.Lines.Add('Parameters: '#9 + li.Parameters);
    end
    else
    begin
      // Target is virtual
      Memo1.Lines.Add('Target display nm.: '#9 + GetTargetDisplayName(li.ClsID));
    end;
    Memo1.Lines.Add('--------------------');
    Memo1.Lines.Add('ClsID (absolute): '#9 + PIDLToString(li.ClsID));
    Memo1.Lines.Add('Description: '#9 + li.Description);
    Memo1.Lines.Add('Shortcut key: '#9 + TranslateHotKeyToText(li.Hotkey));
    Memo1.Lines.Add('Icon path: '#9 + li.IconPath);
    Memo1.Lines.Add('Icon index: '#9 + IntToStr(li.IconIndex));
    case li.ShowState of
      ssNormal:    Memo1.Lines.Add('Show state: '#9'Normal');
      ssMinimized: Memo1.Lines.Add('Show state: '#9'Minimized');
      ssMaximized: Memo1.Lines.Add('Show state: '#9'Maximized');
    end;
    // Icon of target
    Image1.Picture.Icon.ReleaseHandle;
    Image1.Picture.Icon.Handle := GetTargetIconHandle(li.ClsID, False, False);
    Image2.Picture.Icon.ReleaseHandle;
    Image2.Picture.Icon.Handle := GetTargetIconHandle(li.ClsID, True, False);
    // You can get the link's icon (not the target's icon) with ExtractAssociatedIcon
  end
  else
    MessageDlg('Couldn''t get link info.', mtWarning, [mbOk], 0);
end;


function TMainForm.PIDLToString(IDList: PItemIDList): String;

  function NextPIDL(IDList: PItemIDList): PItemIDList;
  begin
    Result := IDList;
    Inc(PChar(Result), IDList^.mkid.cb);
  end;

var
  dummy: Byte;
  guid: TGUID;
begin
  try
    dummy := 2;
    CopyMemory(@guid, Addr(IDList^.mkid.abID[dummy]), SizeOf(guid));
    Result := GUIDToString(guid);
    // Get Next PIDL, if any
    IDList := NextPIDL(IDList);
    if IDList^.mkid.cb <> 0 then
      Result := Result + '\::' + PIDLToString(IDList);
  except
    on Exception do
      Result := 'ERROR';
  end;
end;

end.

