unit pList;
                                                           
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, Trpcb;

type
  TpdForm2 = class(TForm)
    lbPList: TListBox;
    Label1: TLabel;
    sbPListOK: TSpeedButton;
    sbPListClose: TSpeedButton;
    procedure lbPListDblClick(Sender: TObject);
    procedure sbPListCloseClick(Sender: TObject);
    procedure split(const Delimiter: Char; Input: string; const Strings: TStrings);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  pdForm2: TpdForm2;

implementation

{$R *.dfm}

uses vwPtReg;

procedure TpdForm2.split(const Delimiter: Char; Input: string; const Strings: TStrings);
begin
   Assert(Assigned(Strings)) ;
   Strings.Clear;
   Strings.StrictDelimiter:=True;  //Use to specify "use only" delimiter listed in argument
   Strings.Delimiter := Delimiter;
   Strings.DelimitedText := Input;
end;

function gp(x : String; const Delimiter: Char; piece : Integer) : String;  //Get Piece (gp)
Var
 A : TStringList;
 y : String;
begin
  A := TStringList.Create;
  try
    pdForm.split(Delimiter,x,A);
    y:=A[piece-1];
  finally
    A.Free;
  end;
  Result:=y;
end;

procedure TpdForm2.lbPListDblClick(Sender: TObject);
Var
 x : String;
 n : String;
 i : Integer;
begin
 x:='';
 for i:= 0 to lbPList.Count - 1 do
   begin
     if lbPList.Selected[i] then x:=lbPList.Items.Strings[i];
   end;
 if Length(x)>0 then
   begin
     with pdForm do
       begin
         eID.Text:=gp(x,'~',1);
         n:=gp(x,'~',2);
          efName.Text:=gp(n,',',2);
          eLName.Text:=gp(n,',',1);
         eDOB.Text:=gp(x,'~',3);
         eGender.Text:=gp(x,'~',4);
         fauxDFN:=gp(x,'~',5);
         DFN:=StrToInt(fauxDFN);
         sbLU.Enabled:=False;
         RPCBroker1.ClearParameters:=True;
         RPCBroker1.ClearResults:=True;
         RPCBroker1.RemoteProcedure:='VW REG ABSDFN';
         RPCBroker1.Param[0].Value:=cmbxIT.Text+'^'+fauxDFN;
         RPCBroker1.Param[0].PType:=literal;
         RPCBroker1.Call;
         mScratch.Clear;
         mScratch.Lines:=RPCBroker1.Results;
         //showmScratch(Self);
         patC:=StrToInt(gp(RPCBroker1.Results.Strings[0],'^',2));
         //lblINPT.Caption:=gp(RPCBroker1.Results.Strings[1],'^',5)+'   '+gp(RPCBroker1.Results.Strings[1],'^',6);lblInpt.Visible:=True;
         lblINPT.Caption:=gp(RPCBroker1.Results.Strings[1],'^',6);lblInpt.Visible:=True;
         GTF(Self);
       end;
   end;
 sbPListCloseClick(Self);
end;

procedure TpdForm2.sbPListCloseClick(Sender: TObject);
begin
 lbPlist.Clear;
 Close();
end;

end.
