unit iList;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, StdCtrls;

type
  TpdForm3 = class(TForm)
    sbiListOK: TSpeedButton;
    sbiListClose: TSpeedButton;
    Label1: TLabel;
    lbItems: TListBox;
    procedure sbiListCloseClick(Sender: TObject);
    procedure lbItemsDblClick(Sender: TObject);
    procedure split(const Delimiter: Char; Input: string; const Strings: TStrings);
    //function gp(x : String; const Delimiter: Char; piece : Integer) : String;
  private

  public

  end;

var
  pdForm3: TpdForm3;

implementation

{$R *.dfm}

uses vwPtReg;

procedure TpdForm3.sbiListCloseClick(Sender: TObject);
begin
 Close;
end;

procedure TpdForm3.split(const Delimiter: Char; Input: string; const Strings: TStrings);
begin
   Assert(Assigned(Strings)) ;
   Strings.Clear;
   Strings.StrictDelimiter:=True;  //Use to specify "use only" delimiter listed in argument
   Strings.Delimiter := Delimiter;
   Strings.DelimitedText := Input;
end;

function gp(x : String; const Delimiter: Char; piece : Integer) : String;  //Get Piece (gp)
Var
 A : TStringList;
 y : String;
begin
  A := TStringList.Create;
  try
    pdForm3.split(Delimiter,x,A);
    y:=A[piece-1];
  finally
    A.Free;
  end;
  Result:=y;
end;

procedure TpdForm3.lbItemsDblClick(Sender: TObject);
Var
  i:integer;
begin
 for i := 0 to lbItems.Count - 1 do
   begin
     if lbItems.Selected[i]=True then
       begin
        with pdForm do
          begin
            (FindComponent(eLbl) as TEdit).Text:=gp(lbItems.Items.Strings[i],'~',1);
          end;
       end;
   end;
 sbiListCloseClick(Self);
end;

end.
