unit suList;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons, jpeg, Trpcb, ShellLinker, ShellApi, ShlObj,
  ComObj, Grids, ComCtrls, StrUtils, Winsock, Registry, ActiveX, CommCtrl, Menus;

type
  TpdForm4 = class(TForm)
    lblTitle: TLabel;
    Bevel1: TBevel;
    lblHD: TLabel;
    eHomDir: TEdit;
    Bevel2: TBevel;
    mInst: TMemo;
    lblListTemp: TLabel;
    eUN: TEdit;
    sbHDSave: TSpeedButton;
    lbxregit: TListBox;
    lbxDIE: TListBox;
    sbMoveLeft: TSpeedButton;
    sbDeleteT: TSpeedButton;
    sbSaveT: TSpeedButton;
    sbALL: TSpeedButton;
    sbMINE: TSpeedButton;
    sbNS: TSpeedButton;
    eNS: TEdit;
    sbUN: TSpeedButton;
    lbxUserList: TListBox;
    mDesc: TMemo;
    sbClose: TSpeedButton;
    sbMake: TSpeedButton;
    lbxPtFlds: TListBox;
    lblPF: TLabel;
    Shape1: TShape;
    lbleTempName: TLabel;
    CVV: TSpeedButton;
    sbTempSave: TSpeedButton;
    eTemplateName: TEdit;
    Shape2: TShape;
    SpeedButton1: TSpeedButton;
    iMakeHelp: TImage;
    mTF: TMemo;
    mTFlds: TMemo;
    iFI: TImage;
    lblGOTO: TLabel;
    eFindField: TEdit;
    lbxPU: TPopupMenu;
    sbMoveUp: TSpeedButton;
    sbMoveDown: TSpeedButton;
    bbGo: TBitBtn;
    sbmTFldsClear: TSpeedButton;
    procedure iFIClick(Sender: TObject);
    procedure sbmTFldsClearClick(Sender: TObject);
    procedure bbGoClick(Sender: TObject);
    procedure eFindFieldMouseEnter(Sender: TObject);
    procedure sbMoveDownClick(Sender: TObject);
    procedure sbMoveUpClick(Sender: TObject);
    procedure lbxPUPopup(Sender: TObject);
    procedure sbTempSaveClick(Sender: TObject);
    procedure iFMRemindersClick(Sender: TObject);
    procedure mTFldsClick(Sender: TObject);
    procedure iMakeHelpClick(Sender: TObject);
    procedure lbxPtFldsMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lbxregitMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure CVVClick(Sender: TObject);
    procedure sbMakeClick(Sender: TObject);
    procedure sbCloseClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure lbxDIEMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lbxDIEDblClick(Sender: TObject);
    procedure sbHDSaveClick(Sender: TObject);
    procedure eHomDirEnter(Sender: TObject);
    procedure sbSaveTClick(Sender: TObject);
    procedure lbxUserListMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lbxUserListDblClick(Sender: TObject);
    procedure sbDeleteTClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure sbUNClick(Sender: TObject);
    procedure sbMoveLeftClick(Sender: TObject);
    procedure sbMINEClick(Sender: TObject);
    procedure sbNSClick(Sender: TObject);
    procedure sbALLClick(Sender: TObject);
    procedure eUNMouseEnter(Sender: TObject);
    procedure ListTemplates(x:String);
    procedure hiliteMemoLine(Memo:TCustomMemo; xLine: Integer; UpDn: Integer);
    procedure split(const Delimiter: Char; Input: string; const Strings: TStrings);
    function gp(x : String; const Delimiter: Char; piece : Integer) : String;
    function FindControlAtPos: TWinControl;
  private
    lineAT : TPoint;
  public
    { Public declarations }
  end;

  type
    TExHint = class(THintWindow)
    constructor Create(AOwner: TComponent); override;
  end;

var
  pdForm4: TpdForm4;

implementation

{$R *.dfm}

uses vwPtReg, pfSelect;

constructor TExHint.Create(AOwner: TComponent); //Customize size of roll-over hints
begin
  inherited Create(AOwner);
  with Canvas.Font do
  begin
    Name  := 'Calibri';
    Size  := Size + 3;
    Style := [fsItalic];
  end;
end;

function TpdForm4.FindControlAtPos: TWinControl;
var
  Pt: TPoint;
begin
  GetCursorPos(Pt);
  Result := FindControl(WindowFromPoint(Pt));
end;

procedure TpdForm4.split(const Delimiter: Char; Input: string; const Strings: TStrings);
begin
   Assert(Assigned(Strings));
   Strings.Clear;
   Strings.StrictDelimiter:=True;  //Use to specify "use only" delimiter listed in argument
   Strings.Delimiter := Delimiter;
   Strings.DelimitedText := Input;
end;

function TpdForm4.gp(x : String; const Delimiter: Char; piece : Integer) : String;  //Get Piece (gp)
Var
 A : TStringList;
 y : String;
begin
  if x='' then Exit;
  A := TStringList.Create;
  try
    pdForm.split(Delimiter,x,A);
    y:=A[piece-1];  //piece result is always in A[piece-1]
  finally
    A.Free;
  end;
  Result:=y;
end;

procedure TpdForm4.bbGoClick(Sender: TObject);
Var
  i : Integer;
  j : Integer;
  c : Integer;
  x : String;
  y : String;
begin
  //Need to piece eFindFields.text
  c:=0;
  x:=eFindField.Text;
  for i := 0 to Length(eFindField.Text) - 1 do
    begin
      if x[i]=',' then Inc(c)
    end;
  if c=0 then
    begin
      for i:=0 to lbxPtFlds.Items.Count-1 do
        begin
          if AnsiContainsStr(lbxPtFlds.Items.Strings[i],x) then pdForm5.lbxFSelect.Items.Append(lbxPtFlds.Items.Strings[i]);
        end;
    end
    else
      begin
        for i:=1 to c+1 do
          begin
            y:=gp(x,',',i);
            for j := 0 to lbxPtFlds.Items.Count-1 do
              begin
                if AnsiContainsStr(lbxPtFlds.Items.Strings[j],y) then pdForm5.lbxFSelect.Items.Append(lbxPtFlds.Items.Strings[j]);
              end;
          end;
      end;
  //Find parents if missing from the list - go to the M-side...
  with pdForm do
    begin
      RPCBRoker1.ClearParameters:=True;
      RPCBRoker1.ClearResults:=True;
      RPCBroker1.RemoteProcedure:='VW REG FP';
      for i:= 0 to pdForm5.lbxFSelect.Count-1 do
        begin
          RPCBroker1.Param[0].Mult[IntToStr(i)]:=pdForm5.lbxFSelect.Items.Strings[i];
        end;
      RPCBroker1.Param[0].PType:=list;
      pdForm5.lbxFSelect.Clear;
      RPCBroker1.Call;
      pdForm5.lbxFSelect.Items:=RPCBRoker1.Results;
    end;
  pdForm5.Show;
end;

{Returns TRUE if right-mouse button pressed}
function IsMouseBtnDown: Boolean;
begin
  {Result := (GetAsyncKeyState(VK_LBUTTON)
             OR GetAsyncKeyState(VK_MBUTTON)
             OR GetAsyncKeyState(VK_RBUTTON)
             )}
  Result:=GetAsyncKeyState(VK_RBUTTON) AND $8000 <> 0;
end;

procedure TpdForm4.lbxUserListMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if IsMouseBtnDown then lbxUserList.Visible:=False;
end;

procedure TpdForm4.eFindFieldMouseEnter(Sender: TObject);
Var
  x : String;
begin
  Application.HintHidePause:=25000;
  x:='Search for a word in the field listing. Enter multiple words separated by a comma(,).'+#13#10+
     'For best results use full words -vs- partial spellings.';
  eFindField.Hint:=x;
  eFindField.ShowHint:=True;
end;

procedure TpdForm4.eHomDirEnter(Sender: TObject);
begin
  //save home directory
  sbHDSave.Enabled:=True;
end;

procedure TpdForm4.eUNMouseEnter(Sender: TObject);
Var
  x : String;
begin
  Application.HintHidePause:=10000;
  x:='Enter "Lastname,firstname" or the user internal entry number';
  x:=x+#13#10+'Use Fileman Inquire to File 200 to find the IEN';
  x:=x+#13#10+'at "FIRST PRINT FIELD: " enter "NUMBER" with no quotes';
  eUN.Hint:=x;
  eUN.ShowHint:=True;
end;

procedure TpdForm4.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  //pdForm4.eHomDir.Text:='';
  eNS.Text:='';
  eUN.Text:='';
  //lbxRegit.Clear;
  lbxDie.Clear;
end;

procedure TpdForm4.FormCreate(Sender: TObject);
Var
  i : Integer;
begin
  HintWindowClass  := TExHint;
  width:=648;
  height:=900;
  with pdForm do
   begin
     RPCBroker1.ClearParameters:=True;
     RPCbroker1.ClearResults:=True;
     RPCBroker1.RemoteProcedure:='VW REG GET HD';
     RPCBroker1.Call;
     eHomDir.Text:=RPCBroker1.Results.Strings[0];
     for i:=0 to cmbxIT.Items.Count-1 do
       begin
         pdForm4.lbxregit.Items.Append(cmbxIT.Items.Strings[i]);
       end;
   end;
end;

procedure BrowseTo(sURL, sBrowser, sDir :String);
Var
  sei: TShellExecuteInfo;
begin
  ZeroMemory(@sei, sizeof(sei));
  with sei do
    begin
      cbSize := SizeOf(sei);
      fMask  := SEE_MASK_NOCLOSEPROCESS;
      Wnd    := pdForm4.Handle;
      lpVerb := 'open';
      // Need to see if sBrowser empty, if so, pass url to lpFile parameter
      if sBrowser <> #0 then lpFile := PChar(sBrowser)
      else
        lpFile       := PChar(sURL);
        lpParameters := PChar(sURL);
        lpDirectory  := PChar(sDir);
        nShow        := SW_SHOWNORMAL;
    end;
  ShellExecuteEX(@sei);
end;

procedure TpdForm4.iFIClick(Sender: TObject);
var
  IEPath     : String;
  regRegistry: TRegistry; // don't forget to include Registry in your uses clause
begin
  regRegistry := TRegistry.Create;
  try
    regRegistry.RootKey := HKEY_LOCAL_MACHINE;
    if not regRegistry.OpenKey('\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\IEXPLORE.EXE', False) then ShowMessage('Error opening key')
    else
      begin
        IEPath := regRegistry.ReadString('Path');
      end;
  BrowseTo('file:///c:/VWREG/PatientFields.html','iexplore.exe',IEPath);
  finally
    regRegistry.CloseKey;
    regRegistry.Free;
  end;
end;

procedure TpdForm4.iFMRemindersClick(Sender: TObject);
Var
  i : Integer;
  x : String;
begin
  for i:=0 to lbxPtFlds.Items.Count-1 do
    begin
      if lbxPtFlds.Selected[i] then x:=lbxPtFlds.Items.Strings[i]; Break;
    end;
  if Length(x)>0 then
    begin
      with pdForm do
        begin
          RPCBRoker1.ClearParameters:=True;
          RPCBRoker1.ClearResults   :=True;
          //getting field attributes - mainly help and technical help.
        end;
    end;
end;

procedure TpdForm4.iMakeHelpClick(Sender: TObject);
Var
  IEPath  : String;
  regREgistry: TRegistry;
begin
  regRegistry:=TRegistry.Create;
  try
    regRegistry.RootKey:=HKEY_LOCAL_MACHINE;
    if not regRegistry.OpenKey('\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\IEXPLORE.EXE', False) then ShowMessage('Error opening key')
    else
      begin
        IEPath:=regRegistry.ReadString('Path');
      end;
    BrowseTo('file:///c:/VWREG/METHelp.html','iexplore.exe',IEPath);
  finally
    regRegistry.CloseKey;
    regRegistry.Free;
  end;
end;

procedure TpdForm4.lbxDIEDblClick(Sender: TObject);
Var
  i : Integer;
  x : String;
begin
  mDesc.Visible:=False;
  x:='';
  for i := 0 to lbxDIE.Items.Count-1 do
    begin
      if lbxDIE.Selected[i] then x:=lbxDIE.Items.Strings[i];
    end;
  with pdForm do
    begin
      RPCBroker1.ClearParameters:=True;
      RPCBroker1.ClearResults   :=True;
      RPCBroker1.RemoteProcedure:='VW REG GET TEMPLATE DESC';
      RPCBroker1.Param[0].Value:=x;
      RPCBroker1.Param[0].PType:=Literal;
      RPCBroker1.call;
      x:='';
      mDesc.Lines:=RPCBroker1.Results;
      mDesc.Height:=35*RPCBroker1.Results.Count;
    end;
  mDesc.Width:=550;
  mDesc.Left:=50;
  mDesc.Top:=mInst.Top+150;
  mDesc.Visible:=True;
end;

procedure TpdForm4.lbxDIEMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
Var
  i : Integer;
begin
  if isMouseBtnDown then
    begin
      mDesc.Visible:=False;
      for i:=0 to lbxDie.Items.Count-1 do
        begin
          lbxDie.Selected[i]:=False;
        end;
    end;
end;

procedure TpdForm4.lbxPtFldsMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
Var
 i : Integer;
begin
  //if isMouseBtnDown then
    //begin
      for i:=0 to lbxPtFlds.Items.Count-1 do
        begin
          lbxPtFlds.Selected[i]:=False;
        end;
    //end;
end;

procedure TpdForm4.lbxPUPopup(Sender: TObject);
Var
  i : Integer;
begin
  for i:=0 to lbxPtFlds.Items.Count-1 do
    begin
      if lbxPtFlds.Selected[i] then
        begin
          mtFlds.Lines.Add(lbxPtFlds.Items.Strings[i]);
          lbxPtFlds.Selected[i]:=False;
        end;
    end;
    
end;

procedure TpdForm4.lbxregitMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
Var
  i : Integer;
begin
  if IsMouseBtnDown then
    begin
     for i := 0 to lbxregit.Items.Count-1 do
       begin
         lbxregit.Selected[i]:=False;
       end;
    end;
end;

procedure TpdForm4.lbxUserListDblClick(Sender: TObject);  //invisible component
Var
  i : Integer;
  x : String;
  y : String;
begin
  for i:=0 to lbxUserList.Items.Count-1 do
    begin
      if lbxUserList.Selected[i] then x:=lbxUserList.Items.Strings[i];
    end;
  with pdForm do
    begin
      y:=gp(x,'^',1);
    end;
  eUN.Text:=y;
  lbxUserList.Clear;
  lbxUserList.Visible:=False;
end;

procedure TpdForm4.ListTemplates(x:String);
begin
  with pdForm do
    begin
      lbxDIE.Clear();
      RPCBroker1.ClearParameters:=True;
      RPCBroker1.ClearResults   :=True;
      RPCBroker1.RemoteProcedure:='VW REG TEMPLATE LIST';
      RPCBroker1.Param[0].Value :=x;
      RPCBroker1.Param[0].PType :=literal;
      RPCBRoker1.Call;
      if RPCBroker1.Results.Strings[0]='LIST' then
        begin
          lbxUserList.Clear;
          lbxUserList.Items:=RPCBroker1.Results;
          lbxUserList.Visible:=True;
          lbxUserList.Width:=300;
          lbxUserList.Top:=eUN.Top+40;
          lbxUserList.Height:=200;
        end
      else
        begin
          lbxDIE.Items:=RPCBroker1.Results;
      end;
    end;
end;

procedure TpdForm4.mTFldsClick(Sender: TObject);
begin
  lineAT:=mTFlds.CaretPos;
end;

procedure TpdForm4.sbALLClick(Sender: TObject);
begin
  ListTemplates('ALL');
end;

procedure TpdForm4.sbDeleteTClick(Sender: TObject);
begin
  sbSaveT.Enabled:=True;
  while lbxRegit.SelCount>0 do
    begin
      lbxRegit.DeleteSelected;
    end;
end;

procedure TpdForm4.sbHDSaveClick(Sender: TObject);
begin
  with pdForm do
    begin
    RPCBroker1.ClearParameters:=True;
    RPCBroker1.ClearResults   :=True;
    RPCBroker1.RemoteProcedure:='VW REG SAVE HD';
    RPCBroker1.Param[0].Value :=eHomDir.Text;
    RPCBroker1.Param[0].PType :=Literal;
    RPCBroker1.Call;
    if RPCBroker1.Results.Strings[0]='1' then
      begin
        sbHDSave.Enabled:=False;
        Application.HintHidePause:=7000;
        sbHDSave.Hint:='Saved';
        sbHDSave.ShowHint:=True;
    end
    else
      showMessage('Error in file sent to the VW REG mail group');
    end;
end;

procedure TpdForm4.sbMINEClick(Sender: TObject);
begin
  ListTemplates('DUZ');
end;

procedure TpdForm4.sbMoveDownClick(Sender: TObject);
begin
  if lineAT.Y<>mTFlds.Lines.Count-1 then
    begin
      mTFlds.Lines.Move(lineAT.Y,lineAT.Y+1);
      lineAT.Y:=lineAT.Y+1;
      hiliteMemoLine(mTFlds,lineAT.Y,1);
    end;
end;

procedure TpdForm4.sbMoveLeftClick(Sender: TObject);
Var
  i : Integer;
begin
  sbSaveT.Enabled:=True;
  for i := 0 to lbxDIE.Count-1 do
    begin
      if lbxDIE.Selected[i] then lbxRegit.Items.Append(lbxDIE.Items.Strings[i]);
    end;
end;

procedure TpdForm4.hiliteMemoLine(Memo:TCustomMemo; xLine: Integer; UpDn: Integer);
Var
  Line : Integer;
begin
  with Memo do
    begin
      Line      := xLine;
      Line      := Perform(EM_LINEFROMCHAR, SelStart, 0) ;
      if UpDn=0 then SelStart :=Perform(EM_LINEINDEX, Line-1, 0) else SelStart:=Perform(EM_LINEINDEX, Line-1, 0) ;
      SelLength := Length(Lines[Line]) ;
    end;
end;

procedure TpdForm4.sbMoveUpClick(Sender: TObject);
//Var
  //x : String;
begin
  if lineAT.Y<>0 then
    begin
      mTFlds.Lines.Move(lineAT.Y,lineAT.Y-1);
      lineAT.Y:=lineAT.Y-1;
      hiliteMemoLine(mTFlds,lineAT.Y-1,0);
    end;
end;

procedure TpdForm4.sbmTFldsClearClick(Sender: TObject);
begin
  mTFlds.Clear;
  eFindField.Clear;
end;

procedure TpdForm4.sbNSClick(Sender: TObject);
begin
  if eNS.Text='' then
    begin
      showMessage('Please enter a namespace (e.g., VW, DG, N, etc.) or'+#13#10+
      'a user lastname,firstname, or internal user number'+#13#10+
      'Thank you, the Management');
      Exit;
    end;
  ListTemplates('NS^'+eNS.Text);
end;

procedure TpdForm4.sbSaveTClick(Sender: TObject);    //Update template file
Var
  i : Integer;
begin
  with pdForm do
    begin
      cmbxIT.Clear;
      RPCBroker1.ClearParameters:=True;
      RPCBroker1.ClearResults   :=True;
      RPCBroker1.RemoteProcedure:='VW REG UTF';
      for i:=1 to lbxregit.Items.Count-1 do
        begin
          RPCBroker1.Param[0].Mult[IntToStr(i)]:=lbxregit.Items.Strings[i];
          cmbxIT.Items.Append(lbxregit.Items.Strings[i]);
        end;
      RPCBroker1.Param[0].PType:=list;
      RPCBroker1.Call;
      if RPCBroker1.Results.Strings[0]='-1' then
        begin
          showMessage('Failed to save the data; please try again or contact your IT rep.'+#13#10+
                       'Thank you, the Management');
          Exit;
        end
        else
          begin
            Application.HintHidePause:=7000;
            pdForm4.sbSaveT.Hint:='Saved';
            pdForm4.sbSaveT.ShowHint:=True;
            pdForm4.sbSaveT.Enabled:=False;
          end;
    cmbxIT.Text:='<Select template>';
    end;
end;

procedure TpdForm4.sbUNClick(Sender: TObject);
begin
  if eUN.Text='' then
    begin
    showMessage('Please enter a namespace (e.g., VW, DG, N, etc.) or'+#13#10+
    'a user lastname,firstname, or internal user number'+#13#10+
    'Thank you, the Management');
    Exit;
    end;
  ListTemplates('U^'+eUN.Text);
end;

procedure TpdForm4.CVVClick(Sender: TObject);
begin
  width:=648;
  mTF.Clear;
  mTFlds.Clear;
  Close();
end;

procedure TpdForm4.sbTempSaveClick(Sender: TObject);
Var
  i      : Integer;
  //x      : String;
begin
  if eTemplateName.Text='' then
     begin
       showMessage('Please enter the name of your new template.'+#13#10+'Thank you.');
       eTemplateName.SetFocus();
       Exit;
     end;
  with PDForm do
    begin
      RPCBroker1.ClearParameters:=True;
      RPCBroker1.ClearResults:=True;
      RPCBroker1.RemoteProcedure:='VW REG SAVE TEMPLATE FLDS';
      RPCBroker1.Param[0].Mult['0']:=eTemplateName.Text;
      for i := 0 to mTFlds.Lines.Count - 1 do
        begin
          RPCBroker1.Param[0].Mult[IntToStr(i+1)]:=mTFlds.Lines.Strings[i];
        end;
      RPCBRoker1.Param[0].PType:=list;
      RPCBroker1.Call;
      if RPCBRoker1.Results.Strings[0]<>'-1' then
        begin
          pdForm4.lbxregit.Items.Append(RPCBRoker1.Results.Strings[0]);
          pdForm.cmbxIT.Items.Append(RPCBRoker1.Results.Strings[0]);
        end;
    end;
end;

procedure TpdForm4.sbMakeClick(Sender: TObject);
Var
  fWidth : Integer;
  i      : Integer;
  pfn    : Integer; //where patient fields start in for template management
  x      : String;
begin
  mTF.Clear;
  lbxPtFlds.Clear;
  x    :='';
  pfn  :=0;
  pdForm4.Top:=20;
  if pdForm4.Width<>1296 then
    begin
      fWidth:=pdForm4.Width*2;
      pdForm4.Width:=fWidth;
    end;
  {Is there a selection in lbxRegit?}
  for i := 0 to lbxregit.Items.Count-1 do
    begin
      if lbxregit.Selected[i] then x:=lbxregit.items.Strings[i];eTemplateName.Text:=x;mTFlds.Clear;
    end;
  if x='' then  //Selection in lbxDIE?
    begin
      for i := 0 to lbxDIE.items.Count - 1 do
        begin
          if lbxDIE.Selected[i] then x:=lbxDIE.Items.Strings[i];eTemplateName.Text:=x;mTFlds.Clear;
        end;
    end;
  with pdForm do
    begin
      RPCBRoker1.ClearParameters:=True;
      RPCBRoker1.ClearResults:=True;
      RPCBroker1.RemoteProcedure:='VW REG GET TEMPLATE FLDS';
      RPCBroker1.Param[0].Value:=x;
      RPCBroker1.Param[0].PType:=Literal;
      RPCBroker1.Call;
      mTF.Lines:=RPCBroker1.Results;
      {Testing
             mTF.Height:=500;
             mTF.Width:=600;
             mTF.Top:=300;
             mTF.Visible:=True;
       end testing}
    end;
  for i:=0 to mTF.Lines.Count-1 do
    begin
      x:=mTF.Lines.Strings[i];
      if x='[PF]' then Break;
      mTFlds.Lines.Append(x);
    end;
  for i := 0 to mTF.Lines.Count-1 do
    begin
      if mTF.Lines.Strings[i]='[PF]' then
       begin
         pfn:=i;
         Break;
       end;
    end;
  for i := pfn+1 to mTF.Lines.Count-1 do
    begin
      lbxPtFlds.Items.Append(mTF.Lines.Strings[i]);
    end;
end;

procedure TpdForm4.sbCloseClick(Sender: TObject);
Var
 fWidth : Integer;
begin
  //pdForm4.eHomDir.Text:='';
  fWidth:=pdForm4.Width;
  eNS.Text:='';
  eUN.Text:='';
  //lbxRegit.Clear;
  lbxDie.Clear;
  pdForm4.Width:=fWidth div 2;
  Close;
end;

end.
