unit vwPtReg;
{Unused code
 From bld label:
   //better look at all args coming in...
  showMessage(' 2^Text: '+Text+#13#10+
              ' 3^Left: '+IntToStr(Label_Left)+#13#10+
              ' 4^Top : '+IntToStr(Label_Top)+#13#10+
              ' 5^NID : '+IntToStr(NumofComp)+#10#10+
              ' 6^Name: '+Nameown+#13#10+
              ' 7^ASZ : '+BoolToStr(Label_Autosize)+#13#10+
              ' 8^Font: '+BoolToStr(Label_FontBold)+#13#10+
              ' 9^Trns: '+BoolToStr(Label_Trans)+#13#10+
              '10^Val : '+fValue+#13#10+
              '11^Hint: '+fHint+#13#10+
              '12^PS  : '+psF);
}
interface
                           
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Buttons, jpeg, ShellLinker, ShellApi, ShlObj,
  ComObj, Trpcb, Grids, ComCtrls, StrUtils, Winsock, Registry, ActiveX, CommCtrl;

type
  TpdForm = class(TForm)
    iLogo: TImage;
    cmbxIT: TComboBox;
    s1: TShape;
    eID: TEdit;
    lblfName: TLabel;
    efName: TEdit;
    lblDOB: TLabel;
    eDOB: TEdit;
    sbLU: TSpeedButton;
    sbClear: TSpeedButton;
    sbSave: TSpeedButton;
    Shape1: TShape;
    sbHelp: TSpeedButton;
    RPCBroker1: TRPCBroker;
    mScratch: TMemo;
    eGender: TEdit;
    lblGender: TLabel;
    lbllName: TLabel;
    elName: TEdit;
    lblINPT: TLabel;
    sbACI: TSpeedButton;
    sbADM: TSpeedButton;
    eHD: TEdit;
    sbSetUp: TSpeedButton;
    lbxFiled: TListBox;
    sbRefresh: TSpeedButton;
    cmbxID: TComboBox;
    procedure lbxFiledMouseEnter(Sender: TObject);
    procedure psfSHelp(Sender: TObject);
    procedure iDataButtonClick(Sender: TObject);
    procedure sbRefreshClick(Sender: TObject);
    procedure sbSetUpClick(Sender: TObject);
    procedure sbHelpClick(Sender: TObject);
    procedure sbSaveClick(Sender: TObject);
    procedure eIDMouseEnter(Sender: TObject);
    procedure elNameEnter(Sender: TObject);
    procedure efNameEnter(Sender: TObject);
    procedure eDOBEnter(Sender: TObject);
    procedure eGenderEnter(Sender: TObject);
    procedure sbClearClick(Sender: TObject);
    procedure sbLUClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure split(const Delimiter: Char; Input: string; const Strings: TStrings);
    procedure bldLabel(location:TWinControl; Text: String; Label_Left,Label_Top,
              Numofcomp: Integer; NameOwn: string; Label_Autosize,Label_FontBold,
              Label_Trans: Boolean; fvalue: String; fHint: String; psF: String);
    procedure GTF(Sender: TObject);
    procedure psFHelp(Sender: TObject);
    procedure psFClose(Sender: TObject);
    procedure showmScratch(Sender: TObject);
    procedure ColorText(Sender: TObject);
    function gp(x : String; const Delimiter: Char; piece : Integer) : String;
    function BrowseURL(const URL: string) : boolean;
  private
    ImIn   : Integer;
    server : String;
    port   : String;
    fList  : Array of String;
  public
    listSel: Integer;
    fauxDFN: String;
    homDir : String;
    DFN    : Integer;
    patC   : Integer; //Count of returned patients in look up
    rsValue: String;  //Return value from popup form selection
    eLbl   : String;
    butSel : Integer;
end;

  type
    TExHint = class(THintWindow)
    constructor Create(AOwner: TComponent); override;
  end;

  var
  pdForm: TpdForm;

implementation

{$R *.dfm}

uses pList,iList,suList;  //NOTE: CTRL-SHIFT-KM to collapse all methods

constructor TExHint.Create(AOwner: TComponent); //Customize size of roll-over hints
begin
  inherited Create(AOwner);
  with Canvas.Font do
  begin
    Name  := 'Calibri';
    Size  := Size + 2;
    //Style := [fsItalic];
  end;
end;

function pieceCount(const x:String; const c: char) : Integer;
Var
  i : integer;
begin
  result:=0;
  for i := 0 to Length(x) do
    begin
      if x[i]=c then Inc(result);
    end;
end;

function IsMouseBtnDown: Boolean;
begin
  {Result := (GetAsyncKeyState(VK_LBUTTON)
             OR GetAsyncKeyState(VK_MBUTTON)
             OR GetAsyncKeyState(VK_RBUTTON)
             )}
  Result:=GetAsyncKeyState(VK_RBUTTON) AND $8000 <> 0;
end;

{testing}
procedure TpdForm.showmScratch(Sender: TObject);
begin
  mScratch.Width:=500;   //testing only - jeb
  mScratch.Height:=200;
  mScratch.Left:=400;
  mScratch.Align:=alBottom;
  mScratch.Visible:=True;
end;

//Refresh - clear text fields, DFN, etc, leave template in combo box
procedure TpdForm.sbRefreshClick(Sender: TObject);
Var
  x : String;
begin
  x:=cmbxIT.Text;
  sbClearClick(Self);
  cmbxIT.Text:=x;
  sbLU.Enabled:=True;
end;

{In Lieu of Fileman parts this is pascal's equivalent to C's "split" technique.
 2-step process that is call to gp (see below) which then calls split. Return is
 the dynamic TStringList component which is a standard zero based array broken on
 the passed delimiter. Piece you're looking for is always in array node-1.}
procedure TpdForm.split(const Delimiter: Char; Input: string; const Strings: TStrings);
begin
   Assert(Assigned(Strings));
   Strings.Clear;
   Strings.StrictDelimiter:=True;  //Use to specify "use only" delimiter listed in argument
   Strings.Delimiter := Delimiter;
   Strings.DelimitedText := Input;
end;

function TpdForm.gp(x : String; const Delimiter: Char; piece : Integer) : String;  //Get Piece (gp)
Var
 A : TStringList;
 y : String;
begin
  if x='' then Exit;
  A := TStringList.Create;
  try
    pdForm.split(Delimiter,x,A);
    y:=A[piece-1];
  finally
    A.Free;
  end;
  Result:=y;
end;

procedure TpdForm.psFClose(Sender: TObject);
begin
  pdForm3.Close;
end;

//typecast problem here - sender might be vague - resolved with 'safe' cast IS
procedure TpdForm.ColorText(Sender: TObject); {Used to indicate change in the data field}
begin
   if Sender is TEdit then
    begin
      if TEdit(Sender).Text='' then TEdit(Sender).Color:=clWhite else TEdit(Sender).Color:=clSkyBlue;
    end;
   if Sender is TComboBox then
    begin
      if TComboBox(Sender).Text='' then TComboBox(Sender).Color:=clWhite else TComboBox(Sender).Color:=clSkyBlue;
    end;
end;

{Sets of Codes}
procedure TpdForm.psfSHelp(Sender: TObject);
Var
  cName  :String;
  xLen   :Integer;
  xStr   :String;
  xLine  :String;
  x      :String;
  y      :String;
  z      :String;
  i      :Integer;
  xPC    :Integer;
begin
  eLbl:='';
  if Sender is TComboBox then cName:=TComboBox(Sender).Name else Exit;
  eLbl:=cName;
  xLen:=Length(cName);
  xStr:=Copy(cName,5,xLen);
  xLine:=mScratch.Lines.Strings[StrToInt(xStr)];
  x:=gp(xLine,'^',5);
  xPC:=pieceCount(x,';')+1;
  //showMessage('x Var is: '+x+#13#10+'#pieces of x: '+IntToStr(xPC));
  if Sender is TComboBox then TComboBox(Sender).Clear;
  
  for i := 1 to xPC do
    begin
      y:=gp(x,';',i);
      z:=gp(y,':',2);
      if Sender is TComboBox then TComboBox(Sender).Items.Append(z);
    end;
end;

{Pointed to File listings}
procedure TpdForm.psFHelp(Sender: TObject);
Var
  cName  :String;
  xLen   :Integer;
  xStr   :String;
  xLine  :String;
  rCount :Integer;
begin
  eLbl:='';
  if Sender is TEdit then cName:=(Sender as TEdit).Name;
  eLbl:=cName;
  xLen:=Length(cName);
  xStr:=Copy(cName,5,xLen);
  xLine:=mScratch.Lines.Strings[StrToInt(xStr)];
  RPCBroker1.ClearParameters:=True;
  RPCBroker1.ClearResults:=True;
  RPCBroker1.RemoteProcedure:='VW REG PSF';
  RPCBroker1.Param[0].Value:=cmbxIT.Text+'^'+xLine+'^'+IntToStr(DFN);
  RPCBroker1.Param[0].PType:=Literal;
  RPCBroker1.Call;
  if RPCBroker1.Results.Strings[0]='0' then Exit;
  rCount:=RPCBroker1.Results.Count;
  if rCount>0 then
    begin
      pdForm3.lbItems.Items:=RPCBroker1.Results;
      pdForm3.Left:=850;//1060;
      pdForm3.Top :=150;
      pdForm3.Show;
    end;
end;

{*NOTE: Piece 5 will either be empty or contain the set of codes or pointer reference
 *      If piece 5, then can I make elbl a combobox?
 *
}
procedure TpdForm.GTF(Sender : TObject); //Get Template fields from mScratch and run the bldLabel
Var
  x        : String;
  fld      : String;
  flv      : String;
  fln      : String;
  lHint    : String;
  bHint    : String;
  psFld    : String;
  i        : Integer;
  startTop : Integer;
  fListC   : Integer;
  labLeft  : Integer;
  label Column2;
  begin
//bldLabel(pdForm,'STREET',8,155,1,'lblStreet',True,False,False,Field value,hint);
  setLength(fList,(mScratch.Lines.Count-3)*2);
  startTop:=155;
  lHint:='';
  bHint:='';
  psFld:='';
  fListC:=0;
  labLeft:=8;
  for i:=3 to mScratch.Lines.Count-1 do
    begin
      if i=26 then GoTo Column2;
      x:=mScratch.Lines.Strings[i];
      fld:=gp(x,'^',1);
      fln:=gp(x,'^',2);
      flv:=gp(x,'^',3);
      lHint:=gp(x,'^',4);
      psFld:=gp(x,'^',5);
      bHint:=WrapText(lhint,65);
      lHint:=bHint;
        fList[fListC]:='lbl'+IntToStr(i);
        Inc(fListC);
        fList[fListC]:='elbl'+IntToStr(i);
        Inc(fListC);
      bldLabel(pdForm,fld,labLeft,startTop,i,'lbl',False,False,False,flv,lHint,psFld);
      startTop:=startTop+25;
    end;
  Column2:
    startTop:=155;
    lHint:='';
    bHint:='';
    psFld:='';
    //fListC:=0;
    labLeft:=420;
    for i := i to mScratch.Lines.Count - 1 do
      begin
      x:=mScratch.Lines.Strings[i];
      fld:=gp(x,'^',1);
      fln:=gp(x,'^',2);
      flv:=gp(x,'^',3);
      lHint:=gp(x,'^',4);
      psFld:=gp(x,'^',5);
      bHint:=WrapText(lhint,65);
      lHint:=bHint;
        fList[fListC]:='lbl'+IntToStr(i);
        Inc(fListC);
        fList[fListC]:='elbl'+IntToStr(i);
        Inc(fListC);
      bldLabel(pdForm,fld,labLeft,startTop,i,'lbl',False,False,False,flv,lHint,psFld);
      startTop:=startTop+25;
      end;
end;

procedure TpdForm.iDataButtonClick(Sender: TObject);
begin
if DFN<>0 then
  begin
    showMessage('Multi-tab inquiry coming soon');
  end;
end;

procedure TpdForm.lbxFiledMouseEnter(Sender: TObject);
Var
  x : String;
begin
  x:='This field shows your database updates.';
  Application.HintHidePause:=5000;
  lbxFiled.Hint:=x;
  lbxFiled.ShowHint:=True;
end;

procedure TpdForm.bldLabel(location:TWinControl; Text: String; Label_Left,Label_Top,
          NumofComp: Integer; NameOwn: string; Label_Autosize,Label_FontBold,
          Label_Trans: Boolean; fValue: String; fHint: String; psF: String);
Var
  locLabel : TLabel;
  locEdit  : TEdit;
  //locHelp  : TLabel;
  locCBox  : TComboBox;
begin
  locLabel:=TLabel.Create(Self);
  locLabel.Name:=NameOwn+IntToStr(NumofComp);
  locLabel.Parent:=location;
  locLabel.Caption:=Text;
  locLabel.AutoSize:=Label_Autosize;
  locLabel.Transparent:=Label_Trans;
  locLabel.Font.Size:=11;
  locLabel.Font.Name:='Calibri';
  locLabel.Font.Color:=clBlack;
  locLabel.Top:=label_Top;
  locLabel.Left:=Label_Left;
  locLabel.Width:=200;
  locLabel.Alignment:=taRightJustify;
  locLabel.Visible:=True;
  if AnsiContainsStr(psF,':') then
    begin
      //showMessage(psF);
      locCBox:=TComboBox.Create(Self);
      locCBox.Parent:=location;
      locCBox.Name:='e'+NameOwn+IntToStr(NumofComp);
      locCBox.Top:=locLabel.Top-2;
      locCBox.Width:=200;
      if Label_Left>400 then locCBox.Left:=Label_Left+locLabel.Width+15 else locCBox.Left:=locLabel.Width+15;
      locCBox.AddItem(fValue,nil);
      locCBox.ItemIndex:=0;
      locCBox.Hint:=fHint;
      locCBox.ShowHint:=True;
      LocCBox.OnEnter:=psfSHelp;  //For Sets of codes
      locCBox.OnChange:=colorText;
    end
  else
    begin
      locEdit:=TEdit.Create(self);
      locEdit.Parent:=location;
      locEdit.Name:='e'+NameOwn+IntToStr(NumofComp);
      locEdit.Top:=locLabel.Top-2;
      locEdit.Width:=200;
      if Label_Left>400 then locEdit.Left:=Label_left+locLabel.Width+15 else locEdit.Left:=locLabel.Width+15;
      locEdit.Text:=fValue;
      locEdit.Font:=locLabel.Font;
      locEdit.Visible:=True;
      locEdit.Hint:=fHint;
      locEdit.ShowHint:=True;
      locEdit.OnEnter:=psFHelp;
      locEdit.OnChange:=colorText;
      //locEdit.OnExit:=psFClose;     //Note - focus is on pdForm3...no return as a selection might happen
      sbSave.Enabled:=True;
    end;
end;

{Note: Default browser is in HKEY_CLASSES_ROOT\http\shell\open\command...  - jeb}
function TpdForm.BrowseURL(const URL: string) : boolean;
var
   Browser: string;
begin
   Result := True;
   Browser := '';
   with TRegistry.Create do
   try
     RootKey := HKEY_CLASSES_ROOT;
     Access := KEY_QUERY_VALUE;
     if OpenKey('\http\shell\open\command', False) then
       Browser := ReadString('') ;
     CloseKey;
   finally
     Free;
   end;
   if Browser = '' then
   begin
     Result := False;
     Exit;
   end;
   //showmessage(Browser);
   Browser := Copy(Browser, Pos('"', Browser) + 1, Length(Browser)) ;
   Browser := Copy(Browser, 1, Pos('"', Browser) - 1) ;
   ShellExecute(0, 'open', PChar(Browser), PChar(URL), nil, SW_SHOW) ;
end;

procedure TpdForm.eDOBEnter(Sender: TObject);
Var
  x : String;
begin
  x:='Enter the applicant''s date of birth between December 31, 1870 and today.'+#13#10+
     'NOON, MIDNIGHT or NOW are NOT allowed. Examples:'+#13#10+
     'MM/DD/YYYY=> 03/29/1947'+#13#10+
     'MM/DD/YYYY HH/MM=> 03/29/1947 1423'+#13#10+
     'MM/YYYY=> 03/1947'+#13#10+
     'YYYY=> 1947'+#13#10+
     'T-NM=> T-18M - TODAY MINUS 18 MONTHS'+#13#10+
     '-N[M][W][D]=> T-3W  - TODAY MINUS 3 WEEKS'+#13#10+
     '-N[M][W][D]@HH:MM=> T-3D@11:23 - TODAY MINUS 3 DAYS AT 11:23'+#13#10+
     'Note that "TODAY" is always understood for partial entries.'+#13#10+
     'Note that leading with the minus sign for partial entries, like'+#13#10+
     '-3W requires an "@" sign to include time of hours:minutes'+#13#10;
  Application.HintHidePause:=30000;
  eDOB.Hint:=x;
  eDOB.ShowHint:=True;
end;

procedure TpdForm.eGenderEnter(Sender: TObject);
begin
  Application.HintHidePause:=10000;
  eGender.ShowHint:=True;
end;

procedure TpdForm.eIDMouseEnter(Sender: TObject);
Var
  x : String;
begin
  x:='';
  Application.HintHidePause:=30000;
  x:=x+'This is the primary ID used by the patient for identification at your facility.'+#10#13;
  x:=x+'ID might be a national ID or specific ID to this facility/region;'+#10#13;
  x:=x+'HRN typically refers to Health Record Number as issued by a facility or'+#13#10;
  x:=x+'Health system provider;'+#13#10;
  x:=x+'SSN is strictly a USA national ID and may be interchanged with a health providers'+#10#13;
  x:=x+'Health Record Number.';
  x:=x+'NOTE: To RECALL a prior patient, enter a space and press the "Enter/Edit" button.';
  cmbxID.Hint:=x;
  cmbxID.ShowHint:=True;
end;

procedure TpdForm.elNameEnter(Sender: TObject);
begin
  Application.HintHidePause:=15000;
  elName.ShowHint:=True;
end;

procedure TpdForm.efNameEnter(Sender: TObject);
Var
  x : String;
begin
  x:='Enter the person`s first name'+#13#10+
                                   '[optionally a middle initial or middle name'+#13#10+
                                   'preceded by a space]';
  Application.HintHidePause:=15000;
  efName.Hint:=x;
  efName.ShowHint:=True;
end;

function GetShortcutTarget(ShortcutFilename:string):string;
var
  Psl:IShellLink;
  Ppf:IPersistFile;
  WideName:Array [0..MAX_PATH] of WideChar;
  pResult:Array [0..MAX_PATH-1] Of Char;
  Data:TWin32FindData;
const
IID_IPersistFile: TGUID = (D1:$0000010B; D2:$0000; D3:$0000; D4:($C0,$00,$00,$00,$00,$00,$00,$46));
begin
  CoCreateInstance(CLSID_ShellLink,nil,CLSCTX_INPROC_SERVER, IID_IShellLinkA ,psl);
  psl.QueryInterface(IID_IPersistFile,ppf);
  MultiByteToWideChar(CP_ACP, 0, pChar(ShortcutFilename), -1, WideName, Max_Path);
  ppf.Load(WideName,STGM_READ);
  psl.Resolve(0,SLR_ANY_MATCH);
  psl.GetPath(@pResult,MAX_PATH,Data,SLGP_UNCPRIORITY);
  psl.GetArguments(@pResult,MAX_PATH);
  Result:=StrPas(@pResult);
end;

procedure TpdForm.FormCreate(Sender: TObject);
Var
  dFile : TextFile;
  x   : String;
  i     : Integer;
  c     : Integer;
Label jumpFile;
Label jumpHere;
begin
  ImIn:=0;
  listSel:=0;
  c:=0;
  HintWindowClass  := TExHint;
  x:=GetShortcutTarget('c:\Users\Public\Desktop\VWReg.lnk');
  //showMessage('Link: '+x);
  //pdForm4.Width:=648;
  if x='' then GoTo jumpFile;
  server:=gp(gp(x,'=',2),' ',1);TrimLeft(server);TrimRight(server);if Length(server)>0 then Inc(c);
  port:=gp(x,'=',3);TrimLeft(port);TrimRight(port);if Length(port)>0 then Inc(c);
  if c=2 then GoTo jumpHere;
  //application.Terminate; //Testing server/port extraction from short-cut
  jumpFile:
  if FileExists('c:\VWREG\connect.txt') then
    begin
      AssignFile(dFile,'C:\VWREG\connect.txt');
      FileMode := fmOpenRead;
      Reset(dFile);
     while not Eof(dFile) do
      begin
        ReadLN(dFile,x);
        if AnsiContainsStr(x,'.') then server:=x else port:=x;
      end;
     CloseFile(dFile);
    end
    else
      begin
        showMessage('I could not find the shortcut or C:\VWREG\connect.txt;+#13#10Application not started.');
        Application.Terminate;
      end;
  //mScratch.Visible:=True;mScratch.Left:=8;mScratch.Height:=400;mScratch.Width:=600;  //testing
  jumpHere:
  mScratch.Clear;
  RPCBroker1.Server:=server;
  RPCBroker1.ListenerPort:=StrToInt(port);
  RPCBroker1.ClearParameters:=True;
  RPCBroker1.ClearResults:=True;
  RPCBroker1.CreateContext('VW PATIENT REGISTRATION');
  RPCBroker1.RemoteProcedure:='VW REG MAIN';
  RPCBroker1.Call;
  if RPCBroker1.Connected=True then ImIn:=1;
  if RPCBroker1.Results.Strings[2]='[ID]' then
     begin
       butSel:=MessageDlg('There are no template IDs in the regit.txt file'+#13#10+
                    'try the Set-Up Button on the Upper right of the form',mtError,mbOKCancel,0);
     end;
  if gp(RPCBroker1.Results.Strings[0],'^',1)='1' then
     begin
       homDir:=gp(RPCBRoker1.Results.Strings[0],'^',2);
       sbSetUp.Enabled:=True;
     end;
  mScratch.Lines:=RPCBroker1.Results;
  //showmScratch(Self); //testing - displays the data in the mScratch memo component
  for i:=2 to mScratch.Lines.Count-1 do
    begin
      x:=mScratch.Lines.Strings[i];
      if AnsiContainsStr(x,'[ID') then Break;
      cmbxIT.Items.Append(x);
    end;
  mScratch.Clear;
end;

procedure TpdForm.sbClearClick(Sender: TObject);
Var
  i : Integer;
  name:String;
  C : TComponent;
  x : String;
begin
  eID.Text:='';
  efName.Text:='';
  elName.Text:='';
  eDOB.Text:='';
  eGender.Text:='';
  eID.SetFocus;
  lblINPT.Caption:='';
  cmbxIT.Clear;
  cmbxIT.Text:='        <Select Template>';
  cmbxID.Text:='ID';
  DFN:=0;
  mScratch.Clear;
  sbLU.Enabled:=True;
  sbSave.Enabled:=False;
  for i:=0 to Length(fList)-1 do
    begin
      name:=fList[i];
      //showMessage(name);
      C:=(FindComponent(name) as TComponent);
      C.Destroy;
    end;
  fList:=nil;
  RPCBroker1.ClearParameters:=True;
  RPCBroker1.ClearResults:=True;
  RPCBroker1.RemoteProcedure:='VW REG MAIN';
  RPCBroker1.Call;
  if RPCBroker1.Results.Strings[2]='[ID]' then
     begin
       butSel:=MessageDlg('There are no template IDs in the regit.txt file'+#13#10+
                    'try the Set-Up Button on the Upper right of the form',mtError,mbOKCancel,0);
     end;
  if gp(RPCBroker1.Results.Strings[0],'^',1)='1' then homDir:=gp(RPCBRoker1.Results.Strings[0],'^',2);
  mScratch.Lines:=RPCBroker1.Results;
  //showmScratch(Self); //testing - displays the data in the mScratch memo component
  for i:=2 to mScratch.Lines.Count-1 do
    begin
      x:=mScratch.Lines.Strings[i];
      if AnsiContainsStr(x,'[ID') then Break;
      cmbxIT.Items.Append(x);
    end;
  mScratch.Clear;
end;

procedure TpdForm.sbSetUpClick(Sender: TObject);
begin
  pdForm4.Show;
end;

procedure TpdForm.sbHelpClick(Sender: TObject);
begin
  if FileExists('c:\VWREG\RegHelp.html') then
    begin
      BrowseURL('file:///c:/VWREG/RegHelp.html');
    end
  else showMessage('Can not find the file?');
end;

procedure TpdForm.sbLUClick(Sender: TObject);
Var
 patID : String;
 x     : String;
 ward  : String;
 i     : Integer;
 count : Integer;  //Count of empty ID fields
begin
 count:=0;
 patC:=0;
 if ImIn=0 then
   begin
     RPCBroker1.Server:=server;
     RPCBroker1.ListenerPort:=StrToInt(port);
     RPCBroker1.CreateContext('VWPATREG');
   end;
 if AnsiContainsStr(cmbxIT.Text,'<S') then showMessage('Please select a template,'+#13#10+'Thank you');
 x:=elName.Text+','+efName.Text;
 if AnsiContainsStr(x,' ,') then x:=' ';
 if eID.Text=' ' then x:=' ';
 //Count of empty ID fields
 if eID.Text=''       then Inc(count);
 if eFName.Text=''    then Inc(count);
 if eLname.Text=''    then Inc(count);
 if eDOB.Text=''      then Inc(count);
 if eGender.Text=''   then Inc(count);
 RPCBroker1.ClearParameters:=True;
 RPCBroker1.ClearResults:=True;
 RPCBroker1.RemoteProcedure:='VW REG DEMOG';
 RPCBroker1.Param[0].Value:=cmbxIT.Text+'^'+cmbxID.Text+':'+eID.Text+'^'+x+'^'+eDOB.Text+'^'+eGENDER.Text;
 //showmessage(RPCBroker1.Param[0].Value);
 RPCBroker1.Param[0].PType:=literal;
 RPCBroker1.Call;
 patC:=StrToInt(gp(RPCBRoker1.Results.Strings[0],'^',2));
 patID:=RPCBroker1.Results.Strings[1];
 if AnsiContainsStr(RPCBroker1.Results.Strings[0],'MM') then
   begin
     showMessage(patID);
     sbClearClick(Self);
     Exit;
   end;
 if AnsiContainsStr(patID,'-1') then butSel:=MessageDlg('Are you adding a new patient?'+#13#10+
                                'NOTE: The following fields are required'+#13#10+'to make a new patient entry:'+#13#10+
                                '  First name & last name'+#13#10+
                                '  Date of Birth'+#13#10+
                                '  Gender (m or f)'+#13#10+
                                '  ID [optional, but preferred]',mtInformation,[mbYes,mbNo],0);
 if butSel=mrNo then
   begin
     sbClearClick(Self);
     //eID.Text:=''; efName.Text:=''; elName.Text:=''; eDOB.Text:=''; eGender.Text:='';
     Exit;
   end;
 if butSel AND count>0 then
   begin
     ShowMessage('Fill in all the ID fields above and then press the "Enter/Edit" button');
     Exit;
   end
   else if butSel=mrYes then
        begin
          x:='';
          RPCBroker1.ClearParameters:=True;
          RPCBroker1.ClearResults:=True;
          RPCBroker1.RemoteProcedure:='VW REG DEMOG';
          RPCBroker1.Param[0].Value:=cmbxIT.Text+'^'+cmbxID.Text+':'+eID.Text+'^'+elName.Text+','+efName.Text+'^'+eDOB.Text+'^'+eGENDER.Text+'^1';
          RPCBroker1.Param[0].PType:=literal;
          RPCBroker1.Call;
          patID:=RPCBroker1.Results.Strings[1];
          DFN:=StrToInt(gp(patID,'^',1));
          eID.Text:=gp(patID,'^',2);
          x:=gp(patID,'^',3);
          efName.Text:=gp(x,',',2);
          elName.Text:=gp(x,',',1);
          eDOB.Text:=gp(patID,'^',4);
          eGender.Text:=gp(patID,'^',5);
          lblINPT.Caption:=gp(patID,'^',6);
          //Exit;
        end
   else if patC>1 then
     begin
       pdform2.lbPList.Clear;
       for i := 1 to patC do
        begin
          x:=RPCBroker1.Results.Strings[i];
          pdForm2.lbPList.Items.Append(x);
        end;
     pdForm2.Show;
     end
   else if patC<2 then
     begin
       DFN:=StrToInt(gp(patID,'^',1));
       eID.Text:=(gp(patID,'^',2));
       x:=gp(patID,'^',3);
       efName.Text:=gp(x,',',2);
       elName.Text:=gp(x,',',1);
       eDOB.Text:=gp(patID,'^',4);
       eGender.Text:=gp(patID,'^',5);
       ward:=gp(patID,'^',6);
       if Length(ward)>0 then lblINPT.Caption:='Ward: '+ward;
       sbLU.Enabled:=False;
     end;
   mScratch.Clear;
   mScratch.Lines:=RPCBRoker1.Results;
   //showmScratch(Self);  //Display for testing/trouble-shoot
   if patC<2 then GTF(Self);
end;

procedure TpdForm.sbSaveClick(Sender: TObject);
Var
  i,c   : Integer;
  xLen  : Integer;
  name  : String;
  E     : TComponent;
  xLine : String;
  mLine : String;
  x     : String;
begin
  RPCBroker1.ClearParameters:=True;
  RPCBRoker1.ClearResults   :=True;
  RPCBroker1.RemoteProcedure:='VW REG SAVE';
  RPCBroker1.Param[0].Mult['0']:=cmbxIT.Text+'^VWRGUI';
  RPCBroker1.Param[0].Mult['4']:='.363^'+eID.Text;
  RPCBRoker1.Param[0].Mult['1']:='.01^'+elName.Text+','+efName.Text+'('+IntToStr(DFN)+')';
  RPCBroker1.Param[0].Mult['3']:='.03^'+eDOB.Text;
  RPCBroker1.Param[0].Mult['2']:='.02^'+eGender.Text;
  RPCBroker1.Param[0].Mult['5']:='1901^N';
  c:=5;
  for i:=0 to Length(fList)-1 do
    begin
      if AnsiContainsStr(fList[i],'elbl') then
        begin
          E:=(FindComponent(fList[i]) as TComponent);
          name:=E.Name;
          xLen:=Length(name);
          xLine:=Copy(name,5,xLen); //fix where line number is
          Inc(c);
          if E is TEdit then
            begin
              mLine:=mScratch.Lines.Strings[StrToInt(xLine)];
              if (FindComponent(E.Name) as TEdit).Color=clSkyBlue then RPCBroker1.Param[0].Mult[IntToStr(c)]:=gp(mLine,'^',2)+'^'+(FindComponent(E.Name) as TEdit).Text
            end
          else if E is TComboBox then
            begin
              mLine:=mScratch.Lines.Strings[StrToInt(xLine)];
              if (FindComponent(E.Name) as TComboBox).Color=clSkyBlue then RPCBRoker1.Param[0].Mult[IntToStr(c)]:=gp(mLIne,'^',2)+'^'+(FindComponent(E.Name) as TComboBox).Text;
            end;
        end;
    end;
  RPCBroker1.Param[0].PType:=list;
  RPCBroker1.Call;
  if gp(RPCBroker1.Results.Strings[0],'^',1)='1' then
    begin
      x:=gp(RPCBroker1.Results.Strings[0],'^',2);
      lbxFiled.Visible:=True;
      lbxFiled.Items.Append(elName.Text+','+efName.Text+' '+x+' - updated');
    end
  else
    begin
      x:='';
      for i := 0 to RPCBroker1.Results.Count-1 do
        begin
          x:=x+RPCBroker1.Results.Strings[i]+#13#10;
        end;
      showMessage(x);
    end;
  x:=cmbxIT.Text;
  sbClearClick(Self);
  cmbxIT.Text:=x;
end;

end.
