unit FieldList;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, StdCtrls, Menus, Trpcb;

type
  TForm5 = class(TForm)
    f5Main: TMainMenu;
    Cancel1: TMenuItem;
    Finished1: TMenuItem;
    FieldGroup1: TMenuItem;
    sort1: TMenuItem;
    Alphabetical1: TMenuItem;
    Field1: TMenuItem;
    lbxFieldSource: TListBox;
    lbxFieldTarget: TListBox;
    sbMSelect: TSpeedButton;
    sbSelectAll: TSpeedButton;
    sbMoveUp: TSpeedButton;
    sbMoveDown: TSpeedButton;
    Label1: TLabel;
    Label2: TLabel;
    hELP1: TMenuItem;
    sbDeleteTarget: TSpeedButton;
    lblSep: TLabel;
    mForms: TMemo;
    procedure FormShow(Sender: TObject);
    procedure sbMoveDownClick(Sender: TObject);
    procedure sbMoveUpClick(Sender: TObject);
    procedure sbDeleteTargetClick(Sender: TObject);
    procedure sbMoveDownMouseEnter(Sender: TObject);
    procedure sbMoveUpMouseEnter(Sender: TObject);
    procedure sbDeleteTargetMouseEnter(Sender: TObject);
    procedure sbSelectAllMouseEnter(Sender: TObject);
    procedure sbMSelectMouseEnter(Sender: TObject);
    procedure sbMSelectClick(Sender: TObject);
    procedure Field1Click(Sender: TObject);
    procedure Alphabetical1Click(Sender: TObject);
    procedure Cancel1Click(Sender: TObject);
    procedure Finished1Click(Sender: TObject);
    procedure f5FormClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form5: TForm5;

implementation

{$R *.dfm}

uses bfp1;

procedure TForm5.Alphabetical1Click(Sender: TObject);
begin
  //Call and get fields in alphabetic order
end;

procedure TForm5.Cancel1Click(Sender: TObject);
begin
  lbxFieldTarget.Clear;
  lbxFieldSource.Clear;
  Form1.Height:=300;
  Form5.Close;
end;

procedure TForm5.Field1Click(Sender: TObject);
begin
  //Call and get field by field number
end;

procedure TForm5.Finished1Click(Sender: TObject);
Var
  i : Integer;
  x : String;
begin
  if lbxFieldTarget.count<1 then Cancel1Click(Self);
  Form1.RPCBroker1.ClearParameters:=True;
  Form1.RPCBroker1.ClearResults   :=True;
  Form1.RPCBroker1.RemoteProcedure:='VW REG AHF';
  Form1.RPCBroker1.Param[0].Mult[IntToStr(0)]:=Form1.DFN;
  Form1.RPCBroker1.Param[0].PType :=list;
  for i:=0 to lbxFieldTarget.Items.Count-1 do
    begin
      x:=lbxFieldTarget.Items.Strings[i];
      Form1.RPCBroker1.Param[0].Mult[IntToStr(i+1)]:=x;
    end;
  Form1.RPCBroker1.Call;
  if Form1.RPCBroker1.Results.Count<1 then showMessage('Field info not found'); Cancel1Click(Self);
  Form1.mData.Lines:=Form1.RPCBroker1.Results;
  Cancel1Click(Self);
end;

procedure TForm5.f5FormClick(Sender: TObject);
Var
  x : String;
begin
  if Sender is TMenuItem then
    begin
      x:=(Sender as TMenuItem).Caption;
    end;
  lbxFieldTarget.Clear;
  With Form1 do
    begin
      RPCBroker1.ClearParameters:=True;
      RPCBroker1.ClearResults   :=True;
      RPCBroker1.RemoteProcedure:='VW REG FLD BY GRP';
      RPCBroker1.Param[0].Value :=x;
      RPCBroker1.Param[0].PType :=literal;
      RPCBroker1.Call;
      lbxFieldTarget.Items:=RPCBroker1.Results;
     end;
end;

procedure TForm5.FormShow(Sender: TObject);
Var
  m5Item: TMenuItem;
  x     : String;
  i     : Integer;
begin
  With Form1 do
    begin
      RPCBroker1.ClearParameters:=True;
      RPCBroker1.ClearResults   :=True;
      RPCBroker1.RemoteProcedure:='VW REG GRP LIST';
      RPCBroker1.Call;
      for i:=0 to RPCBroker1.Results.Count-1 do
        begin
          x:=RPCBroker1.Results.Strings[i];
          m5Item:=TMenuItem.Create(f5Main.Items[1]);
          m5Item.Name:='T'+IntToStr(i);
          m5Item.ImageIndex:=i*-1;
          m5Item.Caption:=x;
          m5Item.Tag:=i-1;
          m5Item.OnClick:=f5FormClick;
          f5Main.Items[1].Add(m5Item);
        end;
      //Refresh the lbxFieldSource list
      RPCBroker1.ClearParameters:=True;
      RPCBroker1.ClearResults   :=True;
      RPCBroker1.RemoteProcedure:='VW REG FLD BY GRP';
      RPCBroker1.Param[0].Value :='';
      RPCBroker1.Param[0].PType :=literal;
      RPCBroker1.Call;
      lbxFieldSource.Items:=RPCBroker1.Results;
    end;
end;

procedure TForm5.sbDeleteTargetClick(Sender: TObject);
Var
  i : Integer;
begin
  for i:=lbxFieldTarget.items.Count-1 downto 0 do
    begin
      if lbxFieldTarget.Selected[i] then lbxFieldTarget.Items.Delete(i);
    end;
end;

procedure TForm5.sbDeleteTargetMouseEnter(Sender: TObject);
begin
  Application.HintHidePause:=100000;
  hint:='Deletes selected fields from the Target area only';
  showHint:=True;
end;

procedure TForm5.sbMSelectClick(Sender: TObject);
Var
  i : Integer;
begin
  for i:=0 to lbxFieldSource.Items.Count-1 do
    begin
      if lbxFieldSource.Selected[i] then lbxFieldTarget.Items.Add(lbxFieldSource.Items.Strings[i]);
    end;
end;

procedure TForm5.sbMSelectMouseEnter(Sender: TObject);
begin
  Application.HintHidePause:=100000;
  hint:='Move selected source fields to target area';
  showHint:=True;
end;

procedure TForm5.sbSelectAllMouseEnter(Sender: TObject);
begin
  Application.HintHidePause:=100000;
  hint:='Move all source fields to target area (not a good idea...see Help)';
  showHint:=True;
end;

procedure TForm5.sbMoveUpClick(Sender: TObject);
Var
  i : Integer;
  x : String;
begin
  //for i:=lbxFieldTarget.Count-1 downto 0 do
  for i:=0 to lbxFieldTarget.Items.Count-1 do
    begin
      if lbxFieldTarget.Selected[i]=False then Continue;
      x:=lbxFieldTarget.Items.Strings[i];
      lbxFieldTarget.Items.Delete(i);
      lbxFieldTarget.Items.Insert(i-1,x);
      lbxFieldTarget.Selected[i-1]:=True;
    end;
end;

procedure TForm5.sbMoveUpMouseEnter(Sender: TObject);
begin
  Application.HintHidePause:=5000;
  hint:='Move selected field up one step';
  showHint:=True;
end;

procedure TForm5.sbMoveDownClick(Sender: TObject);
Var
  i : Integer;
  x : String;
begin
  for i:=lbxFieldTarget.Count-1 downto 0 do
    begin
      if lbxFieldTarget.Selected[i] then
        begin
          x:=lbxFieldTarget.Items.Strings[i];
          lbxFieldTarget.items.Delete(i);
          if (i+1)>lbxFieldTarget.Items.Count then Break;          
          lbxFieldTarget.Items.Insert(i+1,x);
          lbxFieldTarget.Selected[i+1]:=True;
        end;
    end;
end;

procedure TForm5.sbMoveDownMouseEnter(Sender: TObject);
begin
  Application.HintHidePause:=5000;
  hint:='Move selected field down 1 step';
  showHint:=True;
end;

end.
