unit TM;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, ExtCtrls, Buttons, jpeg, StdCtrls, StrUtils, Types,Trpcb,
  ShellApi, ShlObj, ComObj;

type
  TForm6 = class(TForm)
    Image1: TImage;
    mm6: TMainMenu;
    tmFile: TMenuItem;
    tmSave: TMenuItem;
    TM: TMenuItem;
    Help1: TMenuItem;
    N1: TMenuItem;
    Exit2: TMenuItem;
    Create1: TMenuItem;
    miDeleteTemp: TMenuItem;
    Edit2: TMenuItem;
    AdHoc1: TMenuItem;
    ClearForm1: TMenuItem;
    Memo1: TMemo;
    lbxSource: TListBox;
    lbxTarget: TListBox;
    iUP: TImage;
    iDown: TImage;
    iDelete: TImage;
    AdHocFinished1: TMenuItem;
    Sort1: TMenuItem;
    Byfieldgroup1: TMenuItem;
    alphabetical1: TMenuItem;
    fieldnumber1: TMenuItem;
    lblSource: TLabel;
    lblTarget: TLabel;
    iRight: TImage;
    lbxScratch: TListBox;
    procedure Help1Click(Sender: TObject);
    procedure Edit2Click(Sender: TObject);
    procedure miDeleteTempClick(Sender: TObject);
    procedure tmSaveClick(Sender: TObject);
    procedure iDeleteClick(Sender: TObject);
    procedure AdHocFinished1Click(Sender: TObject);
    procedure iRightClick(Sender: TObject);
    procedure Create1Click(Sender: TObject);
    procedure fieldnumber1Click(Sender: TObject);
    procedure alphabetical1Click(Sender: TObject);
    procedure ByFieldGroup1Click(Sender: TObject);
    procedure AdHoc1Click(Sender: TObject);
    procedure ClearForm1Click(Sender: TObject);
    procedure Exit2Click(Sender: TObject);
    procedure split(const Delimiter: Char; Input: String; const Strings: TStrings);
    procedure VisInvis(Sender: TOBject);
    procedure iUpClick(Sender: TObject);
    procedure iDownClick(Sender: TObject);
    procedure getSortedFields(kind : String);
    procedure washLBX(Sender: TObject);
  private
  TMName     : String;
  TMSelf     : String;
  public
  TMCallerID : Integer;  //Used to ID the menu function being executed.
  end;

var
  Form6: TForm6;

implementation

{$R *.dfm}

uses bfp1, FieldList, OKCANCL2;

procedure TForm6.AdHoc1Click(Sender: TObject);
begin
  VisInvis(Self);
  with Form1 do
    begin
      RPCBroker1.ClearParameters:=True;
      RPCBroker1.ClearResults   :=True;
      RPCBroker1.RemoteProcedure:='VW REG FLD BY GRP';
      RPCBroker1.Param[0].Value:='';
      RPCBroker1.Param[0].PType:=literal;
      RPCBroker1.Call;
      lbxSource.Items:=RPCBroker1.Results;
    end;
end;

procedure TForm6.AdHocFinished1Click(Sender: TObject);
Var
  i : Integer;
  x : String;
begin
  TMCallerID:=0;
  if lbxTarget.count<1 then Exit;
  With Form1 do
    begin
      RPCBroker1.ClearParameters:=True;
      RPCBroker1.ClearResults   :=True;
      RPCBroker1.RemoteProcedure:='VW REG AHF';
      RPCBroker1.Param[0].Mult[IntToStr(0)]:=DFN;
      RPCBroker1.Param[0].PType :=list;
      for i:=0 to lbxTarget.Items.Count-1 do
        begin
          x:=lbxTarget.Items.Strings[i];
          RPCBroker1.Param[0].Mult[IntToStr(i+1)]:=x;
        end;
      RPCBroker1.Call;
      if RPCBroker1.Results.Count<1 then
        begin
          showMessage(' info not found');
          ClearForm1Click(Self);
        end;
      mData.Lines:=RPCBroker1.Results;
      GTF(Self);
      AutoSize:=True;
      SetFocus;
    end;
  VisInvis(Self);
  Close;
end;

procedure TForm6.alphabetical1Click(Sender: TObject);
begin
  getSortedFields('A');
end;

procedure TForm6.getSortedFields(kind : String);
begin
  lbxSource.Clear;
  //lbxTarget.Clear;
  With Form1 do
    begin
      RPCBroker1.ClearParameters:=True;
      RPCBroker1.ClearResults   :=True;
      RPCBroker1.RemoteProcedure:='VW REG FGNA';
      RPCBroker1.Param[0].Value :=kind;
      RPCBroker1.Param[0].PType :=literal;
      RPCBroker1.Call;
      lbxSource.Items:=RPCBroker1.Results;
    end;
  if lbxSource.Count<1 then showMessage('HEY! There ain''t'+' no items to sort'); Exit;
end;

procedure TForm6.Help1Click(Sender: TObject);
begin
//
end;

procedure TForm6.ByFieldGroup1Click(Sender: TObject);
begin
  getSortedFields('G');
end;

procedure TForm6.ClearForm1Click(Sender: TObject);
begin
  lbxSource.Clear;
  lbxTarget.Clear;
  VisInvis(Self);
end;

procedure TForm6.VisInvis(Sender: TOBject);
begin
  if lbxSource.Visible=True then lblSource.Visible:=False else lblSource.Visible:=True;
  if lblTarget.Visible=True then lblTarget.Visible:=False else lblTarget.Visible:=True;
  if lbxSource.Visible=True then lbxSource.Visible:=False else lbxSource.Visible:=True;
  if lbxTarget.Visible=True then lbxTarget.Visible:=False else lbxTarget.Visible:=True;
  if iUP.Visible=True then iUP.Visible:=False else iUP.Visible:=True;
  if iDown.Visible=True then iDown.Visible:=False else iDown.Visible:=True;
  if iDelete.Visible=True then iDelete.Visible:=False else iDelete.Visible:=True;
  if iRight.Visible=True then iRight.Visible:=False else iRight.Visible:=True;

end;

procedure TForm6.Create1Click(Sender: TObject);
begin
  mm6.Items[2].Enabled:=True;
  TMCallerID:=1;
  with Form1 do
    begin
      RPCBroker1.ClearParameters:=True;
      RPCBroker1.ClearResults   :=True;
      RPCBroker1.RemoteProcedure:='VW REG FLD BY GRP';
      RPCBroker1.Param[0].Value:='';
      RPCBroker1.Param[0].PType:=literal;
      RPCBroker1.Call;
      lbxSource.Items:=RPCBroker1.Results;
    end;
  VisInvis(Self);
end;

procedure TForm6.miDeleteTempClick(Sender: TObject);
begin
  tmCallerID:=3;
  With Form1 do
    begin
      RPCBRoker1.ClearParameters:=True;
      RPCBRoker1.ClearResults   :=True;
      RPCBroker1.RemoteProcedure:='VW REG RTF';
      RPCBroker1.Call;
      lbxTarget.Items:=RPCBroker1.Results;
    end;
  VisInvis(Self);
end;

procedure TForm6.Edit2Click(Sender: TObject);
begin
  TMCallerID:=2;
  with Form1 do
    begin
      RPCBroker1.ClearParameters:=True;
      RPCBRoker1.ClearResults   :=True;
      RPCBRoker1.RemoteProcedure:='VW REG RTF';
      RPCBroker1.Call;
      lbxSource.Items:=RPCBroker1.Results;
    end;
    VisInvis(Self);
end;

procedure TForm6.Exit2Click(Sender: TObject);
begin
  lbxSource.Clear;
  lbxTarget.Clear;
  Close;
end;

procedure TForm6.fieldnumber1Click(Sender: TObject);
begin
  getSortedFields('N');
end;

procedure TForm6.iRightClick(Sender: TObject);
Var
  i : Integer;
Label   tempEdit;
begin
  if TMCallerID=2 then GoTo tempEdit;
  for i:=0 to lbxSource.Count-1 do
    begin
      if lbxSource.Selected[i] then lbxTarget.Items.add(lbxSource.items.Strings[i]);
    end;
  Exit;
tempEdit:
  for i:=0 to lbxSource.Count-1 do
    begin
      if lbxSource.Selected[i] then TMName:=lbxSource.items.Strings[i];
    end;
  with Form1 do
    begin
      RPCBroker1.ClearResults   :=True;
      RPCBRoker1.ClearParameters:=True;
      RPCBroker1.RemoteProcedure:='VW REG EGF';
      RPCBroker1.Param[0].Value:=TMName;
      RPCBroker1.Param[0].PType:=literal;
      RPCBroker1.Call;
      lbxTarget.Items:=RPCBroker1.Results;
      {Get the field list for any wanted additions}
      lbxSource.Clear;
      RPCBroker1.ClearParameters:=True;
      RPCBroker1.ClearResults   :=True;
      RPCBroker1.RemoteProcedure:='VW REG FLD BY GRP';
      RPCBroker1.Param[0].Value:='';
      RPCBroker1.Param[0].PType:=literal;
      RPCBroker1.Call;
      lbxSource.Items:=RPCBroker1.Results;
    end;
end;

procedure TForm6.split(const Delimiter: Char; Input: string; const Strings: TStrings);
begin
   Assert(Assigned(Strings));
   Strings.Clear;
   Strings.StrictDelimiter:=True;
   Strings.Delimiter := Delimiter;
   Strings.DelimitedText := Input;
end;

procedure TForm6.washLBX(Sender: TObject);    {data laundering}
Var
  i : Integer;
begin
  lbxScratch.Clear;
  for i:=0 to lbxTarget.Count-1 do
    begin
      lbxScratch.Items.Add(lbxTarget.Items.Strings[i]);
    end;
  lbxTarget.Clear;
  for i:=0 to lbxScratch.Count-1 do
    begin
      lbxTarget.Items.Add(lbxScratch.Items.Strings[i]);
    end;
  lbxScratch.Clear
end;

procedure TForm6.tmSaveClick(Sender: TObject);
Var
  i : Integer;
  x : String;
  a : String;
  m : Integer;
LABEL   SANSDLG;
begin
  washLBX(Self);
  m:=0;
  case TMCallerID of
      1 : a:='Create';
      2 : a:='Edit';
      3 : a:='Delete';
  end;
  TMSelf:='';
  if Length(TMName)>0 then GoTo SANSDLG;
  if OKCANCL2.OKRightDlg.Execute then
    begin
      TMName:=OKRightDlg.eTMName.Text;
      if OKRightDlg.cbxSelf.Checked then TMSelf:='Self';
    end;
  if TMName='' then
    begin
      m:=messageDlg('Template not identified, no action taken',mtCustom,[mbOK],0);
      Exit;
    end;
SANSDLG:    
  with Form1 do
    begin
      RPCBroker1.ClearParameters:=True;
      RPCBroker1.ClearResults   :=True;
      RPCBroker1.RemoteProcedure:='VW REG TEMPLATE';
      RPCBroker1.Param[0].Mult['0']:=TMName+'^'+DUZ+'^'+a+'^'+TMSelf;
      for i:=0 to lbxTarget.Count-1 do
        begin
          x:=lbxTarget.Items.Strings[i];
          RPCBroker1.Param[0].Mult[IntToStr(i+1)]:=x;
        end;
      RPCBroker1.Param[0].PType:=list;
      RPCBroker1.Call;
    end;
  m:=messageDlg(Form1.RPCBroker1.Results.Strings[0],mtCustom,[mbOK],0);
  Close;
end;

function gp(x : String; const Delimiter: Char; piece : Integer) : String;  //Get Piece (gp)
Var
 A : TStringList;
 y : String;
begin
  if x='' then Exit;
  A := TStringList.Create;
  try
    Form6.split(Delimiter,x,A);
    y:=A[piece-1];
  finally
    A.Free;
  end;
  Result:=y;
end;

procedure TForm6.iUpClick(Sender: TObject);
Var
  i : Integer;
  x : String;
begin
  for i:=0 to lbxTarget.Items.Count-1 do
    begin
      if lbxTarget.Selected[i]=False then Continue;
      x:=lbxTarget.Items.Strings[i];
      lbxTarget.Items.Delete(i);
      lbxTarget.Items.Insert(i-1,x);
      lbxTarget.Selected[i-1]:=True;
    end;
end;

procedure TForm6.iDeleteClick(Sender: TObject);
Var
  i : Integer;
begin
  for i:=lbxTarget.items.Count-1 downto 0 do
    begin
      if lbxTarget.Selected[i] then
        begin
          if tmCallerID=3 then OkRightDlg.eTMName.Text:=lbxTarget.Items.Strings[i];
          lbxTarget.Items.Delete(i);
        end;
    end;
end;

procedure TForm6.iDownClick(Sender: TObject);
Var
  i : Integer;
  x : String;
begin
  for i:=lbxTarget.Count-1 downto 0 do
    begin
      if lbxTarget.Selected[i] then
        begin
          x:=lbxTarget.Items.Strings[i];
          lbxTarget.items.Delete(i);
          if (i+1)>lbxTarget.Items.Count then Break;
          lbxTarget.Items.Insert(i+1,x);
          lbxTarget.Selected[i+1]:=True;
        end;
    end;
end;

end.
