unit uMFI;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, jpeg, StdCtrls, Trpcb, {ShellLinker,} ShellApi, ShlObj, ComObj,
  ComCtrls, StrUtils, Winsock, Registry, ActiveX, CommCtrl, ToolWin, ExtCtrls,
  Grids, Buttons, Types;

type
  TForm4 = class(TForm)
    lbxLastEntry: TListBox;
    lblLE: TLabel;
    mMultfield: TMemo;
    sbAdd: TSpeedButton;
    sbCancel: TSpeedButton;
    sbFinished: TSpeedButton;
    sbHelp: TSpeedButton;
    lbxmMaster: TListBox;
    procedure sbHelpClick(Sender: TObject);
    procedure lbxLastEntryDblClick(Sender: TObject);
    procedure sbFinishedClick(Sender: TObject);
    procedure sbCancelClick(Sender: TObject);
    procedure sbAddClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure mGTF(Sender: TObject);
    procedure split(const Delimiter: Char; Input: String; const Strings: TStrings);
    procedure buildField(location:TWinControl; text:String; Label_Left,Label_Top, NumofComp:Integer; NameOwn: String;
                            Label_AutoSize, Label_FontBold, Label_Trans: Boolean; fValue:String; fHint:String; psF:String; fMult:Integer);
    procedure ColorText(Sender: TObject);
    procedure pointerFile(Sender: TObject);
    procedure reAssembly(dataInsert: String; memoLine: String);
  private
  public
    mxMaster:String;
  end;

  const
    MAX_TABS=4;
    TAB=#9;

var
  Form4: TForm4;

implementation

{$R *.dfm}

Uses bfp1, BFP_SelPt,uPointerRef;

function pieceCount(const x:String; const c: char) : Integer;
Var
  i : integer;
begin
  result:=0;
  for i := 0 to Length(x) do
    begin
      if x[i]=c then Inc(result);
    end;
end;

function gp(x : String; const Delimiter: Char; piece : Integer) : String;  //Get Piece (gp)
Var
 A : TStringList;
 y : String;
begin
  if x='' then Exit;
  A := TStringList.Create;
  try
    Form1.split(Delimiter,x,A);
    y:=A[piece-1];
  finally
    A.Free;
  end;
  Result:=y;
end;

function subdd(x:String) : String;
Var
  i : Integer;
begin
  Result:='';
  for i:= 0 to Form4.mMultfield.Lines.Count-1 do
    begin
      if gp(Form4.mMultfield.Lines.Strings[i],'^',1)=x then Break;
    end;
  Result:=gp(Form4.mMultfield.Lines.Strings[i],'^',2);
end;

procedure TForm4.sbAddClick(Sender: TObject);
Var
  i        : Integer;
  x,y,z,dd : String;
  C        : TComponent;
begin
  y:='';
  z:='';
  dd:='';
  for i:=0 to lbxmMaster.Items.Count-1 do
    begin
      x:=lbxmMaster.Items.Strings[i];
      C:=(FindComponent(x) as TComponent);
      if C is TLabel then
        begin
          z:=(C as Tlabel).Caption;
          z:=z+'('+subdd(z)+'):';
        end;
      if AnsiContainsStr(x,'e') then
        begin
          if (C is TEdit) AND (Length((C as TEdit).Text)>0) AND ((C as TEdit).Color=clSkyBlue) then y:=y+z+(C as TEdit).Text+'^'
          else if (C is TComboBox) AND ((C as TComboBox).Color=clSkyBlue) then y:=y+z+(C as TComboBox).Text+'^';
        end;
    end;
  lbxLastEntry.Items.Add(y);
  y:='';
  z:='';
  dd:='';
  for i:=0 to lbxmMaster.Items.Count-1 do
    begin
      x:=lbxmMaster.Items.Strings[i];
      C:=(FindComponent(x) as TComponent);
      C.Destroy;
    end;
  lbxmMaster.Clear;
  mGTF(Self);
end;

procedure TForm4.sbCancelClick(Sender: TObject);
Var
  i : Integer;
  x : String;
  C : TComponent;
begin
  for i:=0 to lbxmMaster.Items.Count-1 do
    begin
      x:=lbxmMaster.Items.Strings[i];
      C:=(FindComponent(x) as TComponent);
      //showMessage('x: '+x+#13#10+'C: '+C.Name);
      C.Destroy;
    end;
  mMultfield.Clear;
  lbxmMaster.Clear;
  Close;
end;

procedure TForm4.sbFinishedClick(Sender: TObject);
{ 1. loop lbxLastEntry
  2. add to Form1.mData at [multiples]}
Var
  i : Integer;
  x : String;
  C : TComponent;
LABEL Sayanara;
begin
  if lbxLastEntry.Items.Count=1 then GoTo Sayanara;
  //set i to where [New] is...
  for i:=0 to lbxLastEntry.Items.Count-1 do
    begin
      if AnsiContainsText(lbxLastEntry.Items.Strings[i],'[New') then Break
    end;
  Inc(i);
  for i:= i to lbxLastEntry.Items.Count-1 do
    begin
      x := lbxLastEntry.Items.Strings[i];
      Form1.mMults.Lines.Add(x);
    end;
Sayanara:
 for i:=0 to lbxmMaster.Items.Count-1 do
   begin
     x:=lbxmMaster.Items.Strings[i];
     C:=(FindComponent(x) as TComponent);
     C.Destroy;
   end;
 lbxLastEntry.Clear;
 lbxmMaster.Clear;
 Close;
end;

procedure TForm4.split(const Delimiter: Char; Input: string; const Strings: TStrings);
begin
   Assert(Assigned(Strings));
   Strings.Clear;
   Strings.StrictDelimiter:=True;  //Use to specify "use only" delimiter listed in argument
   Strings.Delimiter := Delimiter;
   Strings.DelimitedText := Input;
end;

procedure TForm4.ColorText(Sender: TObject);
Var
  x : String;
begin
  if Sender is TEdit then
     begin
       x:=TEdit(Sender).Text;
       x:=AnsiUpperCase(x);
       if (x='MIDNIGHT') OR (x='NOON') then TEdit(Sender).Text:='';
       if TEdit(Sender).Text='' then TEdit(Sender).Color:=clWhite else TEdit(Sender).Color:=clSkyBlue;
     end;
   if Sender is TComboBox then
     begin
       if TComboBox(Sender).Text='' then TComboBox(Sender).Color:=clWhite else TComboBox(Sender).Color:=clSkyBlue;
     end;
end;

procedure TForm4.FormShow(Sender: TObject);
Var
  i : Integer;
  x,y : String;
  Tabulators: array[0..MAX_TABS] of Integer;
begin
 //mMultfield.Visible:=True;
 lbxLastEntry.Clear;
 Application.HintHidePause:=50000;
 Tabulators[0]:=400;
 Tabulators[1]:=125;
 Tabulators[2]:=50;
 Tabulators[3]:=100;
 mGTF(Self);
 with Form1 do
   begin
     RPCBRoker1.ClearParameters:=True;
     RPCBroker1.ClearResults   :=True;
     RPCBroker1.RemoteProcedure:='VW REG GPDM';
     RPCBroker1.Param[0].Value:=mfCaller+'^'+DFN;
     RPCBroker1.Param[0].PType:=literal;
     RPCBroker1.Call;
     //if RPCBroker1.Results.Count>0 then lbxLastEntry.Columns:=pieceCount(RPCBroker1.Results.Strings[0],'^');
     for i:=0 to RPCBroker1.Results.Count-1 do
       begin
         x:=RPCBroker1.Results.Strings[i];
         y:=gp(x,'^',3);
         lbxLastEntry.Items.Add(y+TAB+gp(x,'^',4)+TAB+gp(x,'^',1));
       end;
   end;
 lbxLastEntry.Items.Append('[New]');
end;

procedure TForm4.lbxLastEntryDblClick(Sender: TObject);
begin
  showMessage(Form1.selTemplate);
end;

procedure TForm4.pointerFile(Sender: TOBject);  //Save
Var
  cName,eLbl,cText,xStr,xLine,PF : String;
  xLen : Integer;
begin
  //Get file values, set up dialoge - maybe use a local list box on this form?    lbx didn't format correctly on reslection
  if Sender is TEdit then cName:=(Sender as TEdit).Name;cText:=(Sender as TEdit).Text;
  elbl:=cName;
  mxMaster:=cName;
  xLen:=Length(cName);
  xStr:=Copy(cName,5,xLen);
  xLine:=mMultfield.Lines.Strings[StrToInt(xStr)];
  if gp(xLine,'^',5)='' then Exit;
  PF:=gp(xLine,'^',5);
  Form1.fCaller:=4;
  with Form1 do
  begin
    RPCBroker1.ClearParameters:=True;
    RPCBroker1.ClearResults   :=True;
    RPCBroker1.RemoteProcedure:='VW REG PF';
    RPCBroker1.Param[0].Value :=PF;
    RPCBroker1.Param[0].PType :=literal;
    RPCBroker1.Call;
    Form3.lbxReference.Items:=RPCBroker1.Results;
  end;
  Form3.Top:=Form4.Top+50;
  Form3.Left:=Form4.Left+Form1.Width-250;
  Form3.Show;
end;

procedure TForm4.mGTF(Sender : TObject);
Var
  mi     : Integer;
  mx     : String;
  mfList : Array of String;
  meList : Array of String;
  marLen : Integer;  //mData Array length
  mfName,mfNum,mfVal,mfHelp,mfPSF: String;
  mstartTop,mfMult:Integer;
begin
  mfList:=nil;
  meList:=nil;
  mfMult:=0;
  mstartTop:=30;
  marLen :=mMultfield.Lines.Count;
  setLength(mfList,marLen);  //Labels
  setLength(meList,marLen);  //Edit/Combobox fields
  for mi:=0 to mMultfield.Lines.Count-1 do
    begin
      mx := mMultfield.Lines.Strings[mi];
      mfName:=gp(mx,'^',1);
      mfNum :=gp(mx,'^',2);
      mfVal :=gp(mx,'^',3);
      mfhelp:=gp(mx,'^',4);
      mfPSF :=gp(mx,'^',5);
      mfList[mi]:='lbl'+IntToStr(mi);
      meList[mi]:='e'+IntToStr(mi);
      mfHelp:=AnsiReplaceStr(mfHelp,'$C(13,10)',''+#13#10+'');
      mfHelp:=WrapText(mfHelp,65);
      //mfMult:=StrToInt(gp(mx,'^',6));
      buildField(Form4,mfName,8,mstartTop,mi,'lbl',False,False,False,mfVal,mfHelp,mfPSF,mfMult);
      mstartTop:=mstartTop+19;
    end;
end;

procedure TForm4.buildField(location:TWinControl; text:String; Label_Left,Label_Top, NumofComp:Integer; NameOwn: String;
                            Label_AutoSize, Label_FontBold, Label_Trans: Boolean; fValue:String; fHint:String; psF:String; fMult:Integer);  //Save
Var
  mlocLabel  : TLabel;
  mlocEdit   : TEdit;
  mlocCBox   : TComboBox;
  //StartTop  : Integer;
  i,xPC     : Integer;
  y,z     : String;
begin
  //StartTop :=8;
  mlocLabel:=TLabel.Create(location);
  mlocLabel.Name:=NameOwn+IntToStr(NumofComp);
  mlocLabel.Parent:=location;
  mlocLabel.Caption:=text;
  mlocLabel.AutoSize:=Label_AutoSize;
  mlocLabel.Transparent:=label_Trans;
  mlocLabel.Font.Size:=8;
  mlocLabel.Font.Name:='Verdana';
  mlocLabel.Top:=label_Top;
  mlocLabel.Left:=Label_Left;
  mlocLabel.Width:=175;
  mlocLabel.Alignment:=taRightJustify;
  mlocLabel.Visible:=True;
  lbxmMaster.Items.Add(mlocLabel.Name);
  if AnsiContainsStr(pSF,':') OR (AnsiContainsStr(pSF,'M')) then    //Set of codes in ^5
   begin
     mlocCBox:=TComboBox.Create(location);
     mlocCBox.Font.Name:=mlocLabel.Font.Name;
     mlocCBox.Font.Size:=mlocLabel.Font.Size;
     mlocCBox.Font.Color:=clBlack;
     mlocCBox.Parent:=location;
     mlocCBox.Name:='e'+NameOwn+IntToStr(NumofComp);
     mlocCBox.Top:=mlocLabel.Top-3;
     mlocCBox.Width:=200;
     mlocCBox.Left:=mlocLabel.Width+15;
     mlocCBox.ItemIndex:=0;
     mlocCBox.Hint:=fHint;
     mlocCBox.ShowHint:=True;
     mlocCBox.onChange:=colorText;
     mlocCBox.Text:=fValue;
     mlocCBox.Visible:=True;
     xPC:=pieceCount(psF,';');
     for i := 1 to xPC do
       begin
         y:=gp(pSF,';',i);
         z:=gp(y,':',2);
         mlocCBox.Items.Add(z);
       end;
     lbxmMaster.Items.Add(mlocCBox.Name);
   end
  else if AnsiContainsStr(psF,'W') then
       begin
         //Word process in fValue - make a small memo pad
       end
  else
    begin
      mlocEdit:=TEdit.Create(location);
      mlocEdit.Parent:=location;
      mlocEdit.Name:='e'+NameOwn+IntToStr(NumofComp);
      mlocEdit.Top:=mlocLabel.top-2;
      mlocEdit.Width:=200;
      mlocEdit.Left:=mlocLabel.Width+15;
      mlocEdit.Text:=fValue;
      mlocEdit.Font:=mlocLabel.Font;
      mlocEdit.Font.Size:=mLocLabel.Font.Size;
      mlocEdit.Font.Color:=clBlack;
      mlocEdit.Visible:=True;
      if AnsiContainsStr(psF,'(') then mlocEdit.OnEnter:=Form4.pointerFile;
      //if fMult>0 then mlocEEdit.OnEnter:=multipleField;
      //if AnsiContainsStr(mlocELabel.Caption,'INSURANCE') then mlocEEdit.OnEnter:=insurForm;
      //if AnsiContainsStr(mlocELabel.Caption,'POSTAL') OR (AnsiContainsStr(mlocELabel.Caption,'ZIP')) then mlocEEdit.OnExit:=fieldExit;
      mlocEdit.OnChange:=colorText;
      mlocEdit.Hint:=fHint;
      mlocEdit.ShowHint:=True;
      lbxmMaster.Items.Add(mlocEdit.Name);
    end;
end;

procedure TForm4.reAssembly(dataInsert: String; memoLine: String);
Var
  x : String;
begin
  x:='';
  x:=gp(memoLine,'^',1)+'^';
  x:=x+gp(memoLine,'^',2)+'^';
  x:=x+dataInsert+'^';
  x:=x+'^'+gp(memoLine,'^',5);
  Form1.mData.Lines.Add(x);
end;

procedure TForm4.sbHelpClick(Sender: TObject);
Var
  x : String;
begin
  x:='file:///c:/VWREG/BFPLLC_VW_Help.html/?name=%22Mult%22';
  ShellExecute(self.WindowHandle,'open',PChar(x),nil,nil, SW_SHOWNORMAL);
end;

end.
