unit BFP_SelPt;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StrUtils, StdCtrls, ExtCtrls, jpeg, Buttons, Menus, Trpcb;

type
  TForm2 = class(TForm)
    rgSelPtBy: TRadioGroup;
    rbName: TRadioButton;
    rbIDHRN: TRadioButton;
    rbPhone: TRadioButton;
    rbDOB: TRadioButton;
    iGoPtSel: TImage;
    sbA: TSpeedButton;
    sbC: TSpeedButton;
    sbB: TSpeedButton;
    eName: TEdit;
    lbClients: TListBox;
    eIDHRN: TEdit;
    eDOB: TEdit;
    ePhone: TEdit;
    sbD: TSpeedButton;
    sbE: TSpeedButton;
    sbF: TSpeedButton;
    sbG: TSpeedButton;
    sbH: TSpeedButton;
    sbI: TSpeedButton;
    sbJ: TSpeedButton;
    sbK: TSpeedButton;
    sbL: TSpeedButton;
    sbM: TSpeedButton;
    sbN: TSpeedButton;
    sbO: TSpeedButton;
    sbP: TSpeedButton;
    sbQ: TSpeedButton;
    sbR: TSpeedButton;
    sbS: TSpeedButton;
    sbT: TSpeedButton;
    sbU: TSpeedButton;
    sbV: TSpeedButton;
    sbW: TSpeedButton;
    sbX: TSpeedButton;
    sbY: TSpeedButton;
    sbZ: TSpeedButton;
    MainMenu1: TMainMenu;
    cANCEL1: TMenuItem;
    Clear1: TMenuItem;
    rbSB: TRadioButton;
    procedure rbSBMouseEnter(Sender: TObject);
    procedure rbSBClick(Sender: TObject);
    procedure eDOBEnter(Sender: TObject);
    procedure rbPhoneClick(Sender: TObject);
    procedure rbDOBClick(Sender: TObject);
    procedure rbNameClick(Sender: TObject);
    procedure rbIDHRNClick(Sender: TObject);
    procedure ePhoneMouseEnter(Sender: TObject);
    procedure eDOBMouseEnter(Sender: TObject);
    procedure eNameMouseEnter(Sender: TObject);
    procedure eIDHRNMouseEnter(Sender: TObject);
    procedure Clear1Click(Sender: TObject);
    procedure lbClientsDblClick(Sender: TObject);
    procedure Find1Click(Sender: TObject);
    procedure cANCEL1Click(Sender: TObject);
    procedure eIDHRNEnter(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure eNameEnter(Sender: TObject);
    procedure iGoPtSelClick(Sender: TObject);
    procedure AlphaList(Sender: TObject);
  private
    IDHRN, IDNAME, IDDOB, IDPHONE : Integer;
  public
    callerID : Integer;

  end;

  Const
    MAX_TABS=4;
    TAB=#9;

var
  Form2: TForm2;

implementation

{$R *.dfm}

uses bfp1;

procedure TForm2.CANCEL1Click(Sender: TObject);
begin
  Close();
end;

procedure TForm2.Clear1Click(Sender: TObject);
begin
  //Clear the radio buttons, fields and listbox
  rbIDHRN.Checked:=False;
  rbName.Checked:=False;
  rbDOB.Checked:=False;
  rbPhone.Checked:=False;
  eIDHRN.Text:='<ID/HRN>'; eIDHRN.Font.Color:=clSilver;
  eName.Text :='<Lastname,[first MI Title]>'; eName.Font.Color:=clSilver;
  eDOB.Text  :='<MMM DD,YYYY@ TIME>'; eDOB.Font.Color:=clSilver;
  ePhone.text:='<NNN-NNN-NNNN>'; ePhone.Font.Color:=clSilver;
  lbClients.Clear;lbClients.Items.add('ID/HRN'+TAB+'CLIENT'+TAB+'DATE OF BIRTH@TIME'+TAB+'PHONE');
end;

procedure TForm2.eDOBEnter(Sender: TObject);
begin
  callerID:=3;
  eDOB.Font.Color:=clBlue;
  eDOB.Text:='';
end;

procedure TForm2.eDOBMouseEnter(Sender: TObject);
Var
  x : String;
begin
  Application.HintHidePause:=30000;
  x:='Enter the patient`s DATE OF BIRTH which must be later than 12/31/1870.';
  x:=x+' You may enter date of birth and optional time numerically DD/MM/YYYY@NN:NN';
  x:=x+'Or, you may enter the common means MMM DD, YYYY optionally @ NN:NN. You may';
  x:=x+' also enter a partial date as YYYY or MM/YYYY, etc.';
  eDOB.hint:=WrapText(x,55);
  eDOB.ShowHint:=True;
end;

procedure TForm2.eIDHRNEnter(Sender: TObject);
begin
  eIDHRN.Font.Color:=clBlack;
end;

procedure TForm2.eIDHRNMouseEnter(Sender: TObject);
Var
  x : String;
begin
  Application.HintHidePause:=20000;
  x:='National ID?,'+#13#10+'Medical(Health) Record Number?,'+#13#10+'Policy number?';
  eIDHRN.Hint:=x;
  eIDHRN.ShowHint:=True;
end;

procedure TForm2.eNameEnter(Sender: TObject);
begin
   ename.Font.Color:=clBlack;
end;

procedure TForm2.eNameMouseEnter(Sender: TObject);
Var
  x : String;
begin
  Application.HintHidePause:=50000;
  x:='Enter the patient`s name in "LAST,FIRST MIDDLE SUFFIX" format. This value must be 3-30 characters in';
  x:=x+'length and may contain only uppercase alpha characters, spaces, apostrophes, hyphens and one comma.';
  x:=x+'All other characters and parenthetical text will be removed.';
  x:=WrapText(x,50);
  eName.Hint:=x;
  eName.ShowHint:=True;
  end;

procedure TForm2.ePhoneMouseEnter(Sender: TObject);
Var
  x : String;
begin
  Application.HintHidePause:=30000;
  x:='Enter the telephone number [4-20 characters] to this applicant`s place of residence.';
  x:=x+'Entry may be NNNNNNNNNN or NNN-NNN-NNNN or NNN NNN NNNN, etc';
  ePhone.Hint:=WrapText(x,55);
  ePhone.ShowHint:=True;
end;

procedure TForm2.Find1Click(Sender: TObject);
begin
  //code to find text in the listbox lbClients
end;

procedure TForm2.AlphaList(Sender: TOBject);
Var
  i : Integer;
  x : String;
begin
  //showMessage((Sender as TSpeedButton).Caption);
  lbClients.Clear;
  lbClients.Items.add('ID/HRN'+TAB+'CLIENT'+TAB+'DATE OF BIRTH@TIME'+TAB+'PHONE');
  With Form1 do
    begin
      RPCBroker1.ClearParameters:=True;
      RPCBroker1.ClearResults   :=True;
      RPCBroker1.RemoteProcedure:='VW REG ALIST';
      RPCBroker1.Param[0].Value:=(Sender as TSpeedButton).Caption;
      RPCBroker1.Param[0].PType:=literal;
      RPCBroker1.Param[1].Value:='';
      RPCBroker1.Param[2].PType:=literal;
      RPCBroker1.Call;
      for i:=0 to RPCBroker1.Results.Count-1 do
        begin
          x:=RPCBroker1.Results.Strings[i];
          x:=AnsiReplaceStr(x,'^',TAB);
          Form2.lbClients.Items.Add(x);
        end;
    end;
end;

procedure TForm2.FormCreate(Sender: TObject);
Var
  Tabulators: array[0..MAX_TABS] of Integer;
begin
  Tabulators[0]:=80;
  Tabulators[1]:=200;
  Tabulators[2]:=300;
  Tabulators[3]:=100;
  lbClients.TabWidth:=1;
  SendMessage(lbClients.Handle, LB_SETTABSTOPS, MAX_TABS, Longint(@Tabulators));
  lbClients.Items.add('ID/HRN'+TAB+'CLIENT'+TAB+'DATE OF BIRTH@TIME'+TAB+'PHONE');
  //lbClients.Items.Add('44 55 9878 12345'+TAB+'Winningstadt,Winnifried X'+TAB+'Mar 29, 1947 @ 12:31'+TAB+'503-775-5767');
  lbClients.Visible:=True;
  left:=Form1.Left+Form1.Width+200;
  Top :=Form1.Top+Form1.Height-400;
  IDHRN:=0;IDNAME:=0;IDDOB:=0;IDPHONE:=0;
end;

procedure TForm2.iGoPtSelClick(Sender: TObject);
Var
  x : String;
  i : Integer;
begin
  case callerID of
    1 : x:='1:'+eIDHRN.Text+'^^^';
    2 : x:='2:^'+eName.Text+'^^';
    3 : x:='3:^^'+eDOB.Text+'^';
    4 : x:='4:^^^'+ePHONE.Text;
    5 : x:='5: ^ ^ ^ ';  //Space-bar Fileman function
  end;
  With Form1 do
    begin
      RPCBRoker1.ClearParameters:=True;
      RPCBroker1.ClearResults   :=True;
      RPCBroker1.RemoteProcedure:='VW REG ALIST';
      RPCBroker1.Param[0].Value:='';
      RPCBroker1.Param[0].PType:=literal;
      RPCBroker1.Param[1].Value:=x;
      RPCBroker1.Param[1].PType:=literal;
      RPCBroker1.Call;
      if RPCBroker1.Results.Count=1 then
        begin
          Form1.clientStr:=RPCBroker1.Results.Strings[0];
          Form2.Clear1Click(Self);
          Form2.Close;
        end
      else if RPCBroker1.Results.Count>1 then
        begin
          for i:=0 to RPCBroker1.Results.Count-1 do
            begin
              x:=RPCBroker1.Results.Strings[i];
              x:=AnsiReplaceStr(x,'^',TAB);
              Form2.lbClients.Items.Add(x);
            end;
        end;
    end;
end;

procedure TForm2.lbClientsDblClick(Sender: TObject);
Var
  i : Integer;
begin
  for i:=0 to lbClients.Items.Count-1 do
    begin
      //if lbClients.Selected[i] then showMessage(lbClients.Items.Strings[i]);
      if lbClients.Selected[i] then Form1.clientStr:=lbClients.Items.Strings[i];
    end;
  Clear1Click(Self);
  Close;
end;

procedure TForm2.rbSBClick(Sender: TObject);
begin
  //Send a space-bar (e.g., ' ') to the server; returns last patient dealt with
  eName.SetFocus;
  callerID:=5;
  iGoPtSelClick(Self);
end;

procedure TForm2.rbSBMouseEnter(Sender: TObject);
begin
  Application.HintHidePause:= 100000;
  hint:='Press to access the last patient you were dealing with.';
  showHint:=True;
end;

procedure TForm2.rbDOBClick(Sender: TObject);
begin
 eDOB.SetFocus;
 callerID:=3;
end;

procedure TForm2.rbIDHRNClick(Sender: TObject);
begin
  eIDHRN.SetFocus;
  callerID:=1;
end;

procedure TForm2.rbNameClick(Sender: TObject);
begin
 eName.SetFocus;
 callerID:=2;
end;

procedure TForm2.rbPhoneClick(Sender: TObject);
begin
 ePhone.SetFocus;
 callerID:=4;
end;

end.
