unit InsuranceForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Trpcb, Menus, ExtCtrls, StrUtils, jpeg;

type
  TForm7 = class(TForm)
    lblInsurCo: TLabel;
    lblTypePlan: TLabel;
    cbxPlanType: TComboBox;
    Label3: TLabel;
    Label4: TLabel;
    ePolicy: TEdit;
    MainMenu1: TMainMenu;
    Finished1: TMenuItem;
    Cancel1: TMenuItem;
    Label1: TLabel;
    eEffDate: TEdit;
    Label2: TLabel;
    eExpDate: TEdit;
    Label5: TLabel;
    cbxTOC: TComboBox;
    cbxInsCo: TComboBox;
    lblEmployer: TLabel;
    eEmployer: TEdit;
    lblBillAddr: TLabel;
    eBillAddr: TEdit;
    lblBillAddr2: TLabel;
    eBillAddr2: TEdit;
    lblBillAddrCity: TLabel;
    eBillCity: TEdit;
    lblCntyProv: TLabel;
    eCntyProv: TEdit;
    lblBillState: TLabel;
    lblPostalCode: TLabel;
    eBillPostalC: TEdit;
    iZipGo: TImage;
    cbxBillState: TComboBox;
    rbGrpPolicyYes: TRadioButton;
    rbGrpPolicyNo: TRadioButton;
    eGrpPolicy: TEdit;
    Label6: TLabel;
    cbxGuarantor: TComboBox;
    Label7: TLabel;
    cbGSOFYes: TCheckBox;
    cbGSOFNo: TCheckBox;
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure Cancel1Click(Sender: TObject);
    procedure Finished1Click(Sender: TObject);
    procedure rbGrpPolicyNoClick(Sender: TObject);
    procedure rbGrpPolicyYesClick(Sender: TObject);
    procedure iZipGoClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure split(const Delimiter: Char; Input: string; const Strings: TStrings);
    procedure cbCheckYes(Sender: TObject);
    procedure cbCheckNo(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form7: TForm7;

implementation

{$R *.dfm}

uses bfp1 ;

procedure TForm7.split(const Delimiter: Char; Input: string; const Strings: TStrings);
begin
   Assert(Assigned(Strings));
   Strings.Clear;
   Strings.StrictDelimiter:=True;  //Use to specify "use only" delimiter listed in argument
   Strings.Delimiter := Delimiter;
   Strings.DelimitedText := Input;
end;

function gp(x : String; const Delimiter: Char; piece : Integer) : String;
Var
 A : TStringList;
 y : String;
begin
  if x='' then Exit;
  A := TStringList.Create;
  try
    Form7.split(Delimiter,x,A);
    y:=A[piece-1];
  finally
    A.Free;
  end;
  Result:=y;
end;

procedure TForm7.Cancel1Click(Sender: TObject);
begin
 Close;
end;

procedure TForm7.Finished1Click(Sender: TObject);
Var
  bd : Integer;
begin
  with Form1.mMults.Lines do
    begin
      Add('[Insurance]');
      Add('InsCo^2.312;.01^'+cbxInsCo.Text+'^^DIC(36,^0');
      Add('GrpPlan^2.312;.18^'+eGrpPolicy.Text+'^^IBA(355.3,^0');
      Add('Policy#^2.312;1^'+ePolicy.Text+'^^^0');
      Add('PlanType^^'+cbxPlanType.Text);
      Add('TypeCov^IBE(355.33;40.09^'+cbxTOC.Text+'^^IBA(355.3,^0');
      Add('EffDate^2.312;8^'+eEffDate.Text+'^^^0');
      Add('ExpDate^^'+eExpDate.Text+'^^^0');
      if cbGSOFYes.Checked then Add('SigonFile^Yes') else if NOT(cbGSOFNo.Checked) then add('SigonFile^No') else Add('SigonFile^^');
      Add('Employer^2.312;2.015^'+eEmployer.Text+'^^^0');
      Add('BillingAddr^2.312;.02^'+eBillAddr.Text+'^^^0');
      Add('BillAddr2^2.312;.03^'+eBillAddr2.Text+'^^^0');
      Add('BillPostalCode^2.312;.07^'+eBillPostalC.Text+'^^^0');
      Add('BillCity^2.312;.05^'+eBillCity.Text+'^^^');
      Add('BillCntyProv^^'+eCntyProv.Text+'^^^0');
      Add('BillState^2.312;.06^'+cbxBillState.Text+'^^DIC(5,^0');
      Add('[EndInsurance]');
    end;
  bd:=messageDlg('Add another Insurance company + data?',mtCustom,[mbYes,mbNo],0);
  if bd=mrYes then
    begin
      cbxInsCo.Text:='';
      eGrpPolicy.Text:='';
      ePolicy.Text:='';
      cbxPlanType.Text:='';
      cbxTOC.Text:='';
      eEffDate.Text:='';
      eExpDate.Text:='';
      cbGSOFYes.Checked:=False;
      eEmployer.Text:='';
      eBillAddr.Text:='';
      eBillAddr2.Text:='';
      eBillPostalC.Text:='';
      eBillCity.Text:='';
      eCntyProv.Text:='';
      cbxBillState.Text:='';
    end;
  if bd=mrNo then Form7.Close;
end;

procedure TForm7.FormCreate(Sender: TObject);
Var
  x   : String;
  i,j : Integer;
begin
  {Get
    Insurance Company_____^DIC(36
    Type of Plan__________^IBE(355.1,
    Type of Insurance_____^IBE(355.2,
    Group Plan____________^IBE(355.3, <- REMOVED - circular pointer to the insurance file
    Country_______________^HL(779.004,
  }
  cbxInsCo.Clear;
  cbxPlanType.Clear;
  cbxTOC.Clear;
  cbxGuarantor.Clear;
  with Form1 do
    begin
      RPCBroker1.ClearParameters:=True;
      RPCBroker1.ClearResults   :=True;
      RPCBroker1.RemoteProcedure:='VW REG MISC';
      RPCBroker1.Param[0].Value :='36;355.1;355.2;5^INS';  {Removed Country Code from Insurance Form: 779.004}
      RPCBroker1.Param[0].PType :=literal;
      RPCBroker1.Call;
      if RPCBroker1.Results.Count>0 then
        begin
          for i:=1 to RPCBroker1.Results.Count-1 do  //Insurance Companies
            begin
              x := RPCBroker1.Results.Strings[i];
              if AnsiContainsStr(x,'PLAN]') then Break;
              cbxInsCo.Items.Add(x);
            end;
          //cbxPlanType.Text:=RPCBroker1.Results.Strings[0];
          j:=i+1;
          for i:=j to RPCBroker1.Results.Count-1 do  //Type of Plan
            begin
              x := RPCBroker1.Results.Strings[i];
              if AnsiContainsStr(x,'COVERAGE]') then Break;
              cbxPlanType.Items.Add(x);
            end;
          j:=i+1;
          //cbxTOC.Text:=RPCBroker1.Results.Strings[i];
          for i:=j to RPCBroker1.Results.Count-1 do   //Type of Converage
            begin
              x := RPCBRoker1.Results.Strings[i];
              if AnsiContainsStr(x,'STATE]') then Break;
              cbxTOC.Items.Add(x);
            end;
          j:=i+1;
          for i:=j to RPCBroker1.Results.Count-1 do
            begin
              x := RPCBroker1.Results.Strings[i];
              if AnsiContainsStr(x,'GUARANTOR]') then Break;
              cbxBillState.Items.Add(x);
            end;
          j:=i+1;
          for i:=j to RPCBroker1.Results.Count-1 do
            begin
              x := RPCBroker1.Results.Strings[i];
              if AnsiContainsStr(x,'()') then Break;
              cbxGuarantor.Items.Add(x);
            end;
        end;
    end;
  Top:=Form1.Top+250;
  Left:=Form1.Left+Form1.Width+10;
  AutoSize:=True;
end;

procedure TForm7.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if (key=#27) then
    begin
      //Form1.ESCex:=1;
      Cancel1Click(Self);
    end;
end;

procedure TForm7.iZipGoClick(Sender: TObject);
Var
  x : String;
  i : Integer;
begin
  with Form1 do
    begin
      RPCBroker1.ClearParameters:=True;
      RPCBroker1.ClearResults   :=True;
      RPCBroker1.RemoteProcedure:='VW REG ZIP';
      RPCBroker1.Param[0].Value :=Form7.eBillPostalC.Text;
      RPCBroker1.Param[0].PType :=literal;
      RPCBroker1.Call;
      for i:=0 to RPCBroker1.Results.Count-1 do
        begin
          x:=RPCBroker1.Results.Strings[i];
          case i of
            0 : Form7.cbxBillState.Text:=x;
            1 : Form7.eCntyProv.Text:=x;
            2 : Form7.eBillCity.Text:=x;
          end;
        end;
    end;
  AutoSize:=True;
end;

procedure TForm7.rbGrpPolicyNoClick(Sender: TObject);
begin
  if rbGrpPolicyNo.Checked then eGrpPolicy.Enabled:=False;eGrpPolicy.Color:=clScrollBar;
end;

procedure TForm7.rbGrpPolicyYesClick(Sender: TObject);
begin
  if rbGrpPolicyYes.Checked then
    begin
      eGrpPolicy.Enabled:=True;
      eGrpPolicy.Color:=clWhite;
      eGrpPolicy.SetFocus;
    end;
end;

procedure TForm7.cbCheckYes(Sender: TObject);
begin
  if cbGSOFYes.Checked then cbGSOFNo.Checked:=False;
end;

procedure TForm7.cbCheckNo(Sender: TObject);
begin
  if cbGSOFNo.Checked then cbGSOFYes.Checked:=False;
end;

end.
