unit bfp1;
{Saved code for reference use---------------------------------------------------------------------------
                                                                                                                                  
---------------------------------------------------------------------------------------------------------
}
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, jpeg, StdCtrls, Trpcb, {IOUtils, ShellLinker,} ShellApi, ShlObj, ComObj,
  ComCtrls, StrUtils, Winsock, Registry, ActiveX, CommCtrl, ToolWin, ExtCtrls,
  Grids, Buttons, Types;

type
  TForm1 = class(TForm)
    RPCBroker1: TRPCBroker;
    MainMenu1: TMainMenu;
    Clear1: TMenuItem;
    Exit1: TMenuItem;
    Forms1: TMenuItem;
    N1: TMenuItem;
    Help1: TMenuItem;
    SelectPt1: TMenuItem;
    Save1: TMenuItem;
    mData: TMemo;
    masterLB: TListBox;
    N2: TMenuItem;
    Utilities1: TMenuItem;
    mMults: TMemo;
    templateUsersUtility1: TMenuItem;
    RefreshFormsmenu1: TMenuItem;
    procedure Utilities1Click(Sender: TObject);
    procedure Help1Click(Sender: TObject);
    procedure AddEditaTemplate1Click(Sender: TObject);
    procedure AdHocFieldList1Click(Sender: TObject);
    procedure FormClick(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Clear1Click(Sender: TObject);
    procedure SelectPt1Click(Sender: TObject);
    procedure NewPtClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure split(const Delimiter: Char; Input: string; const Strings: TStrings);
    procedure ColorText(Sender: TObject);
    procedure GTF(Sender : TObject);
    procedure buildField(location:TWinControl; text:String; Label_Left,Label_Top, NumofComp:Integer; NameOwn: String;
                            Label_AutoSize, Label_FontBold, Label_Trans: Boolean; fValue:String; fHint:String; psF:String; fMult:Integer);
    procedure pointerFile(Sender: TOBject);
    procedure multipleField(Sender: TOBject);
    procedure insurForm(Sender: TOBject);
    procedure goingPostal(pcode: String; fLoc: String);
    procedure fieldExit(Sender: TOBject);
    procedure refreshForms(Sender: TObject);
  private
    FormsCount   : Integer;
  public
    ImIn         : Integer;
    mgr          : Integer;
    DefaultState : String;
    selTemplate  : String;
    defTemplate  : String;
    homeDir      : String;
    clientStr    : String;
    DFN          : String;
    DUZ          : String;
    xMaster      : String;
    fCaller      : Integer;
    mfCaller     : String;
    componentName: String;
  end;

  type
    TExHint = class(THintWindow)
    constructor Create(AOwner: TComponent); override;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses BFP_SelPt, upointerRef, uMFI, FieldList, TM, InsuranceForm;

constructor TExHint.Create(AOwner: TComponent); //Customize size of roll-over hints
begin
  inherited Create(AOwner);
  with Canvas.Font do
  begin
    Name  := 'Courier New';
    //Size  := Size + 2; //removed as Verdana default size is good as is
    //Style := [fsItalic];
  end;
end;

function pieceCount(const x:String; const c: char) : Integer;
Var
  i : integer;
begin
  result:=0;
  for i := 0 to Length(x) do
    begin
      if x[i]=c then Inc(result);
    end;
end;

function GetShortcutTarget(ShortcutFilename:string):string;
var
  Psl:IShellLink;
  Ppf:IPersistFile;
  WideName:Array [0..MAX_PATH] of WideChar;
  pResult:Array [0..MAX_PATH-1] Of Char;
  Data:TWin32FindData;
const
IID_IPersistFile: TGUID = (D1:$0000010B; D2:$0000; D3:$0000; D4:($C0,$00,$00,$00,$00,$00,$00,$46));
begin
  CoCreateInstance(CLSID_ShellLink,nil,CLSCTX_INPROC_SERVER, IID_IShellLinkA ,psl);
  psl.QueryInterface(IID_IPersistFile,Ppf);
  MultiByteToWideChar(CP_ACP, 0, pChar(ShortcutFilename), -1, WideName, Max_Path);
  ppf.Load(WideName,STGM_READ);
  psl.Resolve(0,SLR_ANY_MATCH);
  psl.GetPath(@pResult,MAX_PATH,Data,SLGP_UNCPRIORITY);
  psl.GetArguments(@pResult,MAX_PATH);
  Result:=StrPas(@pResult);
end;

procedure TForm1.split(const Delimiter: Char; Input: string; const Strings: TStrings);
begin
   Assert(Assigned(Strings));
   Strings.Clear;
   Strings.StrictDelimiter:=True;  //Use to specify "use only" delimiter listed in argument
   Strings.Delimiter := Delimiter;
   Strings.DelimitedText := Input;
end;

procedure TForm1.Utilities1Click(Sender: TObject);
begin
   Form6.ShowModal;
   refreshForms(Self);
end;

function gp(x : String; const Delimiter: Char; piece : Integer) : String;  //Get Piece (gp)
Var
 A : TStringList;
 y : String;
begin
  if x='' then Exit;
  A := TStringList.Create;
  try
    Form1.split(Delimiter,x,A);
    y:=A[piece-1];
  finally
    A.Free;
  end;
  Result:=y;
end;

procedure TForm1.pointerFile(Sender: TOBject);  //Save
Var
  cName,eLbl,cText,xStr,xLine,PF : String;
  xLen : Integer;
begin
  //Get file values, set up dialoge - maybe use a local list box on this form?    lbx didn't format correctly on reslection
  fCaller:=1;
  if Sender is TEdit then cName:=(Sender as TEdit).Name;cText:=(Sender as TEdit).Text;
  elbl:=cName;
  xMaster:=cName;
  xLen:=Length(cName);
  xStr:=Copy(cName,5,xLen);
  xLine:=mData.Lines.Strings[StrToInt(xStr)];
  if gp(xLine,'^',5)='' then Exit;
  PF:=gp(xLine,'^',5);
  RPCBroker1.ClearParameters:=True;
  RPCBroker1.ClearResults   :=True;
  RPCBroker1.RemoteProcedure:='VW REG PF';
  RPCBroker1.Param[0].Value :=PF;
  RPCBroker1.Param[0].PType :=literal;
  RPCBroker1.Call;
  Form3.lbxReference.Items:=RPCBroker1.Results;
  Form3.Top:=Form1.Top+50;
  Form3.Left:=Form1.Left+Form1.Width+5;
  Form3.Show;
end;

procedure TForm1.refreshForms(Sender: TObject);
Var
  rfMitem : TMenuItem;
  x       : String;
  i       : Integer;
begin
  RPCBroker1.ClearParameters:=True;
  RPCBroker1.ClearResults   :=True;
  RPCBroker1.RemoteProcedure:='VW REG RTF';
  //RPCBroker1.Param[0].Value:='R';
  //RPCBroker1.Param[0].PType:=literal;
  RPCBroker1.Call;
  FormsCount:=0;
  MainMenu1.Items[2].Clear;
  for i := 1 to RPCBRoker1.results.count-1 do
    begin
      x:=RPCBroker1.Results.Strings[i];
      if AnsiContainsStr(x,'[ID]') then Break;
      rfMitem:=TMenuItem.Create(MainMenu1.Items[2]);
      rfMitem.Name:='T'+IntToStr(i);
      rfMitem.ImageIndex:=i*-1;
      rfMitem.Caption:=x;
      rfMitem.Tag:=i-1;
      rfMitem.OnClick:=FormClick;
      MainMenu1.Items[2].Add(rfMItem);
    end;
end;

{1. save data to server
 2. Clear Form data
 3. comboboxes just clear .text property
 4. allegedly I've done the save}
procedure TForm1.Save1Click(Sender: TObject);
Var
  i : Integer;
  j : Integer;
  xl: Integer;  //length of component.name (masterLB.Items.strings[index]
  xs: String;   //Last char in component.name ("")
  x : String;   //mastrLB.Items.Strings[index]
  C : TComponent;
  y : String;  //text of edit field
  //msg:String;
begin
  //msg:='I am sending:'+#13#10;
  AutoSize:=False;
  RPCBroker1.ClearParameters:=True;
  RPCBRoker1.ClearResults   :=True;
  RPCBroker1.RemoteProcedure:='VW REG SAVE'; //need an if and diff call if Length(DFN)>0
  for i:=0 to masterLB.Items.Count-1 do
    begin
      x:=masterLB.Items.Strings[i];
      xl:=Length(x);
      xs:=Copy(x,5,xl);
      if Length(xs)<1 then Continue;
      C:=(FindComponent(x) as TComponent);
      if C is TEdit AND ((C as TEdit).Color=clSkyBlue) then
        begin
          y:=(C as TEdit).Text;
          RPCBroker1.Param[0].Mult[IntToStr(i)]:=gp(mData.Lines.Strings[StrToInt(xs)],'^',1)+'^'+gp(mData.Lines.Strings[StrToInt(xs)],'^',2)+'^'+y+
                                                    '^'+DFN;
          //msg:=msg+IntToStr(i)+'. '+gp(mData.Lines.Strings[StrToInt(xs)],'^',1)+'^'+gp(mData.Lines.Strings[StrToInt(xs)],'^',2)+'^'+y+'^'+DFN+#13#10;
        end
      else if C is TComboBox AND ((C as TComboBox).Color=clSkyBlue) then
        begin
          y:=(C as TComboBox).Text;
          RPCBroker1.Param[0].Mult[IntToStr(i)]:=gp(mData.Lines.Strings[StrToInt(xs)],'^',1)+'^'+gp(mData.Lines.Strings[StrToInt(xs)],'^',2)+'^'+y+
                                                    '^'+DFN;
          //msg:=msg+IntToStr(i)+'. '+gp(mData.Lines.Strings[StrToInt(xs)],'^',1)+'^'+gp(mData.Lines.Strings[StrToInt(xs)],'^',2)+'^'+y+'^'+DFN+#13#10;
        end;
    end;
  for j:=0 to mMults.Lines.Count-1 do
    begin
      Inc(i);
      RPCBroker1.Param[0].Mult[IntToStr(i)]:=mMults.Lines.Strings[j];
    end;
  //showMessage(msg);
  //Application.Terminate;
  RPCBroker1.Param[0].PType:=list;
  RPCBroker1.Call;
  showMessage(RPCBroker1.Results.GetText);
  Clear1Click(Self);
  //newPtClick(Self);
  formClick(Self);
end;

procedure TForm1.goingPostal(pcode: String; fLoc: String);
Var
  c2Name,xCity,xState,xCounty,xFIPS,x : String;
  i,rcount : Integer;
  C        : TComponent;
begin
  RPCBroker1.ClearParameters:=True;
  RPCBRoker1.ClearResults   :=True;
  RPCBroker1.RemoteProcedure:='VW REG ZIP';
  RPCBroker1.Param[0].Value :=pCode;
  RPCBroker1.Param[0].PType :=literal;
  RPCBroker1.Call;
  rcount:=RPCBroker1.Results.Count;
  for i:=0 to rcount-1 do
    begin
      case i of
        0 : xState :=RPCBRoker1.Results.Strings[0];
        1 : xCounty:=RPCBroker1.Results.Strings[1];
        2 : xCity  :=RPCBroker1.Results.Strings[2];
        3 : xFIPS  :=RPCBroker1.Results.Strings[3];
      end;
    end;
  if rcount=1 then Exit;
  for i:=0 to mData.Lines.Count-1 do
    begin
      x:=gp(mData.Lines.Strings[i],'^',1);
      if AnsiContainsStr(x,'CITY') then
        begin
          c2Name:='elbl'+IntToStr(i);
          C:=(FindComponent(c2Name) as TComponent);
          (C as TEdit).Text:=xCity;
        end
      else if AnsiContainsText(x,'STATE') then
        begin
          c2Name:='elbl'+IntToStr(i);
          C:=(FindComponent(c2Name) as TComponent);
          (C as TEdit).Text:=xState;
        end
      else if AnsiContainsText(x,'COUNTY') then
        begin
          c2Name:='elbl'+IntToStr(i);
          C:=(FindComponent(c2Name) as TComponent);
          (C as TEdit).Text:=xCounty;
        end;
    end;
end;

procedure TForm1.fieldExit(Sender: TObject);
Var
  cName,cText : String;
begin
 cText:=(Sender as TEdit).Text;
 cName:=(Sender as TEdit).Name;
 goingPostal(cText,cName);
end;

procedure TForm1.multipleField(Sender: TOBject);
Var
  x,cName,eLbl,cText,xStr,xLine,xFNO : String;
  xLen,i : Integer;
  C : TComponent;
begin
  //mData.Lines.Add('[Multiples]');
  if Sender is TEdit then cName:=(Sender as TEdit).Name; cText:=(Sender as TEdit).Text;
  eLbl:=cName;
  xMaster:=cName;
  xLen:=Length(cName);
  xStr:=Copy(cName,5,xLen);
  xLine:=mData.Lines.Strings[StrToInt(xStr)];
  xFNO:=gp(xLine,'^',2);
  fCaller:=4;
  mfCaller:=gp(xLine,'^',1)+'^'+xFNO;
  RPCBroker1.ClearParameters:=True;
  RPCBRoker1.ClearResults   :=True;
  RPCBroker1.RemoteProcedure:='VW REG MF';
  RPCBroker1.Param[0].Value :=xFNO+'^'+DFN+'^'+selTemplate;
  RPCBroker1.Param[0].PType :=literal;
  RPCBroker1.Call;
  Form4.mMultfield.Lines:=RPCBRoker1.Results;
  Form4.Caption:=Form4.Caption+gp(xLine,'^',1);
  Form4.Top:=Top+(height DIV 3);
  Form4.Left:=Left+(Width DIV 2)+5;
  Form4.ShowModal;
  for i:=0 to mMults.Lines.Count-1 do
    begin
      x := mMults.Lines.Strings[i];
    end;
   C:=(FindComponent(cName) as TComponent);
   if C is TEdit then
     begin
       (C as TEdit).Text:=gp(gp(x,'^',1),':',2);
       (C as TEdit).Color:=clSkyBlue;
     end;
end;

procedure TForm1.insurForm(Sender: TOBject);
begin
  Form7.ShowModal;
end;

procedure TForm1.SelectPt1Click(Sender: TObject);
Var
  x         : String;
  clientName: String;
  xData     : String;
  i         : Integer;
  yLine     : String;
  C         : TComponent;
  c2Name    : String;
begin
  Form2.ShowModal;
  DFN:=gp(gp(clientStr,'(',2),')',1);
  clientStr:=ReplaceText(clientStr,#9,'^');
  clientName:=gp(clientStr,'^',2);
  x:=clientStr;
  x:=ReplaceText(x,'^','  ');
  Caption:=x;
  RPCBroker1.ClearParameters:=True;
  RPCBroker1.ClearResults   :=True;
  RPCBRoker1.RemoteProcedure:='VW REG GPD';
  RPCBroker1.Param[0].Value :=selTemplate+'^^'+clientName;
  RPCBroker1.Param[0].PType :=literal;
  RPCBroker1.Call;
  if RPCBroker1.Results.Count>0 then mMults.Clear;
  for i:=0 to RPCBroker1.Results.Count-1 do
    begin
      x := RPCBroker1.Results.Strings[i];  //full line return
      xData:=gp(x,'^',2);                  //Patient data field value
      yLine:=mData.Lines.Strings[i];
      yLine:=AnsiReplaceStr(yline,'^^',('^'+xData+'^'));
      mData.Lines.Strings[i]:=yLine;
      c2Name:='elbl'+IntToStr(i);
      C:=(FindComponent(c2Name) as TComponent);
      if C is TEdit then
        begin
          (C as TEdit).Text:=xData;
          (C as TEdit).Color:=clWhite;
        end
      else if C is TComboBox then
        begin
          (C as TComboBox).Text:=xData;
          (C as TComboBox).Color:=clWhite;
        end;
    end;
end;

procedure TForm1.Clear1Click(Sender: TObject);
Var
  i : Integer;
  x : String;
  C : TComponent;
begin
  AutoSize:=False;
  for i:=0 to masterLB.Items.Count-1 do
    begin
      x:=masterLB.Items.Strings[i];
      C:=(FindComponent(x) as TComponent);
      C.Destroy;
    end;
masterLB.Clear;
mData.Clear;
clientStr:='';
DFN:='';
Caption:='';
RPCBroker1.ClearParameters:=True;
RPCBroker1.ClearResults   :=True;
height:=300;
end;

procedure TForm1.ColorText(Sender: TObject);
Var
  x : String;
begin
  if Sender is TEdit then
     begin
       x:=TEdit(Sender).Text;
       x:=AnsiUpperCase(x);
       if (x='MIDNIGHT') OR (x='NOON') then TEdit(Sender).Text:='';
       if TEdit(Sender).Text='' then TEdit(Sender).Color:=clWhite else TEdit(Sender).Color:=clSkyBlue;
     end;
   if Sender is TComboBox then
     begin
       if TComboBox(Sender).Text='' then TComboBox(Sender).Color:=clWhite else TComboBox(Sender).Color:=clSkyBlue;
     end;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close();
end;

procedure TForm1.FormClick(Sender: TObject);
Var
  x : String;
begin
  if Sender is TMenuItem then
    begin
//      i:=(Sender as TMenuItem).Tag;
      x:=(Sender as TMenuItem).Caption;
      selTemplate:=x;
    end;
  RPCBroker1.ClearParameters:=True;
  RPCBRoker1.ClearResults   :=True;
  RPCBroker1.RemoteProcedure:='VW REG NEW PT';
  RPCBroker1.Param[0].Value :=DFN+'^'+selTemplate;
  RPCBroker1.Param[0].PType :=literal;
  RPCBroker1.Call;
  mData.Clear;
  mData.Lines:=RPCBroker1.Results;
  //mData.Visible:=True;
  GTF(Self);
  AutoSize:=True;
  MainMenu1.Items[5].Enabled:=True;
end;

procedure TForm1.FormCreate(Sender: TObject);
Var
  dfile   : TextFile;
  x       : String;
  server  : String;
  port    : String;
  i       : Integer;
  c       : Integer;
  mItem   : TMenuItem;
  Label     JumpFile;
  Label     JumpHere;
begin
  Application.HintHidePause:=50000;
  DFN:=''; selTemplate:='';
  mMults.Clear;
  mData.Clear;
  mData.Visible:=False;
  c:=0;
  //Screen.MenuFont.Style:=[fsItalic,fsBold];
  Screen.MenuFont.Name := 'Comic Sans MS';
  Screen.MenuFont.Size := 9;
  {Note - Place shortcut in the main part of public folder, not sub-folders of public folder}
  x:=GetShortcutTarget('C:\Users\Public\BFP_Proj1.exe - Shortcut.lnk');
  //showMessage('This from the desktop shortcut: '+x);
  ;
  if x='' then GoTo JumpFile;
  server:=gp(gp(x,'=',2),' ',1);TrimLeft(server);TrimRight(server);if Length(server)>0 then Inc(c);
  port:=gp(x,'=',3);TrimLeft(port);TrimRight(port);if Length(port)>0 then Inc(c);
  if c=2 then GoTo jumpHere;
  JumpFile:
  if FileExists('c:\VWREG\connect.txt') then
    begin
      AssignFile(dFile,'C:\VWREG\connect.txt');
      FileMode := fmOpenRead;
      Reset(dFile);
     while not Eof(dFile) do
      begin
        ReadLN(dFile,x);
        if AnsiContainsStr(x,'.') then server:=x else port:=x;
      end;
     CloseFile(dFile);
     //showMessage('This from connect.txt- server: '+server+#13#10+'port  : '+port);
    end
    else
      begin
        showMessage('I could not find the shortcut or C:\VWREG\connect.txt;+#13#10Application not started.');
        Application.Terminate;
    end;
  JumpHere:
  RPCBroker1.Server:=server;
  RPCBroker1.ListenerPort:=StrToInt(port);
  RPCBroker1.ClearParameters:=True;
  RPCBroker1.ClearResults:=True;
  RPCBroker1.CreateContext('VW PATIENT REGISTRATION');
  RPCBroker1.RemoteProcedure:='VW REG MAIN';
  RPCBroker1.Call;
  if RPCBroker1.Connected=True then
    begin
      ImIn:=1;
    end
  else
    begin
      showMessage('Unable to connect to server '+server+' @ '+port);
      Application.Terminate;
    end;
  if RPCBroker1.Results.Strings[0]='0' then
    begin
      mgr:=0;
      defaultState:='';
      homeDir:='';
      Exit;
    end;
  mgr         :=StrToInt(gp(RPCBroker1.Results.Strings[0],'^',1));  //Can make/manage templates - jeb
  defaultState:=gp(RPCBRoker1.Results.Strings[0],'^',3);  //Default state from VistA->PARAMATERS app.
  homeDir     :=gp(RPCbroker1.Results.Strings[0],'^',2);  //Home directory for the text file of templates;
  defTemplate :=gp(RPCBRoker1.Results.Strings[0],'^',4);  //Default New Pt Reg Template
  DUZ         :=gp(RPCBroker1.Results.Strings[0],'^',5);
  mData.Lines:=RPCBroker1.Results;
  FormsCount:=0;
  MainMenu1.Items[2].Clear;
  for i := 1 to mData.Lines.Count-1 do
    begin
      x:=mData.Lines.Strings[i];
      if AnsiContainsStr(x,'[ID]') then Break;
      mItem:=TMenuItem.Create(MainMenu1.Items[2]);
      mItem.Name:='T'+IntToStr(i);
      mItem.ImageIndex:=i*-1;
      mItem.Caption:=x;
      mItem.Tag:=i-1;
      mItem.OnClick:=FormClick;
      MainMenu1.Items[2].Add(mItem);
    end;
  MainMenu1.Items[5].Enabled:=False;
  //if mgr>0 then MainMenu1.Items[8].Enabled:=True else MainMenu1.Items[8].Enabled:=False;
  height:=400;
end;

procedure TForm1.NewPtClick(Sender: TObject);
begin
  mData.Clear;
  DFN:='';
  clientStr:='';
  selTemplate:=defTemplate;
  RPCBroker1.ClearParameters:=True;
  RPCBroker1.ClearResults   :=True;
  RPCBroker1.RemoteProcedure:='VW REG NEW PT';
  RPCBroker1.Param[0].Value :=selTemplate;
  RPCBRoker1.Param[0].PType :=literal;
  RPCBroker1.Call;
  mData.Lines:=RPCBRoker1.Results;
  GTF(Self);
  AutoSize:=True;
  selTemplate:='';
end;

procedure TForm1.GTF(Sender : TObject);  //Save //Get loaded fields in memopad and run the bldLabel
Var
  i     : Integer;
  x     : String;
  fList : Array of String;
  eList : Array of String;
  arLen : Integer;  //mData Array length
  fName,fNum,fVal,fHelp,fPSF: String;
  startTop,fMult:Integer;
begin
  fList:=nil;
  eList:=nil;
  startTop:=8;
  arLen :=mData.Lines.Count;
  setLength(fList,arLen);  //Labels
  setLength(eList,arLen);  //Edit/Combobox fields
  for i:=0 to mData.Lines.Count-1 do
    begin
      x := mData.Lines.Strings[i];
      fName:=gp(x,'^',1);
      fNum :=gp(x,'^',2);
      fVal :=gp(x,'^',3);
      fhelp:=gp(x,'^',4);
      fPSF :=gp(x,'^',5);
      fList[i]:='lbl'+IntToStr(i);
      eList[i]:='e'+IntToStr(i);
      fHelp:=AnsiReplaceStr(fHelp,'$C(13,10)',''+#13#10+'');
      fHelp:=WrapText(fHelp,65);
      fMult:=StrToInt(gp(x,'^',6));
      buildField(Form1,fName,8,startTop,i,'lbl',True,False,False,fVal,fHelp,fPSF,fMult);
      startTop:=startTop+19;
    end;
end;

procedure TForm1.Help1Click(Sender: TObject);
begin
  ShellExecute(self.WindowHandle,'open','file:///c:/VWREG/BFPLLC_WV_Help.html',nil,nil, SW_SHOWNORMAL);
end;

procedure TForm1.AddEditaTemplate1Click(Sender: TObject);
begin
  Form6.ShowModal;
end;

procedure TForm1.AdHocFieldList1Click(Sender: TObject);
begin
  mData.Clear;
  clientStr:='';
  Form2.ShowModal;
  Caption:=clientStr;
  DFN:=gp(gp(clientStr,'(',2),')',1);
  Form5.Left:=Form1.Left+(Form1.Width DIV 2);
  Form5.Top :=Form1.Top-125;
  Form5.Caption:='AD HOC FIELD SELECTION';
  Form5.ShowModal;
  if mData.Lines.Count>0 then
    begin
      GTF(Self);
      AutoSize:=True;
    end;
end;

procedure TForm1.buildField(location:TWinControl; text:String; Label_Left,Label_Top, NumofComp:Integer; NameOwn: String;
                            Label_AutoSize, Label_FontBold, Label_Trans: Boolean; fValue:String; fHint:String; psF:String; fMult:Integer);  //Save
Var
  locLabel  : TLabel;
  locEdit   : TEdit;
  locCBox   : TComboBox;
  //StartTop  : Integer;
  i,xPC     : Integer;
  y,z     : String;
begin
  //StartTop :=8;
  locLabel:=TLabel.Create(location);
  locLabel.Name:=NameOwn+IntToStr(NumofComp);
  locLabel.Parent:=location;
  locLabel.Caption:=text;
  locLabel.AutoSize:=Label_AutoSize;
  locLabel.Transparent:=label_Trans;
  locLabel.Font.Size:=9;
  locLabel.Font.Name:='Verdana';
  locLabel.Top:=label_Top;
  locLabel.Left:=Label_Left;
  locLabel.Width:=255;
  locLabel.Alignment:=taRightJustify;
  locLabel.Visible:=True;
  masterLB.Items.Add(locLabel.Name);
  if AnsiContainsStr(pSF,':') OR (AnsiContainsStr(pSF,'M')) then    //Set of codes in ^5
   begin
     locCBox:=TComboBox.Create(location);
     locCBox.Font.Name:=locLabel.Font.Name;
     locCBox.Font.Size:=locLabel.Font.Size;
     locCBox.Parent:=location;
     locCBox.Name:='e'+NameOwn+IntToStr(NumofComp);
     locCBox.Top:=locLabel.Top-3;
     locCBox.Width:=225;
     locCBox.Left:=locLabel.Width+15;
     locCBox.ItemIndex:=0;
     locCBox.Hint:=fHint;
     locCBox.ShowHint:=True;
     locCBox.onChange:=colorText;
     locCBox.Text:=fValue;
     locCBox.Visible:=True;
     xPC:=pieceCount(psF,';');
     for i := 1 to xPC do
       begin
         y:=gp(pSF,';',i);
         z:=gp(y,':',2);
         locCBox.Items.Add(z);
       end;
     masterLB.Items.Add(locCBox.Name);
   end
  else if AnsiContainsStr(psF,'W') then
       begin
         //Word process in fValue - make a small memo pad
       end
  else
    begin
      locEdit:=TEdit.Create(Form1);
      locEdit.Parent:=location;
      locEdit.Name:='e'+NameOwn+IntToStr(NumofComp);
      locEdit.Top:=locLabel.top-2;
      locEdit.Width:=225;
      locEdit.Left:=locLabel.Width+15;
      locEdit.Text:=fValue;
      locEdit.Font:=locLabel.Font;
      locEdit.Visible:=True;
      if AnsiContainsStr(psF,'(') then locEdit.OnEnter:=pointerFile;
      if fMult>0 then locEdit.OnEnter:=multipleField;
      if AnsiContainsStr(locLabel.Caption,'INSURANCE') then locEdit.OnEnter:=insurForm;
      if AnsiContainsStr(locLabel.Caption,'POSTAL') OR (AnsiContainsStr(locLabel.Caption,'ZIP')) then locEdit.OnExit:=fieldExit;
      locEdit.OnChange:=colorText;
      locEdit.Hint:=fHint;
      locEdit.ShowHint:=True;
      masterLB.Items.Add(locEdit.Name);
    end;
end;

end.
