unit VWEsig;
{
Removed from main uses: ShellLinker,
}
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Buttons, Trpcb, jpeg, ShellApi, ShlObj,
  ComObj, Grids, ComCtrls, StrUtils, Winsock, Registry, ActiveX, CommCtrl,
  SyncObjs, Spin;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    lInitial: TLabel;
    lSBPN: TLabel;
    lSBT: TLabel;
    lESIG: TLabel;
    lOPH: TLabel;
    lVP: TLabel;
    lDP: TLabel;
    eESIG: TEdit;
    eInitial: TEdit;
    eSBPN: TEdit;
    eSBT: TEdit;
    eOPH: TEdit;
    eVP: TEdit;
    eDP: TEdit;
    sbSave: TSpeedButton;
    sbCancel: TSpeedButton;
    sbClear: TSpeedButton;
    RPCBroker1: TRPCBroker;
    sbRef: TSpeedButton;
    procedure sbSaveMouseEnter(Sender: TObject);
    procedure sbRefMouseEnter(Sender: TObject);
    procedure sbClearMouseEnter(Sender: TObject);
    procedure sbCancelMouseEnter(Sender: TObject);
    procedure eESIGEnter(Sender: TObject);
    procedure sbCancelClick(Sender: TObject);
    procedure eInitialChange(Sender: TObject);
    procedure sbRefClick(Sender: TObject);
    procedure eOPHMouseEnter(Sender: TObject);
    procedure eSBTMouseEnter(Sender: TObject);
    procedure eSBPNMouseEnter(Sender: TObject);
    procedure eInitialMouseEnter(Sender: TObject);
    procedure eESIGMouseEnter(Sender: TObject);
    procedure eDPMouseEnter(Sender: TObject);
    procedure eVPMouseEnter(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure sbSaveClick(Sender: TObject);
    procedure sbClearClick(Sender: TObject);
    procedure split(const Delimiter: Char; Input: string; const Strings: TStrings);
    function gp(x : String; const Delimiter: Char; piece : Integer) : String;  //Get Piece (gp)
  private
    ImIn      : Integer;
    server    : String;
    port      : String;
    //changed   : Integer;
    eSignature: String;
  public
    dlgClick  : smallInt;   //Used for local dialog box

  end;

  type
    TExHint = class(THintWindow)
    constructor Create(AOwner: TComponent); override;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses locDlg;

constructor TExHint.Create(AOwner: TComponent); //Customize size of roll-over hints
begin
  inherited Create(AOwner);
  with Canvas.Font do
  begin
    Name  := 'Calibri';
    Size  := Size + 2;
    //Style := [fsItalic];
    Application.HintHidePause:=10000;
  end;
end;

function GetShortcutTarget(ShortcutFilename:string):string;
var
  Psl:IShellLink;
  Ppf:IPersistFile;
  WideName:Array [0..MAX_PATH] of WideChar;
  pResult:Array [0..MAX_PATH-1] Of Char;
  Data:TWin32FindData;
const
IID_IPersistFile: TGUID = (D1:$0000010B; D2:$0000; D3:$0000; D4:($C0,$00,$00,$00,$00,$00,$00,$46));
begin
  CoCreateInstance(CLSID_ShellLink,nil,CLSCTX_INPROC_SERVER, IID_IShellLinkA ,psl);
  psl.QueryInterface(IID_IPersistFile,ppf);
  MultiByteToWideChar(CP_ACP, 0, pChar(ShortcutFilename), -1, WideName, Max_Path);
  ppf.Load(WideName,STGM_READ);
  psl.Resolve(0,SLR_ANY_MATCH);
  psl.GetPath(@pResult,MAX_PATH,Data,SLGP_UNCPRIORITY);
  psl.GetArguments(@pResult,MAX_PATH);
  Result:=StrPas(@pResult);
end;

function TForm1.gp(x : String; const Delimiter: Char; piece : Integer) : String;  //Get Piece (gp)
Var
 A : TStringList;
 y : String;
begin
  if x='' then Exit;
  A := TStringList.Create;
  try
    Form1.split(Delimiter,x,A);
    y:=A[piece-1];
  finally
    A.Free;
  end;
  Result:=y;
end;

procedure TForm1.split(const Delimiter: Char; Input: string; const Strings: TStrings);
begin
   Assert(Assigned(Strings));
   Strings.Clear;
   Strings.StrictDelimiter:=True;  //Use to specify "use only" delimiter listed in argument
   Strings.Delimiter := Delimiter;
   Strings.DelimitedText := Input;
end;

procedure TForm1.eDPMouseEnter(Sender: TObject);
Var
  x : String;
begin
  Application.HintHidePause:=10000;
  x:='DIGITAL PAGER (3 TO 20 Characters):'#13#10;
  x:=x+'This field holds a phone number for a DIGITAL PAGER that this'#13#10;
  x:=x+'person carries with them.It needs to be a format that can be'#13#10;
  x:=x+'understood by a sending MODEM.';
  eDP.Hint:=x;
  eDP.ShowHint:=True;
end;

procedure TForm1.eESIGEnter(Sender: TObject);
begin
  //Inc(changed);
end;

procedure TForm1.eESIGMouseEnter(Sender: TObject);
Var
  x : String;
begin
  Application.HintHidePause:=15000;
  x:='ELECTRONIC SIGNATURE CODE (6 to 20 characters):'#10#13;
  x:=x+'This field contains the encrypted code which the user types when'#10#13;
  x:=x+'signing documents electronically.  The user'+''''+'s'+' input will be compared to'#10#13;
  x:=x+'this field when validating his electronic signature.'#10#13;
  x:=x+'All electronic signature codes should be treated as confidential.'#10#13;
  eESIG.Hint:=x;
  eESIG.ShowHint:=True;
end;

procedure TForm1.eInitialChange(Sender: TObject);
begin
 //Inc(changed);
end;

procedure TForm1.eInitialMouseEnter(Sender: TObject);
Var
  x : String;
begin
  Application.HintHidePause:=15000;
  x:='INITIAL (2 to 5 characters):'+#13#10;
  x:=x+'These are the initials of the user, which may be entered for naming users.';
  eInitial.Hint:=x;
  eInitial.ShowHint:=True;
end;

procedure TForm1.eOPHMouseEnter(Sender: TObject);
begin
  Application.HintHidePause:=10000;
  eOPH.Hint:='OFFICE PHONE: This is the business/office telephone for you.';
  eOPH.ShowHint:=True;
end;

procedure TForm1.eSBPNMouseEnter(Sender: TObject);
Var
  x : String;
begin
  Application.HintHidePause:=20000;
  x:='SIGNATURE BLOCK PRINTED NAME (2 to 40 characters):'+#13#10;
  x:=x+'The name entered must contain the surname of the user. The name'+#13#10;
  x:=x+'must be 2 to 40 characters in length. This field can then contain the'+#13#10;
  x:=x+'name of the user as they wish it tobe displayed with the notation that'+#13#10;
  x:=x+'they signed the document electronically.'+#13#10;
  x:=x+'For example: John R. Doe, M.D. or Fred A. Sample, RN.';
  eSBPN.Hint:=x;
  eSBPN.ShowHint:=True;
end;

procedure TForm1.eSBTMouseEnter(Sender: TObject);
Var
  x : String;
begin
  Application.HintHidePause:=20000;
  x:='SIGNATURE BLOCK TITLE (2 to 50 characters):'#13#10;
  x:=x+'This field should contain the title of the person who is electronically'#13#10;
  x:=x+'signing a document. Examples of titles are Chief of Surgery, Dietician,'#13#10;
  x:=x+'Clinical Pharmacist, etc. This title will print next to the name of the'#13#10;
  x:=x+'person who signs the document. The person'+''''+'s name will be taken'#13#10;
  x:=x+'from the SIGNATURE BLOCK PRINTED NAME field.'#13#10;
  x:=x+'The title must be 2 to 50 characters in length.';
  eSBT.Hint:=x;
  eSBT.ShowHint:=True;
end;

procedure TForm1.eVPMouseEnter(Sender: TObject);
Var
  x : String;
begin
  Application.HintHidePause:=10000;
  x:='VOICE PAGER (3 to 20 Characters):'#13#10;
  x:=x+'This field holds a phone number for an ANALOG PAGER that'#13#10;
  x:=x+'this person carries with them.It needs to be a format that can'#13#10;
  x:=x+'be understood by a sending MODEM.';
  eVP.Hint:=x;
  eVP.ShowHint:=True;
end;

procedure TForm1.FormCreate(Sender: TObject);
Var
  dFile       : TextFile;
  x           : String;
  i           : Integer;
  c           : Integer;
Label jumpFile;
Label jumpHere;
begin
  ImIn      :=0;
  c         :=0;
  //changed   :=0;
  eSignature:='';
  HintWindowClass  := TExHint;
  x:=GetShortcutTarget('c:\Users\Public\Desktop\ESIG.lnk');
  if x='' then GoTo jumpFile;
  server:=gp(gp(x,'=',2),' ',1);TrimLeft(server);TrimRight(server);if Length(server)>0 then Inc(c);
  port:=gp(x,'=',3);TrimLeft(port);TrimRight(port);if Length(port)>0 then Inc(c);
  if c=2 then GoTo jumpHere;
  //application.Terminate; //Testing server/port extraction from short-cut
  jumpFile:
  if FileExists('c:\VWREG\connect.txt') then
    begin
      AssignFile(dFile,'C:\VWREG\connect.txt');
      FileMode := fmOpenRead;
      Reset(dFile);
     while not Eof(dFile) do
      begin
        ReadLN(dFile,x);
        if AnsiContainsStr(x,'.') then server:=x else port:=x;
      end;
     CloseFile(dFile);
    end
    else
      begin
        showMessage('I could not find the shortcut or C:\VWREG\connect.txt;+#13#10Application not started.');
        Application.Terminate;
      end;
  //mScratch.Visible:=True;mScratch.Left:=8;mScratch.Height:=400;mScratch.Width:=600;  //testing
  jumpHere:
  RPCBroker1.Server:=server;
  RPCBroker1.ListenerPort:=StrToInt(port);
  RPCBroker1.ClearParameters:=True;
  RPCBroker1.ClearResults:=True;
  RPCBroker1.CreateContext('OR CPRS GUI CHART');
  RPCBroker1.RemoteProcedure:='VW ESIG BEGIN';
  RPCBroker1.Call;
  if RPCBroker1.Connected=True then ImIn:=1;
  for i := 0 to RPCBroker1.Results.Count - 1 do
    begin
      case i of
        0:begin
            eSignature:=RPCBroker1.Results.Strings[i];
            eESIG.Text:=eSignature;
          end;
        1:eInitial.Text:=RPCBroker1.Results.Strings[i];
        2:eSBPN.Text:=RPCBroker1.Results.Strings[i];
        3:eSBT.Text:=RPCBroker1.Results.Strings[i];
        4:eOPH.Text:=RPCBroker1.Results.Strings[i];
        5:eVP.Text:=RPCBroker1.Results.Strings[i];
        6:eDP.Text:=RPCBroker1.Results.Strings[i];
      else
        Exit;
    end;
  end;
end;

procedure TForm1.sbCancelClick(Sender: TObject);
begin
  Close;
{  //if //changed=0 then Close
  //else
    Form2.ShowModal;
    case dlgClick of
      0 : Close;
      1 : sbSaveClick(Self);
     -1 : Form2.Close;
    end; //Removed - overthinking for a trivially small app}
end;

procedure TForm1.sbCancelMouseEnter(Sender: TObject);
begin
  Application.HintHidePause:=10000;
  sbCancel.Hint:='This will close the form if there have been no changes.'+#13#10+
                 'If changes to field(s) have been made without saving,'+#13#10+
                 'then a dialog will pop-up.'+#13#10+
                 'NOTE: Closing the form via the window control will close the'+#13#10+
                 'form WITHOUT saving any data.';
  sbCancel.ShowHint:=True;
end;

procedure TForm1.sbClearClick(Sender: TObject);
begin
 eSignature:='';
 eESIG.Clear;
 eInitial.Clear;
 eSBPN.Clear;
 eSBT.Clear;
 eOPH.Clear;
 eVP.Clear;
 eDP.Clear;
end;

procedure TForm1.sbClearMouseEnter(Sender: TObject);
begin
  sbClear.Hint:='Clears your form data';
  sbClear.ShowHint:=True;
end;

procedure TForm1.sbSaveClick(Sender: TObject);
Var
  Data : String;
begin
  Data:=eESIG.Text+'^'+eInitial.Text+'^'+eSBPN.Text+'^'+eSBT.Text+'^'+eOPH.Text+'^'+eVP.Text+'^'+eDP.Text;
  RPCBroker1.ClearParameters :=True;
  RPCBroker1.ClearResults    :=True;
  RPCBroker1.RemoteProcedure :='VW ESIG SAVE';
  RPCBroker1.Param[0].Value  :=Data;
  RPCBroker1.Param[0].PType  :=literal;
  RPCBroker1.Call;
  showMessage(RPCBroker1.Results.Strings[0]);
  sbClearClick(Self);
  sbRefClick(Self);
  //changed:=0;
end;

procedure TForm1.sbSaveMouseEnter(Sender: TObject);
begin
  sbSave.Hint:='Saves your data. The form will then clear itself'+#13#10+
               'and refresh. It might happen so fast you may not '+#13#10+
               'see it happen.';
  sbSave.ShowHint:=True;
end;

procedure TForm1.sbRefClick(Sender: TObject);
Var
  i : Integer;
begin
  sbClearClick(Self);
  RPCBroker1.ClearParameters:=True;
  RPCBroker1.ClearResults:=True;
  //RPCBroker1.CreateContext('OR CPRS GUI CHART');
  RPCBroker1.RemoteProcedure:='VW ESIG BEGIN';
  RPCBroker1.Call;
  for i := 0 to RPCBroker1.Results.Count - 1 do
    begin
      case i of
        0:begin
          eSignature:=RPCBroker1.Results.Strings[i];
          eESIG.Text:=eSignature;
        end;
        1:eInitial.Text:=RPCBroker1.Results.Strings[i];
        2:eSBPN.Text:=RPCBroker1.Results.Strings[i];
        3:eSBT.Text:=RPCBroker1.Results.Strings[i];
        4:eOPH.Text:=RPCBroker1.Results.Strings[i];
        5:eVP.Text:=RPCBroker1.Results.Strings[i];
        6:eDP.Text:=RPCBroker1.Results.Strings[i];
      else
        Exit;
      end;
    end;
end;

procedure TForm1.sbRefMouseEnter(Sender: TObject);
begin
  sbRef.Hint:='Clears and refreshes the data';
  sbRef.ShowHint:=True;
end;

end.
