CCRDPT ;CCRCCD/SMH - Routines to Extract Patient Data for CCDCCR; 6/15/08
	;;0.1;CCRCCD;;Jun 15, 2008;

	;	NOTE TO PROGRAMMER: You need to call INIT(DPT) to initialize; and
	;	DESTROY to clean-up.

	W "No Entry at top!" Q
	
	;   The following is a map of the relevant data in the patient global.
	;
	;	^DPT(D0,0)= (#.01) NAME [1F] ^ (#.02) SEX [2S] ^ (#.03) DATE OF BIRTH [3D] ^  
	;	==>^ (#.05) MARITAL STATUS [5P:11] ^ (#.06) RACE [6P:10] ^ (#.07) 
	;	==>OCCUPATION [7F] ^ (#.08) RELIGIOUS PREFERENCE [8P:13] ^ (#.09) 
	;	==>SOCIAL SECURITY NUMBER [9F] ^ (#.091) REMARKS [10F] ^ (#.092) 
	;	==>PLACE OF BIRTH [CITY] [11F] ^ (#.093) PLACE OF BIRTH [STATE] 
	;	==>[12P:5] ^  ^ (#.14) CURRENT MEANS TEST STATUS [14P:408.32] ^ 
	;	==>(#.096) WHO ENTERED PATIENT [15P:200] ^ (#.097) DATE ENTERED INTO 
	;	==>FILE [16D] ^ (#.098) HOW WAS PATIENT ENTERED? [17S] ^ (#.081) 
	;	==>DUPLICATE STATUS [18S] ^ (#.082) PATIENT MERGED TO [19P:2] ^ 
	;	==>(#.083) CHECK FOR DUPLICATE [20S] ^ (#.6) TEST PATIENT INDICATOR 
	;	==>[21S] ^ 
	;	^DPT(D0,.01,0)=^2.01^^  (#1) ALIAS
	;	^DPT(D0,.01,D1,0)= (#.01) ALIAS [1F] ^ (#1) ALIAS SSN [2F] ^ (#100.03) ALIAS 
	;	==>COMPONENTS [3P:20] ^ 
	;	^DPT(D0,.11)= (#.111) STREET ADDRESS [LINE 1] [1F] ^ (#.112) STREET ADDRESS 
	;	==>[LINE 2] [2F] ^ (#.113) STREET ADDRESS [LINE 3] [3F] ^ (#.114) 
	;	==>CITY [4F] ^ (#.115) STATE [5P:5] ^ (#.116) ZIP CODE [6F] ^ 
	;	==>(#.117) COUNTY [7N] ^  ^  ^  ^  ^ (#.1112) ZIP+4 [12F] ^ 
	;	==>(#.118) ADDRESS CHANGE DT/TM [13D] ^ (#.119) ADDRESS CHANGE 
	;	==>SOURCE [14S] ^ (#.12) ADDRESS CHANGE SITE [15P:4] ^ (#.121) BAD 
	;	==>ADDRESS INDICATOR [16S] ^ (#.122) ADDRESS CHANGE USER [17P:200] 
	;	==>^ 
	;	^DPT(D0,.121)= (#.1211) TEMPORARY STREET [LINE 1] [1F] ^ (#.1212) TEMPORARY 
	;	==>STREET [LINE 2] [2F] ^ (#.1213) TEMPORARY STREET [LINE 3] [3F] 
	;	==>^ (#.1214) TEMPORARY CITY [4F] ^ (#.1215) TEMPORARY STATE 
	;	==>[5P:5] ^ (#.1216) TEMPORARY ZIP CODE [6F] ^ (#.1217) TEMPORARY 
	;	==>ADDRESS START DATE [7D] ^ (#.1218) TEMPORARY ADDRESS END DATE 
	;	==>[8D] ^ (#.12105) TEMPORARY ADDRESS ACTIVE? [9S] ^ (#.1219) 
	;	==>TEMPORARY PHONE NUMBER [10F] ^ (#.12111) TEMPORARY ADDRESS 
	;	==>COUNTY [11N] ^ (#.12112) TEMPORARY ZIP+4 [12F] ^ (#.12113) 
	;	==>TEMPORARY ADDRESS CHANGE DT/TM [13D] ^ 
	;	^DPT(D0,.121)= (#.12114) TEMPORARY ADDRESS CHANGE SITE [14P:4] ^ 
	;	^DPT(D0,.13)= (#.131) PHONE NUMBER [RESIDENCE] [1F] ^ (#.132) PHONE NUMBER 
	;	==>[WORK] [2F] ^ (#.133) EMAIL ADDRESS [3F] ^ (#.134) PHONE NUMBER 
	;	==>[CELLULAR] [4F] ^ (#.135) PAGER NUMBER [5F] ^ (#.136) EMAIL 
	;	==>ADDRESS CHANGE DT/TM [6D] ^ (#.137) EMAIL ADDRESS CHANGE SOURCE 
	;	==>[7S] ^ (#.138) EMAIL ADDRESS CHANGE SITE [8P:4] ^ (#.139) 
	;	==>CELLULAR NUMBER CHANGE DT/TM [9D] ^ (#.1311) CELLULAR NUMBER 
	;	==>CHANGE SOURCE [10S] ^ (#.13111) CELLULAR NUMBER CHANGE SITE 
	;	==>[11P:4] ^ (#.1312) PAGER NUMBER CHANGE DT/TM [12D] ^ (#.1313) 
	;	==>PAGER NUMBER CHANGE SOURCE [13S] ^ (#.1314) PAGER NUMBER CHANGE 
	;	==>SITE [14P:4] ^ 
	;	^DPT(D0,.21)= (#.211) K-NAME OF PRIMARY NOK [1F] ^ (#.212) K-RELATIONSHIP TO 
	;	==>PATIENT [2F] ^ (#.213) K-STREET ADDRESS [LINE 1] [3F] ^ (#.214) 
	;	==>K-STREET ADDRESS [LINE 2] [4F] ^ (#.215) K-STREET ADDRESS [LINE 
	;	==>3] [5F] ^ 
	;	^DPT(D0,.21)= (#.216) K-CITY [6F] ^ (#.217) K-STATE [7P:5] ^ (#.218) K-ZIP 
	;	==>CODE [8F] ^ (#.219) K-PHONE NUMBER [9F] ^ (#.2125) K-ADDRESS 
	;	==>SAME AS PATIENT'S? [10S] ^ (#.21011) K-WORK PHONE NUMBER [11F] 
	;	==>^ 
	;	^DPT(D0,.211)= (#.2191) K2-NAME OF SECONDARY NOK [1F] ^ (#.2192) 
	;	==>K2-RELATIONSHIP TO PATIENT [2F] ^ (#.2193) K2-STREET ADDRESS 
	;	==>[LINE 1] [3F] ^ (#.2194) K2-STREET ADDRESS [LINE 2] [4F] ^ 
	;	==>(#.2195) K2-STREET ADDRESS [LINE 3] [5F] ^ (#.2196) K2-CITY 
	;	==>[6F] ^ (#.2197) K2-STATE [7P:5] ^ (#.2198) K2-ZIP CODE [8F] ^ 
	;	==>(#.2199) K2-PHONE NUMBER [9F] ^ (#.21925) K2-ADDRESS SAME AS 
	;	==>PATIENT'S? [10S] ^ (#.211011) K2-WORK PHONE NUMBER [11F] ^ 
	;	^DPT(D0,.25)= (#.251) SPOUSE'S EMPLOYER NAME [1F] ^ (#.252) SPOUSE'S EMP 
	;	==>STREET [LINE 1] [2F] ^ (#.253) SPOUSE'S EMP STREET [LINE 2] 
	;	==>[3F] ^ (#.254) SPOUSE'S EMP STREET [LINE 3] [4F] ^ (#.255) 
	;	==>SPOUSE'S EMPLOYER'S CITY [5F] ^ (#.256) SPOUSE'S EMPLOYER'S 
	;	==>STATE [6P:5] ^ (#.257) SPOUSE'S EMP ZIP CODE [7F] ^ (#.258) 
	;	==>SPOUSE'S EMP PHONE NUMBER [8F] ^  ^  ^  ^  ^  ^ (#.2514) 
	;	==>SPOUSE'S OCCUPATION [14F] ^ (#.2515) SPOUSE'S EMPLOYMENT STATUS 
	;	==>[15S] ^ (#.2516) SPOUSE'S RETIREMENT DATE [16D] ^ 
	;	^DPT(D0,.33)= (#.331) E-NAME [1F] ^ (#.332) E-RELATIONSHIP TO PATIENT [2F] ^ 
	;	==>(#.333) E-STREET ADDRESS [LINE 1] [3F] ^ (#.334) E-STREET 
	;	==>ADDRESS [LINE 2] [4F] ^ (#.335) E-STREET ADDRESS [LINE 3] [5F] 
	;	==>^ (#.336) E-CITY [6F] ^ (#.337) E-STATE [7P:5] ^ (#.338) E-ZIP 
	;	==>CODE [8F] ^ (#.339) E-PHONE NUMBER [9F] ^ (#.3305) E-EMER. 
	;	==>CONTACT SAME AS NOK? [10S] ^ (#.33011) E-WORK PHONE NUMBER 
	;	==>[11F] ^ 
	
INIT(DFN) ; Copy DFN global to a local variable; PUBLIC
	; INPUT: Patient IEN (DFN)
	; OUTPUT: PT in the Symbol Table, representing the patient global
	
	; Instead of accessing a global each single read (SLOOOOW)
	; read it off a local variable stored in Memory.
	M PT=^DPT(DFN)
	Q
	;
DESTROY ; Kill local variable; PUBLIC
	; INPUT: None
	; OUTPUT: Kill PT from the Symbol Table after you are done
	K PT
	Q
	;
FAMILY() ; Family Name; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	N NAME S NAME=$P(PT(0),"^",1)
	D NAMECOMP^XLFNAME(.NAME)
	Q NAME("FAMILY")
	;
GIVEN() ; Given Name; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	N NAME S NAME=$P(PT(0),"^",1)
	D NAMECOMP^XLFNAME(.NAME)
	Q NAME("GIVEN")
	;
MIDDLE() ; Middle Name; PUBLIC; Extrinsic 
	; PREREQ: PT Defined
	N NAME S NAME=$P(PT(0),"^",1)
	D NAMECOMP^XLFNAME(.NAME)
	Q NAME("MIDDLE")
	;
SUFFIX() ; Suffi Name; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	N NAME S NAME=$P(PT(0),"^",1)
	D NAMECOMP^XLFNAME(.NAME)
	Q NAME("SUFFIX") 
	;
DISPNAME() ; Display Name; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	N NAME S NAME=$P(PT(0),"^",1)
	Q $$NAMEFMT^XLFNAME(.NAME,"G","MXc") 
	; "G" is Given Name First; "MXc" is Mixed Case, With Suffx Preceded by Comma
DOB() ; Date of Birth; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	N DOB S DOB=$P(PT(0),"^",3)
	; Date in FM Date Format. Convert to UTC/ISO 8601.
	Q $$FMDTOUTC^CCRUTIL(DOB,"D")
	;
GENDER() ; Get Gender; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	Q $P(PT(0),"^",2)
	;
SSN() ; Get SSN for ID; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	Q $P(PT(0),"^",9)
	;
ADDRTYPE(ADDR) ; Get Home Address; PUBLIC; Extrinsic
	; Vista only stores a home address for the patient.
	Q "Home"
	;
ADDR1() ; Get Home Address line 1; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	Q $P(PT(.11),"^",1)
	;
ADDR2() ; Get Home Address line 2; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	; Vista has Lines 2,3; CCR has only line 1,2; so compromise
	Q $P(PT(.11),"^",2)_", "_$P(PT(.11),"^",3)
	;
CITY() ; Get City for Home Address; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	Q $P(PT(.11),"^",4)
	;
STATE() ; Get State for Home Address; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	; State is stored as a pointer
	N STATENUM S STATENUM=$P(PT(.11),"^",5)
	;
	; State File Global is below
	; ^DIC(5,D0,0)= (#.01) NAME [1] ^ (#1) ABBREVIATION [2F] ^ (#2) VA STATE CODE 
    ; ==>[3F] ^ (#5) CAPITAL [4F] ^ (#2.1) AAC RECOGNIZED [5S] ^ (#2.2) 
    ; ==>US STATE OR POSSESSION [6S] ^ 
	Q $P(^DIC(5,STATENUM,0),"^",1)
	;
ZIP() ; Get Zip code for Home Address; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	Q $P(PT(.11),"^",6)
	;
COUNTY() ; Get County for our Address; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	Q $P(PT(.11),"^",7)
	;
COUNTRY() ; Get Country for our Address; PUBLIC; Extrinsic
	; Unfortunately, I can't find where that is stored, so the inevitable...
	Q "USA"
	;
RESTEL() ; Residential Telephone; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	Q $P(PT(.13),"^",1)
	;
WORKTEL() ; Work Telephone; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	Q $P(PT(.13),"^",2)
	;
EMAIL() ; Email Adddress; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	Q $P(PT(.13),"^",3)
	;
CELLTEL() ; Cell Phone; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	Q $P(PT(.13),"^",4)
	;
NOK1FAM() ; Next of Kin 1 (NOK1) Family Name; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	N NAME S NAME=$P(PT(.21),"^",1)
	D NAMECOMP^XLFNAME(.NAME)
	Q NAME("FAMILY")
	;
NOK1GIV() ; NOK1 Given Name; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	N NAME S NAME=$P(PT(.21),"^",1)
	D NAMECOMP^XLFNAME(.NAME)
	Q NAME("GIVEN")
	;
NOK1MID() ; NOK1 Middle Name; PUBLIC; Extrinsic 
	; PREREQ: PT Defined
	N NAME S NAME=$P(PT(.21),"^",1)
	D NAMECOMP^XLFNAME(.NAME)
	Q NAME("MIDDLE")
	;
NOK1SUF() ; NOK1 Suffi Name; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	N NAME S NAME=$P(PT(.21),"^",1)
	D NAMECOMP^XLFNAME(.NAME)
	Q NAME("SUFFIX") 
	;
NOK1DISP() ; NOK1 Display Name; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	N NAME S NAME=$P(PT(.21),"^",1)
	Q $$NAMEFMT^XLFNAME(.NAME,"G","MXc") 
	; "G" is Given Name First; "MXc" is Mixed Case, With Suffx Preceded by Comma
NOK2FAM() ; NOK2 Family Name; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	N NAME S NAME=$P(PT(.211),"^",1)
	D NAMECOMP^XLFNAME(.NAME)
	Q NAME("FAMILY")
	;
NOK2GIV() ; NOK2 Given Name; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	N NAME S NAME=$P(PT(.211),"^",1)
	D NAMECOMP^XLFNAME(.NAME)
	Q NAME("GIVEN")
	;
NOK2MID() ; NOK2 Middle Name; PUBLIC; Extrinsic 
	; PREREQ: PT Defined
	N NAME S NAME=$P(PT(.211),"^",1)
	D NAMECOMP^XLFNAME(.NAME)
	Q NAME("MIDDLE")
	;
NOK2SUF() ; NOK2 Suffi Name; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	N NAME S NAME=$P(PT(.211),"^",1)
	D NAMECOMP^XLFNAME(.NAME)
	Q NAME("SUFFIX") 
	;
NOK2DISP() ; NOK2 Display Name; PUBLIC; Extrinsic
	; PREREQ: PT Defined
	N NAME S NAME=$P(PT(.211),"^",1)
	Q $$NAMEFMT^XLFNAME(.NAME,"G","MXc") 
	; "G" is Given Name First; "MXc" is Mixed Case, With Suffx Preceded by Comma

