C0CDIC   ; CCDCCR/GPL - CCR Dictionary utilities; 6/1/08
 ;;0.1;CCDCCR;nopatch;noreleasedate
 ;Copyright 2008 WorldVistA.  Licensed under the terms of the GNU
 ;General Public License See attached copy of the License.
 ;
 ;This program is free software; you can redistribute it and/or modify
 ;it under the terms of the GNU General Public License as published by
 ;the Free Software Foundation; either version 2 of the License, or
 ;(at your option) any later version.
 ;
 ;This program is distributed in the hope that it will be useful,
 ;but WITHOUT ANY WARRANTY; without even the implied warranty of
 ;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ;GNU General Public License for more details.
 ;
 ;You should have received a copy of the GNU General Public License along
 ;with this program; if not, write to the Free Software Foundation, Inc.,
 ;51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 ;
 W "This is the CCR Dictionary Utility Library ",!
 W !
 Q
 ;
GVARS(C0CVARS,C0CT) ; Get the CCR variables from the CCR template
 ; and return them in C0CVARS, which is passed by name
 ; FIRST PIECE OF C0CVARS(x) IS THE VARIABLE NAME, SECOND PIECE
 ; IS THE LINE NUMBER OF THE VARIABLE IN THE TEMPLATE
 ; C0CT IS RETURNED AS THE CCR TEMPLATE
 N C0CTVARS ; ARRAY FOR THE TEMPLATE AND ARRAY FOR THE VARS
 D LOAD^GPLCCR0(C0CT) ; LOAD THE CCR TEMPLATE
 D XVARS^GPLXPATH("C0CTVARS",C0CT) ; PULL OUT THE VARS
 N C0CI,C0CX
 S @C0CVARS@(0)=C0CTVARS(0) ; SAME COUNT
 F C0CI=1:1:C0CTVARS(0) D  ; FOR EVERY LINE IN THE ARRAY
 . S C0CX=C0CTVARS(C0CI) ; THE VARIABLE - 3 PIECES, FIRST ONE NULL
 . S @C0CVARS@(C0CI)=$P(C0CX,"^",2)_"^"_$P(C0CX,"^",3) ; VAR NAME^LINE NUMBER
 ;D PARY^GPLXPATH("C0CVARS")
 Q
 ;
GXPATH(C0CPVARS,C0CPT) ; LOAD THE CCR TEMPLATE INTO C0CPT, PULL OUT VARIABLES
 ; AND THE XPATH TO THE VARIABLES INTO C0CPVARS
 ; BY INDEXING THE TEMPLATE C0CT AND MATCHING THE XPATH TO THE VARIABLE
 ; BOTH ARE PASSED BY NAME
 ; C0CPVARS(x) IS VAR^LINENUM^XPATH SORTED BY LINENUM
 ; C0CPVARS(0) IS NUMBER OF VARIABLES
 ; C0CPT(0) IS NUMBER OF LINES IN THE TEMPLATE
 D GVARS(C0CPVARS,C0CPT) ; GET THE VARIABLES AND LINE NUMBERS
 ;N C0CTVARS ; HASH TABLE FOR VARIABLE BY LINE NUMBER
 D HASHV ; PUT THE VARIABLES IN A LINE NUMBER HASH FOR MATCHING TO XPATHS
 ; NOW GO GET THE XPATH INDEXES
 D INDEX^GPLXPATH(C0CPT) ; ADD THE XPATH INDEXES TO THE TEMPLATE ARRAY
 S C0CI="" ; GOING TO LOOP THROUGH THE WHOLE ARRAY LOOKING AT XPATHS
 F  S C0CI=$O(@C0CPT@(C0CI)) Q:C0CI=""  D  ; VISIT EVERY LINE
 . I +C0CI'=0 Q  ; SKIP EVERYTHING BUT THE XPATH INDEX
 . I C0CI=0 Q  ; SKIP THE ZERO NODE
 . S C0CX=@C0CPT@(C0CI) ; PULL OUT THE LINE NUMBERS X^Y
 . S C0CY=$P(C0CX,"^",1) ; STARTING LINE NUMBER
 . S C0CZ=$P(C0CX,"^",2) ; ENDING LINE NUMBER
 . I C0CY=C0CZ D  ; THIS IS AN XPATH END NODE, HAS A VARIABLE (WE HOPE)
 . . ; W "FOUND ",C0CI,!
 . . I $D(C0CTVARS(C0CY)) D  ; IF THERE IS A VARIABLE THERE
 . . . S $P(C0CTVARS(C0CY),"^",3)=C0CI ; INSERT THE XPATH FOR THE VAR
 D SORTV ; SORT THE ARRAY BY LINE NUMBER
 Q
 ;
HASHV ; INTERNAL ROUTINE TO PUT VARIABLE NAMES IN A LINE NUMBER HASH
 ;N C0CI,C0CTVARS,C0CX,C0CY
 F C0CI=1:1:@C0CPVARS@(0) D  ; FOR THE ENTIRE ARRAY
 . S C0CX=$P(@C0CPVARS@(C0CI),"^",2) ; LINE NUMBER
 . S C0CY=$P(@C0CPVARS@(C0CI),"^",1) ; VARIABLE NAME
 . S C0CTVARS(C0CX)=C0CY ; BUILD HASH OF VARIABLES BY LINE NUMBER
 Q
 ;
SORTV ; INTERNAL ROUTINE TO OUTPUT VARIABLES (AND XPATHS) IN LINE NUMBER ORDER
 ;N C0CV2 ; SCRACTH SPACE FOR BUILDING SORTED ARRAY
 S C0CI="" ;
 F  S C0CI=$O(C0CTVARS(C0CI)) Q:C0CI=""  D  ; BY LINE NUMBER
 . S C0CX=C0CTVARS(C0CI) ;VARIABLE NAME
 . S $P(C0CX,"^",2)=C0CI ; LINE NUMBER IS SECOND PIECE
 . D PUSH^GPLXPATH("C0C2",C0CX) ; PUT ONTO ARRAY
 K @C0CPVARS
 M @C0CPVARS=C0C2
 Q
 ;
LOAD ; LOAD VARIABLE NAMES AND XPATH IN ^C0CDIC(170
 ; INITIAL LOAD OF THE CCR DICTIONARY
 ;
 N C0CDIC,C0CARY,C0CXML,C0CFDA,C0CI
 S C0CDIC="^C0CDIC(170," ; ROOT OF THE CCR DICTIONARY
 D GXPATH("C0CARY","C0CXML") ; FETCH THE VARIABLES AND XPATH INTO C0CARY
 ; C0CXML WILL CONTAIN THE TEMPLATE - NOT NEEDED FOR LOAD
 D PARY^GPLXPATH("C0CARY") ;TEST
 F C0CI=1:1:C0CARY(0) D  ; LOAD EACH VARIABLE
 . S C0CFDA(170,"+"_C0CI_",",.01)=$P(C0CARY(C0CI),"^",1) ; VAR NAME
 . S C0CFDA(170,"+"_C0CI_",",2)=$P(C0CARY(C0CI),"^",3) ; XPATH
 . D UPDATE^DIE("","C0CFDA")
 . I $D(^TMP("DIERR",$J)) U $P BREAK
 . W "LOADING:",C0CI," ",C0CARY(C0CI),!
 Q
 ;