GPLCCR ; CCDCCR/GPL - CCR MAIN PROCESSING; 6/6/08
 ;;0.1;CCDCCR;nopatch;noreleasedate
 ;
 ; EXPORT A CCR
 ;
EXPORT ; EXPORT ENTRY POINT FOR CCR
        ; Select a patient for real.
        S DIC=2,DIC(0)="AEMQ" D ^DIC
        I Y<1 Q ; EXIT
        S DFN=$P(Y,U,1) ; SET THE PATIENT
        N CCRGLO
        D CCRRPC(.CCRGLO,DFN,"CCR")
        S OARY=$NA(^TMP($J,DFN,"CCR",1))
        S ONAM="PAT_"_DFN_"_CCR_V1.xml"
        S ODIR="/home/glilly/CCROUT"
        D OUTPUT^GPLXPATH(OARY,ONAM,ODIR)
        Q
        ;
CCRRPC(CCRGRTN,DFN,CCRPART) ; RPC ENTRY POINT FOR CCR OUTPUT
        S DEBUG=0
        S TGLOBAL=$NA(^TMP($J,"TEMPLATE")) ; GLOBAL FOR STORING TEMPLATE
        S CCRGLO=$NA(^TMP($J,DFN,"CCR")) ; GLOBAL FOR BUILDING THE CCR
        S ACTGLO=$NA(^TMP($J,DFN,"ACTORS")); GLOBAL FOR ALL ACTORS IN CCR
        ; TO GET PART OF THE CCR RETURNED, PASS CCRPART="PROBLEMS" ETC
        S CCRGRTN=$NA(^TMP($J,DFN,CCRPART)) ; RTN GLO NM OF PART OR ALL OF CCR
        D LOAD^GPLCCR0(TGLOBAL)  ; LOAD THE CCR TEMPLATE
        D CP^GPLXPATH(TGLOBAL,CCRGLO) ; COPY THE TEMPLATE TO THE CCR GLOBAL
        ;
        ; DELETE THE BODY, ACTORS AND SIGNATURES SECTIONS FROM THE CCR GLOBAL
        ; THESE WILL BE POPULATED AFTER CALLS TO THE XPATH PROCESSING ROUTINES
        D REPLACE^GPLXPATH(CCRGLO,"","//ContinuityOfCareRecord/Body")
        D REPLACE^GPLXPATH(CCRGLO,"","//ContinuityOfCareRecord/Actors")
        D REPLACE^GPLXPATH(CCRGLO,"","//ContinuityOfCareRecord/Signatures")
        I DEBUG F I=1:1:@CCRGLO@(0) W @CCRGLO@(I),!
        ;
        D CCRHDR(CCRGLO,DFN) ; MAP HEADER VARIABLES
        S CCRXTAB="^TMP($J,""CCRSTEP"")" ; GLOBAL TO STORE CCR PROCESSING STEPS
        D INITSTPS(CCRXTAB) ; INITIALIZED CCR PROCESSING STEPS
        N I,XI,TAG,RTN,CALL,XPATH,IXML,OXML,INXML,CCRBLD
        F I=1:1:@CCRXTAB@(0)  D  ; PROCESS THE CCR BODY SECTIONS
        . S XI=@CCRXTAB@(I) ; CALL COPONENTS TO PARSE
        . S RTN=$P(XI,";",2) ; NAME OF ROUTINE TO CALL
        . S TAG=$P(XI,";",1) ; LABEL INSIDE ROUTINE TO CALL
        . S XPATH=$P(XI,";",3) ; XPATH TO XML TO PASS TO ROUTINE
        . D QUERY^GPLXPATH(TGLOBAL,XPATH,"INXML") ; EXTRACT XML TO PASS
        . S IXML="INXML"
        . S OXML=$P(XI,";",4) ; ARRAY FOR SECTION VALUES
        . ; W OXML,!
        . S CALL="D "_TAG_"^"_RTN_"(IXML,DFN,OXML)" ; SETUP THE CALL
        . W "RUNNING ",CALL,!
        . X CALL
        . ; NOW INSERT THE RESULTS IN THE CCR BUFFER
        . D INSERT^GPLXPATH(CCRGLO,OXML,"//ContinuityOfCareRecord/Body")
        . I DEBUG F GPLI=1:1:@OXML@(0) W @OXML@(GPLI),!
        . D ACTLST^GPLCCR(CCRGLO,ACTGLO)
        Q
        ;
INITSTPS(TAB)   ; INITIALIZE CCR PROCESSING STEPS
        ; TAB IS PASSED BY NAME
        ; W "TAB= ",TAB,!
        ; D PUSH^GPLXPATH(TAB,"EXTRACT;GPLVITALS;//ContinuityOfCareRecord/Body/VitalSigns;^TMP($J,DFN,""VITALS"")")
        D PUSH^GPLXPATH(TAB,"EXTRACT;GPLPROBS;//ContinuityOfCareRecord/Body/Problems;^TMP($J,DFN,""PROBLEMS"")")
        Q
         ;
CCRHDR(CXML,DFN) ; MAP HEADER VARIABLES: FROM, TO ECT
        N VMAP S VMAP=$NA(^TMP($J,DFN,"HEADER"))
        ; K @VMAP
        S @VMAP@("ACTORPATIENT")="ACTORPATIENT_"_DFN
        S @VMAP@("ACTORFROM")="ACTORPROVIDER_"_DUZ ; FROM DUZ - ???
        S @VMAP@("ACTORFROM2")="ACTORPROVIDER_"_DUZ ; NEED A BETTER WAY
        S @VMAP@("ACTORTO")="ACTORPATIENT_"_DFN  ; FOR TEST PURPOSES,
        ; THIS IS THE USE CASE FOR THE PHR WHERE "TO" IS THE PATIENT
        N CTMP
        D MAP^GPLXPATH(CXML,VMAP,"CTMP")
        D CP^GPLXPATH("CTMP",CXML)
        Q
        ;
ACTLST(AXML,ACTRTN) ; RETURN THE ACTOR LIST FOR THE XML IN AXML
        ; AXML AND ACTRTN ARE PASSED BY NAME
        N I,J,K
        K @ACTRTN ; CLEAR RETURN ARRAY
        F I=1:1:@AXML@(0) D  ; SCAN ALL LINES
        . I @AXML@(I)?.E1"<ActorID>".E D  ; THERE IS AN ACTOR ON THIS LINE
        . . S J=$P($P(@AXML@(I),"<ActorID>",2),"</ActorID>",1)
        . . W "<ActorID>=>",J,!
        . . S K(J)="" ; HASHING ACTOR TO GET RID OF MULTIPLES
        S I="" ; GOING TO $O THROUGH THE HASH
        F J=0:0 D  Q:$O(K(I))=""
        . S I=$O(K(I)) ; WALK THROUGH THE HASH OF ACTORS
        . D PUSH^GPLXPATH(ACTRTN,I) ; ADD THE ACTOR TO THE RETURN ARRAY
        Q
        ;
TEST   ; RUN ALL THE TEST CASES
      ;D TESTALL^GPLUNIT("GPLCCR")
      D ZTEST^GPLCCR("PROBLEMS")
      W "TESTING RETURNED FROM PROBLMES",!
      D ZTEST^GPLCCR("CCR")
      Q
      ;
ZTEST(WHICH) ; RUN ONE SET OF TESTS
      N ZTMP
      D ZLOAD^GPLUNIT("ZTMP","GPLCCR")
      D ZTEST^GPLUNIT(.ZTMP,WHICH)
      Q
      ;
TLIST ; LIST THE TESTS
      N ZTMP
      D ZLOAD^GPLUNIT("ZTMP","GPLCCR")
      D TLIST^GPLUNIT(.ZTMP)
      Q
      ;
;;><TEST>
;;><PROBLEMS>
;;>>>K GPL S GPL=""
;;>>>D CCRRPC^GPLCCR(.GPL,"2","PROBLEMS")
;;>>?@GPL@(@GPL@(0))="</Problems>"
;;><CCR>
;;>>>K GPL S GPL=""
;;>>>D CCRRPC^GPLCCR(.GPL,"2","CCR")
;;>>?@GPL@(@GPL@(0))="</ContinutiyOfCareRecord>"
;;><ACTLST>
;;>>>N TCCR
;;>>>D CCRRPC^GPLCCR(.TCCR,"2","CCR")
;;>>>D ACTLST^GPLCCR("TCCR","ACTTEST")
;;></TEST>
