C0CRNF   ; CCDCCR/GPL - Reference Name Format (RNF) utilities; 12/6/08
 ;;0.1;CCDCCR;nopatch;noreleasedate
 ;Copyright 2008 WorldVistA.  Licensed under the terms of the GNU
 ;General Public License See attached copy of the License.
 ;
 ;This program is free software; you can redistribute it and/or modify
 ;it under the terms of the GNU General Public License as published by
 ;the Free Software Foundation; either version 2 of the License, or
 ;(at your option) any later version.
 ;
 ;This program is distributed in the hope that it will be useful,
 ;but WITHOUT ANY WARRANTY; without even the implied warranty of
 ;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ;GNU General Public License for more details.
 ;
 ;You should have received a copy of the GNU General Public License along
 ;with this program; if not, write to the Free Software Foundation, Inc.,
 ;51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 ;
 W "This is the Reference Name Format (RNF) Utility Library ",!
 W !
 Q
 ;
FIELDS(C0CFRTN,C0CF) ; RETURNS AN ARRAY OF THE FIELDS IN FILE C0CF,
 ; C0CFRTN IS PASSED BY NAME, C0CF IS PASSED BY VALUE
 ;
 N C0CFI,C0CFJ ;INNER LOOP, OUTER LOOP
 N C0CFN ; FIELD NAME
 S C0CFI=0 S C0CFJ=C0CF
 K @C0CFRTN ; CLEAR THE RETURN ARRAY
 F  Q:C0CFJ'[C0CF  D ; FOR THE C0CF FILE AND ALL SUBFILES INCLUSIVE
 . ;W "1: "_C0CFJ," ",C0CFI,!
 . F  S C0CFI=$O(^DD(C0CFJ,C0CFI)) Q:+C0CFI=0  D  ; EVERY FIELD
 . . ;W "2: "_C0CFJ," ",C0CFI,!
 . . S C0CFN=$P(^DD(C0CFJ,C0CFI,0),"^",1) ;PULL FIELD NAME FROM ^DD
 . . ;W "N: ",C0CFN,!
 . . ;I C0CFN="STR" W C0CFN," ",C0CFJ,!
 . . I $D(@C0CFRTN@(C0CFN)) D  ; IS THIS A DUPLICATE?
 . . . W "DUPLICATE FOUND! ",C0CFJ," ",C0CFI," ",C0CFN,!,@C0CFRTN@(C0CFN),!
 . . . S @C0CFRTN@(C0CFN_"_"_C0CFJ)=C0CFJ_"^"_C0CFI
 . . E  S @C0CFRTN@(C0CFN)=C0CFJ_"^"_C0CFI
 . S C0CFJ=$O(^DD(C0CFJ)) ; NEXT SUBFILE
 Q
 ;
GET(GRTN,GFILE,GIEN,GNN) ; RETURN THE DICTIONARY RECORD GIEN IN ARRAY GRTN, PASSED
 ; BY NAME
 ;
 N C0CTMP,C0CI,C0CJ,C0CREF,C0CNAME
 I $D(GNN) I GNN="ALL" S C0CNN=0 ; NOT NON-NULL (ALL FIELDS TO BE RETURNED)
 E  S C0CNN=1 ; NON-NULL IS TRUE (ONLY POPULATED FIELDS RETURNED)
 S C0CREF=GIEN_"," ; OPEN ROOT REFERENCE INTO FILE
 D CLEAN^DILF ; MAKE SURE WE ARE CLEANED UP
 D GETS^DIQ(GFILE,C0CREF,"**","","C0CTMP")
 D FIELDS(GRTN,GFILE) ;GET ALL THE FIELD NAMES FOR THE FILE
 S (C0CI,C0CJ)=""
 F  S C0CJ=$O(C0CTMP(C0CJ)) Q:C0CJ=""  D  ; FOR ALL SUBFILES
 . S C0CREF=$O(C0CTMP(C0CJ,"")) ; RECORD REFERENCE
 . F  S C0CI=$O(C0CTMP(C0CJ,C0CREF,C0CI)) Q:C0CI=""  D  ; ARRAY OF FIELDS
 . . ;W C0CJ," ",C0CI,!
 . . S C0CNAME=$P(^DD(C0CJ,C0CI,0),"^",1) ;PULL THE FIELD NAME
 . . S C0CVALUE=C0CTMP(C0CJ,C0CREF,C0CI) ;
 . . I C0CVALUE["C0CTMP" S C0CVALUE=C0CTMP(C0CJ,C0CREF,C0CI,1) ;1ST LINE OF WP
 . . S $P(@GRTN@(C0CNAME),"^",3)=C0CVALUE ;RETURN VALUE IN P3
 I C0CNN D  ; IF ONLY NON-NULL VALUES ARE TO BE RETURNED
 . S C0CI=""
 . F  S C0CI=$O(@GRTN@(C0CI)) Q:C0CI=""  D  ; GO THROUGH THE WHOLE ARRAY
 . . I $P(@GRTN@(C0CI),"^",3)="" K @GRTN@(C0CI) ; KILL THE NULL ENTRIES
 Q
 ;
GET2(GRTN,GFILE,GREF,GNDX,GNN) ; NEW GET ;GPL ;RETURN THE DICTIONARY RECORD GIEN IN ARRAY GRTN, PASSED
 ; BY NAME
 ; GET IS AN EXTRINSIC WHICH RETURNS THE NEXT IEN AFTER THE CURRENT GIEN
 ; IF GREF IS "" THE FIRST RECORD IS OBTAINED
 ; IF GNDX IS NULL, GREF IS AN IEN FOR THE FILE
 ; GNDX IS THE INDEX TO USE TO OBTAIN THE IEN
 ; GREF IS THE VALUE FOR THE INDEX
 ; GANN= NOT NULL - IF GANN IS "ALL" THEN EVEN NULL FIELDS WILL BE RETURNED
 ; OTHERWISE, ONLY POPULATED FIELDS ARE RETURNED IN GRTN
 ; 
 ;
 N GIEN
 I '$D(GNDX) S GIEN=GREF ; IF NO INDEX USED, GREF IS THE IEN
 E  D  ; WE ARE USING AN INDEX
 . 
 N C0CTMP,C0CI,C0CJ,C0CREF,C0CNAME
 I $D(GNN) I GNN="ALL" S C0CNN=0 ; NOT NON-NULL (ALL FIELDS TO BE RETURNED)
 E  S C0CNN=1 ; NON-NULL IS TRUE (ONLY POPULATED FIELDS RETURNED)
 S C0CREF=GIEN_"," ; OPEN ROOT REFERENCE INTO FILE
 D CLEAN^DILF ; MAKE SURE WE ARE CLEANED UP
 D GETS^DIQ(GFILE,C0CREF,"**","","C0CTMP")
 D FIELDS(GRTN,GFILE) ;GET ALL THE FIELD NAMES FOR THE FILE
 S (C0CI,C0CJ)=""
 F  S C0CJ=$O(C0CTMP(C0CJ)) Q:C0CJ=""  D  ; FOR ALL SUBFILES
 . S C0CREF=$O(C0CTMP(C0CJ,"")) ; RECORD REFERENCE
 . F  S C0CI=$O(C0CTMP(C0CJ,C0CREF,C0CI)) Q:C0CI=""  D  ; ARRAY OF FIELDS
 . . ;W C0CJ," ",C0CI,!
 . . S C0CNAME=$P(^DD(C0CJ,C0CI,0),"^",1) ;PULL THE FIELD NAME
 . . S C0CVALUE=C0CTMP(C0CJ,C0CREF,C0CI) ;
 . . I C0CVALUE["C0CTMP" S C0CVALUE=C0CTMP(C0CJ,C0CREF,C0CI,1) ;1ST LINE OF WP
 . . S $P(@GRTN@(C0CNAME),"^",3)=C0CVALUE ;RETURN VALUE IN P3
 I C0CNN D  ; IF ONLY NON-NULL VALUES ARE TO BE RETURNED
 . S C0CI=""
 . F  S C0CI=$O(@GRTN@(C0CI)) Q:C0CI=""  D  ; GO THROUGH THE WHOLE ARRAY
 . . I $P(@GRTN@(C0CI),"^",3)="" K @GRTN@(C0CI) ; KILL THE NULL ENTRIES
 Q
 ;
GETALL(GARFLD,GARVAL,GAFILE,GACNT,GASTRT,GANN) ; RETURN FIELD MAP AND VALUES
 ; GARFLD, PASSED BY NAME, RETURNS FIELD MAP @GARFLD@("FIELDNAME")
 ; .. ANY FIELD USED BY ANY RECORD PROCESSED IS IN THE FIELD MAP
 ; .. GARFLD IS NOT INITIALIZED, SO MULTIPLE CALLS ARE CUMULATIVE
 ; .. IF GANN="ALL" THEN ALL FIELDS FOR THE FILE ARE IN THE FIELD MAP
 ; GARVAL, PASSED BY NAME, RETURNS VALUES AS @GARVAL@(IEN,"FIELDNAME")=VALUE
 ; .. FOR EVERY RECORD PROCESSED. IT IS NOT INITIALEZED SO IT IS CUMMULATIVE
 ; .. EVEN IF GANN="ALL" ONLY POPULATED FIELDS ARE RETURNED IN GARVAL
 ; .. NUL FIELDS CAN BE DETERMINED BY CHECKING GARFLD - THIS SAVES SPACE
 ; GARFILE IS THE FILE NUMBER TO BE PROCESSED. IT IS PASSED BY VALUE
 ; GARCNT IS THE NUMBER OF RECORDS TO PROCESS. IT IS PASSED BY VALUE
 ; .. IF GARCNT IS NULL, ALL RECORDS ARE PROCESSED
 ; GARSTRT IS THE IEN OF THE FIRST RECORD TO PROCESS. IT IS PASSED BY VALUE
 ; .. IF GARSTART IS NULL, PROCESSING STARTS AT THE FIRST RECORD
 ; GANN= NOT NULL - IF GANN IS "ALL" THEN EVEN NULL FIELDS WILL BE RETURNED
 ; OTHERWISE, ONLY POPULATED FIELDS ARE RETURNED IN GARFLD AND GARVAL
 N GATMP,GAI,GAF
 S GAF=$$FILEREF(GAFILE) ; GET CLOSED ROOT FOR THE FILE NUMBER GAFILE
 W GAF,!
 W $O(@GAF@(0)) ;
 S GAI=0 ;ITERATOR
 ; F  S GAI=$O(@GAF@
 Q
 ;
FILEREF(FNUM) ; EXTRINSIC THAT RETURNS A CLOSED ROOT FOR FILE NUMBER FNUM
 ;
 N C0CF 
 S C0CF=^DIC(FNUM,0,"GL") ;OPEN ROOT TO FILE
 S C0CF=$P(C0CF,",",1)_")" ; CLOSE THE ROOT
 Q C0CF
 ;
ZFILE(ZFN,ZTAB) ; EXTRINSIC TO RETURN FILE NUMBER FOR FIELD NAME PASSED
 ; BY VALUE IN ZFN. FILE NUMBER IS PIECE 1 OF @ZTAB@(ZFN)
 ; IF ZTAB IS NULL, IT DEFAULTS TO C0CA
 I '$D(ZTAB) S ZTAB="C0CA"
 Q $P(@ZTAB@(ZFN),"^",1)
ZFIELD(ZFN,ZTAB) ;EXTRINSIC TO RETURN FIELD NUMBER FOR FIELD NAME PASSED
 ; BY VALUE IN ZFN. FILE NUMBER IS PIECE 2 OF @ZTAB@(ZFN)
 ; IF ZTAB IS NULL, IT DEFAULTS TO C0CA
 I '$D(ZTAB) S ZTAB="C0CA"
 Q $P(@ZTAB@(ZFN),"^",2)
ZVALUE(ZFN,ZTAB) ;EXTRINSIC TO RETURN VALUE FOR FIELD NAME PASSED
 ; BY VALUE IN ZFN. FILE NUMBER IS PIECE 3 OF @ZTAB@(ZFN)
 ; IF ZTAB IS NULL, IT DEFAULTS TO C0CA
 I '$D(ZTAB) S ZTAB="C0CA"
 Q $P(@ZTAB@(ZFN),"^",3)
 ;