GPLCCR   ; CCDCCR/GPL - CCR MAIN PROCESSING; 6/6/08
 ;;0.1;CCDCCR;nopatch;noreleasedate
 ;Copyright 2008 WorldVistA.  Licensed under the terms of the GNU
 ;General Public License See attached copy of the License.
 ;
 ;This program is free software; you can redistribute it and/or modify
 ;it under the terms of the GNU General Public License as published by
 ;the Free Software Foundation; either version 2 of the License, or
 ;(at your option) any later version.
 ;
 ;This program is distributed in the hope that it will be useful,
 ;but WITHOUT ANY WARRANTY; without even the implied warranty of
 ;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ;GNU General Public License for more details.
 ;
 ;You should have received a copy of the GNU General Public License along
 ;with this program; if not, write to the Free Software Foundation, Inc.,
 ;51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 ;
 ; EXPORT A CCR
 ;
EXPORT   ; EXPORT ENTRY POINT FOR CCR
       ; Select a patient.
       S DIC=2,DIC(0)="AEMQ" D ^DIC
       I Y<1 Q  ; EXIT
       S DFN=$P(Y,U,1) ; SET THE PATIENT
       D XPAT(DFN,"","") ; EXPORT TO A FILE
       Q
       ;
XPAT(DFN,DIR,FN) ; EXPORT ONE PATIENT TO A FILE
       ; DIR IS THE DIRECTORY, DEFAULTS IF NULL TO ^TMP("GPLCCR","ODIR")
       ; FN IS FILE NAME, DEFAULTS IF NULL
       N CCRGLO,UDIR,UFN
       I '$D(DIR) S UDIR=""
       E  S UDIR=DIR
       I '$D(FN) S UFN=""
       E  S UFN=FN
       D CCRRPC(.CCRGLO,DFN,"CCR","","","")
       S OARY=$NA(^TMP("GPLCCR",$J,DFN,"CCR",1))
       S ONAM=UFN
       I UFN="" S ONAM="PAT_"_DFN_"_CCR_V1_0_10.xml"
       S ODIRGLB=$NA(^TMP("GPLCCR","ODIR"))
       I '$D(@ODIRGLB) D  ; IF NOT ODIR HAS BEEN SET
       . ;S @ODIRGLB="/home/glilly/CCROUT"
       . ;S @ODIRGLB="/home/cedwards/"
       . S @ODIRGLB="/opt/wv/p/"
       S ODIR=UDIR
       I UDIR="" S ODIR=@ODIRGLB
       N ZY
       S ZY=$$OUTPUT^GPLXPATH(OARY,ONAM,ODIR)
       W !,$P(ZY,U,2),!
       Q
       ;
DCCR(DFN) ; DISPLAY A CCR THAT HAS JUST BEEN EXTRACTED
    ;
    N G1
    S G1=$NA(^TMP("GPLCCR",$J,DFN,"CCR"))
    I $D(@G1@(0)) D  ; CCR EXISTS
    . D PARY^GPLXPATH(G1)
    E  W "CCR NOT CREATED, RUN D XPAT^GPLCCR(DFN,"""","""") FIRST",!
    Q
    ;
CCRRPC(CCRGRTN,DFN,CCRPART,TIME1,TIME2,HDRARY)  ;RPC ENTRY POINT FOR CCR OUTPUT
    ; CCRGRTN IS RETURN ARRAY PASSED BY NAME
    ; DFN IS PATIENT IEN
    ; CCRPART IS "CCR" FOR ENTIRE CCR, OR SECTION NAME FOR A PART
    ;   OF THE CCR BODY.. PARTS INCLUDE "PROBLEMS" "VITALS" ETC
    ; TIME1 IS STARTING TIME TO INCLUDE - NULL MEANS ALL
    ; TIME2 IS ENDING TIME TO INCLUDE TIME IS FILEMAN TIME
    ; - NULL MEANS NOW
    ; HDRARY IS THE HEADER ARRAY DEFINING THE "FROM" AND
    ;    "TO" VARIABLES
    ;    IF NULL WILL DEFAULT TO "FROM" DUZ AND "TO" DFN
    I '$D(DEBUG) S DEBUG=0
    S CCD=0 ; NEED THIS FLAG TO DISTINGUISH FROM CCD
    I '$D(TESTLAB) S TESTLAB=0 ; FLAG FOR TESTING RESULTS SECTION
    I '$D(TESTALERT) S TESTALERT=1 ; FLAG FOR TESTING ALERTS SECTION
    I '$D(TESTMEDS) S TESTMEDS=0 ; FLAG FOR TESTING CCRMEDS SECTION
    S TGLOBAL=$NA(^TMP("GPLCCR",$J,"TEMPLATE")) ; GLOBAL FOR STORING TEMPLATE
    S CCRGLO=$NA(^TMP("GPLCCR",$J,DFN,"CCR")) ; GLOBAL FOR BUILDING THE CCR
    S ACTGLO=$NA(^TMP("GPLCCR",$J,DFN,"ACTORS")) ; GLOBAL FOR ALL ACTORS
    ; TO GET PART OF THE CCR RETURNED, PASS CCRPART="PROBLEMS" ETC
    S CCRGRTN=$NA(^TMP("GPLCCR",$J,DFN,CCRPART)) ; RTN GLO NM OF PART OR ALL
    D LOAD^GPLCCR0(TGLOBAL)  ; LOAD THE CCR TEMPLATE
    D CP^GPLXPATH(TGLOBAL,CCRGLO) ; COPY THE TEMPLATE TO CCR GLOBAL
    ;
    ; DELETE THE BODY, ACTORS AND SIGNATURES SECTIONS FROM GLOBAL
    ; THESE WILL BE POPULATED AFTER CALLS TO THE XPATH ROUTINES
    D REPLACE^GPLXPATH(CCRGLO,"","//ContinuityOfCareRecord/Body")
    D REPLACE^GPLXPATH(CCRGLO,"","//ContinuityOfCareRecord/Actors")
    D REPLACE^GPLXPATH(CCRGLO,"","//ContinuityOfCareRecord/Signatures")
    I DEBUG F I=1:1:@CCRGLO@(0) W @CCRGLO@(I),!
    ;
    D HDRMAP(CCRGLO,DFN,HDRARY) ; MAP HEADER VARIABLES
    ;
    K ^TMP("GPLCCR",$J,"CCRSTEP") ; KILL GLOBAL PRIOR TO ADDING TO IT
    S CCRXTAB=$NA(^TMP("GPLCCR",$J,"CCRSTEP")) ; GLOBAL TO STORE CCR STEPS
    D INITSTPS(CCRXTAB) ; INITIALIZED CCR PROCESSING STEPS
    N PROCI,XI,TAG,RTN,CALL,XPATH,IXML,OXML,INXML,CCRBLD
    F PROCI=1:1:@CCRXTAB@(0)  D  ; PROCESS THE CCR BODY SECTIONS
    . S XI=@CCRXTAB@(PROCI) ; CALL COPONENTS TO PARSE
    . S RTN=$P(XI,";",2) ; NAME OF ROUTINE TO CALL
    . S TAG=$P(XI,";",1) ; LABEL INSIDE ROUTINE TO CALL
    . S XPATH=$P(XI,";",3) ; XPATH TO XML TO PASS TO ROUTINE
    . D QUERY^GPLXPATH(TGLOBAL,XPATH,"INXML") ; EXTRACT XML TO PASS
    . S IXML="INXML"
    . S OXML=$P(XI,";",4) ; ARRAY FOR SECTION VALUES
    . ; K @OXML ; KILL EXPECTED OUTPUT ARRAY
    . ; W OXML,!
    . S CALL="D "_TAG_"^"_RTN_"(IXML,DFN,OXML)" ; SETUP THE CALL
    . W "RUNNING ",CALL,!
    . X CALL
    . ; NOW INSERT THE RESULTS IN THE CCR BUFFER
    . I @OXML@(0)'=0 D  ; THERE IS A RESULT
    . . D INSERT^GPLXPATH(CCRGLO,OXML,"//ContinuityOfCareRecord/Body")
    . . I DEBUG F GPLI=1:1:@OXML@(0) W @OXML@(GPLI),!
    N ACTT,ATMP,ACTT2,ATMP2 ; TEMPORARY ARRAY SYMBOLS FOR ACTOR PROCESSING
    D ACTLST^GPLCCR(CCRGLO,ACTGLO) ; GEN THE ACTOR LIST
    D QUERY^GPLXPATH(TGLOBAL,"//ContinuityOfCareRecord/Actors","ACTT")
    D EXTRACT^GPLACTOR("ACTT",ACTGLO,"ACTT2")
    D INSINNER^GPLXPATH(CCRGLO,"ACTT2","//ContinuityOfCareRecord/Actors")
    N TRIMI,J,DONE S DONE=0
    F TRIMI=0:0 D  Q:DONE  ; DELETE UNTIL ALL EMPTY ELEMENTS ARE GONE
    . S J=$$TRIM^GPLXPATH(CCRGLO) ; DELETE EMPTY ELEMENTS
    . I DEBUG W "TRIMMED",J,!
    . I J=0 S DONE=1 ; DONE WHEN TRIM RETURNS FALSE
    Q
    ;
INITSTPS(TAB)  ; INITIALIZE CCR PROCESSING STEPS
    ; TAB IS PASSED BY NAME
    I DEBUG W "TAB= ",TAB,!
    ; ORDER FOR CCR IS PROBLEMS,FAMILYHISTORY,SOCIALHISTORY,MEDICATIONS,VITALSIGNS,RESULTS,HEALTHCAREPROVIDERS
    D PUSH^GPLXPATH(TAB,"EXTRACT;GPLPROBS;//ContinuityOfCareRecord/Body/Problems;^TMP(""GPLCCR"",$J,DFN,""PROBLEMS"")")
    D PUSH^GPLXPATH(TAB,"EXTRACT;CCRMEDS;//ContinuityOfCareRecord/Body/Medications;^TMP(""GPLCCR"",$J,DFN,""MEDICATIONS"")")
    D PUSH^GPLXPATH(TAB,"EXTRACT;GPLVITAL;//ContinuityOfCareRecord/Body/VitalSigns;^TMP(""GPLCCR"",$J,DFN,""VITALS"")")
    D PUSH^GPLXPATH(TAB,"MAP;GPLLABS;//ContinuityOfCareRecord/Body/Results;^TMP(""GPLCCR"",$J,DFN,""RESULTS"")")
    I TESTALERT D PUSH^GPLXPATH(TAB,"EXTRACT;GPLALERT;//ContinuityOfCareRecord/Body/Alerts;^TMP(""GPLCCR"",$J,DFN,""ALERTS"")")
    Q
    ;
HDRMAP(CXML,DFN,IHDR)   ; MAP HEADER VARIABLES: FROM, TO ECT
    N VMAP S VMAP=$NA(^TMP("GPLCCR",$J,DFN,"HEADER"))
    ; K @VMAP
    S @VMAP@("DATETIME")=$$FMDTOUTC^CCRUTIL($$NOW^XLFDT,"DT")
    ; I IHDR="" D  ; HEADER ARRAY IS NOT PROVIDED, USE DEFAULTS
    D  ; ALWAYS MAP THESE VARIABLES
    . S @VMAP@("ACTORPATIENT")="ACTORPATIENT_"_DFN
    . S @VMAP@("ACTORFROM")="ACTORORGANIZATION_"_DUZ ; FROM DUZ - ???
    . S @VMAP@("ACTORFROM2")="ACTORSYSTEM_1" ; SECOND FROM IS THE SYSTEM
    . S @VMAP@("ACTORTO")="ACTORPATIENT_"_DFN  ; FOR TEST PURPOSES
    . S @VMAP@("PURPOSEDESCRIPTION")="CEND PHR"  ; FOR TEST PURPOSES
    . S @VMAP@("ACTORTOTEXT")="Patient"  ; FOR TEST PURPOSES
    . ; THIS IS THE USE CASE FOR THE PHR WHERE "TO" IS THE PATIENT
    ;I IHDR'="" D  ; HEADER VALUES ARE PROVIDED
    ;. D CP^GPLXPATH(IHDR,VMAP) ; COPY HEADER VARIABLES TO MAP ARRAY
    N CTMP
    D MAP^GPLXPATH(CXML,VMAP,"CTMP")
    D CP^GPLXPATH("CTMP",CXML)
    N HRIMVARS ;
    S HRIMVARS=$NA(^TMP("GPLRIM","VARS",DFN,"HEADER")) ; TO PERSIST VARS
    M @HRIMVARS@(1)=@VMAP ; PERSIST THE HEADER VARIABLES IN RIM TABLE
    S @HRIMVARS@(0)=1 ; ONLY ONE SET OF HEADERS PER PATIENT
    Q
    ;
ACTLST(AXML,ACTRTN) ; RETURN THE ACTOR LIST FOR THE XML IN AXML
    ; AXML AND ACTRTN ARE PASSED BY NAME
    ; EACH ACTOR RECORD HAS 3 PARTS - IE IF OBJECTID=ACTORPATIENT_2
    ; P1= OBJECTID - ACTORPATIENT_2
    ; P2= OBJECT TYPE - PATIENT OR PROVIDER OR SOFTWARE
    ;OR INSTITUTION
    ;  OR PERSON(IN PATIENT FILE IE NOK)
    ; P3= IEN RECORD NUMBER FOR ACTOR - 2
    N I,J,K,L
    K @ACTRTN ; CLEAR RETURN ARRAY
    F I=1:1:@AXML@(0) D  ; SCAN ALL LINES
    . I @AXML@(I)?.E1"<ActorID>".E D  ; THERE IS AN ACTOR THIS LINE
    . . S J=$P($P(@AXML@(I),"<ActorID>",2),"</ActorID>",1)
    . . I DEBUG W "<ActorID>=>",J,!
    . . I J'="" S K(J)="" ; HASHING ACTOR
    . . ;  TO GET RID OF DUPLICATES
    S I="" ; GOING TO $O THROUGH THE HASH
    F J=0:0 D  Q:$O(K(I))=""
    . S I=$O(K(I)) ; WALK THROUGH THE HASH OF ACTORS
    . S $P(L,U,1)=I ; FIRST PIECE IS THE OBJECT ID
    . S $P(L,U,2)=$P($P(I,"ACTOR",2),"_",1) ; ACTOR TYPE
    . S $P(L,U,3)=$P(I,"_",2) ; IEN RECORD NUMBER FOR ACTOR
    . D PUSH^GPLXPATH(ACTRTN,L) ; ADD THE ACTOR TO THE RETURN ARRAY
    Q
    ;
TEST ; RUN ALL THE TEST CASES
  D TESTALL^GPLUNIT("GPLCCR")
  Q
  ;
ZTEST(WHICH)  ; RUN ONE SET OF TESTS
  N ZTMP
  D ZLOAD^GPLUNIT("ZTMP","GPLCCR")
  D ZTEST^GPLUNIT(.ZTMP,WHICH)
  Q
  ;
TLIST  ; LIST THE TESTS
  N ZTMP
  D ZLOAD^GPLUNIT("ZTMP","GPLCCR")
  D TLIST^GPLUNIT(.ZTMP)
  Q
  ;
 ;;><TEST>
 ;;><PROBLEMS>
 ;;>>>K GPL S GPL=""
 ;;>>>D CCRRPC^GPLCCR(.GPL,"2","PROBLEMS","","","")
 ;;>>?@GPL@(@GPL@(0))["</Problems>"
 ;;><VITALS>
 ;;>>>K GPL S GPL=""
 ;;>>>D CCRRPC^GPLCCR(.GPL,"2","VITALS","","","")
 ;;>>?@GPL@(@GPL@(0))["</VitalSigns>"
 ;;><CCR>
 ;;>>>K GPL S GPL=""
 ;;>>>D CCRRPC^GPLCCR(.GPL,"2","CCR","","","")
 ;;>>?@GPL@(@GPL@(0))["</ContinuityOfCareRecord>"
 ;;><ACTLST>
 ;;>>>K GPL S GPL=""
 ;;>>>D CCRRPC^GPLCCR(.GPL,"2","CCR","","","")
 ;;>>>D ACTLST^GPLCCR(GPL,"ACTTEST")
 ;;><ACTORS>
 ;;>>>D ZTEST^GPLCCR("ACTLST")
 ;;>>>D QUERY^GPLXPATH(TGLOBAL,"//ContinuityOfCareRecord/Actors","G2")
 ;;>>>D EXTRACT^GPLACTOR("G2","ACTTEST","G3")
 ;;>>?G3(G3(0))["</Actors>"
 ;;><TRIM>
 ;;>>>D ZTEST^GPLCCR("CCR")
 ;;>>>W $$TRIM^GPLXPATH(CCRGLO)
 ;;><ALERTS>
 ;;>>>S TESTALERT=1
 ;;>>>K GPL S GPL=""
 ;;>>>D CCRRPC^GPLCCR(.GPL,"2","ALERTS","","","")
 ;;>>?@GPL@(@GPL@(0))["</Alerts>"

