GPLIMMU ; CCDCCR/GPL - CCR/CCD PROCESSING FOR IMMUNIZATIONS ; 2/2/09
 ;;0.1;CCDCCR;nopatch;noreleasedate;Build 7
 ;Copyright 2008 WorldVistA.  Licensed under the terms of the GNU
 ;General Public License See attached copy of the License.
 ;
 ;This program is free software; you can redistribute it and/or modify
 ;it under the terms of the GNU General Public License as published by
 ;the Free Software Foundation; either version 2 of the License, or
 ;(at your option) any later version.
 ;
 ;This program is distributed in the hope that it will be useful,
 ;but WITHOUT ANY WARRANTY; without even the implied warranty of
 ;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ;GNU General Public License for more details.
 ;
 ;You should have received a copy of the GNU General Public License along
 ;with this program; if not, write to the Free Software Foundation, Inc.,
 ;51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 ;
 ;
 ; PROCESS THE IMMUNIZATIONS SECTION OF THE CCR
 ;
EXTRACT(IPXML,DFN,OUTXML) ; EXTRACT IMMUNIZATIONS INTO VARIABLES
 ;
 ; INXML AND OUTXML ARE PASSED BY NAME SO GLOBALS CAN BE USED
 ; INXML WILL CONTAIN ONLY THE PROBLEM SECTION OF THE OVERALL TEMPLATE
 ; ONLY THE XML FOR ONE PROBLEM WILL BE PASSED. THIS ROUTINE WILL MAKE
 ; COPIES AS NECESSARY TO REPRESENT MULTIPLE PROBLEMS
 ; INSERT^GPLXPATH IS USED TO APPEND THE PROBLEMS TO THE OUTPUT
 ;
 N RPCRSLT,J,K,PTMP,X,VMAP,TBU
 S TVMAP=$NA(^TMP("GPLCCR",$J,"IMMUVALS"))
 S TARYTMP=$NA(^TMP("GPLCCR",$J,"IMMUARYTMP"))
 S IMMA=$NA(^TMP("PXI",$J)) ;
 K @IMMA ; CLEAR OUT PREVIOUS RESULTS
 K @TVMAP,@TARYTMP ; KILL OLD ARRAY VALUES
 D IMMUN^PXRHS03(DFN) ;
 I $O(@IMMA@(""))="" D  Q  ; RPC RETURNS NULL
 . W "NULL RESULT FROM IMMUN^PXRHS03 ",!
 . S @OUTXML@(0)=0
 ;S @TVMAP@(0)=RPCRSLT(0) ; SAVE NUMBER OF PROBLEMS
 N C0CIM,C0CC,C0CIMD,C0CIEN,C0CT ; 
 S C0CIM=""
 S C0CC=0 ; COUNT
 F  S C0CIM=$O(@IMMA@(C0CIM)) Q:C0CIM=""  D  ; FOR EACH IMMUNE TYPE IN THE LIST
 . S C0CC=C0CC+1 ;INCREMENT COUNT
 . S @TVMAP@(0)=C0CC ; SAVE NEW COUNT TO ARRAY
 . S VMAP=$NA(@TVMAP@(C0CC)) ; THIS IMMUNE ELEMENT
 . K @VMAP ; MAKE SURE IT IS CLEARED OUT
 . W C0CIM,!
 . S C0CIMD="" ; IMMUNE DATE
 . F  S C0CIMD=$O(@IMMA@(C0CIM,C0CIMD)) Q:C0CIMD=""  D  ; FOR EACH DATE
 . . S C0CIEN=$O(@IMMA@(C0CIM,C0CIMD,"")) ;IEN OF IMMUNE RECORD
 . . D GETN^C0CRNF("C0CI",9000010.11,C0CIEN) ; GET THE FILEMAN RECORD TO PULL IENS
 . . W C0CIEN,"_",C0CIMD
 . . S C0CT=$$FMDTOUTC^CCRUTIL(9999999-C0CIMD,"DT") ; FORMAT DATE/TIME
 . . W C0CT,!
 . . S @VMAP@("IMMUNEOBJECTID")="IMMUNIZATION_"_C0CC ;UNIQUE OBJECT ID
 . . S @VMAP@("IMMUNEDATETIMETYPETEXT")="Immunization Date" ; ALL ARE THE SAME
 . . S @VMAP@("IMMUNEDATETIME")=C0CT ;FORMATTED DATE/TIME
 . . S C0CIP=$$ZVALUEI^C0CRNF("ENCOUNTER PROVIDER","C0CI") ;IEN OF PROVIDER
 . . S @VMAP@("IMMUNESOURCEACTORID")="ACTORPROVIDOR_"_C0CIP
 . . S C0CIIEN=$$ZVALUEI^C0CRNF("IMMUNIZATION","C0CI") ;IEN OF IMMUNIZATION
 . . ; FOR LOOKING UP THE CODE (TBD GPL)
 . . S C0CIN=$$ZVALUE^C0CRNF("IMMUNIZATION","C0CI") ;NAME OF IMMUNIZATION
 . . ; GET IT FROM THE CODE FILE CHANGE THIS (TBD GPL)
 . . S @VMAP@("IMMUNEPRODUCTNAMETEXT")=C0CIN ;NAME
 . . S @VMAP@("IMMUNEPRODUCTCODE")="" ;FIX THIS
 . . S @VMAP@("IMMUNEPRODUCTCODESYSTEM")="" ;FIX THIS
 B
 Q
 . S VMAP=$NA(@TVMAP@(J))
 . K @VMAP
 . I DEBUG W "VMAP= ",VMAP,!
 . S PTMP=RPCRSLT(J) ; PULL OUT PROBLEM FROM RPC RETURN ARRAY
 . S @VMAP@("PROBLEMOBJECTID")="PROBLEM"_J ; UNIQUE OBJID FOR PROBLEM
 . S @VMAP@("PROBLEMIEN")=$P(PTMP,U,1)
 . S @VMAP@("PROBLEMSTATUS")=$S($P(PTMP,U,2)="A":"Active",1:"")
 . S @VMAP@("PROBLEMDESCRIPTION")=$P(PTMP,U,3)
 . S @VMAP@("PROBLEMCODINGVERSION")=""
 . S @VMAP@("PROBLEMCODEVALUE")=$P(PTMP,U,4)
 . S @VMAP@("PROBLEMDATEOFONSET")=$$FMDTOUTC^CCRUTIL($P(PTMP,U,5),"DT")
 . S @VMAP@("PROBLEMDATEMOD")=$$FMDTOUTC^CCRUTIL($P(PTMP,U,6),"DT")
 . S @VMAP@("PROBLEMSC")=$P(PTMP,U,7)
 . S @VMAP@("PROBLEMSE")=$P(PTMP,U,8)
 . S @VMAP@("PROBLEMCONDITION")=$P(PTMP,U,9)
 . S @VMAP@("PROBLEMLOC")=$P(PTMP,U,10)
 . S @VMAP@("PROBLEMLOCTYPE")=$P(PTMP,U,11)
 . S @VMAP@("PROBLEMPROVIDER")=$P(PTMP,U,12)
 . S X=@VMAP@("PROBLEMPROVIDER") ; FORMAT Y;NAME Y IS IEN OF PROVIDER
 . S @VMAP@("PROBLEMSOURCEACTORID")="ACTORPROVIDER_"_$P(X,";",1)
 . S @VMAP@("PROBLEMSERVICE")=$P(PTMP,U,13)
 . S @VMAP@("PROBLEMHASCMT")=$P(PTMP,U,14)
 . S @VMAP@("PROBLEMDTREC")=$$FMDTOUTC^CCRUTIL($P(PTMP,U,15),"DT")
 . S @VMAP@("PROBLEMINACT")=$$FMDTOUTC^CCRUTIL($P(PTMP,U,16),"DT")
 . S ARYTMP=$NA(@TARYTMP@(J))
 . ; W "ARYTMP= ",ARYTMP,!
 . K @ARYTMP
 . D MAP^GPLXPATH(IPXML,VMAP,ARYTMP) ;
 . I J=1 D  ; FIRST ONE IS JUST A COPY
 . . ; W "FIRST ONE",!
 . . D CP^GPLXPATH(ARYTMP,OUTXML)
 . . ; W "OUTXML ",OUTXML,!
 . I J>1 D  ; AFTER THE FIRST, INSERT INNER XML
 . . D INSINNER^GPLXPATH(OUTXML,ARYTMP)
 ; ZWR ^TMP("GPLCCR",$J,"PROBVALS",*)
 ; ZWR ^TMP("GPLCCR",$J,"PROBARYTMP",*) ; SHOW THE RESULTS
 ; ZWR @OUTXML
 ; $$HTML^DILF(
 ; GENERATE THE NARITIVE HTML FOR THE CCD
 I CCD D  ; IF THIS IS FOR A CCD
 . N HTMP,HOUT,HTMLO,GPLPROBI,ZX
 . F GPLPROBI=1:1:RPCRSLT(0) D  ; FOR EACH PROBLEM
 . . S VMAP=$NA(@TVMAP@(GPLPROBI))
 . . I DEBUG W "VMAP =",VMAP,!
 . . D QUERY^GPLXPATH(TGLOBAL,"//ContinuityOfCareRecord/Body/PROBLEMS-HTML","HTMP") ; GET THE HTML FROM THE TEMPLATE
 . . D UNMARK^GPLXPATH("HTMP") ; REMOVE <PROBLEMS-HTML> MARKUP
 . . ; D PARY^GPLXPATH("HTMP") ; PRINT IT
 . . D MAP^GPLXPATH("HTMP",VMAP,"HOUT") ; MAP THE VARIABLES
 . . ; D PARY^GPLXPATH("HOUT") ; PRINT IT AGAIN
 . . I GPLPROBI=1 D  ; FIRST ONE IS JUST A COPY
 . . . D CP^GPLXPATH("HOUT","HTMLO")
 . . I GPLPROBI>1 D  ; AFTER THE FIRST, INSERT INNER HTML
 . . . I DEBUG W "DOING INNER",!
 . . . N HTMLBLD,HTMLTMP
 . . . D QUEUE^GPLXPATH("HTMLBLD","HTMLO",1,HTMLO(0)-1)
 . . . D QUEUE^GPLXPATH("HTMLBLD","HOUT",2,HOUT(0)-1)
 . . . D QUEUE^GPLXPATH("HTMLBLD","HTMLO",HTMLO(0),HTMLO(0))
 . . . D BUILD^GPLXPATH("HTMLBLD","HTMLTMP")
 . . . D CP^GPLXPATH("HTMLTMP","HTMLO")
 . . . ; D INSINNER^GPLXPATH("HOUT","HTMLO","//")
 . I DEBUG D PARY^GPLXPATH("HTMLO")
 . D INSB4^GPLXPATH(OUTXML,"HTMLO") ; INSERT AT TOP OF SECTION
 N PROBSTMP,I
 D MISSING^GPLXPATH(ARYTMP,"PROBSTMP") ; SEARCH XML FOR MISSING VARS
 I PROBSTMP(0)>0  D  ; IF THERE ARE MISSING VARS -
 . ; STRINGS MARKED AS @@X@@
 . W !,"PROBLEMS Missing list: ",!
 . F I=1:1:PROBSTMP(0) W PROBSTMP(I),!
 Q
 ;
