CCRMEDS3 ; WV/CCDCCR/SMH - Meds: Non-VA/Outside Meds for Vista
 ;;0.1;CCDCCR;;;
 ;;Last Modified: Sun Jan 11 05:45:03 UTC 2009
 ; Copyright 2009 WorldVistA.  Licensed under the terms of the GNU
 ; General Public License See attached copy of the License.
 ;
 ; This program is free software; you can redistribute it and/or modify
 ; it under the terms of the GNU General Public License as published by
 ; the Free Software Foundation; either version 2 of the License, or
 ; (at your option) any later version.
 ;
 ; This program is distributed in the hope that it will be useful,
 ; but WITHOUT ANY WARRANTY; without even the implied warranty of
 ; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ; GNU General Public License for more details.
 ;
 ; You should have received a copy of the GNU General Public License along
 ; with this program; if not, write to the Free Software Foundation, Inc.,
 ; 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 ;
 W "NO ENTRY FROM TOP",!
 Q
 ;
EXTRACT(MINXML,DFN,OUTXML) ; Extract medications into provided xml template
 ;
 ; MINXML is the Input XML Template, passed by name
 ; DFN is Patient IEN
 ; OUTXML is the resultant XML.
 ;
 ; MEDS is return array from RPC.
 ; MAP is a mapping variable map (store result) for each med
 ; MED is holds each array element from MEDS, one medicine
 ;
 ; Non-VA meds don't have an API. They are stored in file 55, subfile 52.2
 ; Discontinued meds are indicated by the presence of a value in fields
 ; 5 or 6 (STATUS 1 or 2, and DISCONTINUED DATE)
 ; Will use Fileman API GETS^DIQ
 ;
 N MEDS,MAP
 K ^TMP($J,"CCDCCR") ; PLEASE DON'T KILL ALL OF ^TMP($J) HERE!!!!
 K NVA
 D GETS^DIQ(55,DFN,"52.2*","IE","NVA") ; Output in NVA in FDA array format.
 ; If NVA does not exist, then patient has no non-VA meds
 I $D(NVA)=0 S @OUTXML@(0)=0 QUIT
 ; Otherwise, we go on...
 M MEDS=NVA(55.05)
 ; We are done with NVA
 K NVA
 ;
 I DEBUG ZWR MEDS
 N FDAIEN S FDAIEN=0 ; For use in $Order in the MEDS array.
 S MEDMAP=$NA(^TMP("GPLCCR",$J,"MEDMAP"))
 N MEDCOUNT S MEDCOUNT=@MEDMAP@(0) ; We already have meds in the array
 N MEDFIRST S MEDFIRST=1 ; FLAG FOR FIRST MED PROCESSED HERE
 F  S FDAIEN=$O(MEDS(FDAIEN)) Q:FDAIEN=""  D  ; FOR EACH MEDICATION IN THE LIST
 . N MED M MED=MEDS(FDAIEN)
 . I MED(5,"I")!MED(6,"I") QUIT  ; If disconinued, we don't want to pull it.
 . S MEDCOUNT=MEDCOUNT+1
 . S MAP=$NA(^TMP("GPLCCR",$J,"MEDMAP",MEDCOUNT))
 . S @MEDMAP@(0)=@MEDMAP@(0)+1 ; INCREMENT TOTAL MEDS IN VAR ARRAY
 . N RXIEN S RXIEN=$P(FDAIEN,",") ; First piece of FDAIEN is the number of the med for this patient
 . I DEBUG W "RXIEN IS ",RXIEN,!
 . I DEBUG W "MAP= ",MAP,!
 . S @MAP@("MEDOBJECTID")="MED_OUTSIDE"_MEDCOUNT ; MEDCOUNT FOR ID
 . S @MAP@("MEDISSUEDATETXT")="Documented Date"
 . ; Field 6 is "Effective date", and we pull it in timson format w/ I
 . S @MAP@("MEDISSUEDATE")=$$FMDTOUTC^C0CUTIL(MED(11,"I"),"DT")
 . ; Med never filled; next 4 fields are not applicable.
 . S @MAP@("MEDLASTFILLDATETXT")=""
 . S @MAP@("MEDLASTFILLDATE")=""
 . S @MAP@("MEDRXNOTXT")=""
 . S @MAP@("MEDRXNO")=""
 . S @MAP@("MEDTYPETEXT")="Medication"
 . S @MAP@("MEDDETAILUNADORNED")=""  ; Leave blank, field has its uses
 . S @MAP@("MEDSTATUSTEXT")="ACTIVE" ; nearest status for pending meds
 . S @MAP@("MEDSOURCEACTORID")="ACTORPROVIDER_"_MED(12,"I")
 . S @MAP@("MEDPRODUCTNAMETEXT")=MED(.01,"E")
 . ; NDC is field 31 in the drug file.
 . ; The actual drug entry in the drug file (MEDIEN) is not necessarily supplied.
 . ; It' node 1, internal form.
 . N MEDIEN S MEDIEN=MED(1,"I")
 . I +MEDIEN D  ; start of if/else block
 . . ; 12/30/08: I will be using RxNorm for coding...
 . . ; 176.001 is the file for Concepts; 176.003 is the file for
 . . ; sources (i.e. for RxNorm Version)
 . . ;
 . . ; We need the VUID first for the National Drug File entry first
 . . ; We get the VUID of the drug, by looking up the VA Product entry
 . . ; (file 50.68) using the call NDF^PSS50, returned in node 22.
 . . ; Field 99.99 is the VUID.
 . . ;
 . . ; We use the VUID to look up the RxNorm in file 176.001; same idea.
 . . ; Get IEN first using $$FIND1^DIC, then get the RxNorm number by
 . . ; $$GET1^DIQ.
 . . ;
 . . ; I get the RxNorm name and version from the RxNorm Sources (file
 . . ; 176.003), by searching for "RXNORM", then get the data.
 . . D NDF^PSS50(MEDIEN,,,,,"NDF")
 . . N NDFDATA M NDFDATA=^TMP($J,"NDF",MEDIEN)
 . . N NDFIEN S NDFIEN=$P(NDFDATA(20),U)
 . . N VAPROD S VAPROD=$P(NDFDATA(22),U)
 . . ;
 . . ; NDFIEN is not necessarily defined; it won't be if the drug
 . . ; is not matched to the national drug file (e.g. if the drug is
 . . ; new on the market, compounded, or is a fake drug [blue pill].
 . . ; To protect against failure, I will put an if/else block
 . . N VUID,RXNIEN,RXNORM,SRCIEN,RXNNAME,RXNVER
 . . I NDFIEN,$D(^C0CRXN) D  ; $Data is for Systems that don't have our RxNorm file yet.
 . . . S VUID=$$GET1^DIQ(50.68,VAPROD,99.99)
 . . . S RXNIEN=$$FIND1^DIC(176.001,,,VUID,"VUID")
 . . . S RXNORM=$$GET1^DIQ(176.001,RXNIEN,.01)
 . . . S SRCIEN=$$FIND1^DIC(176.003,,"B","RXNORM")
 . . . S RXNNAME=$$GET1^DIQ(176.003,SRCIEN,6)
 . . . S RXNVER=$$GET1^DIQ(176.003,SRCIEN,7)
 . . ;
 . . E  S (RXNORM,RXNNAME,RXNVER)=""
 . . ; End if/else block
 . . S @MAP@("MEDPRODUCTNAMECODEVALUE")=RXNORM
 . . S @MAP@("MEDPRODUCTNAMECODINGINGSYSTEM")=RXNNAME
 . . S @MAP@("MEDPRODUCTNAMECODEVERSION")=RXNVER
 . . ;
 . . S @MAP@("MEDBRANDNAMETEXT")=""
 . . D DOSE^PSS50(MEDIEN,,,,,"DOSE")
 . . N DOSEDATA M DOSEDATA=^TMP($J,"DOSE",MEDIEN)
 . . S @MAP@("MEDSTRENGTHVALUE")=DOSEDATA(901)
 . . S @MAP@("MEDSTRENGTHUNIT")=$P(DOSEDATA(902),U,2)
 . . ; Units, concentration, etc, come from another call
 . . ; $$CPRS^PSNAPIS which returns dosage-form^va class^strengh^unit
 . . ; This call takes nodes 1 and 3 of ^PSDRUG(D0,"ND") as parameters
 . . ; NDF Entry IEN, and VA Product Name
 . . ; These can be obtained using NDF^PSS50 (IEN,,,,,"SUBSCRIPT")
 . . ; Documented in the same manual; executed above.
 . . ;
 . . ; If a drug was not matched to NDF, then the NDFIEN is gonna be ""
 . . ; and this will crash the call. So...
 . . I NDFIEN="" S CONCDATA=""
 . . E  S CONCDATA=$$CPRS^PSNAPIS(NDFIEN,VAPROD)
 . . S @MAP@("MEDFORMTEXT")=$P(CONCDATA,U,1)
 . . S @MAP@("MEDCONCVALUE")=$P(CONCDATA,U,3)
 . . S @MAP@("MEDCONCUNIT")=$P(CONCDATA,U,4)
 . . S @MAP@("MEDQUANTITYVALUE")=""  ; not provided for in Non-VA meds.
 . . ; Oddly, there is no easy place to find the dispense unit.
 . . ; It's not included in the original call, so we have to go to the drug file.
 . . ; That would be DATA^PSS50(IEN,,,,,"SUBSCRIPT")
 . . ; Node 14.5 is the Dispense Unit
 . . D DATA^PSS50(MEDIEN,,,,,"QTY")
 . . N QTYDATA M QTYDATA=^TMP($J,"QTY",MEDIEN)
 . . S @MAP@("MEDQUANTITYUNIT")=QTYDATA(14.5)
 . E  D
 . . S @MAP@("MEDPRODUCTNAMECODEVALUE")=""
 . . S @MAP@("MEDPRODUCTNAMECODINGINGSYSTEM")=""
 . . S @MAP@("MEDPRODUCTNAMECODEVERSION")=""
 . . S @MAP@("MEDBRANDNAMETEXT")=""
 . . S @MAP@("MEDSTRENGTHVALUE")=""
 . . S @MAP@("MEDSTRENGTHUNIT")=""
 . . S @MAP@("MEDFORMTEXT")=""
 . . S @MAP@("MEDCONCVALUE")=""
 . . S @MAP@("MEDCONCUNIT")=""
 . . S @MAP@("MEDSIZETEXT")=""
 . . S @MAP@("MEDQUANTITYVALUE")=""
 . . S @MAP@("MEDQUANTITYUNIT")=""
 . ; End If/Else
 . ; --- START OF DIRECTIONS ---
 . ; Dosage is field 2, route is 3, schedule is 4
 . ; These are all free text fields, and don't point to any files
 . ; For that reason, I will use the field I never used before:
 . ; MEDDIRECTIONDESCRIPTIONTEXT
 . S DIRCNT=1 ; THERE IS ONLY ONE DIRECTION FOR OUTSIDE MEDS
 . S @MAP@("M","DIRECTIONS",1,"MEDDIRECTIONDESCRIPTIONTEXT")=MED(2,"E")_" "_MED(3,"E")_" "_MED(4,"E")
 . S @MAP@("M","DIRECTIONS",1,"MEDDOSEINDICATOR")="4"  ; means look in description text. See E2369-05.
 . S @MAP@("M","DIRECTIONS",1,"MEDDELIVERYMETHOD")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDDOSEVALUE")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDDOSEUNIT")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDRATEVALUE")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDRATEUNIT")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDVEHICLETEXT")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDDIRECTIONROUTETEXT")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDFREQUENCYVALUE")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDINTERVALVALUE")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDINTERVALUNIT")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDDURATIONVALUE")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDDURATIONUNIT")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDPRNFLAG")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDPROBLEMOBJECTID")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDPROBLEMTYPETXT")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDPROBLEMDESCRIPTION")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDPROBLEMCODEVALUE")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDPROBLEMCODINGSYSTEM")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDPROBLEMCODINGVERSION")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDPROBLEMSOURCEACTORID")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDSTOPINDICATOR")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDDIRSEQ")=""
 . S @MAP@("M","DIRECTIONS",1,"MEDMULDIRMOD")=""
 . ;
 . ; --- END OF DIRECTIONS ---
 . ;
 . ; S @MAP@("MEDPTINSTRUCTIONS","F")="52.41^105"
 . I $D(MED(10,1)) D  ;
 . . S @MAP@("MEDPTINSTRUCTIONS")=MED(10,1) ; WP Field
 . E  S @MAP@("MEDPTINSTRUCTIONS")=""
 . I $D(MED(14,1)) D  ;
 . . S @MAP@("MEDFULLFILLMENTINSTRUCTIONS")=MED(14,1) ; WP Field
 . E  S @MAP@("MEDFULLFILLMENTINSTRUCTIONS")=""
 . S @MAP@("MEDRFNO")=""
 . N RESULT S RESULT=$NA(^TMP("GPLCCR",$J,"MAPPED"))
 . K @RESULT
 . D MAP^GPLXPATH(MINXML,MAP,RESULT)
 . ; D PARY^GPLXPATH(RESULT)
 . ; MAPPING DIRECTIONS
 . N MEDDIR1,DIRXML1 S DIRXML1="MEDDIR1" ; VARIABLE AND NAME VARIABLE TEMPLATE
 . N MEDDIR2,DIRXML2 S DIRXML2="MEDDIR2" ; VARIABLE AND NAME VARIABLE RESULT
 . D QUERY^GPLXPATH(MINXML,"//Medications/Medication/Directions",DIRXML1)
 . D REPLACE^GPLXPATH(RESULT,"","//Medications/Medication/Directions")
 . ; N MDZ1,MDZNA
 . I DIRCNT>0 D  ; IF THERE ARE DIRCTIONS
 . . F MDZ1=1:1:DIRCNT  D  ; FOR EACH DIRECTION
 . . . S MDZNA=$NA(@MAP@("M","DIRECTIONS",MDZ1))
 . . . D MAP^GPLXPATH(DIRXML1,MDZNA,DIRXML2)
 . . . D INSERT^GPLXPATH(RESULT,DIRXML2,"//Medications/Medication")
 . I MEDFIRST D  ;
 . . S MEDFIRST=0 ; RESET FIRST FLAG
 . . D CP^GPLXPATH(RESULT,OUTXML) ; First one is a copy
 . D:'MEDFIRST INSINNER^GPLXPATH(OUTXML,RESULT) ; AFTER FIRST, INSERT INNER XML
 N MEDTMP,MEDI
 D MISSING^GPLXPATH(OUTXML,"MEDTMP") ; SEARCH XML FOR MISSING VARS
 I MEDTMP(0)>0 D  ; IF THERE ARE MISSING VARS - MARKED AS @@X@@
 . W "MEDICATION MISSING ",!
 . F MEDI=1:1:MEDTMP(0) W MEDTMP(MEDI),!
 Q
 ;
