C0CMED	; WV/CCDCCR/GPL/SMH - CCR/CCD Medications Driver; Mar 23 2009
	;;0.5;CCDCCR;;JUL 16,2008;
	; Copyright 2008,2009 George Lilly, University of Minnesota and Sam Habiel.
	; Licensed under the terms of the GNU General Public License.
	; See attached copy of the License.
	; 
	; This program is free software; you can redistribute it and/or modify
	; it under the terms of the GNU General Public License as published by
	; the Free Software Foundation; either version 2 of the License, or
	; (at your option) any later version.
	; 
	; This program is distributed in the hope that it will be useful,
	; but WITHOUT ANY WARRANTY; without even the implied warranty of
	; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	; GNU General Public License for more details.
	; 
	; You should have received a copy of the GNU General Public License along
	; with this program; if not, write to the Free Software Foundation, Inc.,
	; 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
	;
	; --Revision History
	; July 2008 - Initial Version/GPL
	; July 2008 - March 2009 various revisions
	; March 2009 - Reconstruction of routine as driver for other med routines/SMH
	;
	Q
EXTRACT(MEDXML,DFN,MEDOUTXML)	; Private; Extract medications into provided XML template
	; DFN passed by reference
	; MEDXML and MEDOUTXML are passed by Name
	; MEDXML is the input template
	; MEDOUTXML is the output template
	; Both of them refer to ^TMP globals where the XML documents are stored
	; 
	; -- This ep is the driver for extracting medications into the provided XML template
	; 1. VA Outpatient Meds are in C0CMED1
	; 2. VA Pending Meds are in C0CMED2
	; 3. VA non-VA Meds are in C0CMED3
	; 4. VA Inpatient IV Meds are in C0CMED4 (not functional)
	; 5. VA Inpatient UD Meds are in C0CMED5 (doesn't exist yet)--March 2009
	; 6. RPMS Meds are in C0CMED6. Need to create other routines for subdivisions of RPMS Meds is not known at this time.
	;
	; --Prep variables	
	D:$$RPMS^C0CUTIL() RPMS QUIT
	D:($$VISTA^C0CUTIL())!($$WV^C0CUTIL()) VISTA QUIT
	D EXTRACT^C0CMED1(MEDXML,DFN,MEDOUTXML) ; FIRST EXTRACT OUTPATIENT MEDS
	I @MEDOUTXML@(0)>0 D  ; C0CMED FOUND ACTIVE OP MEDS
	. W "HAS ACTIVE OP MEDS",!
	N PENDINGXML
	S PENDINGXML="MEDPENDING" ;NAME FOR ARRAY
	D EXTRACT^C0CMED2(MEDXML,DFN,PENDINGXML) ; FIRST EXTRACT OUTPATIENT MEDS
	I @PENDINGXML@(0)>0 D  ; C0CMED FOUND PENDING OP MEDS
	. I @MEDOUTXML@(0)>0 D  ; IF WE NEED TO COMBINE MEDS
	. . D INSINNER^C0CXPATH(MEDOUTXML,PENDINGXML) ;ADD PENDING TO ACTIVE
	. E  D CP^C0CXPATH(PENDINGXML,MEDOUTXML) ; NO ACTIVE MEDS, JUST COPY
	. W "HAS OP PENDING MEDS",!
	N PENDINGXML
	S PENDINGXML="MEDPENDING" ;NAME FOR ARRAY
	D EXTRACT^C0CMED3(MEDXML,DFN,PENDINGXML) ; FIRST EXTRACT OUTPATIENT MEDS
	I @PENDINGXML@(0)>0 D  ; C0CMED FOUND PENDING OP MEDS
	. I @MEDOUTXML@(0)>0 D  ; IF WE NEED TO COMBINE MEDS
	. . D INSINNER^C0CXPATH(MEDOUTXML,PENDINGXML) ;ADD NON-VA TO MEDS
	. E  D CP^C0CXPATH(PENDINGXML,MEDOUTXML) ; NO PREVIOUS MEDS, JUST COPY
	. W:$G(DEBUG) "HAS NON-VA MEDS",!
	Q
	; Extraction Sections
RPMS
	D EXTRACT^C0CMED6(MEDXML,DFN,MEDOUTXML) QUIT
VISTA
	
