C0CLA7Q	;WV/JMC - CCD/CCR Lab HL7 Query Utility ;Apr 13, 2009
	;;n.n;;****;
	;
	;
	Q
	;
	;
LAB(C0CPTID,C0CSDT,C0CEDT,C0CSC,C0CSPEC,C0CERR,C0CDEST,C0CHL7)	; Entry point for Lab Result Query
	;
	;
	K ^TMP("C0C-VLAB",$J)
	;
	; Check and retrieve lab results from LAB DATA file (#63)
	D GCPR^LA7QRY($G(C0CPTID),$G(C0CSDT),$G(C0CEDT),.C0CSC,.C0CSPEC,.C0CERR,$G(C0CDEST),$G(C0CHL7))
	;
	; If V LAB file present then check for lab results that are only in this file
	; If results found in V Lab file then build results and add to above results.
	I $D(^AUPNVLAB) D
	. D VCHECK
	. I $D(^TMP("C0C-VLAB",$J,3)) D VBUILD
	;
	;K ^TMP("C0C-VLAB",$J)
	;
	Q C0CDEST
	;
	;
VCHECK	; If V LAB file present then check for lab results that are only in this file.
	;
	N C0CDA,C0CEND,C0CROOT,C0CVLAB,LA7PTID,LA7SCRC,LA7SPEC,TMP
	;
	S LA7PTID=C0CPTID
	D PATID^LA7QRY2
	I $D(LA7ERR) Q
	;
	; Resolve search codes to lab datanames
	S LA7SCSRC=$G(C0CSC)
	S TMP=$$SCLIST^LA7QRY2(LA7SCSRC)
	Q:$D(LA7ERR) ""
	S LA7SC=TMP  D:LA7SC'="*" CHKSC^LA7QRY1
	;
	; Convert specimen codes to file #61 Topography entries
	S LA7SPEC=$G(C0CSPEC)
	I LA7SPEC'="*"  D SPEC^LA7QRY1
	;
	S C0CROOT="^AUPNVLAB(""ALR4"",DFN,COCSDT)",C0CEND=0
	;
	F  S C0CROOT=$Q(@C0CROOT) Q:C0CROOT=""  D  Q:C0CEND
	. I $QS(C0CROOT,1)'="ALR4"!($QS(C0CROOT,2)'=DFN) S C0CEND=1 Q  ; Left x-ref or patient
	. I $QS(C0CROOT,3)>C0CEDT S C0CEND=1 Q  ; Exceeded end date/time
	. S C0CDA=$QS(C0CROOT,6)
	. I $D(^TMP("C0C-VLAB",$J,1,C0CDA)) Q  ; Already checked during scan of file #63
	. D VCHK1
	;
	;
	Q
	;
	;
VBUILD	; Build results found only in V LAB file into HL7 structure.
	;
	;
	Q
	;
	;
LNCHK	; Check for corresponding entry in V LAB file and related LOINC code for a result in file #63.
	; Call from LA7QRY2
	;
	N DFN,C0C60,C0C63,C0CACC,C0CDA,C0CDT,C0CLN,X
	;
	S DFN=$P(^LR(LRDFN,0),"^",3)
	S C0C63(0)=^LR(LRDFN,LRSS,LRIDT,0)
	S C0CDT=$P(C0C63(0),"^"),C0CACC=$P(C0C63(0),"^",6)
	;
	; ^AUPNVLAB("ALR1",5380,3080307.211055,"EKT 0307 48",188,5427202)=""
	;
	S C0C60=0,C0CLN=""
	F  S C0C60=$O(^LAB(60,"C",LRSS_";"_LRSB_";1",C0C60)) Q:'C0C60  D  Q:C0CLN'=""
	. S C0CDA=$O(^AUPNVLAB("ALR1",DFN,C0CDT,C0CACC,C0C60,0))
	. I C0CDA<1 Q
	. S C0CLN=$P($G(^AUPNVLAB(C0CDA,11)),"^",13)
	. S ^TMP("C0C-VLAB",$J,1,C0CDA)=""
	. S ^TMP("C0C-VLAB",$J,2,LRDFN,LRSS,LRIDT,LRSB)=C0CLN_"^"_C0CDA
	;
	; If LOINC found then update variable with LN code
	I C0CLN'="" D
	. S X=$P(LA7X,"^",3)
	. I $P(X,"!",3)="" S $P(X,"!",3)=C0CLN
	. S $P(LA7X,"^",3)=X
	;
	Q
	;
	;
VCHK1	; Check the entry in V Lab to determine if it meets criteria
	;
	N C0CVLAB,I
	;
	F I=0,12 S C0CVLAB(I)=^AUPNVLAB(C0CDA,I)
	;
	; JMC 04/13/09 - Store anything for now that meets date criteria.
	D VSTORE
	;
	Q
	;
	;
VSTORE	; Store entry for building in HL7 message when parent is from V LAB file.
	;
	N PARENT
	;
	; Determine parent test to use for OBR segment
	S PARENT=$P(C0CVLAB(12),"^",8)
	I PARENT="" S PARENT=$P(C0CVLAB(0),"^")
	;
	;                                patient ien 
	;                                |                 collection date/time
	;                                |                 |             parent test (ordered test)
	;                                |                 |             |      ien of entry in V LAB file
	;                                |                 |             |      |
	S ^TMP("C0C-VLAB",$J,3,$P(C0CVLAB(0),"^",2),$P(C0CVLAB(12),"^"),PARENT,C0CDA)=""
	;
	Q
