C0CBAT   ; CCDCCR/GPL - CCR Batch utilities; 4/21/09
 ;;0.1;CCDCCR;nopatch;noreleasedate
 ;Copyright 2009 George Lilly.  Licensed under the terms of the GNU
 ;General Public License See attached copy of the License.
 ;
 ;This program is free software; you can redistribute it and/or modify
 ;it under the terms of the GNU General Public License as published by
 ;the Free Software Foundation; either version 2 of the License, or
 ;(at your option) any later version.
 ;
 ;This program is distributed in the hope that it will be useful,
 ;but WITHOUT ANY WARRANTY; without even the implied warranty of
 ;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ;GNU General Public License for more details.
 ;
 ;You should have received a copy of the GNU General Public License along
 ;with this program; if not, write to the Free Software Foundation, Inc.,
 ;51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 ;
 W "This is the CCR Batch Utility Library ",!
 Q
 ;
EN ; BATCH ENTRY POINT
 ; PROCESSES THE SUBSCRIPTION FILE, EXTRACTING CCR VARIABLES FOR EACH
 ; PATIENT WITH AN ACTIVE SUBSCRIPTION, AND IF CHECKSUMS INDICATE A CHANGE,
 ; GENERATES A NEW CCR FOR THE PATIENT
 ; UPDATES THE E2 CCR ELEMENTS FILE
 ;
 S C0CQT=1 ; QUIET MODE
 S C0CBDT=$$NOW^XLFDT ; DATE OF THIS RUN
 S C0CBF=177.301 ; FILE NUMBER OF C0C BATCH CONTROL FILE
 S C0CBB=$NA(^TMP("C0CBATCH",C0CBDT)) ; BATCH WORK AREA
 I $D(@C0CBB@(0)) D  ; ERROR SHOULDN'T EXIST
 . W "WORK AREA ERROR",!
 . B
 S @C0CBB@(0)="V21" ; VERSION USED TO CREATE THIS WORK AREA
 S C0CBH=$NA(@C0CBB@("HOTLIST")) ; BASE FOR HOT LIST
 S C0CBS=$NA(^C0CS("B")) ; SUBSCRIPTION LIST BASE
 D BLDHOT(C0CBH) ; BUILD THE HOT LIST
 S C0CHN=$$COUNT(C0CBH) ;COUNT NUMBER IN HOT LIST
 S C0CSN=$$COUNT(C0CBS) ;COUNT NUMBER OF PATIENTS WITH SUBSCRIPTIONS
 S C0CFDA(C0CBF,"+1,",.01)=C0CBDT ; DATE KEY OF BATCH CONTROL
 S C0CFDA(C0CBF,"+1,",.02)=C0CBDT ; BATCH ID IS DATE IN STRING FORM
 S C0CFDA(C0CBF,"+1,",1)=C0CSN ; TOTAL SUBSCRIPTIONS
 S C0CFDA(C0CBF,"+1,",2)=C0CHN ; TOTAL HOT LIST
 D UPDIE ; CREATE THE BATCH RECORD
 S C0CIEN=$O(^C0CB("B",C0CBDT,""))
 S (C0CN,C0CNH)=0 ; COUNTERS FOR TOTAL AND HOT LIST
 S C0CBCUR="" ; CURRENT PATIENT
 ;F  S C0CBCUR=$O(@C0CBH@(C0CBCUR),-1) Q:C0CBCUR=""  D  ; HOT LIST LATEST FIRST
 F  S C0CBCUR=$O(@C0CBH@(C0CBCUR)) Q:C0CBCUR=""  D  ; HOT LIST FIRST FIRST
 . D ANALYZE^C0CRIMA(C0CBCUR,1,"LABLIMIT:T-760^VITLIMIT:T-760")
 . D PUTRIM^C0CFM2(C0CBCUR)
 . I $G(C0CCHK) D XPAT^C0CCCR(C0CBCUR) ; IF VARIABLES HAVE CHANGED GENERATE CCR
 . S C0CN=C0CN+1 ; INCREMENT NUMBER IN TOTAL
 . S C0CNH=C0CNH+1 ; INCREMENT HOT LIST TOTAL
 . S C0CFDA(C0CBF,C0CIEN_",",1.1)=C0CN ;UPDATE TOTAL PROGRESS
 . S C0CFDA(C0CBF,C0CIEN_",",2.1)=C0CNH ; UPDATE HOT LIST PROGRESS
 . S C0CNOW=$$NOW^XLFDT
 . S C0CFDA(C0CBF,C0CIEN_",",4)=C0CNOW
 . S C0CELPS=$$FMDIFF^XLFDT(C0CNOW,C0CBDT,2) ; DIFFERENCE IN SECONDS
 . S C0CAVG=C0CELPS/C0CN ; AVERAGE ELAPSED TIME
 . S C0CFDA(C0CBF,C0CIEN_",",4.1)=C0CAVG
 . S C0CETOT=C0CAVG*C0CSN ; EST TOT ELASPSED TIME 
 . S C0CEST=$$FMADD^XLFDT(C0CBDT,0,0,0,C0CETOT) ; ADD SECONDS TO BATCH START
 . S C0CFDA(C0CBF,C0CIEN_",",4.2)=C0CEST ;ESTIMATED COMPLETION TIME
 . D UPDIE ; 
 F  S C0CBCUR=$O(@C0CBS@(C0CBCUR)) Q:C0CBCUR=""  D  ; REMAINING SUBSCRIPTION LIST
 . I $D(@C0CBH@(C0CBCUR)) Q  ; SKIP IF IN HOT LIST - ALREADY DONE
 . D ANALYZE^C0CRIMA(C0CBCUR,1,"LABLIMIT:T-760^VITLIMIT:T-760")
 . D PUTRIM^C0CFM2(C0CBCUR)
 . I $G(C0CCHK) D XPAT^C0CCCR(C0CBCUR) ; IF VARIABLES HAVE CHANGED GENERATE CCR
 . S C0CN=C0CN+1 ; INCREMENT NUMBER IN TOTAL
 . S C0CFDA(C0CBF,C0CIEN_",",1.1)=C0CN ;UPDATE TOTAL PROGRESS
 . S C0CNOW=$$NOW^XLFDT
 . S C0CFDA(C0CBF,C0CIEN_",",4)=C0CNOW
 . S C0CELPS=$$FMDIFF^XLFDT(C0CNOW,C0CBDT,2) ; DIFFERENCE IN SECONDS
 . S C0CAVG=C0CELPS/C0CN ; AVERAGE ELAPSED TIME
 . S C0CFDA(C0CBF,C0CIEN_",",4.1)=C0CAVG
 . S C0CETOT=C0CAVG*C0CSN ; EST TOT ELASPSED TIME 
 . S C0CEST=$$FMADD^XLFDT(C0CBDT,0,0,0,C0CETOT) ; ADD SECONDS TO BATCH START
 . S C0CFDA(C0CBF,C0CIEN_",",4.2)=C0CEST ;ESTIMATED COMPLETION TIME
 . D UPDIE ; 
 Q
 ;
BLDHOT(ZHB) ; BUILD HOT LIST AT GLOBAL ZHB, PASSED BY NAME
 ; SEARCHS FOR PATIENTS IN THE "AC" INDEX OF THE ORDER FILE
 N ZDFN
 S ZDFN=""
 F  S ZDFN=$O(^OR(100,"AC",ZDFN)) Q:ZDFN=""  D  ; ALL PATIENTS IN THE AC INDX
 . S ZZDFN=$P(ZDFN,";",1) ; FORMAT IS "N;DPT("
 . I '$D(@C0CBS@(ZZDFN)) Q  ; SKIP IF NOT IN SUBSCRIPTION LIST
 . S @ZHB@(ZZDFN)="" ;ADD PATIENT TO THE HOT LIST
 Q
 ;
COUNT(ZB) ; EXTRINSIC THAT RETURNS THE NUMBER OF ARRAY ELEMENTS
 N ZI,ZN
 S ZN=0
 S ZI=""
 F  S ZI=$O(@ZB@(ZI)) Q:ZI=""  D  ;
 . S ZN=ZN+1
 Q ZN
 ;
UPDIEVARPTR(ZVAR,ZTYP) ;EXTRINSIC WHICH RETURNS THE POINTER TO ZVAR IN THE
 ; CCR DICTIONARY. IT IS LAYGO, AS IT WILL ADD THE VARIABLE TO
 ; THE CCR DICTIONARY IF IT IS NOT THERE. ZTYP IS REQUIRED FOR LAYGO
 ;
 N ZCCRD,ZVARN,C0CFDA2
 S ZCCRD=170 ; FILE NUMBER FOR CCR DICTIONARY
 S ZVARN=$O(^C0CDIC(170,"B",ZVAR,"")) ;FIND IEN OF VARIABLE
 I ZVARN="" D  ; VARIABLE NOT IN CCR DICTIONARY - ADD IT
 . I '$D(ZTYP) D  Q  ; WON'T ADD A VARIABLE WITHOUT A TYPE
 . . W "CANNOT ADD VARIABLE WITHOUT A TYPE: ",ZVAR,!
 . S C0CFDA2(ZCCRD,"?+1,",.01)=ZVAR ; NAME OF NEW VARIABLE
 . S C0CFDA2(ZCCRD,"?+1,",12)=ZTYP ; TYPE EXTERNAL OF NEW VARIABLE
 . D CLEAN^DILF ;MAKE SURE ERRORS ARE CLEAN
 . D UPDATE^DIE("E","C0CFDA2","","ZERR") ;ADD VAR TO CCR DICTIONARY
 . I $D(ZERR) D  ; LAYGO ERROR
 . . W "ERROR ADDING "_ZC0CI_" TO CCR DICTIONARY",!
 . E  D  ;
 . . D CLEAN^DILF ; CLEAN UP
 . . S ZVARN=$O(^C0CDIC(170,"B",ZVAR,"")) ;FIND IEN OF VARIABLE
 . . W "ADDED ",ZVAR," TO CCR DICTIONARY, IEN:",ZVARN,!
 Q ZVARN
 ;
UPDIE ; INTERNAL ROUTINE TO CALL UPDATE^DIE AND CHECK FOR ERRORS
 K ZERR
 D CLEAN^DILF
 D UPDATE^DIE("","C0CFDA","","ZERR")
 I $D(ZERR) D  ;
 . W "ERROR",!
 . ZWR ZERR
 . B
 K C0CFDA
 Q
 ;
SETFDA(C0CSN,C0CSV) ; INTERNAL ROUTINE TO MAKE AN FDA ENTRY FOR FIELD C0CSN
 ; TO SET TO VALUE C0CSV.
 ; C0CFDA,C0CC,C0CZX ARE ASSUMED FROM THE CALLING ROUTINE
 ; C0CSN,C0CSV ARE PASSED BY VALUE
 ;
 N C0CSI,C0CSJ
 S C0CSI=$$ZFILE(C0CSN,"C0CC") ; FILE NUMBER
 S C0CSJ=$$ZFIELD(C0CSN,"C0CC") ; FIELD NUMBER
 S C0CFDA(C0CSI,C0CZX_",",C0CSJ)=C0CSV
 Q
ZFILE(ZFN,ZTAB) ; EXTRINSIC TO RETURN FILE NUMBER FOR FIELD NAME PASSED
 ; BY VALUE IN ZFN. FILE NUMBER IS PIECE 1 OF C0CA(ZFN)
 ; IF ZTAB IS NULL, IT DEFAULTS TO C0CA
 I '$D(ZTAB) S ZTAB="C0CA"
 N ZR
 I $D(@ZTAB@(ZFN)) S ZR=$P(@ZTAB@(ZFN),"^",1)
 E  S ZR=""
 Q ZR
ZFIELD(ZFN,ZTAB) ;EXTRINSIC TO RETURN FIELD NUMBER FOR FIELD NAME PASSED
 ; BY VALUE IN ZFN. FILE NUMBER IS PIECE 2 OF C0CA(ZFN)
 ; IF ZTAB IS NULL, IT DEFAULTS TO C0CA
 I '$D(ZTAB) S ZTAB="C0CA"
 N ZR
 I $D(@ZTAB@(ZFN)) S ZR=$P(@ZTAB@(ZFN),"^",2)
 E  S ZR=""
 Q ZR
 ;
ZVALUE(ZFN,ZTAB) ;EXTRINSIC TO RETURN VALUE FOR FIELD NAME PASSED
 ; BY VALUE IN ZFN. FILE NUMBER IS PIECE 3 OF C0CA(ZFN)
 ; IF ZTAB IS NULL, IT DEFAULTS TO C0CA
 I '$D(ZTAB) S ZTAB="C0CA"
 N ZR
 I $D(@ZTAB@(ZFN)) S ZR=$P(@ZTAB@(ZFN),"^",3)
 E  S ZR=""
 Q ZR
 ;
