//kt -- Modified with SourceScanner on 8/26/2007
unit fConsultAlertTo;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ORCtrls, ORfn, ExtCtrls, DKLang;

type
  TfrmConsultAlertsTo = class(TForm)
    cmdOK: TButton;
    cmdCancel: TButton;
    cboSrcList: TORComboBox;
    DstList: TORListBox;
    SrcLabel: TLabel;
    DstLabel: TLabel;
    pnlBase: TORAutoPanel;
    DKLanguageController1: TDKLanguageController;
    procedure cboSrcListNeedData(Sender: TObject; const StartFrom: String;
      Direction, InsertAt: Integer);
    procedure cmdOKClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
    //procedure cboSrcListdblClick(Sender: TObject);
    procedure cboSrcListKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure DstListClick(Sender: TObject);
    procedure cboSrcListMouseClick(Sender: TObject);
  private
    FActionType: integer;
    FRecipients: string ;
    FChanged: Boolean;
  end;

TRecipientList = record
    Changed: Boolean;
    Recipients: string ;
  end;

procedure SelectRecipients(FontSize: Integer; ActionType: integer; var RecipientList: TRecipientList) ;

implementation

{$R *.DFM}

uses rConsults, rCore, uCore, uConsults, fConsults;

//const
//TX_RCPT_TEXT = 'Select recipients or press Cancel.';  <-- original line.  //kt 8/26/2007
//TX_RCPT_CAP = 'No Recipients Selected';  <-- original line.  //kt 8/26/2007
//TX_REQ_TEXT = 'The requesting provider is always included in this type of alert';  <-- original line.  //kt 8/26/2007
//TX_REQ_CAP = 'Cannot Remove Recipient';  <-- original line.  //kt 8/26/2007

var
  TX_RCPT_TEXT : string; //kt
  TX_RCPT_CAP : string; //kt
  TX_REQ_TEXT : string; //kt
  TX_REQ_CAP : string; //kt

procedure SetupVars;
//kt Added entire function to replace constant declarations 8/26/2007
begin
  TX_RCPT_TEXT := DKLangConstW('fConsultAlertTo_Select_recipients_or_press_Cancelx');
  TX_RCPT_CAP := DKLangConstW('fConsultAlertTo_No_Recipients_Selected');
  TX_REQ_TEXT := DKLangConstW('fConsultAlertTo_The_requesting_provider_is_always_included_in_this_type_of_alert');
  TX_REQ_CAP := DKLangConstW('fConsultAlertTo_Cannot_Remove_Recipient');
end;

procedure SelectRecipients(FontSize: Integer; ActionType: integer; var RecipientList: TRecipientList) ;
{ displays recipients select form for consults and returns a record of the selection }
var
  frmConsultAlertsTo: TfrmConsultAlertsTo;
begin
  frmConsultAlertsTo := TfrmConsultAlertsTo.Create(Application);
  try
    ResizeAnchoredFormToFont(frmConsultAlertsTo);
    with frmConsultAlertsTo do
    begin
      FActionType := ActionType;
      FChanged := False;
      cboSrcList.InitLongList('');
(*      cboSrcList.InitLongList(ConsultRec.SendingProviderName);
      cboSrcList.SelectByIEN(ConsultRec.SendingProvider);
      cboSrcListMouseClick(cboSrcList) ;*)
      ShowModal;
      with RecipientList do
        begin
          Recipients := Recipients + FRecipients ;
          Changed := FChanged ;
        end ;
    end; {with frmConsultAlertsTo}
  finally
    frmConsultAlertsTo.Release;
  end;
end;

procedure TfrmConsultAlertsTo.cboSrcListNeedData(Sender: TObject;
  const StartFrom: String; Direction, InsertAt: Integer);
begin
  (Sender as TORComboBox).ForDataUse(SubSetOfPersons(StartFrom, Direction));
end;

procedure TfrmConsultAlertsTo.cmdCancelClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmConsultAlertsTo.cmdOKClick(Sender: TObject);
var
  i: integer ;
begin
  SetupVars;  //kt added 8/26/2007 to replace constants with vars.
  if DstList.Items.Count = 0 then
  begin
    InfoBox(TX_RCPT_TEXT, TX_RCPT_CAP, MB_OK or MB_ICONWARNING);
    FChanged := False ;
    Exit;
  end;
  FChanged := True;
  for i := 0 to DstList.Items.Count-1 do
      FRecipients := Piece(DstList.Items[i],u,1) + ';' + FRecipients;
  Close;
end;

(*procedure TfrmConsultAlertsTo.cboSrcListdblClick(Sender: TObject);
begin
     if cboSrcList.ItemIndex = -1 then exit ;
     if DstList.SelectByID(cboSrcList.ItemID) = -1 then
       DstList.Items.Add(cboSrcList.Items[cboSrcList.Itemindex]) ;
end;*)

procedure TfrmConsultAlertsTo.DstListClick(Sender: TObject);
begin
  SetupVars;  //kt added 8/26/2007 to replace constants with vars.
     if DstList.ItemIndex = -1 then exit ;
(*     if (DstList.ItemIEN = ConsultRec.SendingProvider) and
        ((FActionType = CN_ACT_SIGFIND) or (FActionType = CN_ACT_ADMIN_COMPLETE)) then
       begin
         InfoBox(TX_REQ_TEXT, TX_REQ_CAP, MB_OK or MB_ICONWARNING);
         exit ;
       end ;*)
     DstList.Items.Delete(DstList.ItemIndex) ;
end;

procedure TfrmConsultAlertsTo.cboSrcListKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then cboSrcListMouseClick(Self);
end;

procedure TfrmConsultAlertsTo.cboSrcListMouseClick(Sender: TObject);
begin
     if cboSrcList.ItemIndex = -1 then exit ;
     if DstList.SelectByID(cboSrcList.ItemID) = -1 then
       DstList.Items.Add(cboSrcList.Items[cboSrcList.Itemindex]) ;
end;

end.
