//kt -- Modified with SourceScanner on 8/8/2007
unit fODRadApproval;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ORCtrls, ORfn, ExtCtrls, DKLang;

type
  TfrmODRadApproval = class(TForm)
    cmdOK: TButton;
    cmdCancel: TButton;
    cboRadiologist: TORComboBox;
    SrcLabel: TLabel;
    pnlBase: TORAutoPanel;
    DKLanguageController1: TDKLanguageController;
    procedure cmdOKClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
  private
    FRadiologist: string ;
    FChanged: Boolean;
  end;

procedure SelectApprovingRadiologist(FontSize: Integer; var Radiologist: string) ;

implementation

{$R *.DFM}

uses rODRad, rCore, uCore;

//const
//TX_RAD_TEXT = 'Select radiologist or press Cancel.';  <-- original line.  //kt 8/8/2007
//TX_RAD_CAP = 'No Radiologist Selected';  <-- original line.  //kt 8/8/2007

var
  TX_RAD_TEXT  : string;  //kt
  TX_RAD_CAP   : string;  //kt

procedure SetupVars;
//kt Added entire function to replace constant declarations 8/8/2007
begin
  TX_RAD_TEXT := DKLangConstW('fODRadApproval_Select_radiologist_or_press_Cancelx');
  TX_RAD_CAP := DKLangConstW('fODRadApproval_No_Radiologist_Selected');
end;
 
procedure SelectApprovingRadiologist(FontSize: Integer; var Radiologist: string);
{ displays radiologist selection form and returns a record of the selection }
var
  frmODRadApproval: TfrmODRadApproval;
  W, H: Integer;
begin
  frmODRadApproval := TfrmODRadApproval.Create(Application);
  try
    with frmODRadApproval do
    begin
      Font.Size := FontSize;
      W := ClientWidth;
      H := ClientHeight;
      ResizeToFont(FontSize, W, H);
      ClientWidth  := W; pnlBase.Width  := W;
      ClientHeight := H; pnlBase.Height := H;
      FChanged := False;
      cboRadiologist.Items.Assign(SubsetOfRadiologists);
      ShowModal;
      Radiologist := FRadiologist ;
    end; {with frmODRadApproval}
  finally
    frmODRadApproval.Release;
  end;
end;

procedure TfrmODRadApproval.cmdCancelClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmODRadApproval.cmdOKClick(Sender: TObject);
begin
  SetupVars;  //kt added 8/8/2007 to replace constants with vars.
  if cboRadiologist.ItemIEN = 0 then
  begin
    InfoBox(TX_RAD_TEXT, TX_RAD_CAP, MB_OK or MB_ICONWARNING);
    FChanged := False ;
    Exit;
  end;
  FChanged := True;
  FRadiologist := cboRadiologist.Items[cboRadiologist.ItemIndex] ;
  Close;
end;

end.
