//kt -- Modified with SourceScanner on 8/8/2007
unit fODRadConShRes;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ORCtrls, ORfn, ExtCtrls, DKLang;

type
  TfrmODRadConShRes = class(TForm)
    cmdOK: TButton;
    cmdCancel: TButton;
    cboSource: TORComboBox;
    SrcLabel: TLabel;
    pnlBase: TORAutoPanel;
    txtResearch: TCaptionEdit;
    DKLanguageController1: TDKLanguageController;
    procedure cmdOKClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
  private
    FSource: string  ;
    FChanged: Boolean;
  end;

procedure SelectSource(FontSize: Integer; SrcType: char; var Source: string) ;

implementation

{$R *.DFM}

uses rODRad, rCore, uCore;

//const
//TX_CS_TEXT = 'Select Source, or press Cancel.';  <-- original line.  //kt 8/8/2007
//TX_CS_CAP = 'No Source';  <-- original line.  //kt 8/8/2007
//TX_R_TEXT = 'Enter Source (3-40 characters), or press Cancel.';  <-- original line.  //kt 8/8/2007
//TX_R_CAP = 'No Source';  <-- original line.  //kt 8/8/2007

var
  TX_CS_TEXT  : string;  //kt
  TX_CS_CAP   : string;  //kt
  TX_R_TEXT   : string;  //kt
  TX_R_CAP    : string;  //kt


procedure SetupVars;
//kt Added entire function to replace constant declarations 8/8/2007
begin
  TX_CS_TEXT := DKLangConstW('fODRadConShRes_Select_Sourcex_or_press_Cancelx');
  TX_CS_CAP := DKLangConstW('fODRadConShRes_No_Source');
  TX_R_TEXT := DKLangConstW('fODRadConShRes_Enter_Source_x3x40_charactersxx_or_press_Cancelx');
  TX_R_CAP := DKLangConstW('fODRadConShRes_No_Source');
end;
 
procedure SelectSource(FontSize: Integer; SrcType: char; var Source: string) ;
{ displays Source entry/selection form and returns a record of the selection }
var
  frmODRadConShRes: TfrmODRadConShRes;
  W, H: Integer;
begin
  frmODRadConShRes := TfrmODRadConShRes.Create(Application);
  try
    with frmODRadConShRes do
    begin
      Font.Size := FontSize;
      W := ClientWidth;
      H := ClientHeight;
      ResizeToFont(FontSize, W, H);
      ClientWidth  := W; pnlBase.Width  := W;
      ClientHeight := H; pnlBase.Height := H;
      FChanged := False;
      if SrcType in ['C','S'] then with cboSource do
         begin
           Items.Assign(SubsetOfRadSources(SrcType));
           if Items.Count > 0 then
            begin
             txtResearch.Enabled := False;
             Enabled := True;
             SelectByID(Piece(Source,U,1));
             BringToFront;
             ShowModal;
            end
           {else if Items.Count = 1 then
             FSource := Items[0]}
           else
             FSource := '-1';
         end
      else if SrcType = 'R' then
        begin
          cboSource.Enabled := False;
          txtResearch.BringToFront;
          txtResearch.Text := Source;
          ShowModal;
          FSource := txtResearch.Text;
        end;
      Source:= FSource ;
    end; {frmODRadConShRes}
  finally
    frmODRadConShRes.Release;
  end;
end;

procedure TfrmODRadConShRes.cmdCancelClick(Sender: TObject);
begin
  FChanged := False ;
  FSource := '';
  Close;
end;

procedure TfrmODRadConShRes.cmdOKClick(Sender: TObject);
begin
  SetupVars;  //kt added 8/8/2007 to replace constants with vars.
 if cboSource.Enabled then with cboSource do
  begin
   if ItemIEN = 0 then
    begin
     InfoBox(TX_CS_TEXT, TX_CS_CAP, MB_OK or MB_ICONWARNING);
     FChanged := False ;
     FSource := '';
     Exit;
    end;
   FChanged := True;
   FSource := Items[ItemIndex];
  end
 else
  begin
   if (Length(txtResearch.Text)<3) or (Length(txtResearch.Text)> 40) then
    begin
     InfoBox(TX_R_TEXT, TX_R_CAP, MB_OK or MB_ICONWARNING);
     FChanged := False ;
     FSource := '';
     Exit;
    end ;
   FChanged := True;
   FSource := txtResearch.Text;
  end;
 Close;
end;

end.
