//kt -- Modified with SourceScanner on 8/20/2007
unit uGraphs;

interface

uses
  SysUtils, Classes, Graphics, ORFn;

type
  TGraphSetting = class
  public
    ClearBackground: boolean;
    Dates: boolean;
    FixedDateRange: boolean;
    FMStartDate: double;
    FMStopDate: double;
    Gradient: boolean;
    HighTime: TDateTime;
    Hints: boolean;
    HorizontalZoom: boolean;
    ItemsDisplayed: TStrings;
    ItemsForDisplay: TStrings;
    Legend: boolean;
    Lines: boolean;
    LowTime: TDateTime;
    MaxGraphs: integer;
    MaxSelect: integer;
    MaxSelectMin: integer;
    MaxSelectMax: integer;
    MinGraphHeight: integer;
    OptionSettings: string;              // only used for storage
    Points: boolean;
    SortByType: boolean;
    SortColumn: integer;
    Sources: TStrings;
    StayOnTop: boolean;
    Values: boolean;
    VerticalZoom: boolean;
    View3D: boolean;
  end;

const
  BIG_NUMBER = 9999999;
  BIG_SPACES = '                                                                ';
  FM_START_DATE = 2500101;
  FM_STOP_DATE = 3500101;
  MAX_ITEM_DISCLAIMER = 10;
  NUM_COLORS = 16;
  PROB_HEIGHT = 2;
  RX_HEIGHT_IN = 12;
  RX_HEIGHT_NVA = 9;
  RX_HEIGHT_OUT = 15;
  ZOOM_PERCENT = 95;
  GRAPH_FLOAT = 'F';
  GRAPH_REPORT = 'R';

    // settings use single character
  SETTING_3D = 'A';
  SETTING_CLEAR = 'B';
  SETTING_DATES = 'C';
  SETTING_GRADIENT = 'D';
  SETTING_HINTS = 'E';
  SETTING_LEGEND = 'F';
  SETTING_LINES = 'G';
  SETTING_SORT = 'H';
  SETTING_TOP = 'I';
  SETTING_VALUES = 'J';
  SETTING_HZOOM = 'K';
  SETTING_VZOOM = 'L';
  SETTING_FIXED = 'M';

  // keypress flags
  KEYPRESS_ON = 'YES';
  KEYPRESS_OFF = 'NO';

  // format date/time axis
  DFORMAT_MDY = 'm/d/yyyy';
  DFORMAT_MYY = 'm/yy';
  DFORMAT_YY = 'yy';
  DWIDTH_MDY = 66;
  DWIDTH_MYY = 30;
  DWIDTH_YY = 18;

  // text messages
//TXT_DISCLAIMER = 'Due to number of items and size restrictions on your display, '  <-- original line.  //kt 8/20/2007
//  + 'all items may not be visible.';  <-- original line.  //kt 8/20/2007
//TXT_COPY_DISCLAIMER = 'Note: Graphs display limited data, view details for more information.';  <-- original line.  //kt 8/20/2007
//TXT_REPORT_DISCLAIMER = 'Note: Listing displays limited data, view details for more information.';  <-- original line.  //kt 8/20/2007
//TXT_INFO = 'Select multiple items using Ctrl-click or Shift-click.';  <-- original line.  //kt 8/20/2007
//TXT_PRINTING = 'Graphs are being printed';  <-- original line.  //kt 8/20/2007
//TXT_WARNING = 'Warning: You are using graph settings with a Special Function.';  <-- original line.  //kt 8/20/2007
//TXT_WARNING_SAME_TIME = 'Warning: Items have multiple occurrences at the same time.';  <-- original line.  //kt 8/20/2007
//TXT_ZOOMED = 'Zoomed Date Range: ';  <-- original line.  //kt 8/20/2007

  COLOR_INFO = clCream;
  COLOR_PRINTING = clMoneyGreen;    //$CCFFFF; $CCCCFF; $CCFFCC; $FFCCCC; $FFCCFF; $FFFFCC;
  COLOR_WARNING = clCream;  //clFuchsia;
  COLOR_ZOOM = clCream;  //clSkyBlue;

  // hint messages for view definition
//HINT_PAT_SOURCE     = 'Only items where the patient has data are displayed.'  <-- original line.  //kt 8/20/2007
//              + #13 + 'Use this for selecting items to display on the graph.';  <-- original line.  //kt 8/20/2007
//HINT_ALL_SOURCE     = 'All possible items are displayed.'  <-- original line.  //kt 8/20/2007
//              + #13 + 'Use this for defining items to be displayed/saved as Views.'  <-- original line.  //kt 8/20/2007
//              + #13 + 'Note: For easy use, select Views for graphing.';  <-- original line.  //kt 8/20/2007
//HINT_SELECTION_INFO = 'This form is primarily used for defining views.'  <-- original line.  //kt 8/20/2007
//              + #13 + 'Usually selection is done by selecting Views or Items to graph.'  <-- original line.  //kt 8/20/2007
//              + #13 + 'This form defines views.'  <-- original line.  //kt 8/20/2007
//              + #13 + 'The Settings form defines items that are always selectable for graphing.';  <-- original line.  //kt 8/20/2007
//HINT_SOURCE         = 'These are the different types of data.'  <-- original line.  //kt 8/20/2007
//              + #13 + 'Types are followed by a section showing your Personal Views, then Public Views.'  <-- original line.  //kt 8/20/2007
//              + #13 + 'Click a type and then select individual items'  <-- original line.  //kt 8/20/2007
//              + #13 + 'Double-click a type to select all items of this type  - <any>';  <-- original line.  //kt 8/20/2007
//HINT_SELECTION      = 'Select specific items and move them to the right.'  <-- original line.  //kt 8/20/2007
//              + #13 + 'Use the arrow buttons or double click.'  <-- original line.  //kt 8/20/2007
//              + #13 + 'Selecting a type <any> will use all patients for that type.';  <-- original line.  //kt 8/20/2007
//HINT_DISPLAY        = 'This is the list of items, types, and/or views that compose the View that will be graphed.'  <-- original line.  //kt 8/20/2007
//              + #13 + 'You can save this as a personal view by clicking the Save Personal button.';  <-- original line.  //kt 8/20/2007
//HINT_BTN_ADDALL     = 'Click to add all items for display.';  <-- original line.  //kt 8/20/2007
//HINT_BTN_ADD1       = 'Click to add this item for display (or double-click item).';  <-- original line.  //kt 8/20/2007
//HINT_BTN_REMOVE1    = 'Click to remove this item from display (or double-click item).';  <-- original line.  //kt 8/20/2007
//HINT_BTN_REMOVEALL  = 'Click to remove all items from display.';  <-- original line.  //kt 8/20/2007
//HINT_BTN_CLEAR      = 'Click to clear the Items and Items for Graphing lists.';  <-- original line.  //kt 8/20/2007
//HINT_BTN_DELETE     = 'Click to delete the selected view.';  <-- original line.  //kt 8/20/2007
//HINT_BTN_RENAME     = 'Click to rename the selected view.';  <-- original line.  //kt 8/20/2007
//HINT_BTN_SAVE       = 'Click to save your view.'  <-- original line.  //kt 8/20/2007
//              + #13 + 'You will give this view a name that can be selected from the graph.';  <-- original line.  //kt 8/20/2007
//HINT_BTN_SAVE_PUB   = 'Click to save a public view (available to editors only).'  <-- original line.  //kt 8/20/2007
//              + #13 + 'Public views can be selected by all users.';  <-- original line.  //kt 8/20/2007
//HINT_APPLY          = 'Select the section you where you want to display the graph.';  <-- original line.  //kt 8/20/2007
//HINT_BTN_CLOSE      = 'Click to display items for graphing.'  <-- original line.  //kt 8/20/2007
//              + #13 + 'Note: If you are using this from the Options menu, '  <-- original line.  //kt 8/20/2007
//              + #13 + 'items are not displayed (multiple graphs may be in use).'  <-- original line.  //kt 8/20/2007
//              + #13 + 'You should save any view definitions before closing this form.';  <-- original line.  //kt 8/20/2007



  // hint messages for settings
//SHINT_SOURCES     = 'This is a list of all the types of data that can be graphed.'  <-- original line.  //kt 8/20/2007
//            + #13 + 'Check the types you wish to be selectable on the graph.'  <-- original line.  //kt 8/20/2007
//            + #13 + 'It is best to only check the types that you frequently use.'  <-- original line.  //kt 8/20/2007
//            + #13 + 'If you select a view on the graph that has types defined that are not checked,'  <-- original line.  //kt 8/20/2007
//            + #13 + 'that type of data will become automatically checked.'  <-- original line.  //kt 8/20/2007
//            + #13 + 'Note: Data is only selectable if the patient has that type of data';  <-- original line.  //kt 8/20/2007
//SHINT_OPTIONS     = 'Check options to change the appearance and behavior of the graph.'  <-- original line.  //kt 8/20/2007
//            + #13 + 'Common options are also available on the graph''s right-click menu';  <-- original line.  //kt 8/20/2007
//SHINT_MAX =         'Enter the maximum number of graphs to appear on the screen.'  <-- original line.  //kt 8/20/2007
//            + #13 + 'This is used when individual graphs are displayed and'  <-- original line.  //kt 8/20/2007
//            + #13 + 'applies to both the top and bottom sections.'  <-- original line.  //kt 8/20/2007
//            + #13 + 'When the number of graphs exceeds this limited, the graphs are available by scrolling.';  <-- original line.  //kt 8/20/2007
//SHINT_MIN         = 'Enter the minimum height of a graph (this is in pixels).'  <-- original line.  //kt 8/20/2007
//            + #13 + 'This will depend on the size of your display.'  <-- original line.  //kt 8/20/2007
//            + #13 + 'This setting assures that at least this amount of height will appear on the graph.'  <-- original line.  //kt 8/20/2007
//            + #13 + 'Use in combination with Max Graphs in Display.';  <-- original line.  //kt 8/20/2007
//SHINT_MAX_ITEMS   = 'Enter the maximum number of items that can be graphed at one time.'  <-- original line.  //kt 8/20/2007
//            + #13 + 'This setting prevents you from mistakenly selecting a large number of items.';  <-- original line.  //kt 8/20/2007
//SHINT_FUNCTIONS   = 'These functions are restricted to editors for evaluation.';  <-- original line.  //kt 8/20/2007
//SHINT_BTN_SHOW    = 'Click these buttons to display default settings.';  <-- original line.  //kt 8/20/2007
//SHINT_BTN_PER     = 'Click to display your personal settings.';  <-- original line.  //kt 8/20/2007
//SHINT_BTN_PUB     = 'Click to display the default settings.'  <-- original line.  //kt 8/20/2007
//            + #13 + 'These settings are used when you have not saved a personal setting.';  <-- original line.  //kt 8/20/2007
//SHINT_BTN_SAVE    = 'Click these buttons to save default settings.';  <-- original line.  //kt 8/20/2007
//SHINT_BTN_PERSAVE = 'Click to save your personal defaults';  <-- original line.  //kt 8/20/2007
//SHINT_BTN_PUBSAVE = 'Click to save the public default (available to editors only).';  <-- original line.  //kt 8/20/2007
//SHINT_BTN_ALL     = 'Click to check all sources.';  <-- original line.  //kt 8/20/2007
//SHINT_BTN_CLEAR   = 'Click to uncheck all sources.';  <-- original line.  //kt 8/20/2007
//SHINT_BTN_CLOSE   = 'Click to display these settings for graphing.'  <-- original line.  //kt 8/20/2007
//            + #13 + 'To cancel any unsaved changes you''ve made, click the upper-right x box.'  <-- original line.  //kt 8/20/2007
//            + #13 + 'Note: If you are using this from the Options menu, '  <-- original line.  //kt 8/20/2007
//            + #13 + 'settings will not change your display (multiple graphs may be in use).'  <-- original line.  //kt 8/20/2007
//            + #13 + 'You should save any settings before closing this form.';  <-- original line.  //kt 8/20/2007




function GraphSettingsInit(settings: string): TGraphSetting;

//kt Added the following function to replace constant declarations 8/20/2007
//   This allows just-in-time language translation
Function TXT_DISCLAIMER       : string;  //kt 8-20-07
Function TXT_COPY_DISCLAIMER  : string;  //kt 8-20-07
Function TXT_REPORT_DISCLAIMER: string;  //kt 8-20-07
Function TXT_INFO             : string;  //kt 8-20-07
Function TXT_PRINTING         : string;  //kt 8-20-07
Function TXT_WARNING          : string;  //kt 8-20-07
Function TXT_WARNING_SAME_TIME: string;  //kt 8-20-07
Function TXT_ZOOMED           : string;  //kt 8-20-07
Function HINT_PAT_SOURCE      : string;  //kt 8-20-07
Function HINT_ALL_SOURCE      : string;  //kt 8-20-07
Function HINT_SELECTION_INFO  : string;  //kt 8-20-07
Function HINT_SOURCE          : string;  //kt 8-20-07
Function HINT_SELECTION       : string;  //kt 8-20-07
Function HINT_DISPLAY         : string;  //kt 8-20-07
Function HINT_BTN_ADDALL      : string;  //kt 8-20-07
Function HINT_BTN_ADD1        : string;  //kt 8-20-07
Function HINT_BTN_REMOVE1     : string;  //kt 8-20-07
Function HINT_BTN_REMOVEALL   : string;  //kt 8-20-07
Function HINT_BTN_CLEAR       : string;  //kt 8-20-07
Function HINT_BTN_DELETE      : string;  //kt 8-20-07
Function HINT_BTN_RENAME      : string;  //kt 8-20-07
Function HINT_BTN_SAVE        : string;  //kt 8-20-07
Function HINT_BTN_SAVE_PUB    : string;  //kt 8-20-07
Function HINT_APPLY           : string;  //kt 8-20-07
Function HINT_BTN_CLOSE       : string;  //kt 8-20-07
Function SHINT_SOURCES        : string;  //kt 8-20-07
Function SHINT_OPTIONS        : string;  //kt 8-20-07
Function SHINT_MAX            : string;  //kt 8-20-07
Function SHINT_MIN            : string;  //kt 8-20-07
Function SHINT_MAX_ITEMS      : string;  //kt 8-20-07
Function SHINT_FUNCTIONS      : string;  //kt 8-20-07
Function SHINT_BTN_SHOW       : string;  //kt 8-20-07
Function SHINT_BTN_PER        : string;  //kt 8-20-07
Function SHINT_BTN_PUB        : string;  //kt 8-20-07
Function SHINT_BTN_SAVE       : string;  //kt 8-20-07
Function SHINT_BTN_PERSAVE    : string;  //kt 8-20-07
Function SHINT_BTN_PUBSAVE    : string;  //kt 8-20-07
Function SHINT_BTN_ALL        : string;  //kt 8-20-07
Function SHINT_BTN_CLEAR      : string;  //kt 8-20-07
Function SHINT_BTN_CLOSE      : string;  //kt 8-20-07


implementation

uses DKLang;  //kt


//kt Added the following function to replace constant declarations 8/20/2007
Function TXT_DISCLAIMER: string;  //kt 8-20-07
begin
  Result := DKLangConstW('uGraphs_Due_to_number_of_items_and_size_restrictions_on_your_displayx')
    + DKLangConstW('uGraphs_all_items_may_not_be_visiblex');
end;

Function TXT_COPY_DISCLAIMER: string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Notex_Graphs_display_limited_datax_view_details_for_more_informationx');
end;

Function TXT_REPORT_DISCLAIMER: string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Notex_Listing_displays_limited_datax_view_details_for_more_informationx');
end;

Function TXT_INFO: string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Select_multiple_items_using_Ctrlxclick_or_Shiftxclickx');
end;

Function TXT_PRINTING: string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Graphs_are_being_printed');
end;

Function TXT_WARNING: string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Warningx_You_are_using_graph_settings_with_a_Special_Functionx');
end;

Function TXT_WARNING_SAME_TIME: string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Warningx_Items_have_multiple_occurrences_at_the_same_timex');
end;

Function TXT_ZOOMED: string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Zoomed_Date_Rangex');
end;

Function HINT_PAT_SOURCE    : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Only_items_where_the_patient_has_data_are_displayedx')
                + #13 + DKLangConstW('uGraphs_Use_this_for_selecting_items_to_display_on_the_graphx');
end;


Function HINT_ALL_SOURCE    : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_All_possible_items_are_displayedx')
                + #13 + DKLangConstW('uGraphs_Use_this_for_defining_items_to_be_displayedxsaved_as_Viewsx')
                + #13 + DKLangConstW('uGraphs_Notex_For_easy_usex_select_Views_for_graphingx');
end;

Function HINT_SELECTION_INFO: string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_This_form_is_primarily_used_for_defining_viewsx')
                + #13 + DKLangConstW('uGraphs_Usually_selection_is_done_by_selecting_Views_or_Items_to_graphx')
                + #13 + DKLangConstW('uGraphs_This_form_defines_viewsx')
                + #13 + DKLangConstW('uGraphs_The_Settings_form_defines_items_that_are_always_selectable_for_graphingx');
end;

Function HINT_SOURCE        : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_These_are_the_different_types_of_datax')
                + #13 + DKLangConstW('uGraphs_Types_are_followed_by_a_section_showing_your_Personal_Viewsx_then_Public_Viewsx')
                + #13 + DKLangConstW('uGraphs_Click_a_type_and_then_select_individual_items')
                + #13 + DKLangConstW('uGraphs_Doublexclick_a_type_to_select_all_items_of_this_type__x_xanyx');
end;

Function HINT_SELECTION     : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Select_specific_items_and_move_them_to_the_rightx')
                + #13 + DKLangConstW('uGraphs_Use_the_arrow_buttons_or_double_clickx')
                + #13 + DKLangConstW('uGraphs_Selecting_a_type_xanyx_will_use_all_patients_for_that_typex');
end;

Function HINT_DISPLAY       : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_This_is_the_list_of_itemsx_typesx_andxor_views_that_compose_the_View_that_will_be_graphedx')
                + #13 + DKLangConstW('uGraphs_You_can_save_this_as_a_personal_view_by_clicking_the_Save_Personal_buttonx');
end;

Function HINT_BTN_ADDALL    : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_to_add_all_items_for_displayx');
end;

Function HINT_BTN_ADD1      : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_to_add_this_item_for_display_xor_doublexclick_itemxx');
end;

Function HINT_BTN_REMOVE1   : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_to_remove_this_item_from_display_xor_doublexclick_itemxx');
end;

Function HINT_BTN_REMOVEALL : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_to_remove_all_items_from_displayx');
end;

Function HINT_BTN_CLEAR     : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_to_clear_the_Items_and_Items_for_Graphing_listsx');
end;

Function HINT_BTN_DELETE    : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_to_delete_the_selected_viewx');
end;

Function HINT_BTN_RENAME    : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_to_rename_the_selected_viewx');
end;

Function HINT_BTN_SAVE      : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_to_save_your_viewx')
                + #13 + DKLangConstW('uGraphs_You_will_give_this_view_a_name_that_can_be_selected_from_the_graphx');
end;

Function HINT_BTN_SAVE_PUB  : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_to_save_a_public_view_xavailable_to_editors_onlyxx')
                + #13 + DKLangConstW('uGraphs_Public_views_can_be_selected_by_all_usersx');
end;

Function HINT_APPLY         : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Select_the_section_you_where_you_want_to_display_the_graphx');
end;

Function HINT_BTN_CLOSE     : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_to_display_items_for_graphingx')
                + #13 + DKLangConstW('uGraphs_Notex_If_you_are_using_this_from_the_Options_menux')
                + #13 + DKLangConstW('uGraphs_items_are_not_displayed_xmultiple_graphs_may_be_in_usexx')
                + #13 + DKLangConstW('uGraphs_You_should_save_any_view_definitions_before_closing_this_formx');
end;

Function SHINT_SOURCES    : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_This_is_a_list_of_all_the_types_of_data_that_can_be_graphedx')
              + #13 + DKLangConstW('uGraphs_Check_the_types_you_wish_to_be_selectable_on_the_graphx')
              + #13 + DKLangConstW('uGraphs_It_is_best_to_only_check_the_types_that_you_frequently_usex')
              + #13 + DKLangConstW('uGraphs_If_you_select_a_view_on_the_graph_that_has_types_defined_that_are_not_checkedx')
              + #13 + DKLangConstW('uGraphs_that_type_of_data_will_become_automatically_checkedx')
              + #13 + DKLangConstW('uGraphs_Notex_Data_is_only_selectable_if_the_patient_has_that_type_of_data');
end;

Function SHINT_OPTIONS    : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Check_options_to_change_the_appearance_and_behavior_of_the_graphx')
              + #13 + DKLangConstW('uGraphs_Common_options_are_also_available_on_the_graphxxs_rightxclick_menu');
end;

Function SHINT_MAX        : string;  //kt 8-20-07
begin Result :=  DKLangConstW('uGraphs_Enter_the_maximum_number_of_graphs_to_appear_on_the_screenx')
              + #13 + DKLangConstW('uGraphs_This_is_used_when_individual_graphs_are_displayed_and')
              + #13 + DKLangConstW('uGraphs_applies_to_both_the_top_and_bottom_sectionsx')
              + #13 + DKLangConstW('uGraphs_When_the_number_of_graphs_exceeds_this_limitedx_the_graphs_are_available_by_scrollingx');
end;

Function SHINT_MIN        : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Enter_the_minimum_height_of_a_graph_xthis_is_in_pixelsxx')
              + #13 + DKLangConstW('uGraphs_This_will_depend_on_the_size_of_your_displayx')
              + #13 + DKLangConstW('uGraphs_This_setting_assures_that_at_least_this_amount_of_height_will_appear_on_the_graphx')
              + #13 + DKLangConstW('uGraphs_Use_in_combination_with_Max_Graphs_in_Displayx');
end;

Function SHINT_MAX_ITEMS  : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Enter_the_maximum_number_of_items_that_can_be_graphed_at_one_timex')
              + #13 + DKLangConstW('uGraphs_This_setting_prevents_you_from_mistakenly_selecting_a_large_number_of_itemsx');
end;

Function SHINT_FUNCTIONS  : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_These_functions_are_restricted_to_editors_for_evaluationx');
end;

Function SHINT_BTN_SHOW   : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_these_buttons_to_display_default_settingsx');
end;

Function SHINT_BTN_PER    : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_to_display_your_personal_settingsx');
end;

Function SHINT_BTN_PUB    : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_to_display_the_default_settingsx')
              + #13 + DKLangConstW('uGraphs_These_settings_are_used_when_you_have_not_saved_a_personal_settingx');
end;

Function SHINT_BTN_SAVE   : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_these_buttons_to_save_default_settingsx');
end;

Function SHINT_BTN_PERSAVE: string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_to_save_your_personal_defaults');
end;

Function SHINT_BTN_PUBSAVE: string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_to_save_the_public_default_xavailable_to_editors_onlyxx');
end;

Function SHINT_BTN_ALL    : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_to_check_all_sourcesx');
end;

Function SHINT_BTN_CLEAR  : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_to_uncheck_all_sourcesx');
end;

Function SHINT_BTN_CLOSE  : string;  //kt 8-20-07
begin Result := DKLangConstW('uGraphs_Click_to_display_these_settings_for_graphingx')
              + #13 + DKLangConstW('uGraphs_To_cancel_any_unsaved_changes_youxxve_madex_click_the_upperxright_x_boxx')
              + #13 + DKLangConstW('uGraphs_Notex_If_you_are_using_this_from_the_Options_menux')
              + #13 + DKLangConstW('uGraphs_settings_will_not_change_your_display_xmultiple_graphs_may_be_in_usexx')
              + #13 + DKLangConstW('uGraphs_You_should_save_any_settings_before_closing_this_formx');
end;


function GraphSettingsInit(settings: string): TGraphSetting;
var
  FGraphSetting: TGraphSetting;
begin
  FGraphSetting := TGraphSetting.Create;
  with FGraphSetting do
  begin
    OptionSettings := Piece(settings, '|', 2);
    SortColumn := strtointdef(Piece(settings, '|', 3), 0);
    MaxGraphs := strtointdef(Piece(settings, '|', 4), 5);
    MinGraphHeight := strtointdef(Piece(settings, '|', 5), 90);
    MaxSelect := strtointdef(Piece(settings, '|', 7), 100);
    MaxSelectMin := 1;
    MaxSelectMax := strtointdef(Piece(settings, '|', 8), 1000);
    Values := Pos(SETTING_VALUES, OptionSettings) > 0;
    VerticalZoom := Pos(SETTING_VZOOM, OptionSettings) > 0;
    HorizontalZoom := Pos(SETTING_HZOOM, OptionSettings) > 0;
    View3D := Pos(SETTING_3D, OptionSettings) > 0;
    Legend := Pos(SETTING_LEGEND, OptionSettings) > 0;
    Dates := Pos(SETTING_DATES, OptionSettings) > 0;
    Lines := Pos(SETTING_LINES, OptionSettings) > 0;
    StayOnTop := Pos(SETTING_TOP, OptionSettings) > 0;
    SortByType := Pos(SETTING_SORT, OptionSettings) > 0;
    ClearBackground := Pos(SETTING_CLEAR, OptionSettings) > 0;
    Gradient := Pos(SETTING_GRADIENT, OptionSettings) > 0;
    Hints := Pos(SETTING_HINTS, OptionSettings) > 0;
    FixedDateRange := Pos(SETTING_FIXED, OptionSettings) > 0;
    HighTime := 0;
    LowTime := BIG_NUMBER;
    FMStartDate := FM_START_DATE;
    FMStopDate := FM_STOP_DATE;
    if SortByType then SortColumn := 1 else SortColumn := 0;
  end;
  Result := FGraphSetting;
end;

end.
