//kt -- Modified with SourceScanner on 8/8/2007
unit fODLabOthCollSamp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ORCtrls, StdCtrls, ORFn, DKLang;

type
  TfrmODLabOthCollSamp = class(TForm)
    pnlBase: TORAutoPanel;
    cboOtherCollSamp: TORComboBox;
    cmdOK: TButton;
    cmdCancel: TButton;
    DKLanguageController1: TDKLanguageController;
    procedure cmdCancelClick(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure cboOtherCollSampDblClick(Sender: TObject);
  private
    FOtherCollSamp: string;
  end;

function SelectOtherCollSample(FontSize: Integer; Skip: integer; CollSampList: TList): string ;

implementation

{$R *.DFM}

uses fODLab, rODLab;

//const
//TX_NOCOLLSAMP_TEXT = 'Select a collection sample or press Cancel.';  <-- original line.  //kt 8/8/2007
//TX_NOCOLLSAMP_CAP = 'Missing Collection Sample';  <-- original line.  //kt 8/8/2007

var
  TX_NOCOLLSAMP_TEXT  : string;  //kt
  TX_NOCOLLSAMP_CAP   : string;  //kt


procedure SetupVars;
//kt Added entire function to replace constant declarations 8/8/2007
begin
  TX_NOCOLLSAMP_TEXT := DKLangConstW('fODLabOthCollSamp_Select_a_collection_sample_or_press_Cancelx');
  TX_NOCOLLSAMP_CAP := DKLangConstW('fODLabOthCollSamp_Missing_Collection_Sample');
end;
 
function SelectOtherCollSample(FontSize: Integer; Skip: integer; CollSampList: TList): string ;
{ displays collection sample select form for lab and returns a record of the selection }
var
  frmODLabOthCollSamp: TfrmODLabOthCollSamp;
  W, H, i: Integer;
  x: string;
begin
  frmODLabOthCollSamp := TfrmODLabOthCollSamp.Create(Application);
  try
    with frmODLabOthCollSamp do
    begin
      Font.Size := FontSize;
      W := ClientWidth;
      H := ClientHeight;
      ResizeToFont(FontSize, W, H);
      ClientWidth  := W; pnlBase.Width  := W;
      ClientHeight := H; pnlBase.Height := H;
      with CollSampList do for i := Skip to Count-1 do with TCollSamp(Items[i]) do
        begin
          x := IntToStr(CollSampID) + '^' + CollSampName;
          if Length(TubeColor) <> 0 then x := x + ' (' + TubeColor + ')';
          cboOtherCollSamp.Items.Add(x) ;
        end;
      ShowModal;
      Result := FOtherCollSamp;
    end;
  finally
    frmODLabOthCollSamp.Release;
  end;
end;

procedure TfrmODLabOthCollSamp.cmdCancelClick(Sender: TObject);
begin
  FOtherCollSamp := '-1'  ;
  Close;
end;

procedure TfrmODLabOthCollSamp.cmdOKClick(Sender: TObject);
begin
  SetupVars;  //kt added 8/8/2007 to replace constants with vars.
  if cboOtherCollSamp.ItemIEN = 0 then
   begin
    InfoBox(TX_NOCOLLSAMP_TEXT, TX_NOCOLLSAMP_CAP, MB_OK or MB_ICONWARNING);
    Exit;
   end;
  if cboOtherCollSamp.ItemIEN > 0 then
     FOtherCollSamp := cboOtherCollSamp.Items[cboOtherCollSamp.ItemIndex]
  else
     FOtherCollSamp := '-1'  ;
  Close;
end;

procedure TfrmODLabOthCollSamp.cboOtherCollSampDblClick(Sender: TObject);
begin
  cmdOKClick(Self);
end;

end.
