//kt -- Modified with SourceScanner on 7/7/2007
unit fAbout;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fAutoSz, StdCtrls, ExtCtrls, DKLang;

type
  TfrmAbout = class(TfrmAutoSz)
    Panel1: TPanel;
    Image1: TImage;
    cmdOK: TButton;
    lblProductName: TStaticText;
    lblFileVersion: TStaticText;
    lblCompanyName: TStaticText;
    lblComments: TStaticText;
    lblCRC: TStaticText;
    lblLegalCopyright: TMemo;
    bvlBottom: TBevel;
    lblFileDescription: TStaticText;
    lblInternalName: TStaticText;
    lblOriginalFileName: TStaticText;
    bvl508Disclaimer: TBevel;
    lbl508Notice: TMemo;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

procedure ShowAbout;

implementation

{$R *.DFM}

uses ORSystem, ORFn;

procedure ShowAbout;
var
  frmAbout: TfrmAbout;
begin
  frmAbout := TfrmAbout.Create(Application);
  try
    ResizeFormToFont(TForm(frmAbout));
    frmAbout.lblLegalCopyright.SelStart := 0;
    frmAbout.lblLegalCopyright.SelLength := 0;
    frmAbout.lbl508Notice.SelStart := 0;
    frmAbout.lbl508Notice.SelLength := 0;
    frmAbout.ShowModal;
  finally
    frmAbout.Release;
  end;
end;

procedure TfrmAbout.FormCreate(Sender: TObject);
begin
  inherited;
//lblCompanyName.Caption        := 'Developed for ' + 'VOE VWPT Patient Enhanced Lookup Version 1.6b'; //vwpt  <-- original line.  //kt 7/7/2007
  lblCompanyName.Caption        := DKLangConstW('fAbout_Developed_for_')+' '+ DKLangConstW('fAbout_VOE_VWPT_Patient_Enhanced_Lookup_Version_16b'); //vwpt //kt added 7/7/2007
  //lblCompanyName.Caption        := 'Developed by the ' + FileVersionValue(Application.ExeName, FILE_VER_COMPANYNAME);
//lblFileDescription.Caption    := 'Compiled ' + FileVersionValue(Application.ExeName, FILE_VER_FILEDESCRIPTION);  //date  <-- original line.  //kt 7/7/2007
  lblFileDescription.Caption    := DKLangConstW('fAbout_Compiled')+' '+ FileVersionValue(Application.ExeName, FILE_VER_FILEDESCRIPTION);  //date //kt added 7/7/2007
  lblFileVersion.Caption        := FileVersionValue(Application.ExeName, FILE_VER_FILEVERSION);
  lblInternalName.Caption       := FileVersionValue(Application.ExeName, FILE_VER_INTERNALNAME);
  lblLegalCopyright.Text        := FileVersionValue(Application.ExeName, FILE_VER_LEGALCOPYRIGHT);
  lblOriginalFileName.Caption   := FileVersionValue(Application.ExeName, FILE_VER_ORIGINALFILENAME);  //patch
  lblProductName.Caption        := FileVersionValue(Application.ExeName, FILE_VER_PRODUCTNAME);
  lblComments.Caption           := FileVersionValue(Application.ExeName, FILE_VER_COMMENTS);  // version comment
//lblCRC.Caption                := 'CRC: ' + IntToHex(CRCForFile(Application.ExeName), 8);  <-- original line.  //kt 7/7/2007
  lblCRC.Caption                := DKLangConstW('fAbout_CRC_')+' ' + IntToHex(CRCForFile(Application.ExeName), 8); //kt added 7/7/2007
end;

end.
