//kt -- Modified with SourceScanner on 8/8/2007
unit UBAMessages;

{$OPTIMIZATION OFF}
{.$define debug}

interface


  {$ifdef debug}
const
//BA_ASSRTF                     = 'Assertion failed' + #13;  <-- original line.  //kt 8/8/2007
function BA_ASSRTF                     : string;
  {$endif}

const
  //CPRS User Messages
//BA_MAX_DX_ALLOWED             = 'Can Not Add Diagnosis' + #13 +  <-- original line.  //kt 8/8/2007
//                                 'Reason: Maximum (4) diagnoses have already been applied to this order.' + #13 +  <-- original line.  //kt 8/8/2007
//                                 'You may use the ''Diagnosis Editor'' to manage diagnoses for order(s).';  <-- original line.  //kt 8/8/2007
//BA_NO_ORDERS_SELECTED         = 'No orders have been selected.  Select one or more orders to be signed.';  <-- original line.  //kt 8/8/2007
//BA_CONFIRM_DX_OVERWRITE       = '''Lookup Diagnoses'' action will overwrite any existing diagnoses for selected orders.'+#13+'Do you wish to proceed?';  <-- original line.  //kt 8/8/2007
//BA_MAX_DX                     = 'A maximum of 4 diagnosis can be selected';  <-- original line.  //kt 8/8/2007
//BA_BILLING_DATA_SAVE_FAILED   = 'Error: Billing data was not saved';  <-- original line.  //kt 8/8/2007

//BA_NA_COPY_DISALLOWED         = 'Can''t copy ''N/A'' orders.  Select non-''N/A'' order(s), and retry the copy.';  <-- original line.  //kt 8/8/2007
//BA_NA_PASTE_DISALLOWED        = 'Selected Diagnoses will not be pasted to orders flagged with N/A.';  <-- original line.  //kt 8/8/2007

//BA_ONE_ORDER_ONLY             = 'Only 1 order at a time may be selected for copying';  <-- original line.  //kt 8/8/2007
//BA_PERSONAL_LIST_UPDATED      = 'Personal Diagnoses List Updated.';  <-- original line.  //kt 8/8/2007
//BA_NO_BILLABLE_ORDERS         = 'No billable orders have been selected.';  <-- original line.  //kt 8/8/2007

//BA_INACTIVE_CODE              = 'Inactive Code';  <-- original line.  //kt 8/8/2007
//BA_INACTIVE_ICD9_CODE_1       = 'The diagnosis code (';  <-- original line.  //kt 8/8/2007
//BA_INACTIVE_ICD9_CODE_2       = ') is not active as of today''s date,' + #13#10+  <-- original line.  //kt 8/8/2007
//                                'Please select another.';  <-- original line.  //kt 8/8/2007

  BA_DATA_NOT_REQD              = '9';

//BA_DUP_DX                     = 'Duplicate Diagnosis.';  <-- original line.  //kt 8/8/2007
//BA_DUP_DX_DISALLOWED_1        = 'Diagnosis (';  <-- original line.  //kt 8/8/2007
//BA_DUP_DX_DISALLOWED_2        = ') has already been selected.';   <-- original line.  //kt 8/8/2007


function BA_MAX_DX_ALLOWED             : string;
function BA_NO_ORDERS_SELECTED         : string;
function BA_CONFIRM_DX_OVERWRITE       : string;
function BA_MAX_DX                     : string;
function BA_BILLING_DATA_SAVE_FAILED   : string;
function BA_NA_COPY_DISALLOWED         : string;
function BA_NA_PASTE_DISALLOWED        : string;
function BA_ONE_ORDER_ONLY             : string;
function BA_PERSONAL_LIST_UPDATED      : string;
function BA_NO_BILLABLE_ORDERS         : string;
function BA_INACTIVE_CODE              : string;
function BA_INACTIVE_ICD9_CODE_1       : string;
function BA_INACTIVE_ICD9_CODE_2       : string;
function BA_DUP_DX                     : string;
function BA_DUP_DX_DISALLOWED_1        : string;
function BA_DUP_DX_DISALLOWED_2        : string;


implementation

uses DKLang;  //kt

  {$ifdef debug}
function BA_ASSRTF                     : string;
begin Result := DKLangConstW('UBAMessages_Assertion_failed') + #13; //kt added 8/8/2007
end;
  {$endif}

function BA_MAX_DX_ALLOWED             : string;
begin Result := DKLangConstW('UBAMessages_Can_Not_Add_Diagnosis') + #13 + //kt added 8/8/2007
                                   DKLangConstW('UBAMessages_Reasonx_Maximum_x4x_diagnoses_have_already_been_applied_to_this_orderx') + #13 + //kt added 8/8/2007
                                   DKLangConstW('UBAMessages_You_may_use_the_xxDiagnosis_Editorxx_to_manage_diagnoses_for_orderxsxx'); //kt added 8/8/2007
end;

function BA_NO_ORDERS_SELECTED         : string;
begin Result := DKLangConstW('UBAMessages_No_orders_have_been_selectedx__Select_one_or_more_orders_to_be_signedx'); //kt added 8/8/2007
end;

function BA_CONFIRM_DX_OVERWRITE       : string;
begin Result := DKLangConstW('UBAMessages_Lookup_Diagnosesxx_action_will_overwrite_any_existing_diagnoses_for_selected_ordersx')+#13+DKLangConstW('UBAMessages_Do_you_wish_to_proceedx'); //kt added 8/8/2007
end;

function BA_MAX_DX                     : string;
begin Result := DKLangConstW('UBAMessages_A_maximum_of_4_diagnosis_can_be_selected'); //kt added 8/8/2007
end;

function BA_BILLING_DATA_SAVE_FAILED   : string;
begin Result := DKLangConstW('UBAMessages_Errorx_Billing_data_was_not_saved'); //kt added 8/8/2007
end;

function BA_NA_COPY_DISALLOWED         : string;
begin Result := DKLangConstW('UBAMessages_Canxxt_copy_xxNxAxx_ordersx__Select_nonxxxNxAxx_orderxsxx_and_retry_the_copyx'); //kt added 8/8/2007
end;

function BA_NA_PASTE_DISALLOWED        : string;
begin Result := DKLangConstW('UBAMessages_Selected_Diagnoses_will_not_be_pasted_to_orders_flagged_with_NxAx'); //kt added 8/8/2007
end;

function BA_ONE_ORDER_ONLY             : string;
begin Result := DKLangConstW('UBAMessages_Only_1_order_at_a_time_may_be_selected_for_copying'); //kt added 8/8/2007
end;

function BA_PERSONAL_LIST_UPDATED      : string;
begin Result := DKLangConstW('UBAMessages_Personal_Diagnoses_List_Updatedx'); //kt added 8/8/2007
end;

function BA_NO_BILLABLE_ORDERS         : string;
begin Result := DKLangConstW('UBAMessages_No_billable_orders_have_been_selectedx'); //kt added 8/8/2007
end;

function BA_INACTIVE_CODE              : string;
begin Result := DKLangConstW('UBAMessages_Inactive_Code'); //kt added 8/8/2007
end;

function BA_INACTIVE_ICD9_CODE_1       : string;
begin Result := DKLangConstW('UBAMessages_The_diagnosis_code_x'); //kt added 8/8/2007
end;

function BA_INACTIVE_ICD9_CODE_2       : string;
begin Result := DKLangConstW('UBAMessages_x_is_not_active_as_of_todayxxs_datex') + #13#10+ //kt added 8/8/2007
                DKLangConstW('UBAMessages_Please_select_anotherx'); //kt added 8/8/2007
end;

function BA_DUP_DX                     : string;
begin Result := DKLangConstW('UBAMessages_Duplicate_Diagnosisx'); //kt added 8/8/2007
end;

function BA_DUP_DX_DISALLOWED_1        : string;
begin Result := DKLangConstW('UBAMessages_Diagnosis_x'); //kt added 8/8/2007
end;

function BA_DUP_DX_DISALLOWED_2        : string;
begin Result := DKLangConstW('UBAMessages_x_has_already_been_selectedx');  //kt added 8/8/2007
end;



end.
