//kt -- Modified with SourceScanner on 8/8/2007
unit fPCEOther;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fAutoSz, ORFn, ORCtrls, StdCtrls, DKLang;

type
  TfrmPCEOther = class(TfrmAutoSz)
    cmdCancel: TButton;
    cmdOK: TButton;
    cboOther: TORComboBox;
    DKLanguageController1: TDKLanguageController;
    procedure cmdOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
    procedure cboOtherDblClick(Sender: TObject);
    procedure cboOtherChange(Sender: TObject);
  private
    fOtherApp: Integer;
    FCode:   string;
    procedure SetApp(OtherApp: Integer);
  public
    { Public declarations }
  end;


procedure OtherLookup(var Code: string; OtherApp: Integer);

implementation

{$R *.DFM}

uses rPCE, fEncounterFrame;

procedure OtherLookup(var Code: string; OtherApp: Integer);
var
  frmPCEOther: TfrmPCEOther;
begin
  frmPCEOther := TfrmPCEOther.Create(Application);
  try
    ResizeFormToFont(TForm(frmPCEOther));
    frmPCEOther.SetApp(OtherApp);
    frmPCEOther.ShowModal;
    Code := frmPCEOther.FCode;
  finally
    frmPCEOther.Free;
  end;
end;

procedure TfrmPCEOther.SetApp(OtherApp: Integer);
begin
  fOtherApp := OtherApp;
  case OtherApp of
//  PCE_IMM: Caption := 'Other Immunizations';  <-- original line.  //kt 8/8/2007
    PCE_IMM: Caption := DKLangConstW('fPCEOther_Other_Immunizations'); //kt added 8/8/2007
//  PCE_SK:  Caption := 'Other Skin Tests';  <-- original line.  //kt 8/8/2007
    PCE_SK:  Caption := DKLangConstW('fPCEOther_Other_Skin_Tests'); //kt added 8/8/2007
//  PCE_PED: Caption := 'Other Education Topics';  <-- original line.  //kt 8/8/2007
    PCE_PED: Caption := DKLangConstW('fPCEOther_Other_Education_Topics'); //kt added 8/8/2007
//    PCE_HF:  Caption := 'Other Health Factors';
//  PCE_XAM: Caption := 'Other Examinations';  <-- original line.  //kt 8/8/2007
    PCE_XAM: Caption := DKLangConstW('fPCEOther_Other_Examinations'); //kt added 8/8/2007

  end;
  cboOther.Caption := Caption;
  LoadcboOther(cboOther.Items, uEncPCEData.Location, OtherApp);
end;


procedure TfrmPCEOther.cmdOKClick(Sender: TObject);
begin
  inherited;
  with cboOther do
  begin
    if ItemIndex = -1 then Exit;
    FCode := CboOther.Items[ItemIndex];
//
    Close;
  end;
end;

procedure TfrmPCEOther.FormCreate(Sender: TObject);
begin
  inherited;
  FCode := '';
end;


procedure TfrmPCEOther.cmdCancelClick(Sender: TObject);
begin
  inherited;
  fCode := '';
  close();
end;

procedure TfrmPCEOther.cboOtherDblClick(Sender: TObject);
begin
  inherited;
  cmdOKClick(Sender);
end;

procedure TfrmPCEOther.cboOtherChange(Sender: TObject);
begin
  inherited;
  cmdOK.Enabled := (cboOther.ItemIndex >= 0);
end;

end.
