//kt -- Modified with SourceScanner on 8/8/2007
unit fODLabOthSpec;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ORCtrls, StdCtrls, ORFn, DKLang;

type
  TfrmODLabOthSpec = class(TForm)
    pnlBase: TORAutoPanel;
    cboOtherSpec: TORComboBox;
    cmdOK: TButton;
    cmdCancel: TButton;
    DKLanguageController1: TDKLanguageController;
    procedure cmdCancelClick(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure cboOtherSpecDblClick(Sender: TObject);
    procedure cboOtherSpecNeedData(Sender: TObject; const StartFrom: String;
      Direction, InsertAt: Integer);
  private
    FOtherSpec: string;
  end;

function SelectOtherSpecimen(FontSize: Integer; SpecimenList: TStringList): string ;

implementation

{$R *.DFM}

uses fODLab, rODLab;

//const
//TX_NOSPEC_TEXT = 'Select a specimen or press Cancel.';  <-- original line.  //kt 8/8/2007
//TX_NOSPEC_CAP = 'Missing Specimen';  <-- original line.  //kt 8/8/2007

var
  TX_NOSPEC_TEXT  : string;  //kt
  TX_NOSPEC_CAP   : string;  //kt


procedure SetupVars;
//kt Added entire function to replace constant declarations 8/8/2007
begin
  TX_NOSPEC_TEXT := DKLangConstW('fODLabOthSpec_Select_a_specimen_or_press_Cancelx');
  TX_NOSPEC_CAP := DKLangConstW('fODLabOthSpec_Missing_Specimen');
end;

function SelectOtherSpecimen(FontSize: Integer; SpecimenList: TStringList): string ;
{ displays collection sample select form for lab and returns a record of the selection }
var
  frmODLabOthSpec: TfrmODLabOthSpec;
  W, H: Integer;
begin
  frmODLabOthSpec := TfrmODLabOthSpec.Create(Application);
  try
    with frmODLabOthSpec do
    begin
      Font.Size := FontSize;
      W := ClientWidth;
      H := ClientHeight;
      ResizeToFont(FontSize, W, H);
      ClientWidth  := W; pnlBase.Width  := W;
      ClientHeight := H; pnlBase.Height := H;
      with cboOtherSpec do
        begin
          {MItems.Assign(SpecimenList);
          InsertSeparator; }
          InitLongList('');
        end;
      ShowModal;
      Result := FOtherSpec;
    end;
  finally
    frmODLabOthSpec.Release;
  end;
end;

procedure TfrmODLabOthSpec.cmdCancelClick(Sender: TObject);
begin
  FOtherSpec := '-1'  ;
  Close;
end;

procedure TfrmODLabOthSpec.cmdOKClick(Sender: TObject);
begin
  SetupVars;  //kt added 8/8/2007 to replace constants with vars.
  if cboOtherSpec.ItemIEN = 0 then
   begin
    InfoBox(TX_NOSPEC_TEXT, TX_NOSPEC_CAP, MB_OK or MB_ICONWARNING);
    Exit;
   end;
  if cboOtherSpec.ItemIEN > 0 then
     FOtherSpec := cboOtherSpec.Items[cboOtherSpec.ItemIndex]
  else
     FOtherSpec := '-1'  ;
  Close;
end;

procedure TfrmODLabOthSpec.cboOtherSpecDblClick(Sender: TObject);
begin
  cmdOKClick(Self);
end;

procedure TfrmODLabOthSpec.cboOtherSpecNeedData(Sender: TObject;
  const StartFrom: string; Direction, InsertAt: Integer);
begin
  inherited;
  cboOtherSpec.ForDataUse(SubsetOfSpecimens(StartFrom, Direction));
end;

end.
