//kt -- Modified with SourceScanner on 8/8/2007
unit fODMedFA;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fAutoSz, StdCtrls, ORCtrls, ORFn, DKLang;

type
  TfrmODMedFA = class(TfrmAutoSz)
    Label1: TLabel;
    lstFormAlt: TORListBox;
    Label2: TStaticText;
    cmdYes: TButton;
    cmdNo: TButton;
    DKLanguageController2: TDKLanguageController;
    procedure lstFormAltClick(Sender: TObject);
    procedure cmdYesClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cmdNoClick(Sender: TObject);
  private
    { Private declarations }
    FSelected: string;
  public
    { Public declarations }
  end;

procedure SelectFormularyAlt(AnIEN: Integer; var ADrug, AnOI: Integer;
  var ADrugName, AnOIName: string; PSType: Char);

implementation

{$R *.DFM}

uses rODBase;

//const
//TX_NO_FORM_ALT = 'This drug is not in the formulary!' + CRLF +  <-- original line.  //kt 8/8/2007
//                 'There are no formulary alternatives entered for this item.' + CRLF +  <-- original line.  //kt 8/8/2007
//                 'Please consult with your pharmacy before ordering this item.';  <-- original line.  //kt 8/8/2007
//TC_NO_FORM_ALT = 'No Formulary Alternatives';  <-- original line.  //kt 8/8/2007

var
    //kt Begin Mod (change Consts to Vars) 8/8/2007
    TX_NO_FORM_ALT  : string;  //kt
    TC_NO_FORM_ALT  : string;  //kt
    //kt End Mod -------------------

procedure SetupVars;
//kt Added entire function to replace constant declarations 8/8/2007
begin
  TX_NO_FORM_ALT := DKLangConstW('fODMedFA_This_drug_is_not_in_the_formularyx') + CRLF +
                    DKLangConstW('fODMedFA_There_are_no_formulary_alternatives_entered_for_this_itemx') + CRLF +
                    DKLangConstW('fODMedFA_Please_consult_with_your_pharmacy_before_ordering_this_itemx');
  TC_NO_FORM_ALT := DKLangConstW('fODMedFA_No_Formulary_Alternatives');
end;

procedure SelectFormularyAlt(AnIEN: Integer; var ADrug, AnOI: Integer;
  var ADrugName, AnOIName: string; PSType: Char);
var
  frmODMedFA: TfrmODMedFA;
  FormAltList: TStringList;
begin
  SetupVars;  //kt added 8/8/2007 to replace constants with vars.
  ADrug := 0;
  AnOI  := 0;
  ADrugName := '';
  AnOIName  := '';
  FormAltList := TStringList.Create;
  try
    LoadFormularyAlt(FormAltList, AnIEN, PSType);
    if FormAltList.Count > 0 then
    begin
      frmODMedFA := TfrmODMedFA.Create(Application);
      try
        ResizeFormToFont(TForm(frmODMedFA));
        with frmODMedFA do
        begin
          lstFormAlt.Items.Assign(FormAltList);
          ShowModal;
          if Length(FSelected) > 0 then
          begin
            ADrug := StrToIntDef(Piece(FSelected, U, 1), 0);
            AnOI  := StrToIntDef(Piece(FSelected, U, 4), 0);
            ADrugName := Piece(FSelected, U, 2);
            AnOIName  := Piece(FSelected, U, 5);
          end;
        end;
      finally
        frmODMedFA.Release;
      end; {frmODMedFA}
    end
    else InfoBox(TX_NO_FORM_ALT, TC_NO_FORM_ALT, MB_OK);
  finally
    FormAltList.Free;
  end; {FormAltList}
end;

procedure TfrmODMedFA.FormCreate(Sender: TObject);
begin
  inherited;
  FSelected := '';
end;

procedure TfrmODMedFA.lstFormAltClick(Sender: TObject);
begin
  inherited;
  if lstFormAlt.ItemIndex > -1 then cmdYes.Enabled := True;
end;

procedure TfrmODMedFA.cmdYesClick(Sender: TObject);
begin
  inherited;
  with lstFormAlt do if ItemIndex > -1 then FSelected := Items[ItemIndex];
  Close;
end;

procedure TfrmODMedFA.cmdNoClick(Sender: TObject);
begin
  inherited;
  Close;
end;

end.
