//kt -- Modified with SourceScanner on 8/8/2007
unit fODMedOIFA;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ORCtrls, ExtCtrls, fAutoSz, DKLang;

type
  TfrmODMedOIFA = class(TForm)
    Label1: TLabel;
    lstFormAlt: TORListBox;
    Label2: TStaticText;
    btnPanel: TPanel;
    cmdYes: TButton;
    cmdNo: TButton;
    DKLanguageController1: TDKLanguageController;
    procedure FormCreate(Sender: TObject);
    procedure cmdYesClick(Sender: TObject);
    procedure cmdNoClick(Sender: TObject);
    procedure lstFormAltClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    FSelected: string;
  end;

procedure CheckFormularyOI(var AnIEN: Integer; var AName: string; ForInpatient: Boolean);
procedure CheckFormularyDose(DispDrug: Integer; var OI: Integer; var OIName: string;
  ForInpatient: Boolean);

implementation

{$R *.DFM}

uses ORFn, rODMeds, rMisc;

procedure CheckFormularyOI(var AnIEN: Integer; var AName: string; ForInpatient: Boolean);

//const
//TX_NO_FORM_ALT = 'This drug is not in the formulary!' + CRLF +  <-- original line.  //kt 8/8/2007
//                 'There are no formulary alternatives entered for this item.' + CRLF +  <-- original line.  //kt 8/8/2007
//                 'Please consult with your pharmacy before ordering this item.';  <-- original line.  //kt 8/8/2007
//TC_NO_FORM_ALT = 'No Formulary Alternatives';  <-- original line.  //kt 8/8/2007

var
  frmODMedOIFA: TfrmODMedOIFA;
  FormAltList: TStringList;
  TX_NO_FORM_ALT : string; //kt
  TC_NO_FORM_ALT : string; //kt

begin
  TX_NO_FORM_ALT := DKLangConstW('fODMedOIFA_This_drug_is_not_in_the_formularyx') + CRLF +
                   DKLangConstW('fODMedOIFA_There_are_no_formulary_alternatives_entered_for_this_itemx') + CRLF +
                   DKLangConstW('fODMedOIFA_Please_consult_with_your_pharmacy_before_ordering_this_itemx');  //kt
  TC_NO_FORM_ALT := DKLangConstW('fODMedOIFA_No_Formulary_Alternatives');  //kt
  FormAltList := TStringList.Create;
  try
    LoadFormularyAltOI(FormAltList, AnIEN, ForInpatient);
    if FormAltList.Count > 0 then
    begin
      frmODMedOIFA := TfrmODMedOIFA.Create(Application);
      try
        ResizeFormToFont(TForm(frmODMedOIFA));
        with frmODMedOIFA do
        begin
          lstFormAlt.Items.Assign(FormAltList);
          ShowModal;
          if Length(FSelected) > 0 then
          begin
            AnIEN := StrToIntDef(Piece(FSelected, U, 1), 0);
            AName := Piece(FSelected, U, 2);
          end;
        end; {with frmODMedOIFA}
      finally
        frmODMedOIFA.Release;
      end; {frmODMedOIFA}
    end
    else messageDlg(TX_NO_FORM_ALT,mtWarning, [mbOK],0);
  finally
    FormAltList.Free;
  end; {FormAltList}
end;

procedure CheckFormularyDose(DispDrug: Integer; var OI: Integer; var OIName: string;
  ForInpatient: Boolean);
var
  frmODMedOIFA: TfrmODMedOIFA;
  FormAltList: TStringList;
begin
  FormAltList := TStringList.Create;
  try
    LoadFormularyAltDose(FormAltList, DispDrug, OI, ForInpatient);
    if FormAltList.Count > 0 then
    begin
      frmODMedOIFA := TfrmODMedOIFA.Create(Application);
      try
        ResizeFormToFont(TForm(frmODMedOIFA));
        with frmODMedOIFA do
        begin
          lstFormAlt.Items.Assign(FormAltList);
          ShowModal;
          if Length(FSelected) > 0 then
          begin
            OI     := StrToIntDef(Piece(FSelected, U, 1), 0);
            OIName := Piece(FSelected, U, 2);
          end;
        end; {with frmODMedOIFA}
      finally
        frmODMedOIFA.Release;
      end; {frmODMedOIFA}
    end; {if FormAltList}
  finally
    FormAltList.Free;
  end; {FormAltList}
end;

procedure TfrmODMedOIFA.FormCreate(Sender: TObject);
begin
  inherited;
  FSelected := '';
end;

procedure TfrmODMedOIFA.lstFormAltClick(Sender: TObject);
begin
  inherited;
  if lstFormAlt.ItemIndex > -1 then cmdYes.Enabled := True;
end;

procedure TfrmODMedOIFA.cmdYesClick(Sender: TObject);
begin
  inherited;
  with lstFormAlt do if ItemIndex > -1 then FSelected := Items[ItemIndex];
  Close;
end;

procedure TfrmODMedOIFA.cmdNoClick(Sender: TObject);
begin
  inherited;
  Close;
end;

procedure TfrmODMedOIFA.FormShow(Sender: TObject);
begin
  inherited;
  SetFormPosition(Self);
end;

procedure TfrmODMedOIFA.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  inherited;
  SaveUserBounds(Self);  
end;

end.
