//kt -- Modified with SourceScanner on 8/8/2007
unit fOrdersRenew;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fAutoSz, StdCtrls, ORFn, ComCtrls, uConst, rODMeds, uOrders, fOCAccept,
  ExtCtrls, uODBase, ORCtrls, DKLang;

type
  TfrmRenewOrders = class(TfrmAutoSz)
    hdrOrders: THeaderControl;
    pnlBottom: TPanel;
    cmdCancel: TButton;
    cmdOK: TButton;
    cmdChange: TButton;
    lstOrders: TCaptionListBox;
    procedure FormCreate(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
    procedure lstOrdersMeasureItem(Control: TWinControl; Index: Integer;
      var Height: Integer);
    procedure lstOrdersDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure lstOrdersClick(Sender: TObject);
    procedure cmdChangeClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure hdrOrdersSectionResize(HeaderControl: THeaderControl;
      Section: THeaderSection);
  private
    OKPressed: Boolean;
    OrderList: TList;
    function MeasureColumnHeight(TheOrderText: string; Index: Integer; Column: integer):integer;
    function AcceptOrderCheckOnRenew(const AnOrderID: string; var OCList: TStringList): boolean;
  end;

function ExecuteRenewOrders(var SelectedList: TList): Boolean;

implementation

{$R *.DFM}

uses rOrders, fDateRange, fRenewOutMed, uCore, rCore, rMisc, UBAGlobals;

const
  TEXT_COLUMN = 0;
  DATE_COLUMN = 1;
  WORD_WRAPPED = True;

//TC_START_STOP = 'Change Start/Stop Dates';  <-- original line.  //kt 8/8/2007
//TX_START_STOP = 'Enter the start and stop times for this order.  Stop time is optional.';  <-- original line.  //kt 8/8/2007
//TX_LBL_START  = 'Start Date/Time';  <-- original line.  //kt 8/8/2007
//TX_LBL_STOP   = 'Stop Date/Time';  <-- original line.  //kt 8/8/2007
//TX_NO_DEA     = 'Provider must have a DEA# or VA# to review this order';  <-- original line.  //kt 8/8/2007
//TC_NO_DEA     = 'DEA# Required';  <-- original line.  //kt 8/8/2007
//TC_ORDERCHECKS = 'Order Checks';  <-- original line.  //kt 8/8/2007

var
    TC_START_STOP   : string;  //kt
    TX_START_STOP   : string;  //kt
    TX_LBL_START    : string;  //kt
    TX_LBL_STOP     : string;  //kt
    TX_NO_DEA       : string;  //kt
    TC_NO_DEA       : string;  //kt
    TC_ORDERCHECKS  : string;  //kt


procedure SetupVars;
//kt Added entire function to replace constant declarations 8/8/2007
begin
  TC_START_STOP := DKLangConstW('fOrdersRenew_Change_StartxStop_Dates');
  TX_START_STOP := DKLangConstW('fOrdersRenew_Enter_the_start_and_stop_times_for_this_orderx__Stop_time_is_optionalx');
  TX_LBL_START  := DKLangConstW('fOrdersRenew_Start_DatexTime');
  TX_LBL_STOP   := DKLangConstW('fOrdersRenew_Stop_DatexTime');
  TX_NO_DEA     := DKLangConstW('fOrdersRenew_Provider_must_have_a_DEAx_or_VAx_to_review_this_order');
  TC_NO_DEA     := DKLangConstW('fOrdersRenew_DEAx_Required');
  TC_ORDERCHECKS := DKLangConstW('fOrdersRenew_Order_Checks'); 
end;
 
function PickupText(const x: string): string;
begin
  case CharAt(x, 1) of
//'C': Result := ' (administered in Clinic)';  <-- original line.  //kt 8/8/2007
  'C': Result := DKLangConstW('fOrdersRenew_xadministered_in_Clinicx'); //kt added 8/8/2007
//'M': Result := ' (deliver by Mail)';  <-- original line.  //kt 8/8/2007
  'M': Result := DKLangConstW('fOrdersRenew_xdeliver_by_Mailx'); //kt added 8/8/2007
//'W': Result := ' (pick up at Window)';  <-- original line.  //kt 8/8/2007
  'W': Result := DKLangConstW('fOrdersRenew_xpick_up_at_Windowx'); //kt added 8/8/2007
  else Result := '';
  end;
end;

function ExecuteRenewOrders(var SelectedList: TList): Boolean;
//const
//TC_IMO_ERROR  = 'Inpatient medication order on outpatient authorization required';  <-- original line.  //kt 8/8/2007
var
  frmRenewOrders: TfrmRenewOrders;
  RenewFields: TOrderRenewFields;
  AnOrder, TheOrder: TOrder;
  OriginalID, RNFillerID,x: string;
  OrderableItemIen: integer;
  TreatAsIMOOrder, IsAnIMOOrder: boolean;
  PassDeaList: TList;
  IsInpt: boolean;
  i,j: Integer;
  //m: integer; //BAPHII 1.3.2
  PkgInfo:string;
  PlainText,RnErrMsg: string;
  TD: TFMDateTime;
  OrchkList: TStringList;
  TC_IMO_ERROR  : string; //kt

  function OrderForInpatient: Boolean;
  begin
    Result := Patient.Inpatient;
  end;
begin
  SetupVars;  //kt added 8/8/2007 to replace constants with vars.
  TC_IMO_ERROR  := DKLangConstW('fOrdersRenew_Inpatient_medication_order_on_outpatient_authorization_required'); //kt added 8/8/2007

  Result := False;
  IsAnIMOOrder := False;
  RnErrMsg := '';

  if SelectedList.Count = 0 then Exit;

  PassDeaList := TList.Create;
  OrchkList := TStringList.Create;
  frmRenewOrders := TfrmRenewOrders.Create(Application);

  try
    frmRenewOrders.OrderList := SelectedList;
    ResizeFormToFont(TForm(frmRenewOrders));
    IsInpt := OrderForInpatient;

    with frmRenewOrders.OrderList do
    for j := 0 to Count - 1 do
       begin
         TheOrder := TOrder(Items[j]);
         PkgInfo := GetPackageByOrderID(TheOrder.ID);

         if Pos('PS',PkgInfo)=1 then
            begin
              OrderableItemIen := GetOrderableIen(TheOrder.ID);
              
              if DEACheckFailed(OrderableItemIen, IsInPt) then
                 begin
                   InfoBox(TX_NO_DEA + #13 + TheOrder.Text, TC_NO_DEA, MB_OK);
                   UnlockOrder(TheOrder.ID);
                 end
              else PassDeaList.Add(frmRenewOrders.OrderList.Items[j]);
            end
         else
           PassDeaList.Add(frmRenewOrders.OrderList.Items[j]);
       end;

    frmRenewOrders.OrderList.Clear;
    frmRenewOrders.OrderList := PassDeaList;

    for i := frmRenewOrders.OrderList.Count - 1 downto 0 do
       begin
         AnOrder := TOrder(frmRenewOrders.OrderList.Items[i]);
         if not IMOActionValidation('RENEW^'+ AnOrder.ID,IsAnIMOOrder,RnErrMsg,'C') then
            begin
              frmRenewOrders.OrderList.Delete(i);
              ShowMsgOn(Length(RnErrMsg) > 0, RnErrMsg, TC_IMO_ERROR);
            end;
         RnErrMsg := '';
       end;

    with frmRenewOrders.OrderList do
     for i := 0 to Count - 1 do
       begin
         AnOrder := TOrder(Items[i]);
         RenewFields := TOrderRenewFields.Create;
         LoadRenewFields(RenewFields, AnOrder.ID);
         RenewFields.NewText := AnOrder.Text + PickupText(RenewFields.Pickup);
         AnOrder.LinkObject := RenewFields;
         PlainText := '';

         if RenewFields.NewText <> '' then
           PlainText := PlainText + frmRenewOrders.hdrOrders.Sections[TEXT_COLUMN].Text + ': ' + RenewFields.NewText + CRLF;

         if RenewFields.BaseType = OD_TEXTONLY then
           with RenewFields do
//            PlainText := PlainText + 'Start: ' + StartTime + CRLF + 'Stop: ' + StopTime;  <-- original line.  //kt 8/8/2007
              PlainText := PlainText + DKLangConstW('fOrdersRenew_Startx')+' ' + StartTime + CRLF + DKLangConstW('fOrdersRenew_Stopx') + StopTime; //kt added 8/8/2007

         frmRenewOrders.lstOrders.Items.AddObject(PlainText, AnOrder);
       end;

    if frmRenewOrders.OrderList.Count < 1 then
      frmRenewOrders.Close
    else
      frmRenewOrders.ShowModal;

    if frmRenewOrders.OKPressed then
       begin
         with frmRenewOrders.OrderList do
           for i := Count - 1 downto 0 do
            begin
              OrchkList.Clear;
              AnOrder := TOrder(Items[i]);
              OriginalID := AnOrder.ID;

              //BAPHII 1.3.2 - Pick up source-order ID here
             UBAGlobals.SourceOrderID := OriginalID; //BAPHII 1.3.2
             UBAGlobals.CopyTreatmentFactorsDxsToRenewedOrder; //BAPHII 1.3.2

              if CheckOrderGroup(OriginalID) = 1 then
                RNFillerID := 'PSI'
              else if CheckOrderGroup(OriginalID) = 2 then
                RNFillerID := 'PSO';

              if AddFillerAppID(RNFillerID) and OrderChecksEnabled then
                 begin
//                 StatusText('Order Checking...');  <-- original line.  //kt 8/8/2007
                   StatusText(DKLangConstW('fOrdersRenew_Order_Checkingxxx')); //kt added 8/8/2007
                   x := OrderChecksOnDisplay(RNFillerID);
                   StatusText('');
                   if Length(x) > 0 then InfoBox(x, TC_ORDERCHECKS, MB_OK);
                 end;

              TreatAsIMOOrder := False;

              if not frmRenewOrders.AcceptOrderCheckOnRenew(AnOrder.ID,OrchkList) then
              begin
                frmRenewOrders.OrderList.Delete(i);
                Continue;
              end;

              if IsIMOOrder(OriginalID) then               //IMO
                 begin
                   TD := FMToday;
                   if IsValidIMOLoc(Encounter.Location, Patient.DFN) and (Encounter.DateTime > TD) then
                     TreatAsIMOOrder := True;
                   if Patient.Inpatient then TreatAsIMOOrder := True;
                 end;

              RenewFields := TOrderRenewFields(AnOrder.LinkObject);

              //PSI-COMPLEX Start
              if IsComplexOrder(OriginalID) then
                 begin
                   if TreatAsIMOOrder then
                     RenewOrder(AnOrder, RenewFields,1,Encounter.DateTime,OrchkList)
                   else
                     RenewOrder(AnOrder, RenewFields,1,0,OrchkList);

                   AnOrder.ActionOn := OriginalID + '=RN';
                   SendMessage(Application.MainForm.Handle, UM_NEWORDER, ORDER_CPLXRN, Integer(AnOrder));
                 end
              //PSI-COMPLEX End
              else
                 begin
                   if TreatAsIMOOrder then
                     RenewOrder(AnOrder, RenewFields,0,Encounter.DateTime,OrchkList)
                   else
                     RenewOrder(AnOrder, RenewFields,0,0,OrchkList);

                   AnOrder.ActionOn := OriginalID + '=RN';
                   SendMessage(Application.MainForm.Handle, UM_NEWORDER, ORDER_ACT, Integer(AnOrder));
                 end;
            end;

         Result := True;

       end

    else
     with frmRenewOrders.OrderList do
        for i := 0 to Count - 1 do
           UnlockOrder(TOrder(Items[i]).ID);
  finally
    // free all the TOrderRenewFields that were created
    SelectedList := frmRenewOrders.OrderList;

    with frmRenewOrders.OrderList do for i := 0 to Count - 1 do
       begin
         AnOrder := TOrder(Items[i]);
         RenewFields := TOrderRenewFields(AnOrder.LinkObject);
         RenewFields.Free;
         AnOrder.LinkObject := nil;
       end;
    frmRenewOrders.Release;
  end;
end;

procedure TfrmRenewOrders.FormCreate(Sender: TObject);
begin
  inherited;
  lstOrders.Color := ReadOnlyColor;
  OKPressed := False;
end;

procedure TfrmRenewOrders.lstOrdersMeasureItem(Control: TWinControl;
  Index: Integer; var Height: Integer);
var
  x: string;
  DateHeight, TextHeight: Integer;
  AnOrder: TOrder;
  RenewFields: TOrderRenewFields;
begin
  inherited;
  AnOrder := TOrder(OrderList.Items[Index]);
  if AnOrder <> nil then
  begin
    RenewFields := TOrderRenewFields(AnOrder.LinkObject);
//  with RenewFields do x := 'Start: ' + StartTime + CRLF + 'Stop: ' + StopTime;  <-- original line.  //kt 8/8/2007
    with RenewFields do x := DKLangConstW('fOrdersRenew_Startx') + StartTime + CRLF + DKLangConstW('fOrdersRenew_Stopx') + StopTime; //kt added 8/8/2007
    TextHeight := MeasureColumnHeight(RenewFields.NewText,Index,TEXT_COLUMN);
    DateHeight := MeasureColumnHeight(x, Index, DATE_COLUMN);
    Height := HigherOf(TextHeight, DateHeight);
    if Height > 255 then Height := 255;  //This is maximum allowed by a windows listbox item.
  end
end;

procedure TfrmRenewOrders.lstOrdersDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  x: string;
  AnOrder: TOrder;
  RenewFields: TOrderRenewFields;
begin
  inherited;
  AnOrder := TOrder(lstOrders.Items.Objects[Index]);
  if AnOrder <> nil then with AnOrder do
  begin
    RenewFields := TOrderRenewFields(AnOrder.LinkObject);
    if RenewFields.BaseType = OD_TEXTONLY
//    then with RenewFields do x := 'Start: ' + StartTime + CRLF + 'Stop: ' + StopTime  <-- original line.  //kt 8/8/2007
      then with RenewFields do x := DKLangConstW('fOrdersRenew_Startx') + StartTime + CRLF + DKLangConstW('fOrdersRenew_Stopx') + StopTime //kt added 8/8/2007
      else x := '';
    ListGridDrawLines(lstOrders, hdrOrders, Index, State);
    ListGridDrawCell(lstOrders, hdrOrders, Index, TEXT_COLUMN, RenewFields.NewText, WORD_WRAPPED);
    ListGridDrawCell(lstOrders, hdrOrders, Index, DATE_COLUMN, x, WORD_WRAPPED);
  end;
end;

procedure TfrmRenewOrders.lstOrdersClick(Sender: TObject);
var
  RenewFields: TOrderRenewFields;
begin
  inherited;
  with lstOrders do
  begin
    if ItemIndex < 0 then Exit;
    RenewFields := TOrderRenewFields(TOrder(Items.Objects[ItemIndex]).LinkObject);
    case RenewFields.BaseType of
//  OD_MEDOUTPT: cmdChange.Caption := 'Change Refills/Pick Up...';  <-- original line.  //kt 8/8/2007
    OD_MEDOUTPT: cmdChange.Caption := DKLangConstW('fOrdersRenew_Change_RefillsxPick_Upxxx'); //kt added 8/8/2007
//  OD_TEXTONLY: cmdChange.Caption := 'Change Start/Stop...';  <-- original line.  //kt 8/8/2007
    OD_TEXTONLY: cmdChange.Caption := DKLangConstW('fOrdersRenew_Change_StartxStopxxx'); //kt added 8/8/2007
//  else         cmdChange.Caption := 'Change...';  <-- original line.  //kt 8/8/2007
    else         cmdChange.Caption := DKLangConstW('fOrdersRenew_Changexxx'); //kt added 8/8/2007
    end;
    with RenewFields do if (BaseType = OD_MEDOUTPT) or (BaseType = OD_TEXTONLY)
      then cmdChange.Enabled := True
      else cmdChange.Enabled := False;
  end;
end;

procedure TfrmRenewOrders.cmdChangeClick(Sender: TObject);
var
  StartPos: Integer;
  x, NewComment, OldComment, OldRefills, OldPickup: string;
  AnOrder: TOrder;
  RenewFields: TOrderRenewFields;
begin
  SetupVars;  //kt added 8/8/2007 to replace constants with vars.
  inherited;
  with lstOrders do
  begin
    if ItemIndex < 0 then Exit;
    AnOrder := TOrder(Items.Objects[ItemIndex]);
    RenewFields := TOrderRenewFields(AnOrder.LinkObject);
    case RenewFields.BaseType of
    OD_MEDOUTPT: with RenewFields do begin
//                 OldRefills := IntToStr(Refills) + ' refills';  <-- original line.  //kt 8/8/2007
                   OldRefills := IntToStr(Refills) + DKLangConstW('fOrdersRenew_refills'); //kt added 8/8/2007
                   { reverse string to make sure getting last matching comment }
                   OldComment := UpperCase(ReverseStr(Comments));
                   OldPickup  := PickupText(Pickup);
                   ExecuteRenewOutMed(Refills, Comments, Pickup, AnOrder);
                   NewComment := UpperCase(ReverseStr(Comments));
                   x := ReverseStr(NewText);
                   StartPos := Pos(OldComment, UpperCase(x));
                   if StartPos > 0
                     then x := Copy(x, 1, StartPos - 1) + NewComment +
                               Copy(x, StartPos + Length(OldComment), Length(x))
                     else x := NewComment + x;
                   NewText := ReverseStr(x);
                   x := NewText;
                   StartPos := Pos(OldRefills, x);
                   if StartPos > 0
//                   then x := Copy(x, 1, StartPos - 1) + IntToStr(Refills) + ' refills' +  <-- original line.  //kt 8/8/2007
                     then x := Copy(x, 1, StartPos - 1) + IntToStr(Refills) + DKLangConstW('fOrdersRenew_refills') + //kt added 8/8/2007
                               Copy(x, StartPos + Length(OldRefills), Length(x))
//                   else x := x + ' ' + IntToStr(Refills) + ' refills';  <-- original line.  //kt 8/8/2007
                     else x := x + ' ' + IntToStr(Refills) + DKLangConstW('fOrdersRenew_refills'); //kt added 8/8/2007
                   StartPos := Pos(OldPickup, x);
                   if StartPos > 0
                     then x := Copy(x, 1, StartPos - 1) + PickupText(Pickup) +
                               Copy(x, StartPos + Length(OldPickup), Length(x))
                     else x := x + PickupText(Pickup);
                   NewText := x;
                 end;
    OD_TEXTONLY: with RenewFields do ExecuteDateRange(StartTime, StopTime, DT_FUTURE+DT_TIMEOPT,
                   TC_START_STOP, TX_START_STOP, TX_LBL_START, TX_LBL_STOP);
    end;
  end;
  lstOrders.Invalidate;
end;

procedure TfrmRenewOrders.cmdOKClick(Sender: TObject);
begin
  inherited;
  OKPressed := True;
  Close;
end;

procedure TfrmRenewOrders.cmdCancelClick(Sender: TObject);
begin
  inherited;
  Close;
end;

function TfrmRenewOrders.MeasureColumnHeight(TheOrderText: string; Index,
  Column: integer): integer;
var
  ARect: TRect;
begin
  ARect.Left := 0;
  ARect.Top := 0;
  ARect.Bottom := 0;
  ARect.Right := hdrOrders.Sections[Column].Width -6;
  Result := WrappedTextHeightByFont(lstOrders.Canvas,lstOrders.Font,TheOrderText,ARect);
end;

function TfrmRenewOrders.AcceptOrderCheckOnRenew(const AnOrderID: string;
  var OCList: TStringList): boolean;
var
  OIInfo,FillerID: string;
  AnOIList: TStringList;
begin
  AnOIList := TStringList.Create;
  OIInfo := DataForOrderCheck(AnOrderID);
  FillerID := Piece(OIInfo,'^',2);
  AnOIList.Add(OIInfo);
  OrderChecksOnAccept(OCList, FillerID, '', AnOIList, AnOrderID);
  Result :=  AcceptOrderWithChecks(OCList);
end;

procedure TfrmRenewOrders.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  inherited;
  SaveUserBounds(Self);
end;

procedure TfrmRenewOrders.FormShow(Sender: TObject);
begin
  inherited;
  SetFormPosition(Self);
end;

procedure TfrmRenewOrders.hdrOrdersSectionResize(HeaderControl: THeaderControl; Section: THeaderSection);
begin
  inherited;
  lstOrders.Repaint; //CQ6367
end;


end.
