//kt -- Modified with SourceScanner on 8/8/2007
unit fTemplateImport;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Gauges, StdCtrls, ComCtrls, DKLang;

type
  TfrmTemplateImport = class(TForm)
    animImport: TAnimate;
    btnCancel: TButton;
    lblImporting: TStaticText;
    gaugeImport: TGauge;
    DKLanguageController1: TDKLanguageController;
    procedure btnCancelClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

procedure StartImportMessage(AFileName: string; MaxCount: integer);
function UpdateImportMessage(CurrentCount: integer): boolean;
procedure StopImportMessage;

implementation

{$R *.DFM}

uses
  ORFn;

var
  frmTemplateImport: TfrmTemplateImport = nil;

procedure StartImportMessage(AFileName: string; MaxCount: integer);
begin
  if not assigned(frmTemplateImport) then
  begin
    frmTemplateImport := TfrmTemplateImport.Create(Application);
    ResizeAnchoredFormToFont(frmTemplateImport);
    with frmTemplateImport do
    begin
      lblImporting.Caption := lblImporting.Caption + AFileName;
      lblImporting.Hint := lblImporting.Caption;
      gaugeImport.MaxValue := MaxCount;
      Show;
      Application.ProcessMessages;
    end;
  end;
end;

function UpdateImportMessage(CurrentCount: integer): boolean;
begin
  if assigned(frmTemplateImport) then
  begin
    Result := (not frmTemplateImport.btnCancel.Enabled);
    if not Result then
    begin
      frmTemplateImport.gaugeImport.Progress := CurrentCount;
      Application.ProcessMessages;
    end;  
  end
  else
    Result := TRUE;
end;

procedure StopImportMessage;
begin
  if assigned(frmTemplateImport) then
    FreeAndNil(frmTemplateImport);
end;


procedure TfrmTemplateImport.btnCancelClick(Sender: TObject);
begin
//lblImporting.Caption := 'Canceling...';  <-- original line.  //kt 8/8/2007
  lblImporting.Caption := DKLangConstW('fTemplateImport_Cancelingxxx'); //kt added 8/8/2007
  btnCancel.Enabled := FALSE;
  Application.ProcessMessages;
end;

end.
